<!DOCTYPE html>
<html lang="mr">
<head>
    <meta charset="UTF-8">
    <title>होर्डिंग तपशील</title>
    <style>
        .row {
            display: flex;
            align-items: center;
            gap: 83%;
            margin-bottom: 30px;
        }
        h1 {
            margin: 0;
            font-size: 32px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 18px;
        }
        td {
            border: 1px solid #ccc;
            padding: 10px;
        }
    </style>
</head>
<body>
   @php
            $logoData = file_get_contents(public_path('admin/images/favicon.png'));
            $base64Logo = base64_encode($logoData);
        @endphp
    <div class="row">
        <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
        <h1 style="float: right!important;">होर्डिंग तपशील</h1>
    </div>

       @php
            use Carbon\Carbon;

            $date = Carbon::parse('31 March 2025');
            $startYear = $date->month >= 4 ? $date->year : $date->year - 1;
            $shortEndYear = substr($startYear + 1, -4);
            $financialYear =  $shortEndYear;
        @endphp

    <table>
        <tr>
            <td>जाहिरातकाराचं नाव</td>
            <td>{{ $data->f_name }}</td>
        </tr>
        <tr>
            <td>जाहिरातकाराचं ईमेल</td>
            <td><a href="{{ $data->email_id }}">{{ $data->email_id }}</a></td>
        </tr>
        <tr>
            <td>जाहिरातकाराचं फोन नं</td>
            <td>{{ $data->mobile_no }}</td>
        </tr>
        <tr>
            <td>होर्डिंग आकार</td>
            <td>{{ $data->plot_no}} * {{ $data->size_hoarding }}</td>
        </tr>
        <tr>
            <td>जाहिरात प्रकार</td>
            <td>{{ $typerate->item }}</td>
        </tr>
        <tr>
            <td>होर्डिंग पत्ता</td>
            <td>{{ $data->chowk }}</td>
        </tr>
        <tr>
            <td>होर्डिंग नोंदणी प्रारंभ तारीख</td>
            <td>{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/y') }}</td>
        </tr>
        <tr>
            <td>होर्डिंग नोंदणी समाप्ती तारीख</td>
            <td>31/03/{{ $financialYear }}</td>
        </tr>
    </table>

</body>
</html>
