<x-admin.layout>
    <x-slot name="title">Hoarding Permission / होर्डिंग परवानगी</x-slot>
    <x-slot name="heading">Hoarding Permission / होर्डिंग परवानगी</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Edit Details</h4>
                    </div>

                    <div class="card-body">

                        <div class="mb-4 row">
                            <div class="alert alert-warning fw-bold" role="alert">
                                Applicant Details
                            </div>

                            <input type="hidden" model-id="id" value="{{ $status->id }}">
                            <div class="col-md-3">
                                <label class="col-form-label" for="f_name">Name Of Applicant<span class="text-danger">*</span></label>
                                <input class="form-control" id="f_name" name="f_name" type="text" placeholder="Enter First Name" value="{{ $hoardingPermission->f_name ?? '' }}" readonly>
                                <span class="text-danger is-invalid f_name_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="m_name">Name of Agency</label>
                                <input class="form-control" id="m_name" name="m_name" type="text" placeholder="Enter Middle Name"value="{{ $hoardingPermission->m_name ?? '' }}" readonly>
                                <span class="text-danger is-invalid m_name_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="hoarding_address">होर्डिंग उभारण्याचे ठिकाण नमुद करण्यांत यावा.</label>
                                <textarea class="form-control" id="hoarding_address" name="hoarding_address" type="text" readonly placeholder="Enter  Hoarding Place" >{{ $hoardingPermission->hoarding_address}}</textarea>
                                <span class="text-danger is-invalid hoarding_address_err"></span>
                            </div>

                             <div class="col-md-3">
                                <label class="col-form-label" for="hoardingplace">होर्डिंग लावणेची जागा (खाजगी) <span class="text-danger">*</span></label>
                                <select name="hoardingplace" id="hoardingplace" class="form-select" disabled>
                                    <option value="" disabled selected> -- Select -- </option>
                                    <option value="इमारतीवर / इमारतीच्या परिसरात" {{ $hoardingPermission->hoardingplace == 'इमारतीवर / इमारतीच्या परिसरात' ? 'selected' : '' }}>इमारतीवर / इमारतीच्या परिसरात</option>
                                    <option value="मोकळ्या जागेवर." {{ $hoardingPermission->hoardingplace == 'मोकळ्या जागेवर' ? 'selected' : '' }}>मोकळ्या जागेवर.</option>
                                </select>
                                <span class="text-danger is-invalid hoardingplace_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="typeofhoarding">होर्डिंगचा प्रकार <span class="text-danger">*</span></label>
                                <select name="typeofhoarding" id="typeofhoarding" class="form-select" disabled>
                                    <option value="" disabled selected> -- Select -- </option>
                                    <option value="प्रकाशित (Lite)" {{ $hoardingPermission->typeofhoarding == 'प्रकाशित (Lite)' ? 'selected' : '' }}>प्रकाशित (Lite)</option>
                                    <option value="अप्रकाशित (Without Lite)." {{ $hoardingPermission->typeofhoarding == 'अप्रकाशित (Without Lite)' ? 'selected' : '' }}>अप्रकाशित (Without Lite).</option>
                                </select>
                                <span class="text-danger is-invalid typeofhoarding_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="title">Status<span class="text-danger">*</span></label>
                                <select name="title" id="title" class="form-select"  disabled>
                                    <option value="" disabled > -- Select -- </option>
                                    <option value="Proprietary firm" {{ $hoardingPermission->title == 'Proprietary firm' ? 'selected' : '' }}>Proprietary firm</option>
                                    <option value="Company" {{ $hoardingPermission->title == 'Company' ? 'selected' : '' }}>Company</option>
                                    <option value="Charitable" {{ $hoardingPermission->title == 'Charitable' ? 'selected' : '' }}>Charitable </option>
                                </select>
                                <span class="text-danger is-invalid title_err"></span>

                            </div>

                            {{-- <div class="col-md-3">
                                <label class="col-form-label" for="l_name">Last Name (आडनाव ) <span class="text-danger">*</span></label>
                                <input class="form-control" id="l_name" name="l_name" type="text" placeholder="Enter Last Name"  value="{{ $hoardingPermission->l_name ?? '' }}">
                                <span class="text-danger is-invalid l_name_err"></span>
                            </div> --}}


                            <div class="col-md-4">
                                <label class="col-form-label" for="full_address">Address of Applicant/ Agency (अर्जदाराचा / एजेन्सीचा पत्ता) <span class="text-danger">*</span></label>
                                <textarea class="form-control" name="full_address" id="full_address" cols="30" rows="2" placeholder="Enter Applicant Address" readonly>{{ $hoardingPermission->full_address ?? '' }}</textarea>
                                <span class="text-danger is-invalid full_address_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="mobile_no">Mobile Number (मोबाईल नंबर)<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" type="number" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" placeholder="Enter Mobile Number" value="{{ $hoardingPermission->mobile_no ?? '' }}" readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="email_id">Email Id (ई - मेल आयडी)</label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $hoardingPermission->email_id ?? '' }}" readonly>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                        </div>


                        <div class="mb-4 row">
                            <div class="alert alert-warning fw-bold" role="alert">
                                Site Details of Hoardings
                            </div>



                            <div class="col-md-4">
                                <label class="col-form-label" for="type_hoarding">Medium of advertisements applied for<span class="text-danger">*</span> </label>
                                <select class="form-select" name="type_hoarding" id="type_hoarding" disabled>
                                    <option value="">Select Ward</option>
                                    @foreach ($advertisement as $option)
                                        <option {{ $hoardingPermission->type_hoarding == $option->id ? 'selected' : '' }} value="{{ $option->id }}">{{ $option->item }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid type_hoarding_err"></span>
                            </div>


                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="advertisement_place">Place of advertisement (जाहिरातीचे ठिकाण)<span class="text-danger">*</span> </label>
                                <select class="form-select" name="advertisement_place" id="advertisement_place">
                                    <option value="">--Select--</option>
                                    <option value="1"{{ $hoardingPermission->advertisement_place == '1' ? 'selected' : '' }}>Bhavsingpura Ramabai Chowk </option>
                                    <option value="2"{{ $hoardingPermission->advertisement_place == '2' ? 'selected' : '' }}> Bhavsingpura Amen Chowk </option>
                                    <option value="3"{{ $hoardingPermission->advertisement_place == '3' ? 'selected' : '' }}>Bhavsingpura Ambedkar Chowk </option>
                                    <option value="4"{{ $hoardingPermission->advertisement_place == '4' ? 'selected' : '' }}> Opposite Bhavsingpura Municipal School </option>
                                    <option value="5"{{ $hoardingPermission->advertisement_place == '5' ? 'selected' : '' }}>Behind the Bhavsingpura Sanchi Arch </option>
                                    <option value="6"{{ $hoardingPermission->advertisement_place == '6' ? 'selected' : '' }}> Chinar Garden Chowk </option>
                                    <option value="7"{{ $hoardingPermission->advertisement_place == '7' ? 'selected' : '' }}>Dirt road in front of Vani Complex </option>
                                    <option value="8"{{ $hoardingPermission->advertisement_place == '8' ? 'selected' : '' }}> Dirt road in front of Punjabi Bhavan </option>
                                </select>
                                <span class="text-danger is-invalid advertisement_place_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                <select class="form-select" name="zone" id="zone" >
                                    <option value="">Select Zone</option>
                                    @foreach ($zones as $zone)
                                        <option @if ($hoardingPermission->zone == $zone->name) selected @endif value="{{ $zone->name }}">{{ $zone->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div> --}}


                            <!-- <div class="col-md-4">
                                <label class="col-form-label" for="chowk">Nature of advertisement applied<span class="text-danger">*</span></label>
                                <input class="form-control" id="chowk" name="chowk" type="text" placeholder="Enter Chowk Name" value="{{ $hoardingPermission->chowk ?? '' }}" readonly>
                                <span class="text-danger is-invalid chowk_err"></span>
                            </div> -->

                            <div class="col-md-4">
                                <label class="col-form-label" for="plot_no">Length/In tt/sq.ft<span class="text-danger">*</span></label>
                                <input class="form-control" id="plot_no" name="plot_no" type="text" placeholder="Enter plot no Name" value="{{ $hoardingPermission->plot_no ?? '' }}" readonly>
                                <span class="text-danger is-invalid plot_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="size_hoarding">Width/In tt/sq.ft<span class="text-danger">*</span> </label>
                                <input class="form-control" name="size_hoarding" id="size_hoarding" value="{{ $hoardingPermission->size_hoarding ?? '' }}" readonly>
                                <span class="text-danger is-invalid size_hoarding_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="bussiness_hoarding">Total Area//In tt/sq.ft<span class="text-danger">*</span></label>
                                <input class="form-control" id="bussiness_hoarding" name="bussiness_hoarding" value="{{ $hoardingPermission->bussiness_hoarding ?? '' }}" type="text" placeholder="Enter Business type" value="{{ $hoardingPermission->bussiness_hoarding ?? '' }}" readonly>
                                <span class="text-danger is-invalid bussiness_hoarding_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="format_advertisement">No Of Board<span class="text-danger">*</span> </label>
                                <input class="form-control" name="format_advertisement" value="{{ $hoardingPermission->format_advertisement ?? '' }}" id="format_advertisement" readonly>
                                <span class="text-danger is-invalid format_advertisement_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="detail_address">Name of the Landlord :<span class="text-danger">*</span></label>
                                <input class="form-control" id="detail_address" name="detail_address" type="text" placeholder="Enter" value="{{ $hoardingPermission->detail_address ?? '' }}" readonly>
                                <span class="text-danger is-invalid detail_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="behalf">NOC of the Landlord submitted<span class="text-danger">*</span> </label>
                                <select class="form-select" name="behalf" id="behalf" disabled>
                                    <option value="">--Select--</option>
                                    <option value="yes" {{ $hoardingPermission->behalf == 'yes' ? 'selected' : '' }}>yes</option>
                                    <option value="no" {{ $hoardingPermission->behalf == 'no' ? 'selected' : '' }}>no</option>
                                </select>
                                <span class="text-danger is-invalid behalf_err"></span>
                            </div>


                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="height">Height of the advertisement’s bottom edge from street level (In Feet)(रस्त्याच्या पातळीपासून जाहिरातीच्या तळाची उंची ( फूट मध्ये))<span class="text-danger">*</span></label>
                                <input class="form-control" id="height" name="height" type="text" placeholder="Enter Height"  value="{{ $hoardingPermission->height ?? '' }}">
                                <span class="text-danger is-invalid height_err"></span>
                            </div>


                            <div class="col-md-4" style="margin-top: 20px">
                                <label class="col-form-label" for="structure">Details of structure (संरचनेचा तपशील)<span class="text-danger">*</span> </label>
                                <select class="form-select" name="structure" id="structure" style="margin-top: 20px">
                                    <option value="">--Select--</option>
                                    <option value="Timber/लाकूड" {{ $hoardingPermission->structure == 'Timber/लाकूड' ? 'selected' : '' }}>Timber/लाकूड</option>
                                    <option value="Steel/पोलाद" {{ $hoardingPermission->structure == 'Steel/पोलाद' ? 'selected' : '' }}> Steel/पोलाद</option>
                                    <option value="Other/इतर" {{ $hoardingPermission->structure == 'Other/इतर' ? 'selected' : '' }}> Other/इतर</option>

                                </select>
                                <span class="text-danger is-invalid structure_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="open_populated">The location of the sky sign is an open space or a populated area(मालमत्तेचे स्थान)<span class="text-danger">*</span> </label>
                                <select class="form-select" name="open_populated" id="open_populated" style="margin-top: 20px">
                                    <option value="">--Select--</option>
                                    <option value="Open Space/मोकळी जागा" {{ $hoardingPermission->open_populated == 'Open Space/मोकळी जागा' ? 'selected' : '' }}>Open Space/मोकळी जागा</option>
                                    <option value="Populated Area/लोकवस्तीचे क्षेत्र" {{ $hoardingPermission->open_populated == 'Populated Area/लोकवस्तीचे क्षेत्र' ? 'selected' : '' }}>Populated Area/लोकवस्तीचे क्षेत्र</option>
                                </select>
                                <span class="text-danger is-invalid open_populated_err"></span>
                            </div>






                            <div class="col-md-6">
                                <label class="col-form-label" for="detail_property">land on which the structure is to be erected owned by applicant ? Details of property should be provided along with proof(ज्या जमिनीवर संरचना उभारावयाची आहे ती अर्जदाराच्या मालकीची आहे?पुराव्यासहित मालमत्तेचा तपशील द्याव) <span class="text-danger">*</span></label>
                                <input class="form-control" id="detail_property" name="detail_property" type="text" placeholder="Enter"  value="{{ $hoardingPermission->detail_property ?? '' }}">
                                <span class="text-danger is-invalid detail_property_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="detail_property_images"></label>
                                <input class="form-control" id="detail_property_images" name="detail_property_images" type="file" accept="image/*" style="margin-top:60px" onchange="previewImage(event)">
                                @if ($hoardingPermission->detail_property_image)
                                    <small><a href="{{ asset('storage/' . $hoardingPermission->detail_property_image) }}" target="_blank">View Document</a></small>
                                @endif
                                <span class="text-danger is-invalid detail_property_images_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="postal_address">If the land is owned by a person other than the applicant, the name and postal address of the land owner (जमीन अर्जदाराव्यतिरिक्त अन्य व्यक्तीच्या मालकीची असल्यास, जमीन मालकाचे नाव आणि पोस्टल पत्ता) <span class="text-danger">*</span></label>
                                <input class="form-control" id="postal_address" name="postal_address" type="text" placeholder="Enter"  value="{{ $hoardingPermission->postal_address ?? '' }}">
                                <span class="text-danger is-invalid postal_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="consent_letters">Land owner consent to erect advertisement or how? If so please attach the original consent letter (जमीन मालकाचे संमतीपत्र)<span class="text-danger">*</span></label>
                                <input class="form-control" id="consent_letters" name="consent_letters" type="file" accept="image/*" style="margin-top: 20px">
                                @if ($hoardingPermission->consent_letter)
                                    <small><a href="{{ asset('storage/' . $hoardingPermission->consent_letter) }}" target="_blank">View Document</a></small>
                                @endif
                                <span class="text-danger is-invalid consent_letters_err"></span>
                            </div>


                        </div>
                        <div class="mb-4 row">
                            <div class="mb-4 row">
                                <div class="alert alert-warning fw-bold" role="alert">
                                    Documents Attachment List
                                </div>

                                <div class="alert alert-info fw-bold" role="alert">
                                    Note:(टीप) Upload Below Files only pdf, .jpg, .jpeg, .bmp Max upto 5MB. ( खाली फक्त pdf, .jpg, .jpeg, .bmp इत्यादी फाइल अपलोड करा. कमाल 5MB पर्यंत.)
                                </div>

                                <div class="col-md-6 mb-2">
                                    <label class="col-form-label" for="upload_prescribed_formats">No Objection from Home/Building/Place owner ( Bond Paper of Rs. 500/-) (घर / इमारत / जागा मालकाचे रु.500/- च्या मुद्रांक शुल्क वर नाहरकत)<span class="text-danger">*</span></label>
                                    <input class="form-control" id="upload_prescribed_formats" name="upload_prescribed_formats" type="file" accept="image/*"  onchange="previewImage(event)" style="margin-top:20px">
                                    @if ($hoardingPermission->building_permission)
                                        <small><a href="{{ asset('storage/' . $hoardingPermission->building_permission) }}" target="_blank">View Document</a></small>
                                    @endif
                                    <span class="text-danger is-invalid upload_prescribed_formats_err"></span>
                                </div>

                                <div class="col-md-6 mb-2">
                                    <label class="col-form-label" for="aadhar_pans">Building Permission/Completion Certificate/Standing Commitee (As per Subject no 107) Affadavit for relaxation (बांधकाम परवाना प्रमाणपत्र किंवा मा. स्थायी समिती क्र. 107 नुसार शिथीलताचे शपथपत्र)<span class="text-danger">*</span></label>
                                    <input class="form-control" id="aadhar_pans" name="aadhar_pans" type="file" accept="image/*"  onchange="previewImage(event)">
                                    @if ($hoardingPermission->paid_receipt)
                                        <small><a href="{{ asset('storage/' . $hoardingPermission->paid_receipt) }}" target="_blank">View Document</a></small>
                                    @endif
                                    <span class="text-danger is-invalid aadhar_pans_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="ownership">Existing Property Tax Paid Receipt (कर भरणा पावती)<span class="text-danger">*</span></label>
                                    <input class="form-control" id="ownership" name="ownership" type="file" accept="image/*"  onchange="previewImage(event)" style="margin-top: 20px">
                                    @if ($hoardingPermission->structural_engineer)
                                    <small><a href="{{ asset('storage/' . $hoardingPermission->structural_engineer) }}" target="_blank">View Document</a></small>
                                @endif
                                    <span class="text-danger is-invalid ownership_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="water_bills">Certificate from Structural Engineer (संरचना अभियंता चे प्रमाणपत्र) </label>
                                    <input class="form-control" id="water_bills" name="water_bills" type="file" accept="image/*"  onchange="previewImage(event)">
                                    @if ($hoardingPermission->certificate_of_structural)
                                    <small><a href="{{ asset('storage/' . $hoardingPermission->certificate_of_structural) }}" target="_blank">View Document</a></small>
                                @endif
                                    <span class="text-danger is-invalid water_bills_err"></span>
                                </div>


                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="society">Certificate of Structural Engineer(संरचना अभियंताचे संकल्प चित्र)</label>
                                    <input class="form-control" id="society" name="society" type="file"  accept="image/*"  onchange="previewImage(event)">
                                    @if ($hoardingPermission->no_objection_certificate)
                                    <small><a href="{{ asset('storage/' . $hoardingPermission->no_objection_certificate) }}" target="_blank">View Document</a></small>
                                @endif
                                    <span class="text-danger is-invalid society_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="place">Sightseeing Map (पाहणी स्थळ नकाशा ) <span class="text-danger">*</span></label></label>
                                    <input class="form-control" id="place" name="place" type="file" style="margin-top: 20px"  accept="image/*"  onchange="previewImage(event)">
                                    @if ($hoardingPermission->sightseeing)
                                    <small><a href="{{ asset('storage/' . $hoardingPermission->sightseeing) }}" target="_blank">View Document</a></small>
                                @endif
                                    <span class="text-danger is-invalid place_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="property">Drawing Provided by Structural Engineer (संरचना अभियंता द्वारे प्रदान केलेले रेखाचित्र)<span class="text-danger">*</span></label></label>
                                    <input class="form-control" id="property" name="property" type="file"  accept="image/*"  onchange="previewImage(event)">
                                    @if ($hoardingPermission->drawing_provided)
                                    <small><a href="{{ asset('storage/' . $hoardingPermission->drawing_provided) }}" target="_blank">View Document</a></small>
                                @endif
                                    <span class="text-danger is-invalid property_err"></span>
                                </div>

 --}}

                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="land_propertie">गाव नमुना सात (७/१२) उतारा<span class="text-danger">*</span></label>
                                @if ($hoardingPermission->land_properties)
                                    <div class="d-flex align-items-center mb-2">
                                        <a href="{{ asset('storage/' . $hoardingPermission->land_properties) }}" target="_blank" class="btn btn-sm btn-success">
                                            View Document
                                        </a>
                                    </div>
                                    {{-- Use hidden input for existing file path --}}
                                    <input type="hidden" name="existing_land_propertie" value="{{ $hoardingPermission->land_properties }}">
                                @else
                                    {{-- Show file input field if no document exists --}}
                                    <input type="file" name="land_propertie" id="land_propertie" class="form-control" accept=".pdf,image/*" required>
                                    <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                @endif
                                <span class="text-danger is-invalid land_propertie_err"></span>
                            </div>
                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="stability_certificate">जागा मालक ना हरकत दाखला.<span class="text-danger">*</span></label>
                                @if ($hoardingPermission->stability_certificates)
                                    <div class="d-flex align-items-center mb-2">
                                        <a href="{{ asset('storage/' . $hoardingPermission->stability_certificates) }}" target="_blank" class="btn btn-sm btn-success">
                                            View Document
                                        </a>
                                    </div>
                                    {{-- Use hidden input for existing file path --}}
                                    <input type="hidden" name="existing_stability_certificate" value="{{ $hoardingPermission->stability_certificates }}">
                                @else
                                    {{-- Show file input field if no document exists --}}
                                    <input type="file" name="stability_certificate" id="stability_certificate" class="form-control" accept=".pdf,image/*" required>
                                    <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                @endif
                                <span class="text-danger is-invalid stability_certificate_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label for="photograph">दुकाने आस्थापना नोंदणी प्रमाणपत्र.<span class="text-danger">*</span></label>
                                @if ($hoardingPermission->photographs)
                                    <div class="d-flex align-items-center mb-2">
                                        <a href="{{ asset('storage/' . $hoardingPermission->photographs) }}" target="_blank" class="btn btn-sm btn-success">
                                            View Document
                                        </a>
                                    </div>
                                    <input type="hidden" name="existing_photograph" value="{{ $hoardingPermission->photographs }}">
                                @else
                                    <input type="file" name="photograph" id="photograph" class="form-control" accept="image/*">
                                    <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                @endif
                                <span class="text-danger is-invalid photograph_err"></span>
                            </div>

                            <!-- <div class="col-md-3">
                                <label class="col-form-label" for="tax_registration">सेवा कर नोंदणी प्रमाणपत्र<span class="text-danger">*</span></label>
                               @if ($hoardingPermission->tax_registrations)
                                    <small><a href="{{ asset('storage/' . $hoardingPermission->tax_registrations) }}" target="_blank">View Document</a></small>
                                @endif
                                <span class="text-danger is-invalid tax_registration_err"></span>
                            </div> -->

                            <div class="col-md-3">
                                <label for="tax_registrations">सेवा कर नोंदणी प्रमाणपत्र<span class="text-danger">*</span></label>
                                @if ($hoardingPermission->tax_registrations)
                                    <div class="d-flex align-items-center mb-2">
                                        <a href="{{ asset('storage/' . $hoardingPermission->tax_registrations) }}" target="_blank" class="btn btn-sm btn-success">
                                            View Document
                                        </a>
                                    </div>
                                    <input type="hidden" name="existing_tax_registrations" value="{{ $hoardingPermission->tax_registrations }}">
                                @else
                                    <input type="file" name="tax_registrations" id="tax_registrations" class="form-control" accept="image/*">
                                    <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                @endif
                                <span class="text-danger is-invalid tax_registrations_err"></span>
                            </div>

                            <!-- <div class="col-md-3">
                                <label class="col-form-label" for="agreement_copy">दोन्ही पक्षकार करारनामा प्रत<span class="text-danger">*</span></label>
                                 @if ($hoardingPermission->agreement_copys)
                                    <small><a href="{{ asset('storage/' . $hoardingPermission->agreement_copys) }}" target="_blank">View Document</a></small>
                                @endif
                                <span class="text-danger is-invalid agreement_copy_err"></span>
                            </div> -->
                            <div class="col-md-3">
                                <label for="agreement_copys">दोन्ही पक्षकार करारनामा प्रत<span class="text-danger">*</span></label>
                                @if ($hoardingPermission->agreement_copys)
                                    <div class="d-flex align-items-center mb-2">
                                        <a href="{{ asset('storage/' . $hoardingPermission->agreement_copys) }}" target="_blank" class="btn btn-sm btn-success">
                                            View Document
                                        </a>
                                    </div>
                                    <input type="hidden" name="existing_agreement_copys" value="{{ $hoardingPermission->agreement_copys }}">
                                @else
                                    <input type="file" name="agreement_copys" id="agreement_copys" class="form-control" accept="image/*">
                                    <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                @endif
                                <span class="text-danger is-invalid agreement_copys_err"></span>
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="stamppaper" class="col-form-label">१००/- रु स्टम्प पेपरवर निक्षतीपूर्ती प्रमाणपत्र<span class="text-danger">*</span></label>
                                @if ($hoardingPermission->stamppapers)
                                    <div class="d-flex align-items-center mb-2">
                                        <a href="{{ asset('storage/' . $hoardingPermission->stamppapers) }}" target="_blank" class="btn btn-sm btn-success">
                                            View Document
                                        </a>
                                    </div>
                                    <input type="hidden" name="existing_stamppaper" value="{{ $hoardingPermission->stamppapers }}">
                                @else
                                    <input type="file" name="stamppaper" id="stamppaper" class="form-control" accept="image/*, application/pdf">
                                    <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                @endif
                                <span class="text-danger is-invalid stamppaper_err"></span>
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="locationphoto" class="col-form-label">लोकेशन फोटो व नकाशा<span class="text-danger">*</span></label>
                                @if ($hoardingPermission->locationphotos)
                                    <div class="d-flex align-items-center mb-2">
                                        <a href="{{ asset('storage/' . $hoardingPermission->locationphotos) }}" target="_blank" class="btn btn-sm btn-success">
                                            View Document
                                        </a>
                                    </div>
                                    <input type="hidden" name="existing_locationphoto" value="{{ $hoardingPermission->locationphotos }}">
                                @else
                                    <input type="file" name="locationphoto" id="locationphoto" class="form-control" accept="image/*, application/pdf">
                                    <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                @endif
                                <span class="text-danger is-invalid locationphoto_err"></span>
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="trafficnoc" class="col-form-label">वाहतूक पोलीस NOC<span class="text-danger">*</span></label>
                                @if ($hoardingPermission->trafficnocs)
                                    <div class="d-flex align-items-center mb-2">
                                        <a href="{{ asset('storage/' . $hoardingPermission->trafficnocs) }}" target="_blank" class="btn btn-sm btn-success">
                                            View Document
                                        </a>
                                    </div>
                                    <input type="hidden" name="existing_trafficnoc" value="{{ $hoardingPermission->trafficnocs }}">
                                @else
                                    <input type="file" name="trafficnoc" id="trafficnoc" class="form-control" accept="image/*, application/pdf">
                                    <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                @endif
                                <span class="text-danger is-invalid trafficnoc_err"></span>
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="layout_certificate" class="col-form-label">स्ट्रक्चर डिझाईन स्टॅबिलीटी मांडणी व आराखडा प्रमाणपत्र<span class="text-danger">*</span></label>
                                @if ($hoardingPermission->layout_certificates)
                                    <div class="d-flex align-items-center mb-2">
                                        <a href="{{ asset('storage/' . $hoardingPermission->layout_certificates) }}" target="_blank" class="btn btn-sm btn-success">
                                            View Document
                                        </a>
                                    </div>
                                    <input type="hidden" name="existing_layout_certificate" value="{{ $hoardingPermission->layout_certificates }}">
                                @else
                                    <input type="file" name="layout_certificate" id="layout_certificate" class="form-control" accept="image/*, application/pdf">
                                    <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                @endif
                                <span class="text-danger is-invalid layout_certificate_err"></span>
                            </div>

                             {{-- Document Uploads (col-md-3) --}}
                                <div class="col-md-3 mb-3">
                                    <label for="Adhaar_card" class="col-form-label">आधारकार्ड / पॅनकार्ड<span class="text-danger">*</span></label>
                                    @if ($hoardingPermission->Adhaar_cards)
                                        <div class="d-flex align-items-center mb-2">
                                            <a href="{{ asset('storage/' . $hoardingPermission->Adhaar_cards) }}" target="_blank" class="btn btn-sm btn-success">
                                                View Document
                                            </a>
                                        </div>
                                        <input type="hidden" name="existing_Adhaar_card" value="{{ $hoardingPermission->Adhaar_cards }}">
                                    @else
                                        <input type="file" name="Adhaar_card" id="Adhaar_card" class="form-control" accept="image/*, application/pdf">
                                        <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                    @endif
                                    <span class="text-danger is-invalid Adhaar_card_err"></span>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="plan_certificate" class="col-form-label">भाडेपट्टी करारनामा<span class="text-danger">*</span></label>
                                    @if ($hoardingPermission->plan_certificates)
                                        <div class="d-flex align-items-center mb-2">
                                            <a href="{{ asset('storage/' . $hoardingPermission->plan_certificates) }}" target="_blank" class="btn btn-sm btn-success">
                                                View Document
                                            </a>
                                        </div>
                                        <input type="hidden" name="existing_plan_certificate" value="{{ $hoardingPermission->plan_certificates }}">
                                    @else
                                        <input type="file" name="plan_certificate" id="plan_certificate" class="form-control" accept="image/*, application/pdf">
                                        <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                    @endif
                                    <span class="text-danger is-invalid plan_certificate_err"></span>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="other_doc" class="col-form-label">इतर कागदपत्रे<span class="text-danger">*</span></label>
                                    @if ($hoardingPermission->other_docs)
                                        <div class="d-flex align-items-center mb-2">
                                            <a href="{{ asset('storage/' . $hoardingPermission->other_docs) }}" target="_blank" class="btn btn-sm btn-success">
                                                View Document
                                            </a>
                                        </div>
                                        <input type="hidden" name="existing_other_doc" value="{{ $hoardingPermission->other_docs }}">
                                    @else
                                        <input type="file" name="other_doc" id="other_doc" class="form-control" accept="image/*, application/pdf">
                                        <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                    @endif
                                    <span class="text-danger is-invalid other_doc_err"></span>
                                </div>

                                {{-- Upload Application in Prescribed Format (col-md-4) --}}
                                <div class="col-md-4 mb-3">
                                    <label class="col-form-label" for="upload_prescribed_formats">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा<span class="text-danger">*</span></label>
                                    @if ($hoardingPermission->building_permission)
                                        <div class="d-flex align-items-center mb-2">
                                            <a href="{{ asset('storage/' . $hoardingPermission->building_permission) }}" target="_blank" class="btn btn-sm btn-success">
                                                View Document
                                            </a>
                                        </div>
                                        <input type="hidden" name="existing_upload_prescribed_formats" value="{{ $hoardingPermission->building_permission }}">
                                    @else
                                        {{-- Re-adding the file input that was commented out/missing --}}
                                        <input class="form-control" id="upload_prescribed_formats" name="upload_prescribed_formats" type="file" accept="image/*, application/pdf">
                                        <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                    @endif
                                    <span class="text-danger is-invalid upload_prescribed_formats_err"></span>
                                </div>
                                {{-- Clerk/Engineer Fields (Conditional) --}}
                                @if ((Auth::check() && Auth::user()->hasRole('Clerk')) || Auth::user()->hasRole('JuniorEngineer') || Auth::user()->hasRole('DeputyEngineer') || Auth::user()->hasRole('ExecutiveEngineer') && $status->service_id == '2005')
                                    <div class="col-md-4 mb-3">
                                        <label class="col-form-label" for="start_date"> Advertisement Start Date (जाहिरात सुरू होण्याची तारीख)</label>
                                        {{-- Removed inline style margin-top: 60px --}}
                                        <input class="form-control" id="start_date" name="start_date" type="date" value="{{ old('start_date', substr($hoardingPermission->start_date ,0 , 10) ?? '') }}">
                                        <span class="text-danger is-invalid start_date_err"></span>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="col-form-label" for="end_date">Advertisement End Date (जाहिरात समाप्ती तारीख)</label>
                                        <input class="form-control" id="end_date" name="end_date" type="date" value="{{ old('end_date', substr($hoardingPermission->end_date ,0 , 10) ?? '') }}">
                                        <span class="text-danger is-invalid end_date_err"></span>
                                    </div>
                                @endif
                            <div class="col-md-3">
                                <label for="status_remark">Remark<span class="text-danger">*</span></label>
                                {{-- 🚨 FIX: Remove 'value' attribute and place the content between the tags 🚨 --}}
                                <textarea id="status_remark"  maxlength="255" name="status_remark" class="form-control" rows="4" required> </textarea>
                                    {{-- {{ old('status_remark', $hoardingPermission->status_remark ?? '') }} --}}

                            </div>

                            {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" checked>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>
                    <div class="card-footer">
                      <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button type="button" id="btnCancel" class="btn btn-warning">Cancel</button>
                         @if ((Auth::check() && Auth::user()->hasRole('Clerk')  || Auth::user()->hasRole('JuniorEngineer')) && $status->service_id == '2005')
                        <button type="submit" class="btn btn-secondary" id="addSubmit">Update</button>
                    @endif
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin.layout>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
</script>
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let status_remark = $('#status_remark').val();

            if (status_remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        status_remark: status_remark
                    },

                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add status_remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let status_remark = $('#status_remark').val();

            if (status_remark !== null && status_remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        status_remark: status_remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add status_remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
<script>
     $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route('hoarding-permission.update', $hoardingPermission->id) }}';
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Updated Sucessfully!',
                    text: response.message,
                    confirmButtonText: 'OK'
                }).then(() => {
                    window.location.href = '{{ route('pendinglist') }}';
                });
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
