<x-admin.layout>
    <x-slot name="title">Dashboard</x-slot>
    <x-slot name="heading">Dashboard</x-slot>

<div class="row mb-3">
    <div class="col-12">
        <div class="text-center bg-gray text-white py-2 rounded">
            <h4 class="mb-0 fw-bold">{{ $department }}</h4>
        </div>
    </div>
</div>

<div class="row">
    <!-- Pending Applications Card -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 mb-4">
        <div class="card card-animate h-100">
            <div class="card-header bg-warning text-white text-center">
                <h5 class="mb-0 fw-bold">Pending Applications</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="fw-bold">{{ $pendingCount }}</h2>
            </div>
        </div>
    </div>

    <!-- Approved Applications Card -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 mb-4">
        <div class="card card-animate h-100">
            <div class="card-header bg-success text-white text-center">
                <h5 class="mb-0 fw-bold">Approved Applications</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="fw-bold">{{ $approvalCount }}</h2>
            </div>
        </div>
    </div>

    <!-- Today's Pending Applications Card -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 mb-4">
        <div class="card card-animate h-100">
            <div class="card-header bg-danger text-white text-center">
                <h5 class="mb-0 fw-bold">Today's Pending</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="fw-bold">{{ $todaysdatecount }}</h2>
            </div>
        </div>
    </div>

    <!-- Today's Approved Applications Card -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 mb-4">
        <div class="card card-animate h-100">
            <div class="card-header bg-primary text-white text-center">
                <h5 class="mb-0 fw-bold">Today's Approved</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="fw-bold">{{ $todaysDateApproval }}</h2>
            </div>
        </div>
    </div>
</div>


 <div class="row overflow-hidden">
        <div class="col-xl-6 col-lg-6 col-md-6 col-12">
            <div class="card card-height-100">
                <div class="card-header align-items-center d-flex bg-primary">
                    <h4 class="card-title mb-0 flex-grow-1 text-white">Service Application Wise Pie Chart</h4>

                </div><!-- end card header -->

                <div class="card-body">
                    <div id="rtsPiechart"></div>
                </div>
            </div> <!-- .card-->
        </div> <!-- .col-->

        <div class="col-xl-6 col-lg-6 col-md-6 col-12">
            <div class="card card-height-100">
                <div class="card-header align-items-center d-flex bg-primary">
                    <h4 class="card-title mb-0 flex-grow-1 text-white">Application Wise Bar Chart</h4>
                </div>

                <div class="card-body">
                    <div id="rtsDifferencePiechart"></div> <!-- same ID as in JavaScript -->
                </div>
            </div>
        </div>
 <!-- .col-->
    </div> <!-- end row-->

    <div class="row">
    <div class="col-xl-12 col-12">
        <div class="card">
            <div class="card-header bg-primary d-flex justify-content-between">
                <h3 class="card-title text-white">Day Wise Application Received</h3>
                <select name="year" id="yearSelect">
                    <option value="2025">2025</option>
                    <!-- Add more options if needed -->
                </select>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>id</th>
                                <th>Service Name</th>
                                {{-- <th>Application No</th> --}}
                                <th>Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($deparatmentrecord as $record)
                                <tr>
                                    <td>{{ $record->id }}</td>
                                    <td>{{ $serviceName->where('service_id', $record->service_id)->first()?->service_name }}</td>
                                   {{-- <td>{{ $data->where('service_id', $record->service_id)->where('id', $record->table_id)->first()?->application_no }}</td> --}}
                                    <td>{{ $record->created_at }}</td>
                                    <td>@switch($record->status)
                                        @case(1)
                                            Approved
                                            @break

                                        @case(0)
                                           Pending
                                            @break

                                        @default
                                            Unknown
                                    @endswitch
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>



  @push('scripts')
        <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

        <script type="text/javascript">
           // Load google charts
            google.charts.load('current', {
                'packages': ['corechart']
            });
            google.charts.setOnLoadCallback(drawChart);

            // Draw the chart and set the chart values
            function drawChart() {
                var totalCount = {{ $pendingCount + $approvalCount }}; // Calculate the total count
                var pendingPercentage = ({{ $pendingCount }} / totalCount) * 100;
                var approvalPercentage = ({{ $approvalCount }} / totalCount) * 100;

                // Prepare the data for the chart
                var data = google.visualization.arrayToDataTable([
                    ['Status', 'Percentage'],
                    ['Pending', pendingPercentage],
                    ['Approved', approvalPercentage]
                ]);

                // Optional; add a title and set the width and height of the chart
                var options = {
                    'title': 'Applications Status',
                    'width': 600,
                    'height': 400,
                    'pieSliceText': 'percentage', // Show percentage in the slices
                    'legend': { position: 'labeled' }
                };

                // Display the chart inside the <div> element with id="rtsPiechart"
                var chart = new google.visualization.PieChart(document.getElementById('rtsPiechart'));
                chart.draw(data, options);
            }



          google.charts.load('current', {
                packages: ['corechart']
            });
            google.charts.setOnLoadCallback(drawBarChart);

            function drawBarChart() {
                var data = google.visualization.arrayToDataTable([
                    ['Status', 'Applications', { role: 'style' }],
                    ['Pending', {{ $pendingCount }}, 'color: #f6c23e'],           // Yellow
                    ['Approved', {{ $approvalCount }}, 'color: #1cc88a'],         // Green
                    ['Todays Pending', {{ $todaysdatecount }}, 'color: #e74a3b'], // Red
                    ['Todays Approved', {{ $todaysDateApproval }}, 'color: #4e73df'] // Blue
                ]);

                var options = {
                    title: 'Applications Status Overview',
                    width: '100%',
                    height: 400,
                    bar: { groupWidth: '50%' },
                    legend: { position: 'none' },
                    vAxis: {
                        title: 'No. of Applications',
                        minValue: 0
                    },
                    hAxis: {
                        title: 'Status'
                    }
                };

                var chart = new google.visualization.ColumnChart(document.getElementById('rtsDifferencePiechart'));
                chart.draw(data, options);
            }

        </script>
    @endpush

</x-admin.layout>
