<x-admin.layout>
    <x-slot name="title">Regarding obtaining the birth certificate./ जन्म दाखला मिळविणेबाबत.</x-slot>
    <x-slot name="heading">Regarding obtaining the birth certificate./ जन्म दाखला मिळविणेबाबत.</x-slot>

    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Add Details / माहिती भरा</h4>
                    </div>

                    <div class="card-body">
                        {{-- Applicant Details --}}
                        <h5 class="text-primary">Details of Applicant / अर्जदाराची माहिती</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                            <label class="col-form-label" for="surname">
                                Surname / आडनाव <span class="text-danger">*</span>
                            </label>
                            <input  class="form-control" id="surname"  name="surname"
                                type="text" placeholder="Enter Surname" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                            <span class="text-danger is-invalid surname_err"></span>
                        </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="name">Name / नाव <span class="text-danger">*</span></label>
                                <input class="form-control" id="name" name="name" type="text" placeholder="Enter Name"   oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                                <span class="text-danger is-invalid name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="father_name" class="col-form-label">Father Name / वडिलांचे नाव <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="father_name" name="father_name" placeholder="Enter Father Name"   oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                                <span class="text-danger is-invalid father_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="address" class="col-form-label">Mother Name / आईचे नाव <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="address" name="address" placeholder="Enter Mother Name"   oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="room_name" class="col-form-label">Room Name / खोलीचे नाव<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="room_name" name="room_name" placeholder="Enter Room Name" required>
                                <span class="text-danger is-invalid room_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="block_no" class="col-form-label">Block Number / ब्लॉक क्रमांक<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="block_no" name="block_no" placeholder="Enter Block Number" required>
                                <span class="text-danger is-invalid block_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="road_name" class="col-form-label">Road Name / रस्त्याचे नाव<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="road_name" name="road_name" placeholder="Enter Road Name" required>
                                <span class="text-danger is-invalid road_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="ward" class="col-form-label">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <select name="ward" id="ward" class="form-select" required>
                                    <option value="">Select Ward Area</option>
                                    @foreach ($wards as $ward)
                                        <option value="{{ $ward->name }}">{{ $ward->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_err"></span>
                            </div>

                           <div class="col-md-4">
                                <label for="pincode" class="col-form-label">
                                    Pincode Number / पिनकोड क्रमांक <span class="text-danger">*</span>
                                </label>
                                <input
                                    type="number" class="form-control" id="pincode"  name="pincode"placeholder="Enter Pincode Number"
                                    min="100000" max="999999"  oninput="this.value = this.value.slice(0, 6)"  required>
                                <span class="text-danger is-invalid pincode_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label for="ward_no" class="col-form-label">Ward Number / प्रभाग क्रमांक<span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="ward_no" name="ward_no" placeholder="Enter Ward Number" required>
                                <span class="text-danger is-invalid ward_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="mbmc_elec_ward_no" class="col-form-label">MBMC Electric Ward Number / MBMC इलेक्ट्रिक वार्ड क्रमांक <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="mbmc_elec_ward_no" name="mbmc_elec_ward_no" placeholder="Enter Ward Number" required>
                                <span class="text-danger is-invalid mbmc_elec_ward_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="mobile_no" class="col-form-label">Contact Number/संपर्क क्रमांक<span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="mobile_no" name="mobile_no" placeholder="Enter Contact Number" maxlength="10" pattern="\d{10}" title="Please enter 10 digit number" inputmode="numeric" oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,10);" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>
                        </div>

                        {{-- Important Details --}}
                        <h5 class="text-primary">Applicant Important Details / अर्जदाराचे महत्त्वाचे तपशील</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label for="mother_full_name" class="col-form-label">Mother Full Name / आईचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="mother_full_name" name="mother_full_name" placeholder="Enter Mother Full Name" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                                <span class="text-danger is-invalid mother_full_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="father_full_name" class="col-form-label">Father Full Name/वडिलांचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="father_full_name" name="father_full_name" placeholder="Enter Father Full Name" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                                <span class="text-danger is-invalid father_full_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="mother_father_address" class="col-form-label">Mother Father Full Address/आई वडील पूर्ण पत्ता<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="mother_father_address" name="mother_father_address" placeholder="Enter Full Address" required>
                                <span class="text-danger is-invalid mother_father_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="birth_place" class="col-form-label">Birth Place/जन्मस्थान<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="birth_place" name="birth_place" placeholder="Enter Birth Place" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')"  required>
                                <span class="text-danger is-invalid birth_place_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="birth_date" class="col-form-label">Birth Date/जन्मतारीख<span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="birth_date" name="birth_date" max="{{ now()->format('Y-m-d') }}" required onchange="if (this.value) {
            const parts = this.value.split('-');
            if (parts[0] && parts[0].length > 4) {
                this.value = parts[0].substring(0, 4) + '-' + parts[1] + '-' + parts[2];
            }
        }">
                                <span class="text-danger is-invalid birth_date_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="gender" class="col-form-label">Gender/लिंग<span class="text-danger">*</span></label>
                                <select name="gender" id="gender" class="form-select" required>
                                    <option value="">Select Gender</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                    <option value="Other">Other</option>
                                </select>
                                <span class="text-danger is-invalid gender_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="child_name" class="col-form-label">Child Name/मुलाचे नाव<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="child_name" name="child_name" placeholder="Enter Child Name" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                                <span class="text-danger is-invalid child_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="no_of_certificate">No. Of Certificate/प्रमाणपत्राची संख्या <span class="text-danger">*</span></label>
                                <input class="form-control" id="no_of_certificate" name="no_of_certificate" type="number"  placeholder="Enter Number of certificates" min="1" oninput="validateCertificates()" required>
                                <span class="text-danger is-invalid no_of_certificate_err"></span>
                            </div>
                              <div class="col-md-6" id="upload_section" style="display:none;">
                                    <label class="col-form-label" for="uploaded_applications">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="uploaded_applications" name="uploaded_applications" type="file" required>
                                    <span class="text-danger is-invalid uploaded_applications_err"></span>
                                </div>
                        </div>

                        {{-- Declaration --}}
                           <div class="col-md-12 mt-4">
                                <label for="is_correct_info">Declaration / घोषणापत्र:</label>
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" checked value="yes" required>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div>

                        <div class="form-group" style="text-align: center;">
                            <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                        </div>
                        <div class="card-footer" id="card-footer" style="display:none;">
                            <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                            <button type="reset" class="btn btn-warning">Reset</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin.layout>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="{{ asset('admin/js/save_print.js') }}"></script>


{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var uploadedFile = $('#uploaded_applications').val();
        if (!uploadedFile) {
            swal("Error!", "Please upload the application document.", "error");
            $("#addSubmit").prop('disabled', false);
            return;
        }

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('insurance.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error) {
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                } else {
                    swal("Error!", data.error, "error");
                }
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occurred!", "Something went wrong, please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    attachGlobalValidation('#addForm', '#saveAndPrintBtn', {
        containerId: 'addContainer',
        printTitle: 'Birth Certificate',
    });
});
</script>

<script>
    function displayFileName(input) {
        const fileNameDisplay = document.getElementById(input.id.replace('_pics', '_file_name'));
        if (input.files.length > 0) {
            // .name property only provides the file name, not the path
            fileNameDisplay.textContent = 'Selected: ' + input.files[0].name;
            fileNameDisplay.style.color = 'green';
        } else {
            fileNameDisplay.textContent = 'No file selected';
            fileNameDisplay.style.color = 'gray';
        }
    }

    function validateCertificates() {
        const input = document.getElementById('no_of_certificate');
        const errorSpan = document.querySelector('.no_of_certificate_err'); // <-- correct span

        let value = parseInt(input.value);

        if (isNaN(value) || value <= 0) {
            errorSpan.textContent = "Value must be greater than 0.";
            errorSpan.style.display = 'block'; // ensure visibility
            input.classList.add('is-invalid');
            return false;
        }

        errorSpan.textContent = "";
        input.classList.remove('is-invalid');
        return true;
    }

</script>


