<!DOCTYPE html>
<html lang="mr">
<head>
    <meta charset="UTF-8">
    <title>BIRTH CERTIFICATE</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 10px;
        }
        .header, .footer {
            text-align: center;
        }

         @media print {
        .page-break {
            page-break-before: always;
        }

        .bottom-note {
            position: absolute;
            bottom: 30px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 16px;
            font-weight: bold;
        }
    }

    .bottom-note {
        margin-top: 100px;
        text-align: center;
        font-size: 10px;
        font-weight: bold;
    }
    .page {
        overflow: hidden;
        page-break-after: always;
    }
    .page:last-of-type {
        page-break-after: auto
    }
    </style>
</head>
<body>
    @php
    $totalNo = (int)$data->no_of_certificate ?? 0;
    @endphp
    @for($i = 0; $i <= $totalNo; $i++)
    <div class="header">
        @php
        $logoData = file_get_contents(public_path('admin/images/favicon.png'));
        $logoData1 = file_get_contents(public_path('admin/images/seal_of_maharashtra.png'));
        $logoData2 = file_get_contents(public_path('admin/images/vector_smart_object.png'));
        $base64Logo = base64_encode($logoData);
        $base64Logo2 = base64_encode($logoData2);
        $base641Logo = base64_encode($logoData1);
        @endphp
       <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
       <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="100" width="100">
       <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo"  style="float:right;margin-top:35px;" height="100" width="100">
       <div class="rox">
        <p>महाराष्ट्र शासन </p>
        <p>GOVERNMENT OF MAHARASHTRA</p>
        <p>सार्वजनिक आरोग्य विभाग </p>
        <p>DEPARTMENT OF PUBLIC HEALTH</p>
        <p>MUNCIPAL CORPORATION BHIWANDI</p>
        <P>जन्म प्रमाणपत्र</P>
        <p>BIRTH CERTIFICATE</p>
       </div>
    </div>
<hr style="1px solid #000; height:5px; background-color:#000;">
    <div class="sub-header">
        <div class="row d-flex">
        <p>जा.क्र. मनपा/जन्म-मृत्यु/ {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/ 2025-2026
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        दि. <span>{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/y') }}</span></p>
        </div>
    </div>

        <p >(जन्म आणि मृत्यू नोंदणी अधिनियम, 1969 च्या कलम 12/17 आणि महाराष्ट्र जन्म आणि मृत्यू नियम 2000 चे नियम 8/13 अन्वये देण्यात आले आहे)<br>
            (ISSUED UNDER SECTION 12/17 OF THE REGISTRATION OF BIRTHS AND DEATHS ACT, 1969 AND RULE 8/13 OF THE MAHARASHTRA REGISTRATION OF BIRTHS & DEATHS RULES 2000)
            <br>
            <br>
            प्रमाणित करण्यात येत आहे की खालील माहिती जन्म नोंदवहीच्या मूळ अभिलेखावरून घेण्यात आली आहे. जी तहसील / ब्लॉकच्या ठाणे जिल्ह्याच्या ठाणे राज्य / केंद्रशासित प्रदेश, भारत यांच्या नोंदवहीत उपलब्ध आहे.
           <br>
           <br>
            THIS IS TO CERTIFY THAT THE FOLLOWING INFORMATION HAS BEEN TAKEN FROM THE ORIGINAL RECORD OF BIRTH:
            WHICH IS THE REGISTER FOR MUNICIPAL CORPORATION BHIWANDI OF TAHSIL/BLOCK THANE OF DISTRICT THANE OF STATE/UNION, TERRITORY OF MAHARASHTRA INDIA:
           </p>
        <tr>
            <th style="float: left;"><b>नाव/Name :</b></th><td style="float: left;">&nbsp;&nbsp;&nbsp;&nbsp;{{ $data->name}}{{ $data->father_name}}{{ $data->surname}}</td>
           &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
           &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <th><b>लिंग/Sex: </b></th>
            <td>{{$data->gender}}</td>
        </tr>
        <br>
        <br>
        <tr>
            <th style="float: left;"><b>आधार क्रमांक/Aadhaar Number :</b></th>
            <td style="float: left;">&nbsp;&nbsp;&nbsp;&nbsp;456856256889</td>
        </tr>
        <br>
        <br>
        <tr>
            <th style="float: left;"><b>जन्मतारीख/Date of Birth : </b></th>
            <td style="float: left;">&nbsp;&nbsp;&nbsp;&nbsp;{{$data->birth_date}}</td>
             &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
           &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<th><b>जन्मस्थान/Place of Birth :</b> </th>
            <td>{{$data->birth_place}}</td>
        </tr>
        <br>
        <br>
        <tr>
            <th style="float: left;"><b>आईचे नाव/NAME OF THE MOTHER: </b></th>
            <td style="float: left;">{{$data->mother_full_name}}</td>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
          <th><b>वडिलांचे नाव/NAME OF THE FATHER: </b></th><br>
             &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
           &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
           &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
           &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
           &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<td>{{$data->father_full_name}}</td>
        </tr>
        <br>
        <br>
        <tr>
            <th style="float: left;"><b>आईचा आधार क्रमांक/ADHAR NUMBER OF MOTHER:</b></th>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
               <th><b>वडिलांचा आधार क्रमांक/ADHAR NUMBER OF FATHER:</b> <br></th>
            <td style="float: left;">XXXX-XXXX-8149</td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<td>XXXX-XXXX-1858</td>
        </tr>
        <br><br>
        <tr>
            <th><b>मुलाच्या जन्माच्या वेळी पालकांचा पत्ता/ADDRESS OF PARENTS <br> AT THE TIME OF BIRTH OF THE CHILD : </b></th>
               &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<th><b>पालकांचा कायमचा पत्ता/PERMANENT ADDRESS PARENTS : </b></th><br>
            <td>
               {{$data->mother_father_address}}
            </td>
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<td>
                {{ $data->address }}
            </td>
        </tr>
        <br>
        <br>
        <tr>
            <th><b>नोंदणी क्रमांक/REGISTERATION NUMBER : </b></th>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <th><b>नोंदणीची तारीख/DATE OF REGISTERATION : </b></th><br>
            <td>B-2019: 27-90147-004504</td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <td>24-06-2019</td>
        </tr>
        <br></br>
        <tr>
            <th><b>शेरा(असल्यास)/REMARKS (IF ANY) : </b></th>
        </tr>
        <br>
        <br>
        <tr>
            <th><b>प्रमाणपत्र दिल्याचा दिनांक/DATE OF ISSUE : </b></th>
            <td colspan="3">30-05-2025</td>
        </tr>
            <br>
        <br>
        <tr>
            <th><b>Updated On : </b></th>
            <td>{{$data->updated_at}}</td>
        </tr>
    </table>
<br>

    <div class="footer" style="float:right;">
        <p><strong>निर्गमित करणाऱ्या प्राधिकान्याची सही / SIGNATURE OF ISSUING AUTHORITY : </strong><br>
        निबंधक (जन्म आणि मृत्यू)<br>
        Registrar (BIRTH & DEATH)<br>
        MUNICIPAL CORPORATION BHIWANDI
     </p>
    </div>

    <br>
    <div class="bottom-note mt-2" >
        "प्रत्येक जन्म आणि मृत्यूची नोंदणी सुनिश्चित करा / ENSURE REGISTRATION OF EVERY BIRTH AND DEATH"
    </div>
    <div class="page"></div>
    @endfor
</body>
</html>
