<x-admin.layout>
    <x-slot name="title">Regarding obtaining the birth certificate./ जन्म दाखला मिळविणेबाबत.</x-slot>
    <x-slot name="heading">Regarding obtaining the birth certificate./ जन्म दाखला मिळविणेबाबत.</x-slot>

    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Edit Details</h4>
                    </div>

                    <div class="card-body">
                        <div class="mb-3 row">
                                <input type="hidden" model-id="id" value="{{ $status->id }}">
                            {{-- Applicant Details --}}
                            <h5 class="mb-3">Details of Applicant / अर्जदाराची माहिती</h5>

                            <div class="col-md-4">
                                <label for="surname">Surname / आडनाव<span class="text-danger">*</span></label>
                                <input type="text" name="surname" id="surname" class="form-control" placeholder="Enter applicant surname" value="{{ $insuranceofbirthreading->surname }}" readonly>
                                <span class="text-danger is-invalid surname_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="name">Name / नाव <span class="text-danger">*</span></label>
                                <input type="text" name="name" id="name" class="form-control" placeholder="Enter applicant name" value="{{ $insuranceofbirthreading->name }}" readonly>
                                <span class="text-danger is-invalid name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="father_name">Father Name / वडिलांचे नाव <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="father_name" name="father_name" placeholder="Enter Father Name" value="{{ $insuranceofbirthreading->father_name }}" readonly>
                                <span class="text-danger is-invalid father_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="address">Mother Name / आईचे नाव <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="address" name="address" placeholder="Enter Mother Name" value="{{ $insuranceofbirthreading->address }}" readonly>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="room_name">Room Name / खोलीचे नाव<span class="text-danger">*</span></label>
                                <input type="text" name="room_name" id="room_name" class="form-control" placeholder="Enter room_name" value="{{ $insuranceofbirthreading->room_name }}" readonly>
                                <span class="text-danger is-invalid room_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="block_no">Block Number / ब्लॉक क्रमांक<span class="text-danger">*</span></label>
                                <input type="text" name="block_no" id="block_no" class="form-control" placeholder="Enter block_no" value="{{ $insuranceofbirthreading->block_no }}" readonly>
                                <span class="text-danger is-invalid block_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="road_name">Road Name / रस्त्याचे नाव<span class="text-danger">*</span></label>
                                <input type="text" name="road_name" id="road_name" class="form-control" placeholder="Enter road_name" value="{{ $insuranceofbirthreading->road_name }}" readonly>
                                <span class="text-danger is-invalid road_name_err"></span>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="gender">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <select class="form-select" name="gender" id="gender" disabled>
                                    @foreach($wards as $ward)
                                        <option value="{{ $ward->id }}" {{ ($insuranceofbirthreading->ward == $ward->id) ? 'selected' : '' }}>
                                            {{ $ward->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid gender_err"></span>
                            </div>
                            <!-- <div class="col-md-4">
                                <label for="ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <select class="form-select" name="ward" id="ward">
                                    <option value="">Select Ward Area</option>
                                    @foreach($wards as $ward)
                                        <option value="{{ $ward->id }}" {{ ($insuranceofbirthreading->ward == $ward->id) ? 'selected' : '' }}>
                                            {{ $ward->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_err"></span>
                            </div> -->

                             <div class="col-md-4">
                                <label for="pincode_no">Pincode Number / पिनकोड क्रमांक<span class="text-danger">*</span></label>
                                <input type="text" name="pincode_no" id="pincode_no" class="form-control" placeholder="Enter pincode_no" value="{{ $insuranceofbirthreading->pincode_no }}" readonly>
                                <span class="text-danger is-invalid pincode_no_err"></span>
                            </div>

                             <div class="col-md-4">
                                <label for="ward_no">Ward Number / प्रभाग क्रमांक<span class="text-danger">*</span></label>
                                <input type="text" name="ward_no" id="ward_no" class="form-control" placeholder="Enter ward_no" value="{{ $insuranceofbirthreading->ward_no }}" readonly>
                                <span class="text-danger is-invalid ward_no_err"></span>
                            </div>

                             <div class="col-md-4">
                                <label for="mbmc_elec_ward_no">MBMC Electric Ward Number / MBMC इलेक्ट्रिक वार्ड क्रमांक <span class="text-danger">*</span></label>
                                <input type="text" name="mbmc_elec_ward_no" id="mbmc_elec_ward_no" class="form-control" placeholder="Enter mbmc_elec_ward_no" value="{{ $insuranceofbirthreading->mbmc_elec_ward_no }}" readonly>
                                <span class="text-danger is-invalid mbmc_elec_ward_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="contact_no">Contact Number/संपर्क क्रमांक<span class="text-danger">*</span></label>
                                <input type="text" name="contact_no" id="contact_no" class="form-control" placeholder="Enter contact_no" value="{{ $insuranceofbirthreading->contact_no }}" readonly>
                                <span class="text-danger is-invalid contact_no_err"></span>
                            </div>


                            {{-- Property Details --}}
                            <h5 class="mt-4 mb-3">Applicant Important Details / अर्जदाराचे महत्त्वाचे तपशील</h5>

                            <div class="row">

                                {{-- Row 1: Mother Name, Father Name, Mother/Father Address --}}
                                <div class="col-md-4 mb-3">
                                    <label for="mother_full_name">Mother Full Name / आईचे पूर्ण नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" name="mother_full_name" id="mother_full_name" placeholder="Enter full name" value="{{ $insuranceofbirthreading->mother_full_name }}" readonly>
                                    <span class="text-danger is-invalid mother_full_name_err"></span>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="father_full_name">Father Full Name/वडिलांचे पूर्ण नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" name="father_full_name" id="father_full_name" placeholder="Enter full name" value="{{ $insuranceofbirthreading->father_full_name }}" readonly>
                                    <span class="text-danger is-invalid father_full_name_err"></span>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="mother_father_address">Mother Father Full Address/आई वडील पूर्ण पत्ता<span class="text-danger">*</span></label>
                                    <input class="form-control" name="mother_father_address" id="mother_father_address" placeholder="Enter address" value="{{ $insuranceofbirthreading->mother_father_address }}" readonly>
                                    <span class="text-danger is-invalid mother_father_address_err"></span>
                                </div>

                                {{-- Row 2: Birth Place, Birth Date, Gender --}}
                                <div class="col-md-4 mb-3">
                                    <label for="birth_place">Birth Place/जन्मस्थान<span class="text-danger">*</span></label>
                                    <input class="form-control" name="birth_place" id="birth_place" placeholder="Enter place of birth" value="{{ $insuranceofbirthreading->birth_place }}" readonly>
                                    <span class="text-danger is-invalid birth_place_err"></span>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="birth_date">Birth Date/जन्मतारीख<span class="text-danger">*</span></label>
                                    {{-- Changed to type="date" and removed rows="2" --}}
                                    <input type="date" class="form-control" name="birth_date" id="birth_date" value="{{ $insuranceofbirthreading->birth_date }}">
                                    <span class="text-danger is-invalid birth_date_err"></span>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="gender">Gender/लिंग<span class="text-danger">*</span></label>
                                    <select class="form-select" name="gender" id="gender" disabled>
                                        <option value="" disabled>-- Select --</option>
                                        <option value="Female" {{ $insuranceofbirthreading->gender == 'Female' ? 'selected' : '' }}>Female</option>
                                        <option value="Male" {{ $insuranceofbirthreading->gender == 'Male' ? 'selected' : '' }}>Male</option>
                                        <option value="Other" {{ $insuranceofbirthreading->gender == 'Other' ? 'selected' : '' }}>Other</option>
                                    </select>
                                    <span class="text-danger is-invalid gender_err"></span>
                                </div>

                                {{-- Row 3: Child Name, Certificate No., Adhar Card Photo --}}
                                <div class="col-md-4 mb-3">
                                    <label for="child_name">Child Name/मुलाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" name="child_name" id="child_name" placeholder="Enter child's name" value="{{ $insuranceofbirthreading->child_name }}" readonly>
                                    <span class="text-danger is-invalid child_name_err"></span>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="no_of_certificate">No. Of Certificate/प्रमाणपत्राची संख्या<span class="text-danger">*</span></label>
                                    <input class="form-control" name="no_of_certificate" id="no_of_certificate" placeholder="Enter number of certificates" value="{{ $insuranceofbirthreading->no_of_certificate }}" readonly>
                                    <span class="text-danger is-invalid no_of_certificate_err"></span>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="upload_section">Document Uploaded<span class="text-danger">*</span></label>

                                    @if($insuranceofbirthreading->uploaded_application)
                                        {{-- CASE 1: Document is uploaded - Show View Button --}}
                                        <div class="d-flex align-items-center">
                                            <a href="{{ asset('storage/' . $insuranceofbirthreading->uploaded_application) }}" target="_blank" class="btn btn-sm btn-success">
                                                View Document
                                            </a>
                                        </div>
                                        <input type="hidden" name="existing_upload_section" value="{{ $insuranceofbirthreading->uploaded_application }}">
                                    @else
                                        <input type="file" name="upload_section" id="upload_section" class="form-control" accept="image/*">
                                        <p class="mt-1 mb-0 text-danger">No Document Uploaded</p>
                                    @endif
                                    <span class="text-danger is-invalid upload_section_err"></span>
                                </div>
                            </div>

                            {{-- Document Uploads --}}
                            <!-- <h5 class="mt-4 mb-3">Document Uploads / दस्तऐवज अपलोड करा</h5>

                             <div class="col-md-6" id="upload_section" style="display:block;">
                                    <label class="col-form-label" for="uploaded_applications">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                     @if($insuranceofbirthreading->uploaded_application)
                                    <a href="{{ asset('storage/' . $insuranceofbirthreading->uploaded_application) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                    <input class="form-control" id="uploaded_applications" name="uploaded_applications" type="file" >
                                    <span class="text-danger is-invalid uploaded_applications_err"></span>
                            </div> -->
                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" maxlength="255" class="form-control" rows="4" required></textarea>
                            </div>

                            {{-- Declaration --}}
                            {{-- <div class="col-md-12 mt-4">
                                <label for="is_correct_info">Declaration / घोषणापत्र:</label>
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" checked value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>

                    <div class="card-footer">
                         <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin.layout>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });

    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>

{{-- update --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);


        var formdata = new FormData(this);
        var updateUrl = '{{ route('insurance.update', $insuranceofbirthreading->id) }}'; // 👈 FIXED
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
