<x-layout>
    <x-slot name="title">Issuance Of Marriage Registration Certificate / विवाह नोंदणी प्रमाणपत्र देणे</x-slot>
    <style>
        .swal-overlay {
            z-index: 99999 !important;
        }
    </style>
    <div class="row">
        <div class="col-lg-12">
            <div class="row">
                <div class="col-xl-12 col-12">
                    <div class="card">
                        {{-- <div class="container mt-5"> --}}
                        <div class="card-header">
                            <h4 class="mb-0 text-dark" style="font-weight: 600">
                                ISSUANCE OF MARRIAGE REGISTRATION CERTIFICATE / विवाह नोंदणी प्रमाणपत्र देणे
                            </h4>
                        </div>
                        <div class="card-body">
                            <!-- Tabs -->
                            <ul class="nav nav-tabs mb-4" id="formTabs" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="step1-tab" data-bs-toggle="pill" data-bs-target="#step1" data-title="Marriage Registration Form" type="button" role="tab">Marriage Registration Form <br>(विवाह नोंदणी फॉर्म)</button>
                                </li>
                                <br>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="step2-tab" data-bs-toggle="pill" data-bs-target="#step2" data-title="Marriage Registration Details" type="button" role="tab" disabled>Marriage Registration Details (विवाह <br> नोंदणी माहिती)</button>
                                </li>
                                <br>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="step3-tab" data-bs-toggle="pill" data-bs-target="#step3" type="button" data-title="Groom Information" role="tab" disabled>Groom Information (वराची माहिती)</button>
                                </li>
                                <br>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="step4-tab" data-bs-toggle="pill" data-bs-target="#step4" data-title="Bride Information" type="button" role="tab" disabled>Bride Information (वधूची माहिती)</button>
                                </li>
                                <br>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="step5-tab" data-bs-toggle="pill" data-bs-target="#step5" type="button" data-title="Priest Information" role="tab" disabled>Priest Information (पुरोहिताची <br>माहिती)</button>
                                </li>
                                <br>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="step6-tab" data-bs-toggle="pill" data-bs-target="#step6" type="button" data-title="Witness Information" role="tab" disabled>Witness Information <br>(साक्षीदाराची माहिती)</button>
                                </li>
                            </ul>
                            <div id="pdfLoaderModal" class="modal-loader">
                                <div class="loader-content">
                                    <div class="spinner"></div>
                                    <p>Generating PDF...</p>
                                </div>
                            </div>

                            <!-- Form Steps -->
                            <form id="multiStepForm">
                                @csrf
                                <div class="tab-content">
                                    <!-- Step 1 -->
                                    <div class="tab-pane fade show active" id="step1" role="tabpanel">
                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Applicant Mobile Number (अर्जदाराचा मोबाईल क्रमांक) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" name="registration_from_applicant_mobile_no" placeholder="Enter applicant mobile number" required />
                                                    <span class="text-danger is-invalid registration_from_applicant_mobile_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Applicant Full Name (अर्जदाराचे पूर्ण नाव)<span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="registration_from_applicant_full_name" placeholder="Enter applicant full name"  oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required />
                                                    <span class="text-danger is-invalid registration_from_applicant_full_name_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Applicant Home Address (अर्जदाराच्या घराचा पत्ता) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="registration_from_applicant_home_address" placeholder="Enter applicant home address" required></textarea>
                                                    <span class="text-danger is-invalid registration_from_applicant_home_address_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pincode (पिनकोड) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="6" minlength="6" class="form-control" name="registration_from_pincode" placeholder="Enter pincode" required />
                                                    <span class="text-danger is-invalid registration_from_pincode_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Applicant E-mail (अर्जदाराचा ई-मेल) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="registration_from_applicant_email" placeholder="Enter applicant email" required />
                                                    <span class="text-danger is-invalid registration_from_applicant_email_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Aadhar Card No. (आधार कार्ड क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="12" minlength="12" class="form-control" name="registration_from_aadhar_card_no" placeholder="Enter aadhar card no." required />
                                                    <span class="text-danger is-invalid registration_from_aadhar_card_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Applicant alternate Mobile Number (अर्जदाराचा पर्यायी मोबाईल क्रमांक)</label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="registration_from_alternate_mobile_number" placeholder="Enter applicant alternate mobile number" required />
                                                    <span class="text-danger is-invalid registration_from_alternate_mobile_number_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pan Card No. (पॅन कार्ड क्र.) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="registration_from_pan_card_no" placeholder="Enter pan card no." required />
                                                    <span class="text-danger is-invalid registration_from_pan_card_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Residential Ward Name (रहिवाशीच्या प्रभागाचे नाव) <span class="text-danger">*</span></label>
                                                    <select name="registration_from_residential_ward_name" class="form-select" required>
                                                        <option value="">Select Ward</option>
                                                        @foreach ($options as $ward)
                                                            <option value="{{ $ward->id }}">{{ $ward->name }}</option>
                                                        @endforeach
                                                    </select>

                                                    <span class="text-danger is-invalid registration_from_residential_ward_name_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Marriage solemnized within Maharashtra State? (विवाह सोहळा महाराष्ट्र राज्यात झाला आहे का ?) <span class="text-danger">*</span></label>
                                                    <select name="registration_from_marriage_solemnized_within_maharashtra_state" id="registrationFromMarriageSolemnizedWithinMaharashtraState" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Yes</option>
                                                        <option value="2">No</option>
                                                    </select>
                                                    <span class="text-danger is-invalid registration_from_marriage_solemnized_within_maharashtra_state_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12 d-none" id="registrationFromAffidavitForMarriageOutsideMaharashtras">
                                                <div class="mb-3">
                                                    <label class="form-label">Affidavit for Marriage Outside Maharashtra <br><span class="text-danger">Upload PDF Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="registration_from_affidavit_for_marriage_outside_maharashtras" placeholder="Enter affidavit for marriage outside maharashtra" />
                                                    <span class="text-danger is-invalid registration_from_affidavit_for_marriage_outside_maharashtras_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="d-flex justify-content-end">
                                            <button type="button" class="btn btn-primary btnNext">Next</button>
                                        </div>
                                    </div>

                                    <!-- Step 2 -->
                                    <div class="tab-pane fade" id="step2" role="tabpanel">
                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Form Filled Date (फॉर्म भरण्याची तारीख) <span class="text-danger">*</span></label>
                                                    <input type="date" id="registration_details_form_filled_date"
                                                        value="{{ date('Y-m-d') }}" class="form-control"
                                                        name="registration_details_form_filled_date"
                                                        placeholder="Enter form filled date" autocomplete="off" required readonly />
                                                    <span class="text-danger is-invalid registration_details_form_filled_date_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Marriage Date in English (लग्नाची तारीख इंग्रजीमध्ये)<span class="text-danger">*</span></label>
                                                    <input
                                                        type="date"
                                                        class="form-control"
                                                        id="registration_details_marriage_date_in_english"
                                                        name="registration_details_marriage_date_in_english"
                                                        placeholder="Enter marriage date in english"
                                                        onchange="syncDates(this)"
                                                        autocomplete="off"
                                                        required
                                                    />
                                                    <span class="text-danger is-invalid registration_details_marriage_date_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Marriage Date in Marathi (लग्नाची तारीख मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input
                                                        type="text"
                                                        class="form-control"
                                                        id="registration_details_marriage_date_in_marathi"
                                                        name="registration_details_marriage_date_in_marathi"
                                                        placeholder="Enter marriage date in marathi"
                                                        readonly
                                                    />
                                                    <span class="text-danger is-invalid registration_details_marriage_date_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Marriage Place, Full Address in English (इंग्रजीमध्ये लग्नाच्या ठिकाणाचा पत्ता) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="registration_details_marriage_place_in_english" placeholder="Enter marriage place, full address in english" required></textarea>
                                                    <span class="text-danger is-invalid registration_details_marriage_place_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Marriage Place, Full Address in Marathi (मराठीमध्ये लग्नाच्या ठिकाणाचा पत्ता) <span class="text-danger">*</span></label>
                                                    <textarea type="text" class="form-control marathi-only" name="registration_details_marriage_place_in_marathi" placeholder="Enter marriage place, full address in marathi" required   oninput="validateMarathi(this)"></textarea>
                                                    <span class="text-danger is-invalid registration_details_marriage_place_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Couple Photo of Wedding (लग्न विधी चा फोटो) <br><span class="text-danger">Upload Image / PDF Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="registration_details_couple_photos" required />
                                                    <span class="text-danger is-invalid registration_details_couple_photos_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Is Husband/Wife Widower/Widow? (वर/वधू -- विधुर / विधवा आहे का ?) <span class="text-danger">*</span></label>
                                                    <select name="registration_details_is_widow" class="form-select" required>
                                                        <option value="">Select option</option>
                                                        <option value="1">Yes</option>
                                                        <option value="2">No</option>
                                                    </select>
                                                    <span class="text-danger is-invalid registration_details_is_widow_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Is Husband/Wife previously divorced? (वर वधू यांचे घटस्पोट झाला आहे का ?) <span class="text-danger">*</span></label>
                                                    <select name="registration_details_is_previously_divorced" class="form-select" required>
                                                        <option value="">Select option</option>
                                                        <option value="1">Yes</option>
                                                        <option value="2">No</option>
                                                    </select>
                                                    <span class="text-danger is-invalid registration_details_is_previously_divorced_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Is Marriage Intercaste? (आंतरजातीय विवाह झाला आहे का ?) <span class="text-danger">*</span></label>
                                                    <select name="registration_details_is_marriage_intercaste" class="form-select" required>
                                                        <option value="">Select option</option>
                                                        <option value="1">Yes</option>
                                                        <option value="2">No</option>
                                                    </select>
                                                    <span class="text-danger is-invalid registration_details_is_marriage_intercaste_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Wedding card Image. If not available, attach Affidavit (लग्न पत्रिका चा फोटो नसल्यास, प्रतिज्ञापत्र जोडावे ) <br><span class="text-danger">Upload PDF Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="registration_details_wedding_card_images" required />
                                                    <span class="text-danger is-invalid registration_details_wedding_card_images_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="d-flex justify-content-between">
                                            <button type="button" class="btn btn-secondary btnPrevious">Previous</button>
                                            <button type="button" class="btn btn-primary btnNext">Next</button>
                                        </div>
                                    </div>

                                                                       <!-- Step 3 -->
                                    <div class="tab-pane fade" id="step3" role="tabpanel">
                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name in English (पहिले नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_fname_in_english" required placeholder="Enter first name in english" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" />
                                                    <span class="text-danger is-invalid groom_info_fname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In English (मधले नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_mname_in_english" required oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" placeholder="Enter middle name in english" />
                                                    <span class="text-danger is-invalid groom_info_mname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In English (आडनाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_lname_in_english" required oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" placeholder="Enter last name in english" />
                                                    <span class="text-danger is-invalid groom_info_lname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name In Marathi (पहिले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="groom_info_fname_in_marathi" oninput="validateMarathiName(this)" placeholder="Enter first name in marathi"  required />
                                                    <span class="text-danger is-invalid groom_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In Marathi (मधले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="groom_info_mname_in_marathi" oninput="validateMarathiName(this)" placeholder="Enter middle name in marathi"  required/>
                                                    <span class="text-danger is-invalid groom_info_mname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In Marathi (आडनाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="groom_info_lname_in_marathi" oninput="validateMarathiName(this)" placeholder="Enter last name in marathi" required />
                                                    <span class="text-danger is-invalid groom_info_lname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="groom_info_address_in_english" placeholder="Enter address in english"  required></textarea>
                                                    <span class="text-danger is-invalid groom_info_address_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control marathi-only" name="groom_info_address_in_marathi" placeholder="Enter address in marathi"  oninput="validateMarathi(this)" required></textarea>
                                                    <span class="text-danger is-invalid groom_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pincode (पिनकोड) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="6" minlength="6" class="form-control" name="groom_info_pincode" placeholder="Enter pincode" required />
                                                    <span class="text-danger is-invalid groom_info_pincode_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pincode in Marathi (पिनकोड मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control only-marathi-digits" name="groom_info_pincode_in_marathi" placeholder="Enter pincode in marathi" maxlength="6" minlength="6"  required/>
                                                    <span class="text-danger is-invalid groom_info_pincode_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="groom_info_mobile_no" placeholder="Enter mobile no." required />
                                                    <span class="text-danger is-invalid groom_info_mobile_no_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Email (ईमेल) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_email" placeholder="Enter email"  required/>
                                                    <span class="text-danger is-invalid groom_info_email_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Aadhar Card No. <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="12" minlength="12" class="form-control" name="groom_info_aadhar_card_no" placeholder="Enter aadhar card no."  required/>
                                                    <span class="text-danger is-invalid groom_info_aadhar_card_no_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Date of Birth (जन्मतारीख) <span class="text-danger">*</span></label>
                                                    <input type="date" class="form-control" name="groom_info_dob" id="gdate_of_birth"
                                                         placeholder="Select date of birth" max="{{ now()->format('Y-m-d') }}" autocomplete="off" required />
                                                    <span class="text-danger is-invalid groom_info_dob_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Groom's Age At Time of Marriage<span class="text-danger">*</span></label>
                                                    <input
                                                        type="text"
                                                        id="gage"
                                                        class="form-control"
                                                        name="groom_info_age"
                                                        placeholder="Calculated Age"
                                                        readonly
                                                    />
                                                    <span class="text-danger is-invalid groom_info_age_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                                                    <select name="groom_info_gender" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Male</option>
                                                        <option value="2">Female</option>
                                                        <option value="3">Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_gender_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Religion by birth (जन्माने धर्म) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_religion_by_birth" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Hindu</option>
                                                        <option value="2">Muslim</option>
                                                        <option value="3">Jain</option>
                                                        <option value="4">Shikh</option>
                                                        <option value="5">Buddhism</option>
                                                        <option value="6">Christian</option>
                                                        <option value="7">Parsi</option>
                                                        <option value="8">Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_religion_by_birth_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Religion by adoption (दत्तक घेऊन धर्म) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_religion_by_adoption" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Hindu</option>
                                                        <option value="2">Muslim</option>
                                                        <option value="3">Jain</option>
                                                        <option value="4">Shikh</option>
                                                        <option value="5">Buddhism</option>
                                                        <option value="6">Christian</option>
                                                        <option value="7">Parsi</option>
                                                        <option value="8">Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_religion_by_adoption_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Groom Photo (वराचा फोटो) <br><span class="text-danger">Upload Passport size -- jpg/jpeg/png Format Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateImageFile(this)" class="form-control" name="groom_info_photos" required />
                                                    <span class="text-danger is-invalid groom_info_photos_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Id Proof (आयडी पुरावा)<span class="text-danger">*</span></label>
                                                    <select name="groom_info_id_proof" class="form-select" required>
                                                        <option value="" disabled selected>Select an ID Proof</option>
                                                        <option value="2">Aadhaar Card</option>
                                                        <option value="3">Passport</option>
                                                        <option value="4">Voter ID</option>
                                                        <option value="5">Pan Card</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_id_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Residential Proof (निवासी पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_residential_proof" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Ration Card</option>
                                                        <option value="2">Aadhaar Card</option>
                                                        <option value="3">Passport</option>
                                                        <option value="4">Voter ID</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_residential_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age Proof (वयाचा पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_age_proof" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Birth Certificate</option>
                                                        <option value="2">School Leaving Certificate</option>
                                                        <option value="3">SSC Board Certificate</option>
                                                        <option value="4">HSC Board Certificate</option>
                                                        <option value="5">Higher Education</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_age_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Id Proof (आयडी पुरावा) <br><span class="text-danger">Upload Image / Pdf Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="groom_info_id_proof_files" required/>
                                                    <span class="text-danger is-invalid groom_info_id_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Residential Proof (निवासी पुरावा) <br><span class="text-danger">Upload Image / Pdf Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="groom_info_residential_proof_files"  required/>
                                                    <span class="text-danger is-invalid groom_info_residential_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Age Proof (वयाचा पुरावा) <br><span class="text-danger">Upload Image / Pdf Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="groom_info_age_proof_files"  required/>
                                                    <span class="text-danger is-invalid groom_info_age_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) <br><span class="text-danger">Upload Image Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateImageFile(this)" class="form-control" name="groom_info_upload_signatures" required />
                                                    <span class="text-danger is-invalid groom_info_upload_signatures_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Previous Status (मागील स्थिती) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_previous_status" class="form-select" id="groomInfoPreviousStatus" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Unmarried</option>
                                                        <option value="2">Widow/Widower</option>
                                                        <option value="3">Divorce</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_previous_status_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12 d-none" id="groomInfoPreviousStatusProof">
                                                <div class="mb-3">
                                                    <label class="form-label">Previous Status Proof (मागील स्थितीचा पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_previous_status_proof" class="form-select">
                                                        <option value="">Choose one</option>
                                                        <option value="1"> Death Certificate </option>
                                                        <option value="2"> Decree &amp; Court Judgement </option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_previous_status_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12 d-none" id="groomInfoUploadPreviousStatusProofs">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Previous Status Proof (मागील स्थितीचा पुरावा)<br><span class="text-danger">Upload Image / Pdf Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="groom_info_upload_previous_status_proofs" />
                                                    <span class="text-danger is-invalid groom_info_upload_previous_status_proofs_err"></span>
                                                </div>
                                            </div>

                                            <div class="form-check d-flex align-items-start">
                                                <input type="checkbox" class="form-check-input mt-1"
                                                    id="is_correct_info"
                                                    name="is_correct_info"
                                                    value="yes"
                                                    >
                                                <label class="form-check-label ms-2" for="is_correct_info">
                                                    Is anyone residing within the MBMC area?
                                                </label>
                                            </div>

                                            <br>
                                        </div>

                                        <div class="d-flex justify-content-between">
                                            <button type="button" class="btn btn-secondary btnPrevious">Previous</button>
                                            <button type="button" class="btn btn-primary btnNext">Next</button>
                                        </div>
                                    </div>

                                    <!-- Step 4 -->
                                    <div class="tab-pane fade" id="step4" role="tabpanel">
                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name in English (पहिले नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_fname_in_english" placeholder="Enter first name in english" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required />
                                                    <span class="text-danger is-invalid bride_info_fname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In English (मधले नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_mname_in_english" placeholder="Enter middle name in english" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required />
                                                    <span class="text-danger is-invalid bride_info_mname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In English (आडनाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_lname_in_english" placeholder="Enter last name in english" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required />
                                                    <span class="text-danger is-invalid bride_info_lname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name In Marathi (पहिले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="bride_info_fname_in_marathi" placeholder="Enter first name in marathi" oninput="validateMarathiName(this)" required />
                                                    <span class="text-danger is-invalid bride_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In Marathi (मधले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="bride_info_mname_in_marathi" oninput="validateMarathiName(this)"  placeholder="Enter middle name in marathi" required />
                                                    <span class="text-danger is-invalid bride_info_mname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In Marathi (आडनाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="bride_info_lname_in_marathi" oninput="validateMarathiName(this)" placeholder="Enter last name in marathi" required />
                                                    <span class="text-danger is-invalid bride_info_lname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="bride_info_address_in_english" placeholder="Enter address in english" required></textarea>
                                                    <span class="text-danger is-invalid bride_info_address_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control marathi-only" name="bride_info_address_in_marathi" placeholder="Enter address in marathi" oninput="validateMarathi(this)" required></textarea>
                                                    <span class="text-danger is-invalid bride_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pincode (पिनकोड) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="6" minlength="6" class="form-control" name="bride_info_pincode" placeholder="Enter pincode" required />
                                                    <span class="text-danger is-invalid bride_info_pincode_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pincode in Marathi (पिनकोड मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control only-marathi-digits" name="bride_info_pincode_in_marathi" maxlength="6" minlength="6" placeholder="Enter pincode in marathi" required />
                                                    <span class="text-danger is-invalid bride_info_pincode_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="bride_info_mobile_no" placeholder="Enter mobile no" required />
                                                    <span class="text-danger is-invalid bride_info_mobile_no_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Email (ईमेल) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_email" placeholder="Enter email" required />
                                                    <span class="text-danger is-invalid bride_info_email_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Aadhar Card No. <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="12" minlength="12" class="form-control" name="bride_info_aadhar_card_no" placeholder="Enter name" required />
                                                    <span class="text-danger is-invalid bride_info_aadhar_card_no_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Date of Birth (जन्मतारीख) <span class="text-danger">*</span></label>
                                                    <input type="date" class="form-control" name="bride_info_dob" id="bdate_of_birth" max="{{ now()->format('Y-m-d') }}"
                                                         placeholder="Select date of birth" autocomplete="off" required />
                                                    <span class="text-danger is-invalid bride_info_dob_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Bride's Age At Time of Marriage <span class="text-danger">*</span></label>
                                                    <input
                                                        type="text"
                                                        id="bage"
                                                        class="form-control"
                                                        name="bride_info_age"
                                                        placeholder="Calculated Age"
                                                        readonly
                                                    />
                                                    <span class="text-danger is-invalid bride_info_age_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                                                    <select name="bride_info_gender" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Male</option>
                                                        <option value="2">Female</option>
                                                        <option value="3">Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_gender_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Religion by birth (जन्माने धर्म) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_religion_by_birth" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Hindu</option>
                                                        <option value="2">Muslim</option>
                                                        <option value="3">Jain</option>
                                                        <option value="4">Shikh</option>
                                                        <option value="5">Buddhism</option>
                                                        <option value="6">Christian</option>
                                                        <option value="7">Parsi</option>
                                                        <option value="8">Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_religion_by_birth_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Religion by adoption (दत्तक घेऊन धर्म) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_religion_by_adoption" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Hindu</option>
                                                        <option value="2">Muslim</option>
                                                        <option value="3">Jain</option>
                                                        <option value="4">Shikh</option>
                                                        <option value="5">Buddhism</option>
                                                        <option value="6">Christian</option>
                                                        <option value="7">Parsi</option>
                                                        <option value="8">Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_religion_by_adoption_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Bride Photo (वधूचा फोटो) <br><span class="text-danger">Upload Passport size -- jpg/jpeg/png Format Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateImageFile(this)" class="form-control" name="bride_info_photos" required />
                                                    <span class="text-danger is-invalid bride_info_photos_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Id Proof (आयडी पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_id_proof" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <!--<option value="1">Ration Card</option>-->
                                                        <option value="2">Aadhaar Card</option>
                                                        <option value="3">Passport</option>
                                                        <option value="4">Voter ID</option>
                                                        <option value="5">Pan Card</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_id_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Residential Proof (निवासी पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_residential_proof" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Ration Card</option>
                                                        <option value="2">Aadhaar Card</option>
                                                        <option value="3">Passport</option>
                                                        <option value="4">Voter ID</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_residential_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age Proof (वयाचा पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_age_proof" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Birth Certificate</option>
                                                        <option value="2">School Leaving Certificate</option>
                                                        <option value="3">SSC Board Certificate</option>
                                                        <option value="4">HSC Board Certificate</option>
                                                        <option value="5">Higher Education</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_age_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Id Proof (आयडी पुरावा) <br><span class="text-danger">Upload Image / Pdf Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="bride_info_id_proof_files" required />
                                                    <span class="text-danger is-invalid bride_info_id_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Residential Proof (निवासी पुरावा) <br><span class="text-danger">Upload Image / Pdf Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="bride_info_residential_proof_files" required />
                                                    <span class="text-danger is-invalid bride_info_residential_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Age Proof (वयाचा पुरावा) <br><span class="text-danger">Upload Image / Pdf Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="bride_info_age_proof_files" required />
                                                    <span class="text-danger is-invalid bride_info_age_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) Upload jpg,png img only <br><span class="text-danger">Upload Image / Pdf Format Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateImageFile(this)" class="form-control" name="bride_info_upload_signatures" placeholder="Enter name" required />
                                                    <span class="text-danger is-invalid bride_info_upload_signatures_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Previous Status (मागील स्थिती) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_previous_status" class="form-select" id="brideInfoPreviousStatus" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Unmarried</option>
                                                        <option value="2">Widow/Widower</option>
                                                        <option value="3">Divorce</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_previous_status_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12 d-none" id="brideInfoPreviousStatusProof">
                                                <div class="mb-3">
                                                    <label class="form-label">Previous Status Proof (मागील स्थितीचा पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_previous_status_proof" class="form-select">
                                                        <option value="">Choose one</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_previous_status_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12 d-none" id="brideInfoUploadPreviousStatusProofs">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Previous Status Proof (मागील स्थितीचा पुरावा) <br><span class="text-danger">Upload Image / Pdf Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="bride_info_upload_previous_status_proofs" />
                                                    <span class="text-danger is-invalid bride_info_upload_previous_status_proofs_err"></span>
                                                </div>
                                            </div>
                                             <div class="form-check d-flex align-items-start">
                                                <input type="checkbox" class="form-check-input mt-1"
                                                    id="is_correct_info_bride"
                                                    name="is_correct_info_bride"
                                                    value="yes"
                                                    >
                                                <label class="form-check-label ms-2" for="is_correct_info_bride">
                                                    Is anyone residing within the MBMC area?
                                                </label>
                                            </div>
                                        </div>

                                        <div class="d-flex justify-content-between">
                                            <button type="button" class="btn btn-secondary btnPrevious">Previous</button>
                                            <button type="button" class="btn btn-primary btnNext">Next</button>
                                        </div>
                                    </div>

                                    <!-- Step 5 -->
                                    <div class="tab-pane fade" id="step5" role="tabpanel">
                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name in English (पहिले नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="priest_info_fname_in_english" placeholder="Enter first name in english" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required />
                                                    <span class="text-danger is-invalid priest_info_fname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In English (मधले नाव इंग्रजीमध्ये)<span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="priest_info_mname_in_english" placeholder="Enter middle name in english" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required />
                                                    <span class="text-danger is-invalid priest_info_mname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In English (आडनाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="priest_info_lname_in_english" placeholder="Enter last name in english" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required />
                                                    <span class="text-danger is-invalid priest_info_lname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name In Marathi (पहिले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="priest_info_fname_in_marathi" oninput="validateMarathiName(this)" placeholder="Enter first name in marathi" required />
                                                    <span class="text-danger is-invalid priest_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In Marathi (मधले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="priest_info_mname_in_marathi" oninput="validateMarathiName(this)" placeholder="Enter middle name in marathi" required />
                                                    <span class="text-danger is-invalid priest_info_mname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In Marathi (आडनाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="priest_info_lname_in_marathi" oninput="validateMarathiName(this)" placeholder="Enter last name in marathi" required />
                                                    <span class="text-danger is-invalid priest_info_lname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea type="text" class="form-control" name="priest_info_address_in_english" placeholder="Enter address in english" required></textarea>
                                                    <span class="text-danger is-invalid priest_info_address_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea type="text" class="form-control marathi-only" name="priest_info_address_in_marathi" placeholder="Enter address in marathi" oninput="validateMarathi(this)"  required></textarea>
                                                    <span class="text-danger is-invalid priest_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="priest_info_mobile_no" placeholder="Enter mobile no" required />
                                                    <span class="text-danger is-invalid priest_info_mobile_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age (वय) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value = this.value.replace(/\D/g, '')" class="form-control" name="priest_info_age" placeholder="Enter age" maxlength="3" required />
                                                    <span class="text-danger is-invalid priest_info_age_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Religion (धर्म) <span class="text-danger">*</span></label>
                                                    <select name="priest_info_religion" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Hindu</option>
                                                        <option value="2">Muslim</option>
                                                        <option value="3">Jain</option>
                                                        <option value="4">Shikh</option>
                                                        <option value="5">Buddhism</option>
                                                        <option value="6">Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid priest_info_religion_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) <br><span class="text-danger">Upload Image/Pdf Format Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="priest_info_upload_signatures" required />
                                                    <span class="text-danger is-invalid priest_info_upload_signatures_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="d-flex justify-content-between">
                                            <button type="button" class="btn btn-secondary btnPrevious">Previous</button>
                                            <button type="button" class="btn btn-primary btnNext">Next</button>
                                        </div>
                                    </div>

                                    <!-- Step 6 -->
                                    <div class="tab-pane fade" id="step6" role="tabpanel">
                                        <h5 style="font-weight: 800;" class="text-dark">First Witness Information (प्रथम साक्षीदाराची माहिती)</h5>
                                        <hr>
                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In English (पूर्ण नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="first_witness_info_fname_in_english" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" placeholder="Enter full name in english" required />
                                                    <span class="text-danger is-invalid first_witness_info_fname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In Marathi (पूर्ण नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="first_witness_info_fname_in_marathi" placeholder="Enter full name in marathi" oninput="validateMarathiName(this)" required />
                                                    <span class="text-danger is-invalid first_witness_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="first_witness_info_mobile_no" placeholder="Enter mobile no" required />
                                                    <span class="text-danger is-invalid first_witness_info_mobile_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Date of Birth (जन्मतारीख) <span class="text-danger">*</span></label>
                                                    <input type="date" class="form-control" id="first_witness_info_dob" name="first_witness_info_dob" placeholder="Select date of birth" max="{{ now()->format('Y-m-d') }}" autocomplete="off" required />
                                                    <span class="text-danger is-invalid first_witness_info_dob_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age (वय) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value = this.value.replace(/\D/g, '')" class="form-control" name="first_witness_info_age" placeholder="Enter age" maxlength="3" required />
                                                    <span class="text-danger is-invalid first_witness_info_age_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                                                    <select name="first_witness_info_gender" class="form-select" required>
                                                        <option value="">Select gender</option>
                                                        <option value="1">Male</option>
                                                        <option value="2">Female</option>
                                                        <option value="3">Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid first_witness_info_gender_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Relation (संबंध) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="first_witness_info_relation" placeholder="Enter relation" required />
                                                    <span class="text-danger is-invalid first_witness_info_relation_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="first_witness_info_address_in_english" placeholder="Enter address" required></textarea>
                                                    <span class="text-danger is-invalid first_witness_info_address_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control marathi-only" name="first_witness_info_address_in_marathi" placeholder="Enter address in marathi" oninput="validateMarathi(this)"  required></textarea>
                                                    <span class="text-danger is-invalid first_witness_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Id Proof (कागदपत्र सादर केले) <span class="text-danger">*</span></label>
                                                    <select name="first_witness_info_id_proof" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Aadhar Card</option>
                                                        <option value="2">Voter Id</option>
                                                    </select>
                                                    <span class="text-danger is-invalid first_witness_info_id_proof_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Witness Photo (साक्षीदाराचा फोटो) <br><span class="text-danger"> Upload Passport size -- jpg/jpeg/png Format Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="first_witness_info_witness_photos" required />
                                                    <span class="text-danger is-invalid first_witness_info_witness_photos_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) <br><span class="text-danger">Upload Image/Pdf Format Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="first_witness_info_upload_signatures" required />
                                                    <span class="text-danger is-invalid first_witness_info_upload_signatures_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Document (कागदपत्र सादर केले) <span class="text-danger">Upload Image / PDF Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="first_witness_info_upload_documents"  required />
                                                    <span class="text-danger is-invalid first_witness_info_upload_documents_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <h5 style="font-weight: 800;" class="text-dark">Second Witness Information (दुसऱ्या साक्षीदाराची माहिती)</h5>
                                        <hr>
                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In English (पूर्ण नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="second_witness_info_fname_in_english" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" placeholder="Enter full name in english" required />
                                                    <span class="text-danger is-invalid second_witness_info_fname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In Marathi (पूर्ण नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="second_witness_info_fname_in_marathi" oninput="validateMarathiName(this)" placeholder="Enter full name in marathi" required />
                                                    <span class="text-danger is-invalid second_witness_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="second_witness_info_mobile_no" placeholder="Enter mobile no" required />
                                                    <span class="text-danger is-invalid second_witness_info_mobile_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Date of Birth (जन्मतारीख) <span class="text-danger">*</span></label>
                                                    <input type="date" class="form-control"  id="second_witness_info_dob" name="second_witness_info_dob" placeholder="Select date of birth" max="{{ now()->format('Y-m-d') }}" autocomplete="off" required />
                                                    <span class="text-danger is-invalid second_witness_info_dob_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age<span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value = this.value.replace(/\D/g, '')" class="form-control" name="second_witness_info_age" placeholder="Age" maxlength="3" required />
                                                    <span class="text-danger is-invalid second_witness_info_age_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                                                    <select name="second_witness_info_gender" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Male</option>
                                                        <option value="2">Female</option>
                                                        <option value="3">Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid second_witness_info_gender_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Relation (संबंध) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="second_witness_info_relation" placeholder="Enter relation" required />
                                                    <span class="text-danger is-invalid second_witness_info_relation_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="second_witness_info_address_in_english" placeholder="Enter address in english" required></textarea>
                                                    <span class="text-danger is-invalid second_witness_info_address_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control marathi-only" name="second_witness_info_address_in_marathi" placeholder="Enter address in marathi" oninput="validateMarathi(this)" required></textarea>
                                                    <span class="text-danger is-invalid second_witness_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Id Proof (कागदपत्र सादर केले) <span class="text-danger">*</span></label>
                                                    <select name="second_witness_info_id_proof" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Aadhar Card</option>
                                                        <option value="2">Voter Id</option>
                                                    </select>
                                                    <span class="text-danger is-invalid second_witness_info_id_proof_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Witness Photo (साक्षीदाराचा फोटो) <br><span class="text-danger"> Upload Passport size -- jpg/jpeg/png Format Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="second_witness_info_witness_photos" required />
                                                    <span class="text-danger is-invalid second_witness_info_witness_photos_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) <br><span class="text-danger">Upload Image/Pdf Format Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="second_witness_info_upload_signatures" required />
                                                    <span class="text-danger is-invalid second_witness_info_upload_signatures_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Document (कागदपत्र सादर केले) <br><span class="text-danger">Upload Image / PDF Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="second_witness_info_upload_documents" required />
                                                    <span class="text-danger is-invalid second_witness_info_upload_documents_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <h5 style="font-weight: 800;" class="text-dark">Third Witness Information (तिसरा साक्षीदाराची माहिती)</h5>
                                        <hr>
                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In English (पूर्ण नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="third_witness_info_fname_in_english" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" placeholder="Enter full name in english" required />
                                                    <span class="text-danger is-invalid third_witness_info_fname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In Marathi (पूर्ण नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control marathi-only" name="third_witness_info_fname_in_marathi" placeholder="Enter full name in marathi" oninput="validateMarathiName(this)" required />
                                                    <span class="text-danger is-invalid third_witness_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="third_witness_info_mobile_no" placeholder="Enter mobile no" required />
                                                    <span class="text-danger is-invalid third_witness_info_mobile_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Date of Birth (जन्मतारीख) <span class="text-danger">*</span></label>
                                                    <input type="date" class="form-control" id="third_witness_info_dob" name="third_witness_info_dob" placeholder="Enter date of birth" max="{{ now()->format('Y-m-d') }}" autocomplete="off" required />
                                                    <span class="text-danger is-invalid third_witness_info_dob_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age<span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value = this.value.replace(/\D/g, '')" class="form-control" name="third_witness_info_age" placeholder="Enter age" maxlength="3" required />
                                                    <span class="text-danger is-invalid third_witness_info_age_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                                                    <select name="third_witness_info_gender" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Male</option>
                                                        <option value="2">Female</option>
                                                        <option value="3">Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid third_witness_info_gender_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Relation (संबंध) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="third_witness_info_relation" placeholder="Enter relation" required />
                                                    <span class="text-danger is-invalid third_witness_info_relation_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="third_witness_info_address_in_english" placeholder="Enter address in english" required></textarea>
                                                    <span class="text-danger is-invalid third_witness_info_address_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control marathi-only" name="third_witness_info_address_in_marathi" placeholder="Enter address in marathi" oninput="validateMarathiName(this)" required></textarea>
                                                    <span class="text-danger is-invalid third_witness_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Id Proof (कागदपत्र सादर केले) <span class="text-danger">*</span></label>
                                                    <select name="third_witness_info_id_proof" class="form-select" required>
                                                        <option value="">Choose one</option>
                                                        <option value="1">Aadhar Card</option>
                                                        <option value="2">Voter Id</option>
                                                    </select>
                                                    <span class="text-danger is-invalid third_witness_info_id_proof_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Witness Photo (साक्षीदाराचा फोटो) <br><span class="text-danger"> Upload Passport size -- jpg/jpeg/png Format Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="third_witness_info_witness_photos" required />
                                                    <span class="text-danger is-invalid third_witness_info_witness_photos_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) <br><span class="text-danger">Upload Image/Pdf Format Only (Max size 400kb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="third_witness_info_upload_signatures" required />
                                                    <span class="text-danger is-invalid third_witness_info_upload_signatures_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Document (कागदपत्र सादर केले) <br><span class="text-danger">Upload Image / PDF Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" onchange="validateFileSize(this, 2)" class="form-control" name="third_witness_info_upload_documents" required />
                                                    <span class="text-danger is-invalid third_witness_info_upload_documents_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-md-6" id="upload_section" style="display:none;">
                                                <div class="col-md-6">
                                                    <label class="col-form-label" for="prescribed_docs">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                                    <input class="form-control" id="prescribed_docs" name="prescribed_docs" type="file" placeholder="Enter Document No. / दस्तऐवज क्रमांक भरा">
                                                    <span class="text-danger is-invalid prescribed_docs_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                                        <div class="col-md-12">
                                            <div class="form-check d-flex align-items-start">
                                                <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" required>
                                                <label class="form-check-label ms-2" for="is_correct_info">
                                                    "All information provided above is correct and I shall be fully responsible for any discrepancy. <br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                                    असेन."
                                                </label>
                                            </div>
                                                <span class="text-danger is-invalid is_correct_info_err"></span>
                                            </div>
                                        </div>
                                        <div class="mt-4" style="display: flex; justify-content :center">
                                            <button type="button" class="btn btn-info btnSavePrint">Save & Print</button>
                                            <button type="button" class="btn btn-success btnSubmitFinal" style="display:none;">Submit</button>
                                        </div>
                                    </div>
                                    </div>
                                </div>
                            </form>
                            {{-- </div> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layout>
<!-- JavaScript -->

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="/admin/js/select2.min.js"></script>
<script src="path/to/app.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

<script>
    async function generateStepwisePDF(formSelector, printTitleText) {
         if (!formSelector || formSelector === '#') {
            console.error('Invalid form selector:', formSelector);
            return;
        }
        const form = document.querySelector(formSelector);
        if (!form) return console.error('Form not found');

        const tabs = form.querySelectorAll('.tab-pane'); // all steps
        const { jsPDF } = window.jspdf;
        const pdf = new jsPDF('p', 'mm', 'a4');
        const pdfWidth = pdf.internal.pageSize.getWidth();
        const pdfHeight = pdf.internal.pageSize.getHeight();
        const margin = 10;

        let container = document.getElementById('printContainer');
        if (!container) {
            container = document.createElement('div');
            container.id = 'printContainer';
            container.style.position = 'fixed';
            container.style.left = '-9999px';
            document.body.appendChild(container);
        }

        for (let i = 0; i < tabs.length; i++) {
            const step = tabs[i];

            tabs.forEach(t => t.classList.remove('show', 'active'));
            step.classList.add('show', 'active');
            // step.style.display = 'block';
            // step.style.position = 'absolute';
            // step.style.left = '-9999px';

            const clone = step.cloneNode(true);

            if (step.id === 'step3' || step.id === 'step4') {
                clone.style.cssText = `font-size:14px; line-height:1.3; padding:15px; margin:0 auto; background:#fff; width:190mm; min-height:270mm; box-sizing:border-box;`;
            } else if (step.id === 'step6') {

                const step6Clone = clone.cloneNode(true);
                const witnessSections = Array.from(step6Clone.querySelectorAll('h5.text-dark')).map(h => {
                    const sectionDiv = document.createElement('div');
                    sectionDiv.style.marginBottom = "20px";
                    sectionDiv.appendChild(h.cloneNode(true));

                    let el = h.nextElementSibling;
                    while (el && el.tagName !== 'H5') {
                        sectionDiv.appendChild(el.cloneNode(true));
                        el = el.nextElementSibling;
                    }
                    return sectionDiv;
                });

                const containers = [
                    document.createElement('div'),
                    document.createElement('div'),
                    document.createElement('div')
                ];

                containers.forEach(container => {
                    container.style.cssText = `
                        font-size:12px;
                        line-height:1.1;
                        width:210mm;
                        min-height:310mm;
                        padding:20px;
                        background:#fff;
                        box-sizing:border-box;`;
                });

                // Assign Witness sections properly
                if (witnessSections[0]) containers[0].appendChild(witnessSections[0]);
                if (witnessSections[1]) containers[1].appendChild(witnessSections[1]);
                if (witnessSections[2]) containers[2].appendChild(witnessSections[2]);

                const tabButtons = document.querySelectorAll('.nav-link[data-bs-toggle="pill"]');
                const tabButton = tabButtons[i];
                const stepTitleText = tabButton?.getAttribute('data-title') || `Step ${i + 1}`;

                containers.forEach(c => {
                    const title = document.createElement('h2');
                    title.textContent = `${printTitleText} - ${stepTitleText}`;
                    title.style.textAlign = 'center';
                    title.style.marginBottom = '10px';
                    c.insertBefore(title, c.firstChild);
                });

                // Render each Witness Section as separate page
                for (let j = 0; j < containers.length; j++) {
                    if (!containers[j].hasChildNodes()) continue;

                    container.innerHTML = '';
                    container.appendChild(containers[j]);

                     const originalSelects = step.querySelectorAll('select');
                    originalSelects.forEach(originalSelect => {

                        const name = originalSelect.name;
                        if (!name) return;

                        const cloneSelect = containers[j].querySelector(`[name="${name}"]`);
                        if (!cloneSelect) return;

                        // prevent wrong witness mapping
                        if (!containers[j].contains(cloneSelect)) return;

                        const selectedIndex = originalSelect.selectedIndex;
                        if (selectedIndex >= 0) {
                            const selectedText = originalSelect.options[selectedIndex].textContent.trim();
                            const newDisplay = document.createElement('div');
                            newDisplay.textContent = selectedText;

                            newDisplay.style.cssText = `
                                padding: 8px 12px;
                                border: 1px solid;
                                border-radius: 4px;
                                background: #fff;
                                min-height: 34px;
                                display: flex;
                                align-items: center;
                                margin: 4px 0;
                            `;
                            cloneSelect.parentElement.appendChild(newDisplay);
                        }

                        cloneSelect.remove();
                    });


                    const canvas = await html2canvas(containers[j], {
                        scale: 2,
                        useCORS: true,
                        backgroundColor: '#fff',
                        allowTaint: true,
                    });

                    const imgData = canvas.toDataURL('image/jpeg', 0.9);
                    const ratio = canvas.width / canvas.height;
                    const imgWidth = pdfWidth - margin * 2;
                    const imgHeight = imgWidth / ratio;

                    if (i > 0 || j > 0) pdf.addPage();
                    pdf.addImage(imgData, 'JPEG', margin, margin, imgWidth, imgHeight);
                }

                continue;
            }
            else {
                clone.style.cssText = `width:210mm; min-height:297mm; padding:20px; background:#fff; box-sizing:border-box;`;
            }

            clone.style.fontFamily = getComputedStyle(step).fontFamily;
            Array.from(clone.querySelectorAll('button')).forEach(btn => btn.remove());
            Array.from(clone.querySelectorAll('.card')).forEach(card => {
                card.style.background = 'white';
                card.style.boxShadow = 'none';
                card.style.border = '1px solid #ccc';
                card.style.marginBottom = '12px';
                card.style.padding = '12px';
            });
            Array.from(clone.querySelectorAll('input[type="file"]')).forEach(cloneFileInput => {
                if (cloneFileInput.files.length > 0) {
                    const fileName = cloneFileInput.files[0].name;
                    const parentColDiv = cloneFileInput.parentElement;

                    if (parentColDiv) {
                        const labelEl = parentColDiv.querySelector('.col-form-label');
                        const labelText = labelEl ? labelEl.textContent.replace('*', '').trim() : 'Uploaded Document';
                        if (labelEl) labelEl.remove();

                         const newDisplay = document.createElement('div');
                            newDisplay.innerHTML = `
                                <div class="pdf-filename">${fileName}</div>
                            `;

                            newDisplay.style.cssText = `
                                padding: 6px 10px;
                                border: 1px solid #999;
                                border-radius: 4px;
                                background: #fafafa;
                                min-height: 36px;
                                margin: 6px 0;
                                width: 100%;
                                font-size: 13px;
                                line-height: 1.4;
                                display: flex;
                                align-items: center;
                                box-sizing: border-box;
                            `;
                        parentColDiv.appendChild(newDisplay);
                    }
                }
                cloneFileInput.remove(); // remove after processing
            });
            Array.from(form.querySelectorAll('input[type="date"]')).forEach(originalDateInput => {
                // 1. Get the corresponding date input in the CLONE
                if (originalDateInput.id) {
                        const cloneDateInput = clone.querySelector(`#${originalDateInput.id}`);
                    if (cloneDateInput) {
                        const dateValue = originalDateInput.value || originalDateInput.getAttribute('value');

                        if (dateValue) {
                            const [year, month, day] = dateValue.split('-');
                            const formattedDate = `${day}-${month}-${year}`;

                            const newBox = document.createElement('div');
                            newBox.textContent = formattedDate;
                            newBox.style.border = "1px solid #000";
        newBox.style.borderRadius = "4px";
        newBox.style.padding = "6px 10px";
        newBox.style.minHeight = "38px";
        newBox.style.fontSize = "14px";
        newBox.style.display = "flex";
        newBox.style.alignItems = "center";
        newBox.style.width = getComputedStyle(cloneDateInput).width; // match input width
        newBox.style.boxSizing = "border-box"; // ensures width matches form-control
        newBox.style.backgroundColor = "#fff"; // clean background for PDF
        newBox.style.marginTop = "0"; // keep spacing neat

                            cloneDateInput.insertAdjacentElement('afterend', newBox);
                        }

                        cloneDateInput.remove();
                    }
                }
            });

            Array.from(clone.querySelectorAll('.selected-value')).forEach(div => div.classList.remove('d-none'));
            // const originalSelects = form.querySelectorAll('select');
              const originalSelects = step.querySelectorAll('select');

            Array.from(originalSelects).forEach(originalSelect => {
            if (originalSelect.name) {
                const cloneSelect = clone.querySelector(`[name="${originalSelect.name}"]`);
                if (cloneSelect) {
                    const selectedIndex = originalSelect.selectedIndex;
                    if (selectedIndex >= 0) {
                        const selectedText = originalSelect.options[selectedIndex].textContent.trim();
                        const parentDiv = cloneSelect.parentElement;

                        const newDisplay = document.createElement('div');
                        newDisplay.textContent = selectedText;

                        newDisplay.style.cssText = `
                                    padding: 8px 12px;
                                    border: 1px solid;
                                    border-radius: 4px;
                                    background: #fff;
                                    min-height: 34px;
                                    display: flex;
                                    align-items: center;
                                    margin: 4px 0;
                                `;

                        parentDiv.appendChild(newDisplay);
                        }
                    cloneSelect.remove(); // remove the original select from clone
                }
            }
        });

            const tabButtons = document.querySelectorAll('.nav-link[data-bs-toggle="pill"]');
            const tabButton = tabButtons[i]; // now points to the actual button
            const stepTitleText = tabButton?.getAttribute('data-title')|| tabButton?.querySelector('h5, h4, .tab-title')?.textContent?.trim() || `Step ${i + 1}`;
            const title = document.createElement('h2');
            title.textContent = `${printTitleText} - ${stepTitleText}`;
            title.style.textAlign = 'center';
            title.style.marginBottom = '10px';
            clone.insertBefore(title, clone.firstChild);

            container.innerHTML = '';
            container.appendChild(clone);

            let canvas;
            try {
                canvas = await html2canvas(clone, {
                    scale: 2,
                    useCORS: true,
                    backgroundColor: '#fff',
                    allowTaint: true,
                });
            } catch(err) {
                console.error('HTML2Canvas error at step', i, err);
                continue;
            }
            const imgData = canvas.toDataURL('image/jpeg', 0.9);

            const ratio = canvas.width / canvas.height;
            const imgWidth = pdfWidth - margin * 2;
            const imgHeight = imgWidth / ratio;

            if (i > 0) pdf.addPage();
            pdf.addImage(imgData, 'JPEG', margin, margin, imgWidth, imgHeight);
        }
       $('#step6').addClass('show active');

        pdf.save(`${printTitleText}.pdf`);

    }
</script>

<script>
    const tabs = ['#step1-tab', '#step2-tab', '#step3-tab', '#step4-tab', '#step5-tab', '#step6-tab'];
    let currentStep = 0;


    function switchTab(step) {
        document.querySelector(tabs[step]).disabled = false;
        new bootstrap.Tab(document.querySelector(tabs[step])).show();
        updateProgressBar(step);
    }

    function getCurrentStepPaneId() {
        const activeTab = document.querySelector('.nav-link.active');
        return activeTab ? activeTab.getAttribute('data-bs-target') : null; // e.g., '#step1'
    }

    function validateCurrentStep() {
        let stepValid = true;
        resetErrors(); // Clear all errors first

        const currentPaneSelector = getCurrentStepPaneId();
        if (!currentPaneSelector) return false;

        const requiredFields = document.querySelector(currentPaneSelector).querySelectorAll('[required]:not([disabled])');

        let firstErrorField = null;

        requiredFields.forEach(field => {
            let isFieldValid = true;
            let errorMessage = 'This field is required'; // Default
            const fieldName = field.name;
            const fieldValue = field.value.trim();

            // 1. Basic Required Field Check
            if (field.type === 'checkbox' || field.type === 'radio') {
                if (!field.checked) {
                    isFieldValid = false;
                }
            } else if (field.tagName.toLowerCase() === 'select') {
                if (field.value === '' || field.value === null) {
                    isFieldValid = false;
                }
            } else if (fieldValue === '') {
                isFieldValid = false;
            }

            // 2. Specific Validation Checks
            if (isFieldValid) {
                switch (fieldName) {
                    case 'registration_from_applicant_mobile_no':
                    case 'groom_info_mobile_no':
                    case 'bride_info_mobile_no':
                    case 'registration_from_alternate_mobile_number':
                    case 'priest_info_mobile_no':
                    case 'first_witness_info_mobile_no':
                    case 'second_witness_info_mobile_no':
                    case 'third_witness_info_mobile_no':
                        const mobile = fieldValue.replace(/\D/g, '');
                        if (mobile.length !== 10 || isNaN(mobile)) {
                            isFieldValid = false;
                            errorMessage = 'Mobile number must be 10 digits.';
                        }
                        break;

                    case 'registration_from_aadhar_card_no':
                    case 'groom_info_aadhar_card_no':
                    case 'bride_info_aadhar_card_no':
                        const aadharNumber = fieldValue.replace(/\D/g, '');
                        if (aadharNumber.length !== 12 || isNaN(aadharNumber)) {
                            isFieldValid = false;
                            errorMessage = 'Aadhar Card number must be 12 digits.';
                        }
                        break;

                    case 'registration_from_pincode':
                    case 'bride_info_pincode':
                        const pincode = fieldValue.replace(/\D/g, '');
                        if (pincode.length !== 6 || isNaN(pincode)) {
                            isFieldValid = false;
                            errorMessage = 'Pincode must be 6 digits.';
                        }
                        break;

                    case 'registration_from_applicant_email':
                        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                        if (!emailRegex.test(fieldValue)) {
                            isFieldValid = false;
                            errorMessage = 'Please enter a proper email address.';
                        }
                        break;

                    case 'registration_from_pan_card_no':
                        // Basic PAN format check (5 letters, 4 numbers, 1 letter)
                        const panRegex = /^[A-Z]{5}[0-9]{4}[A-Z]{1}$/;
                        if (!panRegex.test(fieldValue.toUpperCase())) {
                            isFieldValid = false;
                            errorMessage = 'PAN Card number must be 10 characters (alphanumeric, 5 letters, 4 numbers, 1 letter).';
                        }
                        break;

                    case 'registration_details_marriage_date_in_english':
                        const dateRegex_english = /^\d{2}[-/]\d{2}[-/]\d{4}$/;
                        const dateRegex_displayed_format = /^\d{2}-\d{2}-\d{4}$/;

                        break;
                    case 'groom_info_email':
                    case 'bride_info_email':
                        const grromEmailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                        if (!grromEmailRegex.test(fieldValue)) {
                            isFieldValid = false;
                            errorMessage = 'Please enter a proper email address.';
                        }
                        break;
                    case 'groom_info_dob':
                        const ageCheckGroom = calculateAge(document.getElementById('gdate_of_birth').value);
                        if (ageCheckGroom < 0) { isFieldValid = false; errorMessage = 'Date of Birth cannot be a future date.'; }
                        else if (ageCheckGroom < 21) { isFieldValid = false; errorMessage = 'Groom must be 21 years or older.'; }
                        break;

                    case 'bride_info_dob':
                        const ageCheckBride = calculateBrideAge(document.getElementById('bdate_of_birth').value);
                        if (ageCheckBride < 0) { isFieldValid = false; errorMessage = 'Date of Birth cannot be a future date.'; }
                        else if (ageCheckBride < 18) { isFieldValid = false; errorMessage = 'Bride must be 18 years or older.'; }
                        break;
                    case 'groom_info_pincode_in_marathi':
                    case 'bride_info_pincode_in_marathi':
                        const marathiDigits = fieldValue.match(/[०-९]/g);
                        if (!marathiDigits || marathiDigits.length !== 6) {
                            isFieldValid = false;
                            errorMessage = 'पिनकोड ६ आकडी असावा.'; // “Pincode must be 6 digits” in Marathi
                        }
                        break;
                }
            }

            // 3. Apply Error State and Message
            if (!isFieldValid) {
                stepValid = false;
                displayError(fieldName, errorMessage);
                if (!firstErrorField) {
                    firstErrorField = field;
                }
            }
        });

        if (!stepValid && firstErrorField) {
            firstErrorField.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }

        return stepValid;
    }

    document.querySelectorAll('[required]').forEach(field => {
        field.addEventListener('input', () => {
            if (field.value.trim() !== '') {
                field.classList.remove('is-invalid');
                const errorSpan = document.querySelector(`.${field.name}_err`);
                if (errorSpan) errorSpan.textContent = '';
            }
        });
    });

    function resetErrors() {
        const invalidFields = document.querySelectorAll('.is-invalid');
        invalidFields.forEach(field => {
            field.classList.remove('is-invalid');
        });

         const errorMessages1 = document.querySelectorAll('[class*="_err"]');
        errorMessages1.forEach(errorSpan => {
            errorSpan.textContent = '';
        });
        const errorMessages = document.querySelectorAll('[class*="error-for-"]');
        errorMessages.forEach(errorSpan => {
            errorSpan.textContent = '';
        });

        const declarationError = document.querySelector('.declaration-error-text'); // Use the actual class/selector for your red text
        if(declarationError) {
            declarationError.style.display = 'none';
        }
    }

    function displayError(fieldName, message) {
        // Find the error span using the fieldName_err class
        const errorSpan = document.querySelector(`.${fieldName}_err`);
        if (errorSpan) {
            errorSpan.textContent = message;
        }
        // Add visual indicator to the input itself (if you use an is-invalid class on the input)
        const field = document.querySelector(`[name="${fieldName}"]`);
        if (field) {
            field.classList.add('is-invalid');
        }
        console.log(fieldName , message);
    }

    function updateProgressBar(step) {
        const steps = tabs.length;
        const percent = parseFloat(100 / steps) * (step + 1);
        const progressBar = document.querySelector('.progress-bar');
        if (progressBar) {
            // Assuming you have a progress bar element with the class .progress-bar
            progressBar.style.width = percent.toFixed() + "%";
        }
    }

    document.querySelectorAll('.btnNext').forEach(btn => {
        btn.addEventListener('click', () => {
            if (validateCurrentStep()) {
                if (currentStep < tabs.length - 1) {
                    currentStep++;
                    switchTab(currentStep);
                }
            }
        });
    });

    document.querySelectorAll('.btnPrevious').forEach(btn => {
        btn.addEventListener('click', () => {
            if (currentStep > 0) {
                currentStep--;
                switchTab(currentStep);
            }
        });
    });

</script>

<script>
    function syncDates(englishDateField) {
        const marathiField = document.getElementById('registration_details_marriage_date_in_marathi');
        const dateValue = englishDateField.value; // format: YYYY-MM-DD

        if (marathiField && dateValue) {
            const [year, month, day] = dateValue.split('-');
            const formattedDate = `${day}-${month}-${year}`;

            marathiField.value = formattedDate;

            // Trigger events in case other scripts listen to input/change
            marathiField.dispatchEvent(new Event('input', { bubbles: true }));
            marathiField.dispatchEvent(new Event('change', { bubbles: true }));
        } else if (marathiField) {
            marathiField.value = '';
            marathiField.dispatchEvent(new Event('change', { bubbles: true }));
        }
    }
</script>


<script>

    function calculateAge(dobValue) {
        const ageInput = document.getElementById('gage');
        if (!dobValue) {
            if (ageInput) ageInput.value = '';
            return null;
        }
        const parts = dobValue.split('-');
        if (parts.length !== 3) return null;

        const dob = new Date(parts[0], parts[1]-1, parts[2]);
        if (isNaN(dob)) return null;

        const today = new Date();
        let age = today.getFullYear() - dob.getFullYear();
        const monthDiff = today.getMonth() - dob.getMonth();
        if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < dob.getDate())) age--;

        if (ageInput) ageInput.value = age;
        return age;
    }

    function calculateBrideAge(dobValue) {
        const ageInput = document.getElementById('bage');
        if (!dobValue) {
            if (ageInput) ageInput.value = '';
            return null;
        }
        const parts = dobValue.split('-');
        if (parts.length !== 3) return null;

        const dob = new Date(parts[0], parts[1]-1, parts[2]);
        if (isNaN(dob)) return null;

        const today = new Date();
        let age = today.getFullYear() - dob.getFullYear();
        const monthDiff = today.getMonth() - dob.getMonth();
        if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < dob.getDate())) age--;

        if (ageInput) ageInput.value = age;
        return age;
    }

    function validateFileSize(input, maxSizeMB) {
        if (input.files[0].size > maxSizeMB * 1024 * 1024) {
            alert("File too large! Max size " + maxSizeMB + "MB");
            input.value = "";
            return false;
        }
        return true;
    }

    function validateImageFile(input) {
        const allowedTypes = ['image/jpeg', 'image/png', 'image/jpg'];
        const maxSize = 400 * 1024; // 400 KB
        const file = input.files[0];

        // Safely find the error span in the same parent container
        const errorSpan = input.closest('.mb-3')?.querySelector('.text-danger');
        if (errorSpan) errorSpan.textContent = '';

        if (file) {
            const fileType = file.type.toLowerCase();
            const fileName = file.name.toLowerCase();

            // ✅ Check both MIME type & file extension for reliability
            const validExtension = fileName.endsWith('.jpg') || fileName.endsWith('.jpeg') || fileName.endsWith('.png');

            if (!allowedTypes.includes(fileType) && !validExtension) {
                if (errorSpan) errorSpan.textContent = 'Only JPG, JPEG, or PNG files are supported';
                input.value = '';
                return false;
            }

            if (file.size > maxSize) {
                if (errorSpan) errorSpan.textContent = 'File size must be less than 400 KB';
                input.value = '';
                return false;
            }
        }
    }

    document.addEventListener("DOMContentLoaded", function() {
        console.log("DOM fully loaded ✅");

        const btnSubmit = document.querySelector('.btnSubmitFinal');
        const btnSavePrint = document.querySelector('.btnSavePrint');
        const pdfLoaderModal = document.getElementById('pdfLoaderModal');

        const groomDOB = document.getElementById('gdate_of_birth');
        const brideDOB = document.getElementById('bdate_of_birth');


        // ================== AGE CALCULATION ==================
        if (groomDOB) groomDOB.addEventListener('change', function() {
            calculateAge(this.value);
        });

        if (brideDOB) brideDOB.addEventListener('change', function() {
            calculateBrideAge(this.value);
        });

        function calculateAge(dobValue) {
            const ageInput = document.getElementById('gage');
            const marriageDateInput = document.getElementById('registration_details_marriage_date_in_english');
            const marriageDateValue = marriageDateInput ? marriageDateInput.value : null;

            if (!dobValue) {
                if (ageInput) ageInput.value = '';
                validateGroomAge(null);
                return null;
            }

            const parts = dobValue.split('-');
            if (parts.length !== 3) return null;

            const dob = new Date(parts[0], parts[1] - 1, parts[2]);
            if (isNaN(dob)) return null;

            // ✅ Use marriage date if available, else fallback to today
            const referenceDate = marriageDateValue ? new Date(marriageDateValue) : new Date();

            let age = referenceDate.getFullYear() - dob.getFullYear();
            const monthDiff = referenceDate.getMonth() - dob.getMonth();
            if (monthDiff < 0 || (monthDiff === 0 && referenceDate.getDate() < dob.getDate())) age--;

            // ✅ Prevent negative ages
            if (age < 0) age = -1;

            if (ageInput) ageInput.value = age;

            validateGroomAge(age);
            return age;
            }

            function calculateBrideAge(dobValue) {
            const ageInput = document.getElementById('bage');
            const marriageDateInput = document.getElementById('registration_details_marriage_date_in_english');
            const marriageDateValue = marriageDateInput ? marriageDateInput.value : null;

            if (!dobValue) {
                if (ageInput) ageInput.value = '';
                validateBrideAge(null);
                return null;
            }

            const parts = dobValue.split('-');
            if (parts.length !== 3) return null;

            const dob = new Date(parts[0], parts[1] - 1, parts[2]);
            if (isNaN(dob)) return null;

            const referenceDate = marriageDateValue ? new Date(marriageDateValue) : new Date();

            let age = referenceDate.getFullYear() - dob.getFullYear();
            const monthDiff = referenceDate.getMonth() - dob.getMonth();
            if (monthDiff < 0 || (monthDiff === 0 && referenceDate.getDate() < dob.getDate())) age--;

            // ✅ Prevent negative ages
            if (age < 0) age = -1;

            if (ageInput) ageInput.value = age;

            validateBrideAge(age);
            return age;
        }

        function validateGroomAge(age) {
            const errorSpan = document.querySelector('.groom_info_dob_err');
            if (!age && age !== 0) { errorSpan.textContent = 'Please enter date of birth.'; return false; }
            if (age < 0) { errorSpan.textContent = 'Date of Birth cannot be a future date.'; return false; }
            if (age < 21) { errorSpan.textContent = 'Groom must be at least 21 years old.'; return false; }
            errorSpan.textContent = '';
            return true;
        }

        function validateBrideAge(age) {
            const errorSpan = document.querySelector('.bride_info_dob_err');
            if (!age && age !== 0) { errorSpan.textContent = 'Please enter date of birth.'; return false; }
            if (age < 0) { errorSpan.textContent = 'Date of Birth cannot be a future date.'; return false; }
            if (age < 18) { errorSpan.textContent = 'Bride must be at least 18 years old.'; return false; }
            errorSpan.textContent = '';
            return true;
        }

        // ================== SAVE & PRINT ==================
        if (btnSavePrint) {
            btnSavePrint.addEventListener('click', async function(e) {
                e.preventDefault();
                console.log("Save & Print clicked ✅");

                const form = document.querySelector('#multiStepForm');
                if (!form) return console.error("Form not found ❌");

                // Validate all steps
                let allValid = true;
                for (let i = 0; i < tabs.length; i++) {
                    currentStep = i;
                    switchTab(currentStep);
                    if (!validateCurrentStep()) {
                        allValid = false;
                        break;
                    }
                }

                if (!allValid) {
                    swal("Error!", "Please fill all required fields correctly before generating PDF.", "warning");
                    return;
                }

                try {
                    if (pdfLoaderModal) pdfLoaderModal.style.display = 'flex'; // show loader
                    await generateStepwisePDF('#multiStepForm', 'Marriage Certificate Application');

                    // Show upload section
                    const uploadSection = document.getElementById('upload_section');
                    if (uploadSection) uploadSection.style.display = 'block';

                    // Make prescribed_docs required
                    const prescribedDocs = document.getElementById('prescribed_docs');
                    if (prescribedDocs) prescribedDocs.setAttribute('required', 'required');

                    // Toggle buttons
                    document.querySelector('.btnSubmitFinal').style.display = 'inline-block';
                    document.querySelector('.btnSavePrint').style.display = 'none';

                    swal("PDF Generated!", "Your form PDF has been generated successfully.", "success");

                } catch(err) {
                    console.error("PDF generation failed ❌", err);
                    swal("Error!", "PDF generation failed.", "error");
                } finally {
                    if (pdfLoaderModal) pdfLoaderModal.style.display = 'none'; // hide loader
                }
            });
        }

        // ================== SUBMIT ==================
        if (btnSubmit) {
            btnSubmit.addEventListener('click', function(e) {
                e.preventDefault();
                console.log("Submit button clicked");

                const checkboxGroom = document.getElementById('is_correct_info');
                const checkboxBride = document.getElementById('is_correct_info_bride');

                if (!checkboxGroom?.checked && !checkboxBride?.checked) {
                    swal("Alert", "You are not a member of MBMC.", "warning");
                    return;
                }

                // Check prescribed_docs before submission
                const prescribedDocs = document.getElementById('prescribed_docs');
                const errorSpan = document.querySelector('.prescribed_docs_err');
                if (prescribedDocs && (!prescribedDocs.files || prescribedDocs.files.length === 0)) {
                    errorSpan.textContent = "Please upload the application document.";
                    prescribedDocs.classList.add('is-invalid');
                    prescribedDocs.scrollIntoView({behavior:'smooth', block:'center'});
                    return;
                } else {
                    errorSpan.textContent = '';
                    prescribedDocs.classList.remove('is-invalid');
                }

                // Submit form via AJAX
                const formdata = new FormData(document.getElementById('multiStepForm'));
                formdata.append('_token', '{{ csrf_token() }}');
                $.ajax({
                    url: '{{ route('marriage-registration.store-marriage-registration-form') }}',
                    type: 'POST',
                    data: formdata,
                    contentType: false,
                    processData: false,
                    beforeSend: function() { $('#preloader').css({opacity:'0.5',visibility:'visible'}); },
                    success: function(data) {
                        if (!data.error) {
                            swal("Successful!", data.success, "success")
                                .then(()=>window.location.href='/my-application');
                        } else {
                            swal("Error!", data.error, "error");
                        }
                    },
                    statusCode: {
                        422: function(resp){ printErrMsg(resp.responseJSON.errors); },
                        500: function(){ swal("Error!", "Something went wrong.", "error"); }
                    },
                    complete: function() { $('#preloader').css({opacity:'0',visibility:'hidden'}); }
                });
            });
        }

        function printErrMsg(msg) {
            $.each(msg, function(key, value){
                $('.' + key + '_err').text(value);
            });
        }

    });

$('.marathi-only').on('keypress', function(e) {
    const char = String.fromCharCode(e.which);

    // Allowed characters:
    const allowed = /[\u0900-\u097F\u0966-\u096F .,\/\-_:;#@&'"()!?*+]/;

    if (!allowed.test(char)) {
        e.preventDefault();
    }
});



    document.addEventListener('input', function (e) {
        if (e.target.classList.contains('only-marathi-digits')) {
            e.target.value = e.target.value.replace(/[^०-९]/g, '');
        }
    });

</script>


<style>
    .modal-loader {
        display: none; /* hidden initially */
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        z-index: 1050;
        justify-content: center;
        align-items: center;
    }

    .loader-content {
        background: #fff;
        padding: 30px 50px;
        border-radius: 10px;
        text-align: center;
        box-shadow: 0 0 20px rgba(0,0,0,0.3);
    }

    .spinner {
        border: 6px solid #f3f3f3;
        border-top: 6px solid #007bff;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        margin: 0 auto 15px auto;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .loader-content p {
        margin: 0;
        font-size: 18px;
        color: #333;
    }
</style>

<!-- no  use -->
{{-- Add marriage registration details --}}
{{-- <script>
    $("#marriageRegistrationDetails").submit(function(e) {
        e.preventDefault();
        $("#marriageRegistrationDetailsBtn").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('marriage-registration.store-marriage-registration-details') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function()
            {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#marriageRegistrationDetailsBtn").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        checkStatuActive("groom-information")
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#marriageRegistrationDetailsBtn").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#marriageRegistrationDetailsBtn").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script> --}}
{{-- End of add marriage registration details --}}


{{-- Add groom information --}}
{{-- <script>
    $("#groomInformation").submit(function(e) {
        e.preventDefault();
        $("#groomInformationBtn").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('marriage-registration.store-groom-information') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function()
            {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#groomInformationBtn").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        checkStatuActive("bride-information")
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#groomInformationBtn").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#groomInformationBtn").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script> --}}
{{-- End of add groom information --}}

{{-- Add bride information --}}
{{-- <script>
    $("#brideInformation").submit(function(e) {
        e.preventDefault();
        $("#brideInformationBtn").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('marriage-registration.store-bride-information') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function()
            {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#brideInformationBtn").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        checkStatuActive("priest-information")
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#brideInformationBtn").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#brideInformationBtn").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script> --}}
{{-- End of add bride information --}}

{{-- Add priest information --}}
{{-- <script>
    $("#priestInformation").submit(function(e) {
        e.preventDefault();
        $("#priestInformationBtn").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('marriage-registration.store-priest-information') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function()
            {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#priestInformationBtn").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        checkStatuActive("witness-information")
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#priestInformationBtn").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#priestInformationBtn").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script> --}}
{{-- End of add bride information --}}

{{-- Add witness information --}}
{{-- <script>
    $("#witnessInformation").submit(function(e) {
        e.preventDefault();
        $("#witnessInformationBtn").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('marriage-registration.store-witness-information') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function()
            {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#witnessInformationBtn").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route("my-application") }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#witnessInformationBtn").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#witnessInformationBtn").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });

    function checkStatuActive(id){
        $('.nav-link').removeClass('active');
        $('#'+id+'-tab').addClass('active');
        $('#'+id+'-tab').prop("disabled", false);
        $('.tab-pane.fade').removeClass('show active');
        $('#'+id).addClass('show active')
    }
</script> --}}
{{-- End of add bride information --}}

{{-- event --}}
{{-- <script>
    $(document).ready(function(){
        $('#registrationFromMarriageSolemnizedWithinMaharashtraState').change(function(){
            let checkValue = $(this).val();

            if(checkValue == "1"){
                $('#registrationFromAffidavitForMarriageOutsideMaharashtras').addClass('d-none');
                $('#registrationFromAffidavitForMarriageOutsideMaharashtras').find('input[name="registration_from_affidavit_for_marriage_outside_maharashtras"]').prop('required', false);
            }else{
                $('#registrationFromAffidavitForMarriageOutsideMaharashtras').removeClass('d-none');
                $('#registrationFromAffidavitForMarriageOutsideMaharashtras').find('input[name="registration_from_affidavit_for_marriage_outside_maharashtras"]').prop('required', true);
            }
        });


        $("#gdate_of_birth").change(function() {
            var today = new Date();
            var dateString = $(this).val();
            var birthDate = new Date(dateString);
            var age = today.getFullYear() - birthDate.getFullYear();
            var m = today.getMonth() - birthDate.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
                age--;
            }

            if (age >= 21) {
                $("#groomInformationBtn").removeClass('d-none');
            } else {
                $("#gdate_of_birth").val("");
                alert("Your Age is less than 21 you are not eligible");
                $("#groomInformationBtn").addClass('d-none');
            }
        });


        $('#groomInfoPreviousStatus').change(function(){
            let checkValue = $(this).val();

            if(checkValue == "2"){
                $('#groomInfoPreviousStatusProof').removeClass('d-none');
                $('#groomInfoPreviousStatusProof').find('select').html(`<option value="1"> Death Certificate </option>`);
                $('#groomInfoUploadPreviousStatusProofs').removeClass('d-none');
            }else if(checkValue == "3"){
                $('#groomInfoPreviousStatusProof').removeClass('d-none');
                $('#groomInfoPreviousStatusProof').find('select').html(`<option value="2"> Decree &amp; Court Judgement </option>`);
                $('#groomInfoUploadPreviousStatusProofs').removeClass('d-none');
            }else{
                $('#groomInfoPreviousStatusProof').addClass('d-none');
                $('#groomInfoPreviousStatusProof').find('select').html(`<option value=""></option>`);
                $('#groomInfoUploadPreviousStatusProofs').addClass('d-none');
            }
        });


        $("#bdate_of_birth").change(function() {
            var today = new Date();
            var dateString = $(this).val();
            var birthDate = new Date(dateString);
            var age = today.getFullYear() - birthDate.getFullYear();
            var m = today.getMonth() - birthDate.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
                age--;
            }

            if (age >= 18) {
                $("#brideInformationBtn").removeClass('d-none');
            } else {
                $("#bdate_of_birth").val("");
                alert("Your Age is less than 18 you are not eligible");
                $("#brideInformationBtn").addClass('d-none');
            }
        });

        $('#brideInfoPreviousStatus').change(function(){
            let checkValue = $(this).val();

            if(checkValue == "2"){
                $('#brideInfoPreviousStatusProof').removeClass('d-none');
                $('#brideInfoPreviousStatusProof').find('select').html(`<option value="1"> Death Certificate </option>`);
                $('#brideInfoUploadPreviousStatusProofs').removeClass('d-none');
            }else if(checkValue == "3"){
                $('#brideInfoPreviousStatusProof').removeClass('d-none');
                $('#brideInfoPreviousStatusProof').find('select').html(`<option value="2"> Decree &amp; Court Judgement </option>`);
                $('#brideInfoUploadPreviousStatusProofs').removeClass('d-none');
            }else{
                $('#brideInfoPreviousStatusProof').addClass('d-none');
                $('#brideInfoPreviousStatusProof').find('select').html(`<option value=""></option>`);
                $('#brideInfoUploadPreviousStatusProofs').addClass('d-none');
            }
        });
    })
</script> --}}
{{-- <script>
function syncDates(englishDateField) {
    const marathiField = document.getElementById('registration_details_marriage_date_in_marathi');
    const dateValue = englishDateField.value; // YYYY-MM-DD

    if (!dateValue) {
        marathiField.value = "";
        return;
    }

    // English → Marathi digit mapping
    const marathiDigits = {
        '0': '०',
        '1': '१',
        '2': '२',
        '3': '३',
        '4': '४',
        '5': '५',
        '6': '६',
        '7': '७',
        '8': '८',
        '9': '९'
    };

    // Convert English numbers → Marathi numbers
    function convertToMarathi(str) {
        return str.replace(/[0-9]/g, d => marathiDigits[d]);
    }

    // Split date (YYYY-MM-DD)
    const parts = dateValue.split("-");
    const year = parts[0];
    const month = parts[1];
    const day = parts[2];

    // Final Marathi date (DD-MM-YYYY)
    const finalMarathiDate =
        convertToMarathi(day) + "-" +
        convertToMarathi(month) + "-" +
        convertToMarathi(year);

    // Set to Marathi field
    marathiField.value = finalMarathiDate;

    // Trigger events (optional)
    marathiField.dispatchEvent(new Event('input', { bubbles: true }));
    marathiField.dispatchEvent(new Event('change', { bubbles: true }));
}
</script> --}}
<script>
function syncDates(englishDateField) {

    const marathiField = document.getElementById('registration_details_marriage_date_in_marathi');
    const errorSpan = document.querySelector('.registration_details_marriage_date_in_english_err');
    const dateValue = englishDateField.value;

    // Marathi digits map
    const marathiDigits = {
        "0": "०",
        "1": "१",
        "2": "२",
        "3": "३",
        "4": "४",
        "5": "५",
        "6": "६",
        "7": "७",
        "8": "८",
        "9": "९"
    };

    function convertToMarathi(numStr) {
        return numStr.replace(/[0-9]/g, d => marathiDigits[d]);
    }

    // If empty
    if (!dateValue) {
        if (marathiField) marathiField.value = "";
        if (errorSpan) errorSpan.textContent = "";
        return;
    }

    // FUTURE DATE CHECK
    const selectedDate = new Date(dateValue);
    const today = new Date();
    today.setHours(0, 0, 0, 0);

    if (selectedDate > today) {
        if (errorSpan) errorSpan.textContent = "Future date is not allowed.";
        englishDateField.value = "";
        if (marathiField) marathiField.value = "";
        return;
    } else {
        if (errorSpan) errorSpan.textContent = "";
    }

    // FORMAT: DD-MM-YYYY (converted to Marathi)
    const [year, month, day] = dateValue.split("-");
    const formatted = `${convertToMarathi(day)}-${convertToMarathi(month)}-${convertToMarathi(year)}`;

    marathiField.value = formatted;

    marathiField.dispatchEvent(new Event('input', { bubbles: true }));
    marathiField.dispatchEvent(new Event('change', { bubbles: true }));
}
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {

    function validateDate() {
        const inputDate = new Date(this.value + "T00:00:00");
        const today = new Date();
        today.setHours(0,0,0,0);

        const errorSpan = document.querySelector("." + this.id + "_err");
        if (errorSpan) errorSpan.textContent = "";

        if (inputDate > today) {
            if (errorSpan) errorSpan.textContent = "Future date is not allowed.";
            this.value = "";
        }
        const age = calculateAge(inputDate);

        if (age < 18) {
            if (errorSpan) errorSpan.textContent = "Witness must be more than 18 years old.";
            this.value = "";
            return;
        }
    }
      function calculateAge(birthDate) {
        const today = new Date();
        let age = today.getFullYear() - birthDate.getFullYear();
        const m = today.getMonth() - birthDate.getMonth();

        if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
            age--;
        }
        return age;
    }

    ["first_witness_info_dob", "second_witness_info_dob", "third_witness_info_dob"].forEach(id => {
        const field = document.getElementById(id);
        if (field) field.addEventListener("change", validateDate);
    });

});
</script>
<script>
function validateMarathi(field) {
    // Allow: Devanagari + special chars + spaces
    const allowed = /[^\u0900-\u097F\s\p{P}\p{S}]/gu;
    field.value = field.value.replace(allowed, "");
}
</script>
<script>
function validateMarathiName(field) {
    // Allow ONLY Marathi letters + spaces
    const allowed = /[^\u0900-\u097F\s]/g;
    field.value = field.value.replace(allowed, "");
}
</script>








