<x-layout>
    <x-slot name="title">Issuance Of Marriage Registration Certificate / विवाह नोंदणी प्रमाणपत्र देणे</x-slot>
    {{-- <x-slot name="heading">Issuance Of Marriage Registration Certificate / विवाह नोंदणी प्रमाणपत्र देणे</x-slot> --}}
@php
    $can_update = Auth::check() && Auth::user()->hasRole('Clerk');
    $approve_require_fields = 
        !empty($data->serialnumber_eng) &&
        !empty($data->volumenumber_eng) &&
        !empty($data->sr_number_mr) &&
        !empty($data->volume_number_mr);
@endphp

    <div class="row">
        <div class="col-lg-12">
            <div class="row">
                <div class="col-xl-12 col-12">
                    <div class="card">
                        {{-- <div class="container mt-5"> --}}
                        <div class="card-header">
                            <h4 class="mb-0 text-dark" style="font-weight: 600">
                                VIEW ISSUANCE OF MARRIAGE REGISTRATION CERTIFICATE / विवाह नोंदणी प्रमाणपत्र देणे
                            </h4>
                        </div>
                        <div class="card-body">
                            <!-- Tabs -->

                            <!-- Form Steps -->
                            <form id="multiStepForm" enctype="multipart/form-data">
                                 @csrf


                            <input type="hidden" model-id="id" value="{{ $status->id }}">
                                <div class="tab-content">
                                    <div class="card-header">
                                        <h4 class="mb-0 text-dark" style="font-weight: 600">
                                            Marriage Registration Form / (विवाह नोंदणी फॉर्म)
                                        </h4>
                                    </div>
                                    <br>
                                    <!-- Step 1 -->
                                    <div class="tab-pane fade show active" id="step1" role="tabpanel">
                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Applicant Mobile Number (अर्जदाराचा मोबाईल क्रमांक) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" name="registration_from_applicant_mobile_no" placeholder="Enter applicant mobile number" value="{{ $data->registration_from_applicant_mobile_no }}" readonly/>
                                                    <span class="text-danger is-invalid registration_from_applicant_mobile_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Applicant Full Name (अर्जदाराचे पूर्ण नाव)<span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="registration_from_applicant_full_name" placeholder="Enter applicant full name" value="{{ $data->registration_from_applicant_full_name }}" readonly />
                                                    <span class="text-danger is-invalid registration_from_applicant_full_name_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Applicant Home Address (अर्जदाराच्या घराचा पत्ता) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="registration_from_applicant_home_address"  readonly placeholder="Enter applicant home address">{{ $data->registration_from_applicant_home_address }}</textarea>
                                                    <span class="text-danger is-invalid registration_from_applicant_home_address_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pincode (पिनकोड) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="6" minlength="6" class="form-control" name="registration_from_pincode" value="{{ $data->registration_from_pincode }}" placeholder="Enter pincode"  readonly/>
                                                    <span class="text-danger is-invalid registration_from_pincode_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Applicant E-mail (अर्जदाराचा ई-मेल) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="registration_from_applicant_email" value="{{ $data->registration_from_applicant_email }}" placeholder="Enter applicant email"  readonly/>
                                                    <span class="text-danger is-invalid registration_from_applicant_email_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Aadhar Card No. (आधार कार्ड क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="12" minlength="12" value="{{ $data->registration_from_aadhar_card_no }}" class="form-control" name="registration_from_aadhar_card_no" placeholder="Enter aadhar card no."  readonly/>
                                                    <span class="text-danger is-invalid registration_from_aadhar_card_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Applicant alternate Mobile Number (अर्जदाराचा पर्यायी मोबाईल क्रमांक)</label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="registration_from_alternate_mobile_number" value="{{ $data->registration_from_alternate_mobile_number }}" placeholder="Enter applicant alternate mobile number"  readonly/>
                                                    <span class="text-danger is-invalid registration_from_alternate_mobile_number_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pan Card No. (पॅन कार्ड क्र.) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="registration_from_pan_card_no" placeholder="Enter pan card no." value="{{ $data->registration_from_pan_card_no }}"  readonly/>
                                                    <span class="text-danger is-invalid registration_from_pan_card_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Residential Ward Name (रहिवाशीच्या प्रभागाचे नाव) <span class="text-danger">*</span></label>
                                                    <select name="registration_from_residential_ward_name" class="form-select"  disabled>
                                                        <option value="">Select Ward</option>
                                                        @foreach ($options as $ward)
                                                            <option @if ($data->registration_from_residential_ward_name == $ward->id) selected @endif value="{{ $ward->id }}">{{ $ward->name }}</option>
                                                        @endforeach
                                                    </select>

                                                    <span class="text-danger is-invalid registration_from_residential_ward_name_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Marriage solemnized within Maharashtra State? (विवाह सोहळा महाराष्ट्र राज्यात झाला आहे का ?) <span class="text-danger">*</span></label>
                                                    <select name="registration_from_marriage_solemnized_within_maharashtra_state" id="registrationFromMarriageSolemnizedWithinMaharashtraState" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->registration_from_marriage_solemnized_within_maharashtra_state == '1' ? 'selected' : '' ?>>Yes</option>
                                                        <option value="2" <?= $data->registration_from_marriage_solemnized_within_maharashtra_state == '2' ? 'selected' : '' ?>>No</option>
                                                    </select>
                                                    <span class="text-danger is-invalid registration_from_marriage_solemnized_within_maharashtra_state_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-6 col-12 d-none" id="registrationFromAffidavitForMarriageOutsideMaharashtras">
                                                <div class="mb-3">
                                                    <label class="form-label">Affidavit for Marriage Outside Maharashtra <br><span class="text-danger">Upload PDF Format Only (Max size 2mb) *</span></label>
                                                    <input type="file" class="form-control" name="registration_from_affidavit_for_marriage_outside_maharashtras" value="{{ $data->registration_from_affidavit_for_marriage_outside_maharashtras }}" placeholder="Enter affidavit for marriage outside maharashtra"  readonly/>
                                                    <span class="text-danger is-invalid registration_from_affidavit_for_marriage_outside_maharashtras_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card-header">
                                            <h4 class="mb-0 text-dark" style="font-weight: 600">
                                                Marriage Registration Details (विवाह नोंदणी माहिती)
                                            </h4>
                                        </div>

                                        <!-- Step 2 -->

                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Form Filled Date (फॉर्म भरण्याची तारीख) <span class="text-danger">*</span></label>
                                                    <input type="date" value="{{ date('Y-m-d') }}" class="form-control" name="registration_details_form_filled_date" value="{{ $data->registration_details_form_filled_date }}" placeholder="Enter form filled date" autocomplete="off" readonly />
                                                    <span class="text-danger is-invalid registration_details_form_filled_date_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Marriage Date in English (लग्नाची तारीख इंग्रजीमध्ये)<span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control datepicker" name="registration_details_marriage_date_in_english" placeholder="Enter marriage date in english" value="{{ $data->registration_details_marriage_date_in_english ? \Carbon\Carbon::parse($data->registration_details_marriage_date_in_english)->format('d-m-Y') : '' }}"  autocomplete="off" readonly/>
                                                    <span class="text-danger is-invalid registration_details_marriage_date_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Marriage Date in Marathi (लग्नाची तारीख मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="registration_details_marriage_date_in_marathi" placeholder="Enter marriage date in marathi" value="{{ $data->registration_details_marriage_date_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid registration_details_marriage_date_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Marriage Place, Full Address in English (इंग्रजीमध्ये लग्नाच्या ठिकाणाचा पत्ता) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="registration_details_marriage_place_in_english" readonly placeholder="Enter marriage place, full address in english">{{ $data->registration_details_marriage_place_in_english }}</textarea>
                                                    <span class="text-danger is-invalid registration_details_marriage_place_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Marriage Place, Full Address in Marathi (मराठीमध्ये लग्नाच्या ठिकाणाचा पत्ता) <span class="text-danger">*</span></label>
                                                    <textarea type="text" class="form-control" name="registration_details_marriage_place_in_marathi"  readonly placeholder="Enter marriage place, full address in marathi">{{ $data->registration_details_marriage_place_in_marathi }}</textarea>
                                                    <span class="text-danger is-invalid registration_details_marriage_place_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Couple Photo of Wedding (लग्न विधी चा फोटो) </label>
                                                    @if($data->registration_details_couple_photo)
                                                        <div class="mb-2">
                                                            <a href="{{ asset('storage/' . $data->registration_details_couple_photo) }}" target="_blank" class="btn btn-sm btn-success">View Document</a>
                                                        </div>
                                                    @endif
                                                    <input type="file" class="form-control" name="registration_details_couple_photos" />
                                                    <span class="text-danger is-invalid registration_details_couple_photos_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Is Husband/Wife Widower/Widow? (वर/वधू -- विधुर / विधवा आहे का ?) <span class="text-danger">*</span></label>
                                                    <select name="registration_details_is_widow" class="form-select" disabled>
                                                        <option value="">Select option</option>
                                                        <option value="1" <?= $data->registration_details_is_widow == '1' ? 'selected' : '' ?>>Yes</option>
                                                        <option value="2" <?= $data->registration_details_is_widow == '2' ? 'selected' : '' ?>>No</option>
                                                    </select>
                                                    <span class="text-danger is-invalid registration_details_is_widow_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Is Husband/Wife previously divorced? (वर वधू यांचे घटस्पोट झाला आहे का ?) <span class="text-danger">*</span></label>
                                                    <select name="registration_details_is_previously_divorced" class="form-select" disabled>
                                                        <option value="">Select option</option>
                                                        <option value="1" <?= $data->registration_details_is_previously_divorced == '1' ? 'selected' : '' ?>>Yes</option>
                                                        <option value="2" <?= $data->registration_details_is_previously_divorced == '2' ? 'selected' : '' ?>>No</option>
                                                    </select>
                                                    <span class="text-danger is-invalid registration_details_is_previously_divorced_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Is Marriage Intercaste? (आंतरजातीय विवाह झाला आहे का ?) <span class="text-danger">*</span></label>
                                                    <select name="registration_details_is_marriage_intercaste" class="form-select" disabled>
                                                        <option value="">Select option</option>
                                                        <option value="1" <?= $data->registration_details_is_marriage_intercaste == '1' ? 'selected' : '' ?>>Yes</option>
                                                        <option value="2" <?= $data->registration_details_is_marriage_intercaste == '2' ? 'selected' : '' ?>>No</option>
                                                    </select>
                                                    <span class="text-danger is-invalid registration_details_is_marriage_intercaste_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Wedding card Image. If not available, attach Affidavit (लग्न पत्रिका चा फोटो नसल्यास, प्रतिज्ञापत्र जोडावे )</label>
                                                    @if (!empty($data->registration_details_wedding_card_image))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->registration_details_wedding_card_image) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    <span class="text-danger is-invalid registration_details_wedding_card_images_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card-header">
                                            <h4 class="mb-0 text-dark" style="font-weight: 600">
                                                Groom Information (वराची माहिती)
                                            </h4>
                                        </div>

                                        <!-- Step 3 -->

                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name in English (पहिले नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_fname_in_english" placeholder="Enter first name in english" value="{{ $data->groom_info_fname_in_english }}" readonly/>
                                                    <span class="text-danger is-invalid groom_info_fname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In English (मधले नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_mname_in_english" placeholder="Enter middle name in english" value="{{ $data->groom_info_mname_in_english }}"  readonly/>
                                                    <span class="text-danger is-invalid groom_info_mname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In English (आडनाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_lname_in_english" placeholder="Enter last name in english" value="{{ $data->groom_info_lname_in_english }}"  readonly/>
                                                    <span class="text-danger is-invalid groom_info_lname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name In Marathi (पहिले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_fname_in_marathi" placeholder="Enter first name in marathi" value="{{ $data->groom_info_fname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid groom_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In Marathi (मधले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_mname_in_marathi" placeholder="Enter middle name in marathi" value="{{ $data->groom_info_mname_in_marathi }}" readonly />
                                                    <span class="text-danger is-invalid groom_info_mname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In Marathi (आडनाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_lname_in_marathi" placeholder="Enter last name in marathi" value="{{ $data->groom_info_lname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid groom_info_lname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="groom_info_address_in_english"  readonly placeholder="Enter address in english">{{ $data->groom_info_address_in_english }}</textarea>
                                                    <span class="text-danger is-invalid groom_info_address_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="groom_info_address_in_marathi"  readonly placeholder="Enter address in marathi">{{ $data->groom_info_address_in_marathi }}</textarea>
                                                    <span class="text-danger is-invalid groom_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pincode (पिनकोड) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="6" minlength="6" class="form-control" name="groom_info_pincode" placeholder="Enter pincode" value="{{ $data->groom_info_pincode }}"  readonly/>
                                                    <span class="text-danger is-invalid groom_info_pincode_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pincode in Marathi (पिनकोड मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_pincode_in_marathi" placeholder="Enter pincode in marathi" maxlength="6" minlength="6" value="{{ $data->groom_info_pincode_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid groom_info_pincode_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="groom_info_mobile_no" value="{{ $data->groom_info_mobile_no }}" placeholder="Enter mobile no."  readonly/>
                                                    <span class="text-danger is-invalid groom_info_mobile_no_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Email (ईमेल) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="groom_info_email" placeholder="Enter email" value="{{ $data->groom_info_email }}"  readonly/>
                                                    <span class="text-danger is-invalid groom_info_email_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Aadhar Card No. <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="12" minlength="12" class="form-control" name="groom_info_aadhar_card_no" value="{{ $data->groom_info_aadhar_card_no }}" placeholder="Enter aadhar card no."  readonly/>
                                                    <span class="text-danger is-invalid groom_info_aadhar_card_no_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Date of Birth (जन्मतारीख) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control datepicker" name="groom_info_dob" id="gdate_of_birth" placeholder="Select date of birth" value="{{ $data->groom_info_dob ? \Carbon\Carbon::parse($data->groom_info_dob)->format('d-m-Y') : ''}}" autocomplete="off" readonly/>
                                                    <span class="text-danger is-invalid groom_info_dob_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age (वय) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value = this.value.replace(/\D/g, '')" id="gage" class="form-control" name="groom_info_age" value="{{ $data->groom_info_age }}" placeholder="Enter age" readonly/>
                                                    <span class="text-danger is-invalid groom_info_age_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                                                    <select name="groom_info_gender" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->groom_info_gender == '1' ? 'selected' : '' ?>>Male</option>
                                                        <option value="2"<?= $data->groom_info_gender == '2' ? 'selected' : '' ?>>Female</option>
                                                        <option value="3"<?= $data->groom_info_gender == '3' ? 'selected' : '' ?>>Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_gender_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Religion by birth (जन्माने धर्म) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_religion_by_birth" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->groom_info_religion_by_birth == '1' ? 'selected' : '' ?>>Hindu</option>
                                                        <option value="2" <?= $data->groom_info_religion_by_birth == '2' ? 'selected' : '' ?>>Muslim</option>
                                                        <option value="3" <?= $data->groom_info_religion_by_birth == '3' ? 'selected' : '' ?>>Jain</option>
                                                        <option value="4" <?= $data->groom_info_religion_by_birth == '4' ? 'selected' : '' ?>>Shikh</option>
                                                        <option value="5" <?= $data->groom_info_religion_by_birth == '5' ? 'selected' : '' ?>>Buddhism</option>
                                                        <option value="6" <?= $data->groom_info_religion_by_birth == '6' ? 'selected' : '' ?>>Christian</option>
                                                        <option value="7" <?= $data->groom_info_religion_by_birth == '7' ? 'selected' : '' ?>>Parsi</option>
                                                        <option value="8" <?= $data->groom_info_religion_by_birth == '8' ? 'selected' : '' ?>>Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_religion_by_birth_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Religion by adoption (दत्तक घेऊन धर्म) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_religion_by_adoption" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->groom_info_religion_by_adoption == '1' ? 'selected' : '' ?>>Hindu</option>
                                                        <option value="2" <?= $data->groom_info_religion_by_adoption == '2' ? 'selected' : '' ?>>Muslim</option>
                                                        <option value="3" <?= $data->groom_info_religion_by_adoption == '3' ? 'selected' : '' ?>>Jain</option>
                                                        <option value="4" <?= $data->groom_info_religion_by_adoption == '4' ? 'selected' : '' ?>>Shikh</option>
                                                        <option value="5" <?= $data->groom_info_religion_by_adoption == '5' ? 'selected' : '' ?>>Buddhism</option>
                                                        <option value="6" <?= $data->groom_info_religion_by_adoption == '6' ? 'selected' : '' ?>>Christian</option>
                                                        <option value="7" <?= $data->groom_info_religion_by_adoption == '7' ? 'selected' : '' ?>>Parsi</option>
                                                        <option value="8" <?= $data->groom_info_religion_by_adoption == '8' ? 'selected' : '' ?>>Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_religion_by_adoption_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Groom Photo (वराचा फोटो) </label>
                                                    @if (!empty($data->groom_info_photo))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->groom_info_photo) }}" target="_blank"  class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    <span class="text-danger is-invalid groom_info_photos_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Id Proof (आयडी पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_id_proof" class="form-select" disabled>
                                                        <option value="2" <?= $data->registration_details_is_widow == '2' ? 'selected' : '' ?>>Aadhaar Card</option>
                                                        <option value="3" <?= $data->registration_details_is_widow == '3' ? 'selected' : '' ?>>Passport</option>
                                                        <option value="4" <?= $data->registration_details_is_widow == '4' ? 'selected' : '' ?>>Voter ID</option>
                                                        <option value="5" <?= $data->registration_details_is_widow == '5' ? 'selected' : '' ?>>Pan Card</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_id_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Residential Proof (निवासी पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_residential_proof" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->groom_info_residential_proof == '1' ? 'selected' : '' ?>>Ration Card</option>
                                                        <option value="2" <?= $data->groom_info_residential_proof == '2' ? 'selected' : '' ?>>Aadhaar Card</option>
                                                        <option value="3" <?= $data->groom_info_residential_proof == '3' ? 'selected' : '' ?>>Passport</option>
                                                        <option value="4" <?= $data->groom_info_residential_proof == '4' ? 'selected' : '' ?>>Voter ID</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_residential_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age Proof (वयाचा पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_age_proof" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->groom_info_age_proof == '1' ? 'selected' : '' ?>>Birth Certificate</option>
                                                        <option value="2" <?= $data->groom_info_age_proof == '2' ? 'selected' : '' ?>>School Leaving Certificate</option>
                                                        <option value="3" <?= $data->groom_info_age_proof == '3' ? 'selected' : '' ?>>SSC Board Certificate</option>
                                                        <option value="4" <?= $data->groom_info_age_proof == '4' ? 'selected' : '' ?>>HSC Board Certificate</option>
                                                        <option value="5" <?= $data->groom_info_age_proof == '5' ? 'selected' : '' ?>>Higher Education</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_age_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Id Proof (आयडी पुरावा) </label>
                                                    @if (!empty($data->groom_info_id_proof_file))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->groom_info_id_proof_file) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    <span class="text-danger is-invalid groom_info_id_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Residential Proof (निवासी पुरावा) </label>
                                                    @if (!empty($data->groom_info_residential_proof_file))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->groom_info_residential_proof_file) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    <span class="text-danger is-invalid groom_info_residential_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Age Proof (वयाचा पुरावा) </label>
                                                    @if (!empty($data->groom_info_age_proof_file))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->groom_info_age_proof_file) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    <span class="text-danger is-invalid groom_info_age_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) </label>
                                                    @if (!empty($data->groom_info_upload_signature))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->groom_info_upload_signature) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    <span class="text-danger is-invalid groom_info_upload_signatures_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Previous Status (मागील स्थिती) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_previous_status" class="form-select" id="groomInfoPreviousStatus" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->groom_info_previous_status == '1' ? 'selected' : '' ?>>Unmarried</option>
                                                        <option value="2" <?= $data->groom_info_previous_status == '2' ? 'selected' : '' ?>>Widow/Widower</option>
                                                        <option value="3" <?= $data->groom_info_previous_status == '3' ? 'selected' : '' ?>>Divorce</option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_previous_status_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12 d-none" id="groomInfoPreviousStatusProof">
                                                <div class="mb-3">
                                                    <label class="form-label">Previous Status Proof (मागील स्थितीचा पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="groom_info_previous_status_proof" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->groom_info_previous_status_proof == '1' ? 'selected' : '' ?>> Death Certificate </option>
                                                        <option value="2" <?= $data->groom_info_previous_status_proof == '2' ? 'selected' : '' ?>> Decree &amp; Court Judgement </option>
                                                    </select>
                                                    <span class="text-danger is-invalid groom_info_previous_status_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12 d-none" id="groomInfoUploadPreviousStatusProofs">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Previous Status Proof (मागील स्थितीचा पुरावा)</label>
                                                    @if (!empty($data->groom_info_upload_previous_status_proof))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->groom_info_upload_previous_status_proof) }}" target="_blank">View Document</a></div>
                                                    @endif
                                                    <input type="file" class="form-control" name="groom_info_upload_previous_status_proofs" />
                                                    <span class="text-danger is-invalid groom_info_upload_previous_status_proofs_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card-header">
                                            <h4 class="mb-0 text-dark" style="font-weight: 600">
                                                Bride Information (वधूची माहिती)
                                            </h4>
                                        </div>

                                        <!-- Step 4 -->

                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name in English (पहिले नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_fname_in_english" placeholder="Enter first name in english" value="{{ $data->bride_info_fname_in_english }}" readonly/>
                                                    <span class="text-danger is-invalid bride_info_fname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In English (मधले नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_mname_in_english" placeholder="Enter middle name in english" value="{{ $data->bride_info_mname_in_english }}"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_mname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In English (आडनाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_lname_in_english" placeholder="Enter last name in english" value="{{ $data->bride_info_lname_in_english }}"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_lname_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name In Marathi (पहिले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_fname_in_marathi" placeholder="Enter first name in marathi" value="{{ $data->bride_info_fname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In Marathi (मधले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_mname_in_marathi" placeholder="Enter middle name in marathi" value="{{ $data->bride_info_mname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_mname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In Marathi (आडनाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_lname_in_marathi" placeholder="Enter last name in marathi" value="{{ $data->bride_info_lname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_lname_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="bride_info_address_in_english" readonly placeholder="Enter address in english">{{ $data->bride_info_address_in_english }}</textarea>
                                                    <span class="text-danger is-invalid bride_info_address_in_english_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="bride_info_address_in_marathi"  readonly placeholder="Enter address in marathi">{{ $data->bride_info_address_in_marathi }}</textarea>
                                                    <span class="text-danger is-invalid bride_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pincode (पिनकोड) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="6" minlength="6" class="form-control" name="bride_info_pincode" placeholder="Enter pincode" value="{{ $data->bride_info_pincode }}"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_pincode_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Pincode in Marathi (पिनकोड मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_pincode_in_marathi" maxlength="6" minlength="6" placeholder="Enter pincode in marathi" value="{{ $data->bride_info_pincode_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_pincode_in_marathi_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="bride_info_mobile_no" value="{{ $data->bride_info_mobile_no }}" placeholder="Enter mobile no"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_mobile_no_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Email (ईमेल) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="bride_info_email" placeholder="Enter email" value="{{ $data->bride_info_email }}"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_email_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Aadhar Card No. <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="12" minlength="12" value="{{ $data->bride_info_aadhar_card_no }}" class="form-control" name="bride_info_aadhar_card_no" placeholder="Enter name"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_aadhar_card_no_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Date of Birth (जन्मतारीख) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control datepicker" name="bride_info_dob" id="bdate_of_birth" value="{{ $data->bride_info_dob ? \Carbon\Carbon::parse($data->bride_info_dob)->format('d-m-Y') : '' }}" autocomplete="off"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_dob_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age (वय) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value = this.value.replace(/\D/g, '')" class="form-control" value="{{ $data->bride_info_age }}" name="bride_info_age" placeholder="Enter age" id="bage"  readonly/>
                                                    <span class="text-danger is-invalid bride_info_age_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                                                    <select name="bride_info_gender" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->bride_info_gender == '1' ? 'selected' : '' ?>>Male</option>
                                                        <option value="2" <?= $data->bride_info_gender == '2' ? 'selected' : '' ?>>Female</option>
                                                        <option value="3" <?= $data->bride_info_gender == '3' ? 'selected' : '' ?>>Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_gender_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Religion by birth (जन्माने धर्म) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_religion_by_birth" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->bride_info_religion_by_birth == '1' ? 'selected' : '' ?>>Hindu</option>
                                                        <option value="2" <?= $data->bride_info_religion_by_birth == '2' ? 'selected' : '' ?>>Muslim</option>
                                                        <option value="3" <?= $data->bride_info_religion_by_birth == '3' ? 'selected' : '' ?>>Jain</option>
                                                        <option value="4" <?= $data->bride_info_religion_by_birth == '4' ? 'selected' : '' ?>>Shikh</option>
                                                        <option value="5" <?= $data->bride_info_religion_by_birth == '5' ? 'selected' : '' ?>>Buddhism</option>
                                                        <option value="6" <?= $data->bride_info_religion_by_birth == '6' ? 'selected' : '' ?>>Christian</option>
                                                        <option value="7" <?= $data->bride_info_religion_by_birth == '7' ? 'selected' : '' ?>>Parsi</option>
                                                        <option value="8" <?= $data->bride_info_religion_by_birth == '8' ? 'selected' : '' ?>>Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_religion_by_birth_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Religion by adoption (दत्तक घेऊन धर्म) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_religion_by_adoption" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->bride_info_religion_by_adoption == '1' ? 'selected' : '' ?>>Hindu</option>
                                                        <option value="2" <?= $data->bride_info_religion_by_adoption == '2' ? 'selected' : '' ?>>Muslim</option>
                                                        <option value="3" <?= $data->bride_info_religion_by_adoption == '3' ? 'selected' : '' ?>>Jain</option>
                                                        <option value="4" <?= $data->bride_info_religion_by_adoption == '4' ? 'selected' : '' ?>>Shikh</option>
                                                        <option value="5" <?= $data->bride_info_religion_by_adoption == '5' ? 'selected' : '' ?>>Buddhism</option>
                                                        <option value="6" <?= $data->bride_info_religion_by_adoption == '6' ? 'selected' : '' ?>>Christian</option>
                                                        <option value="7" <?= $data->bride_info_religion_by_adoption == '7' ? 'selected' : '' ?>>Parsi</option>
                                                        <option value="8" <?= $data->bride_info_religion_by_adoption == '8' ? 'selected' : '' ?>>Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_religion_by_adoption_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Bride Photo (वधूचा फोटो) </label>
                                                    @if (!empty($data->bride_info_photo))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->bride_info_photo) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="bride_info_photos" /> --}}
                                                    <span class="text-danger is-invalid bride_info_photos_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Id Proof (आयडी पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_id_proof" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <!--<option value="1">Ration Card</option>-->
                                                        <option value="2" <?= $data->bride_info_id_proof == '2' ? 'selected' : '' ?>>Aadhaar Card</option>
                                                        <option value="3" <?= $data->bride_info_id_proof == '3' ? 'selected' : '' ?>>Passport</option>
                                                        <option value="4" <?= $data->bride_info_id_proof == '4' ? 'selected' : '' ?>>Voter ID</option>
                                                        <option value="5" <?= $data->bride_info_id_proof == '5' ? 'selected' : '' ?>>Pan Card</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_id_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Residential Proof (निवासी पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_residential_proof" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->bride_info_residential_proof == '1' ? 'selected' : '' ?>>Ration Card</option>
                                                        <option value="2" <?= $data->bride_info_residential_proof == '2' ? 'selected' : '' ?>>Aadhaar Card</option>
                                                        <option value="3" <?= $data->bride_info_residential_proof == '3' ? 'selected' : '' ?>>Passport</option>
                                                        <option value="4" <?= $data->bride_info_residential_proof == '4' ? 'selected' : '' ?>>Voter ID</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_residential_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age Proof (वयाचा पुरावा) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_age_proof" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->bride_info_age_proof == '1' ? 'selected' : '' ?>>Birth Certificate</option>
                                                        <option value="2" <?= $data->bride_info_age_proof == '2' ? 'selected' : '' ?>>School Leaving Certificate</option>
                                                        <option value="3" <?= $data->bride_info_age_proof == '3' ? 'selected' : '' ?>>SSC Board Certificate</option>
                                                        <option value="4" <?= $data->bride_info_age_proof == '4' ? 'selected' : '' ?>>HSC Board Certificate</option>
                                                        <option value="5" <?= $data->bride_info_age_proof == '5' ? 'selected' : '' ?>>Higher Education</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_age_proof_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Id Proof (आयडी पुरावा) </label>
                                                    @if (!empty($data->bride_info_id_proof_file))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->bride_info_id_proof_file) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="bride_info_id_proof_files" /> --}}
                                                    <span class="text-danger is-invalid bride_info_id_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Residential Proof (निवासी पुरावा) </label>
                                                    @if (!empty($data->bride_info_residential_proof_file))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->bride_info_residential_proof_file) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="bride_info_residential_proof_files" /> --}}
                                                    <span class="text-danger is-invalid bride_info_residential_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Age Proof (वयाचा पुरावा) </label>
                                                    @if (!empty($data->bride_info_age_proof_file))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->bride_info_age_proof_file) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="bride_info_age_proof_files" /> --}}
                                                    <span class="text-danger is-invalid bride_info_age_proof_files_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) </label>
                                                    @if (!empty($data->bride_info_upload_signature))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->bride_info_upload_signature) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="bride_info_upload_signatures" placeholder="Enter name" /> --}}
                                                    <span class="text-danger is-invalid bride_info_upload_signatures_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Previous Status (मागील स्थिती) <span class="text-danger">*</span></label>
                                                    <select name="bride_info_previous_status" class="form-select" id="brideInfoPreviousStatus" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->bride_info_previous_status == '1' ? 'selected' : '' ?>>Unmarried</option>
                                                        <option value="2" <?= $data->bride_info_previous_status == '2' ? 'selected' : '' ?>>Widow/Widower</option>
                                                        <option value="3" <?= $data->bride_info_previous_status == '3' ? 'selected' : '' ?>>Divorce</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_previous_status_err"></span>
                                                </div>
                                            </div>
                                            {{-- <div class="col-lg-4 col-md-4 col-sm-6 col-12 d-none" id="brideInfoPreviousStatusProof">
                                                <div class="mb-3">
                                                    <label class="form-label">Previous Status Proof (मागील स्थितीचा पुरावा) <span class="text-danger">*</span></label>

                                                    <select name="bride_info_previous_status_proof" class="form-select">
                                                        <option value="">Choose one</option>
                                                    </select>
                                                    <span class="text-danger is-invalid bride_info_previous_status_proof_err"></span>
                                                </div>
                                            </div> --}}
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12 d-none" id="brideInfoUploadPreviousStatusProofs">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Previous Status Proof (मागील स्थितीचा पुरावा) </label>
                                                    @if (!empty($data->bride_info_upload_previous_status_proof))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->bride_info_upload_previous_status_proof) }}" target="_blank">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="bride_info_upload_previous_status_proofs" /> --}}
                                                    <span class="text-danger is-invalid bride_info_upload_previous_status_proofs_err"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-header">
                                            <h4 class="mb-0 text-dark" style="font-weight: 600">
                                                Priest Information (पुरोहिताची माहिती)
                                            </h4>
                                        </div>

                                        <!-- Step 5 -->

                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name in English (पहिले नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="priest_info_fname_in_english" placeholder="Enter first name in english" value="{{ $data->priest_info_fname_in_english }}"  readonly/>
                                                    <span class="text-danger is-invalid priest_info_fname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In English (मधले नाव इंग्रजीमध्ये)<span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="priest_info_mname_in_english" placeholder="Enter middle name in english" value="{{ $data->priest_info_mname_in_english }}"  readonly/>
                                                    <span class="text-danger is-invalid priest_info_mname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In English (आडनाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="priest_info_lname_in_english" placeholder="Enter last name in english" value="{{ $data->priest_info_lname_in_english }}"  readonly/>
                                                    <span class="text-danger is-invalid priest_info_lname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">First Name In Marathi (पहिले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="priest_info_fname_in_marathi" placeholder="Enter first name in marathi" value="{{ $data->priest_info_fname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid priest_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Middle Name In Marathi (मधले नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="priest_info_mname_in_marathi" placeholder="Enter middle name in marathi" value="{{ $data->priest_info_mname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid priest_info_mname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Last Name In Marathi (आडनाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="priest_info_lname_in_marathi" placeholder="Enter last name in marathi" value="{{ $data->priest_info_lname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid priest_info_lname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea type="text" class="form-control" name="priest_info_address_in_english"  readonly placeholder="Enter address in english">{{ $data->priest_info_address_in_english }}</textarea>
                                                    <span class="text-danger is-invalid priest_info_address_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea type="text" class="form-control" name="priest_info_address_in_marathi" readonly placeholder="Enter name">{{ $data->priest_info_address_in_marathi }}</textarea>
                                                    <span class="text-danger is-invalid priest_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="priest_info_mobile_no" placeholder="Enter mobile no" value="{{ $data->priest_info_mobile_no }}"  readonly/>
                                                    <span class="text-danger is-invalid priest_info_mobile_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age (वय) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value = this.value.replace(/\D/g, '')" class="form-control" name="priest_info_age" placeholder="Enter age" value="{{ $data->priest_info_age }}"  readonly/>
                                                    <span class="text-danger is-invalid priest_info_age_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Religion (धर्म) <span class="text-danger">*</span></label>
                                                    <select name="priest_info_religion" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->priest_info_religion == '1' ? 'selected' : '' ?>>Hindu</option>
                                                        <option value="2" <?= $data->priest_info_religion == '2' ? 'selected' : '' ?>>Muslim</option>
                                                        <option value="3" <?= $data->priest_info_religion == '3' ? 'selected' : '' ?>>Jain</option>
                                                        <option value="4" <?= $data->priest_info_religion == '4' ? 'selected' : '' ?>>Shikh</option>
                                                        <option value="5" <?= $data->priest_info_religion == '5' ? 'selected' : '' ?>>Buddhism</option>
                                                        <option value="6" <?= $data->priest_info_religion == '6' ? 'selected' : '' ?>>Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid priest_info_religion_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) </label>
                                                    @if (!empty($data->priest_info_upload_signature))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->priest_info_upload_signature) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="priest_info_upload_signatures" /> --}}
                                                    <span class="text-danger is-invalid priest_info_upload_signatures_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card-header">
                                            <h4 class="mb-0 text-dark" style="font-weight: 600">
                                                Witness Information (साक्षीदाराची माहिती)
                                            </h4>
                                        </div>
                                        <br>
                                        <!-- Step 6 -->
                                        <h5 style="font-weight: 800;" class="text-dark">First Witness Information (प्रथम साक्षीदाराची माहिती)</h5>
                                        <hr>
                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In English (पूर्ण नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="first_witness_info_fname_in_english" placeholder="Enter full name in english" value="{{ $data->first_witness_info_fname_in_english }}" readonly/>
                                                    <span class="text-danger is-invalid first_witness_info_fname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In Marathi (पूर्ण नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="first_witness_info_fname_in_marathi" placeholder="Enter full name in marathi" value="{{ $data->first_witness_info_fname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid first_witness_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="first_witness_info_mobile_no" placeholder="Enter mobile no" value="{{ $data->first_witness_info_mobile_no }}"  readonly/>
                                                    <span class="text-danger is-invalid first_witness_info_mobile_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Date of Birth (जन्मतारीख) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control datepicker" name="first_witness_info_dob" placeholder="Select date of birth" value="{{ $data->first_witness_info_dob  ? \Carbon\Carbon::parse($data->first_witness_info_dob)->format('d-m-Y') : '' }}" autocomplete="off"  readonly/>
                                                    <span class="text-danger is-invalid first_witness_info_dob_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age (वय) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value = this.value.replace(/\D/g, '')" class="form-control" name="first_witness_info_age" value="{{ $data->first_witness_info_age }}" placeholder="Enter age"  readonly/>
                                                    <span class="text-danger is-invalid first_witness_info_age_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                                                    <select name="first_witness_info_gender" class="form-select" disabled>
                                                        <option value="">Select gender</option>
                                                        <option value="1" <?= $data->first_witness_info_gender == '1' ? 'selected' : '' ?>>Male</option>
                                                        <option value="2"<?= $data->first_witness_info_gender == '2' ? 'selected' : '' ?>>Female</option>
                                                        <option value="3" <?= $data->first_witness_info_gender == '3' ? 'selected' : '' ?>>Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid first_witness_info_gender_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Relation (संबंध) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="first_witness_info_relation" value="{{ $data->first_witness_info_relation }}" placeholder="Enter relation"  readonly/>
                                                    <span class="text-danger is-invalid first_witness_info_relation_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="first_witness_info_address_in_english"  readonly placeholder="Enter address">{{ $data->first_witness_info_address_in_english }}</textarea>
                                                    <span class="text-danger is-invalid first_witness_info_address_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="first_witness_info_address_in_marathi" readonly  placeholder="Enter address in marathi">{{ $data->first_witness_info_address_in_marathi }}</textarea>
                                                    <span class="text-danger is-invalid first_witness_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Id Proof (कागदपत्र सादर केले) <span class="text-danger">*</span></label>
                                                    <select name="first_witness_info_id_proof" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1"<?= $data->first_witness_info_id_proof == '1' ? 'selected' : '' ?>>Aadhar Card</option>
                                                        <option value="2"<?= $data->first_witness_info_id_proof == '2' ? 'selected' : '' ?>>Voter Id</option>
                                                    </select>
                                                    <span class="text-danger is-invalid first_witness_info_id_proof_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Witness Photo (साक्षीदाराचा फोटो) </label>
                                                    @if (!empty($data->first_witness_info_witness_photo))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->first_witness_info_witness_photo) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="first_witness_info_witness_photos" /> --}}
                                                    <span class="text-danger is-invalid first_witness_info_witness_photos_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) </label>
                                                    @if (!empty($data->first_witness_info_upload_signature))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->first_witness_info_upload_signature) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="first_witness_info_upload_signatures" /> --}}
                                                    <span class="text-danger is-invalid first_witness_info_upload_signatures_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Document (कागदपत्र सादर केले) </label>
                                                    @if (!empty($data->first_witness_info_upload_document))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->first_witness_info_upload_document) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="first_witness_info_upload_documents" /> --}}
                                                    <span class="text-danger is-invalid first_witness_info_upload_documents_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <h5 style="font-weight: 800;" class="text-dark">Second Witness Information (दुसऱ्या साक्षीदाराची माहिती)</h5>
                                        <hr>
                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In English (पूर्ण नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="second_witness_info_fname_in_english" placeholder="Enter full name in english" value="{{ $data->second_witness_info_fname_in_english }}"  readonly/>
                                                    <span class="text-danger is-invalid second_witness_info_fname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In Marathi (पूर्ण नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="second_witness_info_fname_in_marathi" placeholder="Enter full name in marathi" value="{{ $data->second_witness_info_fname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid second_witness_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="second_witness_info_mobile_no" placeholder="Enter mobile no" value="{{ $data->second_witness_info_mobile_no }}"  readonly/>
                                                    <span class="text-danger is-invalid second_witness_info_mobile_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Date of Birth (जन्मतारीख) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control datepicker" name="second_witness_info_dob" placeholder="Select date of birth" autocomplete="off" value="{{ $data->second_witness_info_dob ? \Carbon\Carbon::parse($data->second_witness_info_dob)->format('d-m-Y') : '' }}"  readonly/>
                                                    <span class="text-danger is-invalid second_witness_info_dob_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age (वय) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value = this.value.replace(/\D/g, '')" class="form-control" name="second_witness_info_age" placeholder="Age" value="{{ $data->second_witness_info_age }}" readonly />
                                                    <span class="text-danger is-invalid second_witness_info_age_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                                                    <select name="second_witness_info_gender" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->second_witness_info_gender == '1' ? 'selected' : '' ?>>Male</option>
                                                        <option value="2"<?= $data->second_witness_info_gender == '2' ? 'selected' : '' ?>>Female</option>
                                                        <option value="3"<?= $data->second_witness_info_gender == '3' ? 'selected' : '' ?>>Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid second_witness_info_gender_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Relation (संबंध) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="second_witness_info_relation" placeholder="Enter relation" value="{{ $data->second_witness_info_relation }}"  readonly/>
                                                    <span class="text-danger is-invalid second_witness_info_relation_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="second_witness_info_address_in_english"  readonly placeholder="Enter address in english">{{ $data->second_witness_info_address_in_english }}</textarea>
                                                    <span class="text-danger is-invalid second_witness_info_address_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="second_witness_info_address_in_marathi"  readonly placeholder="Enter address in marathi">{{ $data->second_witness_info_address_in_marathi }}</textarea>
                                                    <span class="text-danger is-invalid second_witness_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Id Proof (कागदपत्र सादर केले) <span class="text-danger">*</span></label>
                                                    <select name="second_witness_info_id_proof" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->second_witness_info_id_proof == '1' ? 'selected' : '' ?>>Aadhar Card</option>
                                                        <option value="2" <?= $data->second_witness_info_id_proof == '2' ? 'selected' : '' ?>>Voter Id</option>
                                                    </select>
                                                    <span class="text-danger is-invalid second_witness_info_id_proof_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Witness Photo (साक्षीदाराचा फोटो) </label>
                                                    @if (!empty($data->second_witness_info_witness_photo))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->second_witness_info_witness_photo) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="second_witness_info_witness_photos" /> --}}
                                                    <span class="text-danger is-invalid second_witness_info_witness_photos_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) </label>
                                                    @if (!empty($data->second_witness_info_upload_signature))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->second_witness_info_upload_signature) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="second_witness_info_upload_signatures" /> --}}
                                                    <span class="text-danger is-invalid second_witness_info_upload_signatures_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Document (कागदपत्र सादर केले) </label>
                                                    @if (!empty($data->second_witness_info_upload_document))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->second_witness_info_upload_document) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="second_witness_info_upload_documents" /> --}}
                                                    <span class="text-danger is-invalid second_witness_info_upload_documents_err"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <h5 style="font-weight: 800;" class="text-dark">Third Witness Information (तिसरा साक्षीदाराची माहिती)</h5>
                                        <hr>
                                        <div class="row mt-3">
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In English (पूर्ण नाव इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="third_witness_info_fname_in_english" placeholder="Enter full name in english" value="{{ $data->third_witness_info_fname_in_english }}" readonly/>
                                                    <span class="text-danger is-invalid third_witness_info_fname_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Full Name In Marathi (पूर्ण नाव मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="third_witness_info_fname_in_marathi" placeholder="Enter full name in marathi" value="{{ $data->third_witness_info_fname_in_marathi }}"  readonly/>
                                                    <span class="text-danger is-invalid third_witness_info_fname_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Mobile No (मोबाईल क्र) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value=this.value.replace(/\D/g, '')" maxlength="10" minlength="10" class="form-control" name="third_witness_info_mobile_no" value="{{ $data->third_witness_info_mobile_no }}" placeholder="Enter mobile no"  readonly/>
                                                    <span class="text-danger is-invalid third_witness_info_mobile_no_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Date of Birth (जन्मतारीख) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control datepicker" name="third_witness_info_dob" value="{{ $data->third_witness_info_dob ? \Carbon\Carbon::parse($data->third_witness_info_dob)->format('d-m-Y') : '' }}" placeholder="Enter date of birth" autocomplete="off"  readonly/>
                                                    <span class="text-danger is-invalid third_witness_info_dob_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Age (वय) <span class="text-danger">*</span></label>
                                                    <input type="text" oninput="this.value = this.value.replace(/\D/g, '')" class="form-control" value="{{ $data->third_witness_info_age }}" name="third_witness_info_age" placeholder="Enter age"  readonly/>
                                                    <span class="text-danger is-invalid third_witness_info_age_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                                                    <select name="third_witness_info_gender" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->third_witness_info_gender == '1' ? 'selected' : '' ?>>Male</option>
                                                        <option value="2" <?= $data->third_witness_info_gender == '2' ? 'selected' : '' ?>>Female</option>
                                                        <option value="3" <?= $data->third_witness_info_gender == '3' ? 'selected' : '' ?>>Other</option>
                                                    </select>
                                                    <span class="text-danger is-invalid third_witness_info_gender_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Relation (संबंध) <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="third_witness_info_relation" placeholder="Enter relation" value="{{ $data->third_witness_info_relation }}"  readonly/>
                                                    <span class="text-danger is-invalid third_witness_info_relation_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In English (पत्ता इंग्रजीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="third_witness_info_address_in_english"  readonly placeholder="Enter address in english">{{ $data->third_witness_info_address_in_english }}</textarea>
                                                    <span class="text-danger is-invalid third_witness_info_address_in_english_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Address In Marathi (पत्ता मराठीमध्ये) <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="third_witness_info_address_in_marathi"  readonly placeholder="Enter address in marathi">{{ $data->third_witness_info_address_in_marathi }}</textarea>
                                                    <span class="text-danger is-invalid third_witness_info_address_in_marathi_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Id Proof (कागदपत्र सादर केले) <span class="text-danger">*</span></label>
                                                    <select name="third_witness_info_id_proof" class="form-select" disabled>
                                                        <option value="">Choose one</option>
                                                        <option value="1" <?= $data->third_witness_info_id_proof == '1' ? 'selected' : '' ?>>Aadhar Card</option>
                                                        <option value="2" <?= $data->third_witness_info_id_proof == '2' ? 'selected' : '' ?>>Voter Id</option>
                                                    </select>
                                                    <span class="text-danger is-invalid third_witness_info_id_proof_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Witness Photo (साक्षीदाराचा फोटो) </label>
                                                    @if (!empty($data->third_witness_info_witness_photo))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->third_witness_info_witness_photo) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="third_witness_info_witness_photos" /> --}}
                                                    <span class="text-danger is-invalid third_witness_info_witness_photos_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-4">
                                                    <label class="form-label">Upload Signature(स्वाक्षरी अपलोड करा) </label>
                                                    @if (!empty($data->third_witness_info_upload_signature))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->third_witness_info_upload_signature) }}" target="_blank">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="third_witness_info_upload_signatures" /> --}}
                                                    <span class="text-danger is-invalid third_witness_info_upload_signatures_err"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Upload Document (कागदपत्र सादर केले) </label>
                                                    @if (!empty($data->third_witness_info_upload_document))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->third_witness_info_upload_document) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    {{-- <input type="file" class="form-control" name="third_witness_info_upload_documents" /> --}}
                                                    <span class="text-danger is-invalid third_witness_info_upload_documents_err"></span>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Uploaded Prescribed Format / विहित नमुन्यातील अर्ज अपलोड </label>
                                                    @if (!empty($data->prescribed_doc))
                                                        <div class="mb-2"><a href="{{ asset('storage/' . $data->prescribed_doc) }}" target="_blank" class="btn btn-sm btn-success">View Document</a></div>
                                                    @endif
                                                    <span class="text-danger is-invalid prescribed_docs_err"></span>
                                                </div>
                                            </div>

                                             @if ((Auth::check() && Auth::user()->hasRole('Clerk')) && $status->service_id == '75')
                                                <div class="col-md-4 mb-2">
                                                        <label class="col-form-label" for="Volumenumber_marathi">खंड क्रमांक<span class="text-danger">*</span></label>
                                                        <input type="number" name="volume_number_mr" id="Volumenumber_marathi" class="form-control" placeholder="Please enter Volume Number in Marathi" value="{{ isset($data) && isset($data->volume_number_mr) ? $data->volume_number_mr : '' }}" required>
                                                    </div>

                                                <div class="col-md-4 mb-2">
                                                        <label class="col-form-label"  for="Serialnumber_marathi">अनुक्रमांक<span class="text-danger">*</span></label>
                                                        <input type="number" name="sr_number_mr" id="Serialnumber_marathi" class="form-control" placeholder="Please enter Serial Number in Marathi" value="{{ isset($data) && isset($data->sr_number_mr) ? $data->sr_number_mr : '' }}" required>
                                                    </div>

                                                     <div class="col-md-4 mb-2">
                                                        <label class="col-form-label" for="Volumenumber_english">Volume Number<span class="text-danger">*</span></label>
                                                        <input type="number" name="volumenumber_eng" id="Volumenumber_english" class="form-control" placeholder="please enter volume Number in English" value="{{ isset($data) && isset($data->volumenumber_eng) ? $data->volumenumber_eng : '' }}" required>
                                                    </div>

                                                <div class="col-md-4 mb-2">
                                                        <label class="col-form-label"  for="Serialnumber_english">Serial Number<span class="text-danger">*</span></label>
                                                        <input type="number" name="serialnumber_eng" id="Serialnumber_english" class="form-control" placeholder ="Enter Serial number"  value="{{ isset($data) && isset($data->serialnumber_eng) ? $data->serialnumber_eng : '' }}" required>
                                                    </div>
                                                    @else
                                                                                            
                                                  @if(!empty($data->volume_number_mr))
                                                <div class="col-md-4 mb-2">
                                                    <label class="col-form-label">खंड क्रमांक</label>
                                                    <input type="text" class="form-control" value="{{ $data->volume_number_mr }}" readonly>
                                                </div>
                                                @endif

                                                @if(!empty($data->sr_number_mr))
                                                <div class="col-md-4 mb-2">
                                                    <label class="col-form-label">अनुक्रमांक</label>
                                                    <input type="text" class="form-control" value="{{ $data->sr_number_mr }}" readonly>
                                                </div>
                                                @endif

                                                @if(!empty($data->volumenumber_eng))
                                                <div class="col-md-4 mb-2">
                                                    <label class="col-form-label">Volume Number</label>
                                                    <input type="text" class="form-control" value="{{ $data->volumenumber_eng }}" readonly>
                                                </div>
                                                @endif

                                                @if(!empty($data->serialnumber_eng))
                                                <div class="col-md-4 mb-2">
                                                    <label class="col-form-label">Serial Number</label>
                                                    <input type="text" class="form-control" value="{{ $data->serialnumber_eng }}" readonly>
                                                </div>
                                                @endif

                                            @endif



                                            <div class="col-md-4 mb-2">
                                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                                <textarea id="Remark" name="remark" class="form-control" rows="4" maxlength="255"></textarea>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-2">
                                            <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}" @if(!$approve_require_fields) disabled @endif>Approve</button>
                                            <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                                            <button type="button" id="btnCancel" class="btn btn-warning">Cancel</button>
                                               @if ((Auth::check() && Auth::user()->hasRole('Clerk') && $status->service_id == '75'))
                                                <button type="submit" class="btn btn-secondary" id="addSubmit">Update</button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </form>
                            {{-- </div> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layout>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {
        $('.next-tab').on('click', function() {
            const nextTabId = $(this).data('next');
            const nextTabBtn = $(`button[data-bs-target="#${nextTabId}"]`);

            nextTabBtn.removeAttr('disabled');
            nextTabBtn.tab('show');
        });

        $('.prev-tab').on('click', function() {
            const prevTabId = $(this).data('prev');
            const prevTabBtn = $(`button[data-bs-target="#${prevTabId}"]`);

            prevTabBtn.tab('show');
        });
    });


     $("#multiStepForm").submit(function(e) {

        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);

        console.log(formdata);
        var updateUrl = '{{ route('marriage-registration.update', $data->id) }}';
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Updated Sucessfully!',
                    text: response.message,
                    confirmButtonText: 'OK'
                }).then(() => {
                    window.location.href = '{{ route('pendinglist') }}';
                });
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });

    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            console.log(statusId);
            let remark = $('#Remark').val();



            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
<script>
    $('#groomInfoPreviousStatus').change(function() {
        let checkValue = $(this).val();
        displaygroomInformationPreviousStatus(checkValue);
    });

    let checkVal = $('#groomInfoPreviousStatus').val();
    displaygroomInformationPreviousStatus(checkVal);

    function displaygroomInformationPreviousStatus(checkValue) {
        if (checkValue == "2") {
            $('#groomInfoPreviousStatusProof').removeClass('d-none');
            $('#groomInfoPreviousStatusProof').find('select').html(`<option value="1"> Death Certificate </option>`);
            $('#groomInfoUploadPreviousStatusProofs').removeClass('d-none');
        } else if (checkValue == "3") {
            $('#groomInfoPreviousStatusProof').removeClass('d-none');
            $('#groomInfoPreviousStatusProof').find('select').html(`<option value="2"> Decree &amp; Court Judgement </option>`);
            $('#groomInfoUploadPreviousStatusProofs').removeClass('d-none');
        } else {
            $('#groomInfoPreviousStatusProof').addClass('d-none');
            $('#groomInfoPreviousStatusProof').find('select').html(`<option value=""></option>`);
            $('#groomInfoUploadPreviousStatusProofs').addClass('d-none');
        }
    }

    // $("#bdate_of_birth").change(function() {
    //     var dateString = $(this).val();
    //     bdateOfBirth(dateString);
    // });


    // let brideInformationDateValue = $("#bdate_of_birth").val();

    // bdateOfBirth(brideInformationDateValue);

    // function bdateOfBirth(dateValue){
    //     var today = new Date();
    //     var dateString = dateValue;
    //     var birthDate = new Date(dateString);
    //     var age = today.getFullYear() - birthDate.getFullYear();
    //     var m = today.getMonth() - birthDate.getMonth();
    //     if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
    //         age--;
    //     }

    //     if (age >= 18) {
    //         $("#brideInformationBtn").removeClass('d-none');
    //     } else {
    //         $("#bdate_of_birth").val("");
    //         alert("Your Age is less than 18 you are not eligible");
    //         $("#brideInformationBtn").addClass('d-none');
    //     }
    // }

    $('#brideInfoPreviousStatus').change(function() {
        let checkValue1 = $(this).val();
        displaybrideInformationPreviousStatus(checkValue1);
    });

    let checkVal1 = $('#brideInfoPreviousStatus').val();
    displaybrideInformationPreviousStatus(checkVal1);

    function displaybrideInformationPreviousStatus(checkValue) {
        if (checkValue == "2") {
            $('#brideInfoPreviousStatusProof').removeClass('d-none');
            $('#brideInfoPreviousStatusProof').find('select').html(`<option value="1"> Death Certificate </option>`);
            $('#brideInfoUploadPreviousStatusProofs').removeClass('d-none');
        } else if (checkValue == "3") {
            $('#brideInfoPreviousStatusProof').removeClass('d-none');
            $('#brideInfoPreviousStatusProof').find('select').html(`<option value="2"> Decree &amp; Court Judgement </option>`);
            $('#brideInfoUploadPreviousStatusProofs').removeClass('d-none');
        } else {
            $('#brideInfoPreviousStatusProof').addClass('d-none');
            $('#brideInfoPreviousStatusProof').find('select').html(`<option value=""></option>`);
            $('#brideInfoUploadPreviousStatusProofs').addClass('d-none');
        }
    }
</script>
