<?php
if (!function_exists('convertToMarathiNumber'))
{
    function convertToMarathiNumber($number)
    {
        $marathiDigits = ['०', '१', '२', '३', '४', '५', '६', '७', '८', '९'];
        $numberStr     = (string) $number;
        $marathiNumber = '';

        for ($i = 0; $i < mb_strlen($numberStr); $i++)
        {
            $digit = $numberStr[$i];
            if (is_numeric($digit))
            {
                $marathiNumber .= $marathiDigits[$digit];
            }
            else
            {
                $marathiNumber .= $digit;
            }
        }

        return $marathiNumber;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Marriage Certificate</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 17px;
            margin: 30px;
        }
        .header, .footer {
            text-align: center;
        }
        .logos {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .logos img {
            height: 70px;
        }
        .certificate-title {
            text-align: center;
            font-weight: bold;
            text-decoration: underline;
            margin-top: 10px;
            font-size: 18px;
        }
        .section {
            margin-top: 20px;
        }
        .details-table {
            width: 100%;
            border-collapse: collapse;
        }
        .details-table td {
            padding: 5px;
            vertical-align: top;
        }
        .bold {
            font-weight: bold;
        }
        .photo-section {
            display: flex;
            justify-content: space-around;
            margin-top: 30px;
        }
        .photo-section img {
            height: 100px;
            width: 100px;
            object-fit: cover;
            border: 1px solid #000;
        }
        .signature-section {
            display: flex;
            justify-content: space-between;
            margin-top: 40px;
        }
        .seal {
            text-align: center;
        }
        hr {
            margin-top: 15px;
        }
    </style>
</head>
<body>



<div class="header">
        @php
        $logoData = file_get_contents(public_path('admin/images/satyamev-jayate-7223886_1280.png'));
        $logoData1 = file_get_contents(public_path('admin/images/seal_of_maharashtra.png'));
        $logoData2 = file_get_contents(public_path('admin/images/favicon.png'));
        $base64Logo = base64_encode($logoData);
        $base64Logo2 = base64_encode($logoData2);
        $base641Logo = base64_encode($logoData1);
        @endphp
       <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
       <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="100" width="100">
       <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo"  style="float:right;margin-top:35px;" height="100" width="100">
       <div class="rox">
        <p><strong>महाराष्ट्र शासन </strong></p>
        <p><strong>GOVERNMENT OF MAHARASHTRA</strong></p>
        <p><strong>भिवंडी निजामपूर शहर महानगरपालिका</strong></p>
        <p><strong>Bhiwandi Nizampur City Municipal Corporation </strong></p>
        <p>(भाग चार -ब) महाराष्ट्र शासन राजपत्र, मे २०, १९९९ / वैशाख ३०, शके १९२१</p>
        <p><strong>नमुना 'ई' Form-E</strong></p>
        <P>विवाह नोंदणी प्रमाणपत्र</P>
        <p><strong>Certificate of Registration of Marriage</strong></p>
        <p>(कलम ६ (१) आणि नियम ५ पहा)</p>
        <p>(See Section 6(1) and Rule 5)</p>
       </div>
    </div>

    <hr>

     <div class="section">
<table>
        <tbody>
	    <tr>
	        <td  colspan="3">  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;	<b>   प्रमाणित करण्यात येते की / Certified that, Marriage between<br></b></td>
	    </tr>
		<tr>
			<td>पतीचे नाव : </td>
			<td><b>{{$data->groom_info_fname_in_marathi}}&nbsp;&nbsp;{{ $data->groom_info_mname_in_marathi}}&nbsp;&nbsp;{{ $data->groom_info_lname_in_marathi}}</b></td>
			<td> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;आधार क्रमांक /Aadhar No.: <b>{{ $data->groom_info_aadhar_card_no}}</b></td>
		</tr>
		<tr>
			<td> Name of Husband : </td>
			<td colspan="2"> <strong style="text-transform:capitalize;">{{$data->groom_info_fname_in_english}}&nbsp;&nbsp;{{ $data->groom_info_mname_in_english}}&nbsp;&nbsp;{{ $data->groom_info_lname_in_english}}</strong></td>
		</tr>
		<tr>
			<td>राहणार :</td>
			<td colspan="2"> <b>{{ $data->groom_info_address_in_marathi}}</b> </td>
		</tr>
		<tr>
			<td>residing at :</td>
			<td colspan="2"> <strong>{{  $data->groom_info_address_in_english}} </strong></td>
		</tr>
		<tr>
			<td> पत्नीचे नाव :</td>
			<td> <b>{{$data->bride_info_fname_in_marathi}}&nbsp;&nbsp;{{ $data->bride_info_mname_in_marathi}}&nbsp;&nbsp;{{ $data->bride_info_lname_in_marathi}}</b></td>
			<td>  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;आधार क्रमांक /Aadhar No.: <b>{{ $data->bride_info_aadhar_card_no }}</b></td>
		</tr>
		<tr>
			<td>  Wife's name : </td>
			<td colspan="2"> <strong style="text-transform:capitalize;">{{$data->bride_info_fname_in_english}}&nbsp;&nbsp;{{ $data->bride_info_mname_in_english}}&nbsp;&nbsp;{{ $data->bride_info_lname_in_english}}</strong></td>
		</tr>
		<tr>
			<td>राहणार :</td>
			<td colspan="2"> <strong>{{  $data->bride_info_address_in_marathi}} </strong></td>
		</tr>
		<tr>
			<td> residing at :</td>
			<td colspan="2"> <strong>{{ $data->bride_info_address_in_english }}</strong></td>
		</tr>
	</tbody>

</table>

        <div class="line-break"></div>
<br>
      <div >
    	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; यांचा विवाह दिनांक<strong> <span lang="mr">{{ $data->registration_details_marriage_date_in_marathi }}</span></strong> रोजी <strong>{{ $data->registration_details_marriage_place_in_marathi}} </strong> येथे ( ठिकाणी ) विवाह विधी संपन्न झाला . त्याची महाराष्ट्र विवाह मंडळाचे विनियमन आणि विवाह नोंदणी विधेयक , १९१८ अन्वये ठेवण्यात आलेल्या  नोंदवहीच्या खंड क्रमांक <strong><span lang="mr">{{ convertToMarathiNumber( $data->volume_number_mr) }}</span></strong>
    	 अनुक्रमांक: <strong><span lang="mr">{{ convertToMarathiNumber($data->sr_number_mr) }}</span></strong>
    	  वर दिनांक <strong>{{ convertToMarathiNumber(date('d-m-Y', strtotime($data->registration_details_form_filled_date))) }}</strong> रोजी माझ्याकडून नोंदणी करण्यात आली आहे.
    	</div>
    		<div >
    	 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Solemnized on Date : <strong>{{(date('d-m-Y',strtotime($data->registration_details_marriage_date_in_english ))) }}</strong> at </strong> {{ $data->registration_details_marriage_place_in_english}} .(Place) is registered by me on Date : <strong>{{(date('d-m-Y',strtotime($data->registration_details_form_filled_date ))) }}</strong> at Serial No: <strong>{{ $data->serialnumber_eng}}</strong> of Volume <strong>{{ $data->volumenumber_eng }}</strong> of register of Marriages maintained under the Maharashtra Regulation of Marriage Bureaus and Registration of Marriages Act 1998.
    	</div>
    	<br/>

    </div>

        <hr>

                <div class="photo-section">
                @php
                $groomPhoto = file_get_contents(public_path('storage/'.$data->groom_info_photo));
                $groom64Photo = base64_encode($groomPhoto);
                @endphp
                <img src="data:image/png;base64,{{ $groom64Photo }}" width="100" alt="Husband Photo">

                @php
                $bridePhoto = file_get_contents(public_path('storage/'.$data->bride_info_photo));
                $bride64Photo = base64_encode($bridePhoto);
                @endphp
                <img src="data:image/png;base64,{{ $bride64Photo }}" width="100" style="float: right;" alt="Wife Photo">
            </div>




        <hr>
    <div class="signature-section">
        <div>
            <p><strong>Place:</strong> Bhiwandi</p>
            <p><strong>Date:</strong> {{ $data->created_at}}</p>
        </div>
        <div style="text-align: right;">
            <p><strong>Signature</strong></p>
            <p>Registrar of Marriages</p>
            <p>Bhiwandi</p>
        </div>
    </div>

</body>
</html>
