<!DOCTYPE html>
<html lang="mr">
<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
        }
        .header, .footer {
            text-align: center;
        }
        .content {
            margin-top: 30px;
        }
        /* .sub-header {
            text-align: right;
        } */
        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }
        .points {
            margin-top: 20px;
        }
        .points li {
            margin-bottom: 10px;
            margin-left:5%;
        }
        p{
            font-size:18px;
        }
    </style>
</head>
<body>

    <div class="header">
        @php
        $logoData = file_get_contents(public_path('admin/images/favicon.png'));
        $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
        $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
        $base64Logo = base64_encode($logoData);
        $base64Logo2 = base64_encode($logoData2);
        $base641Logo = base64_encode($logoData1);
        @endphp
       <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
       <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150">
       <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo"  style="float:right;margin-top:35px;" height="150" width="150">
       <div class="rox">
        <h2>मिरा भाईंदर महानगरपालिका</h2>
        <p>स्व.इंदिरा गांधी भवन,मुख्य कार्यालय, छत्रपती शिवाजी महाराज मार्ग, भाईंदर (प.),ता.ठाणे-४०११०१</p>
        <p>दूरध्वनी क्र.२८१९२४८</p>
        <h3>घनकचरा व्यवस्थापन विभाग</h3>
       </div>
    </div>
<hr>
<hr style="1px solid #000; height:5px; background-color:#000;">
     <div class="sub-header">
        <div class="row d-flex">
        <p>जा.क्र. मनपा/सां/ {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/ 2025-2026
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        दि. <span >{{ \Carbon\Carbon::parse($data->created_at)->format('d/m') }}</span> / <span>{{ \Carbon\Carbon::parse($data->created_at)->format('Y') }}</span></p>
        </div>
    </div>

    <p>प्रति<br>
        श्री./श्रीम. {{ $data->applicant_name}} <br>
    </p>

    <p style="margin-left:20%;"><strong>विषय :</strong>शहरात स्वच्छता ठेवणे बाबत.</p>
    <p style="margin-left:20%;"><strong>संदर्भ :</strong> आपला अर्ज दि.{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }}रोजी प्राप्त.</p>

    <br>

    <div class="content">
        <p >उपरोक्त संदर्भिय विषयानुसार आपणांस कळविण्यात येते की, आपली शहरातील स्वच्छता अंतर्गत अर्ज प्राप्त झाला असुन आपल्या {{  $data->applicant_address}}परिसरातील
संबंधित स्वच्छता निरीक्षक यांच्या देखरेखी खाली परिसराची साफसफाई करण्यात आलेली आहे.</p>

    </div>
    <br>
    <br>

    <div class="footer" style="float:right;">
       <p><strong>कार्यकारी अभियंता (साबां/वि)</strong><br>
        मिरा-भाईंदर महानगरपालिका</p>
    </div>

</body>
</html>
