<x-admin.layout>
    <x-slot name="title">शहरात स्वच्छता ठेवणे</x-slot>
    <x-slot name="heading">शहरात स्वच्छता ठेवणे</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
    <div class="col-sm-12">
        <div class="card">
            <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                @csrf
                <div class="card-header">
                    <h4 class="card-title">Edit Details</h4>
                </div>
                <div class="card-body">
                    <div class="mb-3 row">
                        <input type="hidden" model-id="id" value="{{ $status->id }}">

                        <div class="col-md-4 mb-3">
                            <label class="col-form-label" for="applicant_name">Applicant Name <span class="text-danger">*</span></label>
                            <input class="form-control" id="applicant_name" name="applicant_name" type="text" value="{{ $data->applicant_name }}" placeholder="Enter Full Name" readonly>
                            <span class="text-danger is-invalid applicant_name_err"></span>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="col-form-label" for="applicant_address">Applicant Address <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="applicant_address" name="applicant_address" rows="1" placeholder="Enter Address Name" readonly>{{ $data->applicant_address }}</textarea>
                            <span class="text-danger is-invalid applicant_address_err"></span>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="col-form-label" for="mobile_no">Mobile Number<span class="text-danger">*</span></label>
                            <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $data->mobile_no }}" type="text" readonly maxlength="10" minlength="10" placeholder="Enter Mobile Number">
                            <span class="text-danger is-invalid mobile_no_err"></span>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="col-form-label" for="email">Email<span class="text-danger">*</span></label>
                            <input class="form-control" id="email" name="email" value="{{ $data->email }}" type="email" placeholder="Enter Email" readonly>
                            <span class="text-danger is-invalid email_err"></span>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="col-form-label" for="aadhar_num">Aadhar Number<span class="text-danger">*</span></label>
                            <input class="form-control" id="aadhar_num" name="aadhar_num" type="text" value="{{ $data->aadhar_num }}" readonly maxlength="12" minlength="12" placeholder="Enter Aadhar Card Number">
                            <span class="text-danger is-invalid aadhar_num_err"></span>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="col-form-label" for="address"> Residential Address <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="address" id="address" rows="2" placeholder="Enter Address" readonly>{{ $data->address }}</textarea>
                            <span class="text-danger is-invalid address_err"></span>
                        </div>
                    </div>

                    <hr>

                    {{-- DOCUMENT / GEO PHOTO SECTION (2 columns per row) --}}
                    <h5 class="text-primary mb-3">Documents & Action</h5>
                    <div class="mb-3 row">

                        {{-- Geo Photo --}}
                        <div class="col-md-6 mb-3">
                            <label class="col-form-label" for="geo_photo">Upload Geo Photos<span class="text-danger">*</span></label>
                            @if($data->geo_photos)
                            <div class="d-flex align-items-center mb-2">
                                <a href="{{ asset('storage/' . $data->geo_photos) }}" target="_blank" class="btn btn-sm btn-success">
                                    View Document
                                </a>
                            </div>
                            {{-- Only show file input if geo_photos is NOT present (for new upload/replace) --}}
                            @else
                            <input type="file" name="geo_photo" id="geo_photo" class="form-control" accept="image/*,.pdf">
                            @endif
                            <span class="text-danger is-invalid geo_photo_err"></span>
                            @if(isset($data->geo_photo))
                            <input type="hidden" name="existing_geo_photo" value="{{ $data->geo_photo }}">
                            @endif
                        </div>

                        {{-- Prescribed Document --}}
                        <div class="col-md-6 mb-3">
                            <label class="col-form-label" for="upload_prescribed_doc">Upload Application in Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                            @if($data->upload_prescribed_docs)
                            <div class="d-flex align-items-center mb-2">
                                <a href="{{ asset('storage/' . $data->upload_prescribed_docs) }}" target="_blank" class="btn btn-sm btn-success">
                                    View Document
                                </a>
                            </div>
                            @else
                            <input type="file" name="upload_prescribed_doc" id="upload_prescribed_doc" class="form-control" accept="image/*,.pdf">
                            @endif
                            <span class="text-danger is-invalid upload_prescribed_doc_err"></span>
                            @if(isset($data->upload_prescribed_docs))
                            <input type="hidden" name="existing_upload_prescribed_doc" value="{{ $data->upload_prescribed_docs }}">
                            @endif
                        </div>

                        {{-- Remark --}}
                        <div class="col-md-6 mb-3">
                            <label for="remark">Remark<span class="text-danger">*</span></label>
                            <textarea id="Remark"  maxlength="255" name="remark" class="form-control" rows="4" required></textarea>
                            <span class="text-danger is-invalid remark_err"></span>
                        </div>

                    </div>
                </div>

                <div class="card-footer">
                    <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                    <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                    <button id="btnCancel" class="btn btn-warning">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

</x-admin.layout>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
</script>
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>






