<x-admin.layout>
    <x-slot name="title">रस्त्यांवरील खड्डे बुजविणे</x-slot>
    <x-slot name="heading">रस्त्यांवरील खड्डे बुजविणे</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">View Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">

                            <input type="hidden" model-id="id" value="{{ $status->id }}">

                            <div class="col-md-4">
                                <label class="col-form-label" for="application_name">Applicant Name <span class="text-danger">*</span></label>
                                <input class="form-control" id="application_name" name="application_name" type="text" placeholder="Enter Applicant Name" value="{{ $grantNursingLicense->application_name }}" readonly>
                                <span class="text-danger is-invalid application_name_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="area">Area <span class="text-danger">*</span></label>
                                <input class="form-control" id="area" name="area" type="text" placeholder="Enter the area" value="{{ $grantNursingLicense->area }}" readonly>
                                <span class="text-danger is-invalid area_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="location">Locality <span class="text-danger">*</span></label>
                                <input class="form-control" id="location" name="location" type="text" placeholder="Enter the location" value="{{ $grantNursingLicense->location }}" readonly>
                                <span class="text-danger is-invalid location_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number <span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" type="number" placeholder="Enter the mobile_no" value="{{ $grantNursingLicense->mobile_no }}" readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="email">Email<span class="text-danger">*</span></label>
                                <input class="form-control" id="email" name="email" type="text" placeholder="Enter the email" value="{{ $grantNursingLicense->email }}" readonly>
                                <span class="text-danger is-invalid email_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="adhaarno">Aadhaar Number <span class="text-danger">*</span></label>
                                <input class="form-control" id="adhaarno" name="adhaarno" type="text" placeholder="Enter the adhaar number" value="{{ $grantNursingLicense->adhaarno }}" readonly>
                                <span class="text-danger is-invalid adhaarno_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="pincode">Pincode<span class="text-danger">*</span></label>
                                <input class="form-control" id="pincode" name="pincode" type="number" placeholder="Enter the pincode" value="{{ $grantNursingLicense->pincode }}" readonly>
                                <span class="text-danger is-invalid pincode_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="landmark">landmark<span class="text-danger">*</span></label>
                                <input class="form-control" id="landmark" name="landmark" type="text" placeholder="Enter the landmark" value="{{ $grantNursingLicense->landmark }}" readonly>
                                <span class="text-danger is-invalid landmark_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="ward_area">Ward Type<span class="text-danger">*</span></label>
                                <select name="ward_area" id="ward_area" class="form-select" readonly>
                                    <option value="" disabled selected> -- Select -- </option>
                                    @foreach ($options as $option)
                                        <option {{ $grantNursingLicense->ward_area == $option->id ? 'selected' : '' }} value="{{ $option->id }}">{{ $option->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_area_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="details">Details/तक्रारीचे स्वरूप<span class="text-danger">*</span></label>
                                <textarea class="form-control" id="details" name="details" type="text" placeholder="Enter the details" readonly>{{ $grantNursingLicense->details }}</textarea>
                                <span class="text-danger is-invalid details_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="gpsphotos">Upload GPS Photo/GPS फोटो अपलोड करा<span class="text-danger">*</span></label>
                                @if ($grantNursingLicense->gpsphoto)
                                    <a href="{{ asset('storage/' . $grantNursingLicense->gpsphoto) }}">View File</a>
                                @endif
                                {{-- <input class="form-control" id="gpsphotos" name="gpsphotos" type="file" readonly> --}}
                                <span class="text-danger is-invalid gpsphotos_err"></span>
                            </div>

                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="upload_prescribed_formats">Upload Application in Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                @if ($grantNursingLicense->prescribed_docs)
                                    <a href="{{ asset('storage/' . $grantNursingLicense->prescribed_docs) }}">View File</a>
                                @endif
                                {{-- <input class="form-control" id="upload_prescribed_formats" name="upload_prescribed_formats" type="file" required> --}}
                                <span class="text-danger is-invalid upload_prescribed_formats_err"></span>
                            </div>
                            @if (Auth::check())
                                @if (Auth::user()->hasRole('JuniorEngineer') && $status->service_id == '8933')
                                    @if (empty($grantNursingLicense->completion_photos))
                                        <div class="col-md-4 mb-2">
                                            <label class="col-form-label" for="completion_photo">Upload Work Completion GPS Photo/GPS फोटो अपलोड करा<span class="text-danger">*</span></label>
                                            <span style="color:red;">please upload photo</span>
                                            <input class="form-control" id="completion_photo" name="completion_photo" type="file" required>
                                            <span class="text-danger is-invalid completion_photo_err"></span>
                                        </div>
                                    @else
                                        <div class="col-md-4 mb-2">
                                            <label class="col-form-label" for="completion_photo">Upload Work Completion GPS Photo/GPS फोटो अपलोड करा<span class="text-danger">*</span></label>
                                            <small><a href="{{ asset('storage/' . $grantNursingLicense->completion_photos) }}" target="_blank">View Document</a></small>
                                            <span class="text-danger is-invalid completion_photo_err"></span>
                                        </div>
                                    @endif
                                @elseif ((Auth::user()->hasRole('DeputyEngineer') || Auth::user()->hasRole('ExecutiveEngineer')) && $status->service_id == '8933')
                                    @if (empty($grantNursingLicense->completion_photos))
                                        <div class="col-md-4 mb-2">
                                            <label class="col-form-label" for="completion_photo">Upload Work Completion GPS Photo/GPS फोटो अपलोड करा<span class="text-danger">*</span></label>
                                            <small><em>No upload permission. Only Junior Engineers can upload.</em></small>
                                            <span class="text-danger is-invalid completion_photo_err"></span>
                                        </div>
                                    @else
                                        <div class="col-md-4 mb-2">
                                            <label class="col-form-label" for="completion_photo">Upload Work Completion GPS Photo/GPS फोटो अपलोड करा<span class="text-danger">*</span></label>
                                            <small><a href="{{ asset('storage/' . $grantNursingLicense->completion_photos) }}" target="_blank">View Document</a></small>
                                            <span class="text-danger is-invalid completion_photo_err"></span>
                                        </div>
                                    @endif
                                @endif
                            @endif

                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" maxlength="255" class="form-control" rows="4" required></textarea>
                            </div>


                        @php
                            $currentUser = Auth::user();
                        @endphp

                        @if(!$currentUser->hasRole('clerk'))
                            <div>
                                @foreach($approvaldata as $approval)
                                    @if(!is_null($approval->remark))
                                        <div class="mb-3 p-2 border rounded bg-light">
                                            <p><strong>Approver Name:</strong> {{ $approval->approver->name ?? 'N/A' }}</p>
                                            <p><strong>Approver Time:</strong> {{ $approval->updated_at?? 'N/A' }}</p>

                                            @if($approval->approver_user_id == Auth::user()->id)
                                                <p><strong>Matched Auth User:</strong> {{ $name }}</p>
                                            @else
                                            @endif

                                            <p><strong>Remark:</strong> {{ $approval->remark }}</p>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        @endif


                        </div>

                        {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                        <div class="col-md-12">
                            <div class="form-check d-flex align-items-start">
                                <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" checked value="yes">
                                <label class="form-check-label ms-2" for="is_correct_info">
                                    "All information provided above is correct and I shall be fully responsible for any discrepancy. <br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                    असेन."
                                </label>
                            </div>
                            <span class="text-danger is-invalid is_correct_info_err"></span>
                        </div> --}}

                    </div>
            </div>
            <div class="card-footer">
                @if (Auth::check() && Auth::user()->hasRole('JuniorEngineer') && $status->service_id == '8933')
                    @if (empty($grantNursingLicense->completion_photos))
                        <button type="submit" class="btn btn-secondary" id="addSubmit">Update</button>
                    @else
                        <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button id="btnCancel" class="btn btn-warning">Cancel</button>
                    @endif
                @else
                    <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                    <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                    <button id="btnCancel" class="btn btn-warning">Cancel</button>
                @endif
            </div>

            </form>
        </div>
    </div>
    </div>

</x-admin.layout>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
</script>
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route('potholes-road.update', $grantNursingLicense->id) }}';
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Updated Sucessfully!',
                    text: response.message,
                    confirmButtonText: 'OK'
                }).then(() => {
                    window.location.href = '{{ route('pendinglist') }}';
                });
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
