<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>Receipt</title>

    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
            font-size: 14px;
        }

        .header {
            text-align: center;
            margin-bottom: 10px;
        }

        .header img {
            float: left;
            margin-right: 20px;
        }

        hr {
            border: 1px solid #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        td,
        th {
            padding: 8px 12px;
            text-align: left;
        }

        .bordered-table th,
        .bordered-table td {
            border: 1px solid #000;
        }

        .note {
            margin-top: 40px;
            text-align: center;
            font-size: 16px;
        }
    </style>
</head>

<body>

    <div class="header">
        @php
            $logoData1 = file_get_contents(public_path('admin/images/favicon.png'));
            $base641Logo = base64_encode($logoData1);
        @endphp

        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" height="120" width="120">

        <h2 style="margin:0;">MIRA BHAYANDAR MUNICIPAL CORPORATION</h2>
        <p style="margin:0;">Indira Gandhi Bhavan, Chattrapati Shivaji Maharaj Marg, Bhayandar(W), Dist - Thane</p>
        <p style="margin:0;">Tel Nos. 022-28192828 / 28193028 / 28181183 / 28181353 / 28145985</p>
        <h3 style="margin-top:10px;">आरोग्य विभाग</h3>
    </div>

    <div style="clear:both;"></div>

    <hr>

    <!-- Receipt No Row -->
    <table>
        <tr>
            <td><strong>Receipt No.:</strong> {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}</td>
            <td><strong>Date:</strong> {{ \Carbon\Carbon::parse($paymentdata->created_at)->format('d/m/Y') }}</td>
        </tr>
    </table>

    <!-- Details Table -->
    <table>
        <tr>
            <td><strong>Account Name:</strong></td>
            <td>Mira Bhayandar Municipal Corporation General Fund</td>
            <td><strong>Bank Name:</strong></td>
            <td>Bank of Baroda</td>
        </tr>
        <tr>
            <td><strong>Account No:</strong></td>
            <td>**********0569</td>
            <td><strong>IFSC Code:</strong></td>
            <td>BARB0DBBHAW</td>
        </tr>
        <tr>
            <td><strong>Application No:</strong></td>
            <td>{{ $data->application_no }}</td>
            <td><strong>Payment Date:</strong></td>
            <td>{{ \Carbon\Carbon::parse($paymentdata->created_at)->format('d/m/Y') }}</td>
        </tr>
        <tr>
            <td><strong>Applicant Name:</strong></td>
            <td>{{ $data->first_name }}</td>
            <td><strong>Verified Date:</strong></td>
            <td>-</td>
        </tr>
        <tr>
            <td><strong>Applicant Mobile No:</strong></td>
            <td>{{ $data->mobile_num }}</td>
            <td><strong>Transaction No:</strong></td>
            <td>{{ $paymentdata->orderno }}</td>
        </tr>
        <tr>
            <td><strong>Reference No:</strong></td>
            <td>-</td>
            <td><strong>Service Name:</strong></td>
            <td>Civil Local Self-Government Nomination Certificate for State Food License / राज्य खाद्य परवान्या करिता नागरी स्थानिक स्वराज्य संस्थांचा नाहरकत दाखला</td>
        </tr>
        <tr>
            <td><strong>Received From:</strong></td>
            <td>-</td>
            <td><strong>PTAX SAC Number:</strong></td>
            <td>-</td>
        </tr>
        <tr>
            <td><strong>Demand Note Reference No:</strong></td>
            <td>-</td>
            <td></td>
            <td></td>
        </tr>
    </table>

    <!-- Amount Table -->
    <table class="bordered-table">
        <thead>
            <tr>
                <th>Sr No</th>
                <th>Description</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>1.</td>
                <td>Certificate Charges</td>
                <td>Rs. {{ $paymentdata->amount }}</td>
            </tr>
            <tr>
                <td></td>
                <td><strong>Gross Amount</strong></td>
                <td><strong>Rs. {{ $paymentdata->amount }}</strong></td>
            </tr>
        </tbody>
    </table>

    <!-- Amount in Words -->
    <?php
        $number = $paymentdata->amount;
        $no = floor($number);
        $point = round($number - $no, 2) * 100;
        $hundred = null;
        $digits_1 = strlen($no);
        $i = 0;
        $str = [];
        $words = [
            '0' => '', '1' => 'one', '2' => 'two', '3' => 'three', '4' => 'four', '5' => 'five', '6' => 'six',
            '7' => 'seven', '8' => 'eight', '9' => 'nine', '10' => 'ten', '11' => 'eleven', '12' => 'twelve',
            '13' => 'thirteen', '14' => 'fourteen', '15' => 'fifteen', '16' => 'sixteen', '17' => 'seventeen',
            '18' => 'eighteen', '19' => 'nineteen', '20' => 'twenty', '30' => 'thirty', '40' => 'forty',
            '50' => 'fifty', '60' => 'sixty', '70' => 'seventy', '80' => 'eighty', '90' => 'ninety'
        ];

        $digits = ['', 'hundred', 'thousand', 'lakh', 'crore'];

        while ($i < $digits_1) {
            $divider = $i == 2 ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $counter = count($str);
                $plural = $counter && $number > 9 ? 's' : null;
                $hundred = $counter == 1 && $str[0] ? ' and ' : null;
                $str[] = ($number < 21)
                    ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred
                    : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else {
                $str[] = null;
            }
        }

        $str = array_reverse($str);
        $result = implode('', $str);
        $title = 'Amount In Words :- ';
        $points = $point ? ' and ' . $words[floor($point / 10) * 10] . ' ' . $words[$point % 10] . ' Paise' : '';
        echo "<p><strong>{$title} Rupees ".ucfirst(trim($result))." {$points}</strong></p>";
    ?>

    <p class="note">Note: This is a computer-generated receipt, hence no signature is required.</p>

</body>

</html>
