<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .content {
            margin-top: 30px;
        }

        /* .sub-header {
            text-align: right;
        } */
        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }

        .points {
            margin-top: 20px;
        }

        .points li {
            margin-bottom: 10px;
            margin-left: 5%;
        }

        p {
            font-size: 18px;
        }
    </style>
</head>

<body>

    <div class="header">
        @php
            $logoData = file_get_contents(public_path('admin/images/favicon.png'));
            $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
            $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
            $base64Logo = base64_encode($logoData);
            $base64Logo2 = base64_encode($logoData2);
            $base641Logo = base64_encode($logoData1);
        @endphp
        <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150">
        <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo" style="float:right;margin-top:35px;" height="150" width="150">
        <div class="rox">
            <h2>मिरा भाईंदर महानगरपालिका</h2>
            <p>स्व.इंदिरा गांधी भवन,मुख्य कार्यालय, छत्रपती शिवाजी महाराज मार्ग, भाईंदर (प.),ता.ठाणे-४०११०१</p>
            <p>दूरध्वनी क्र.२८१९२४८</p>
            <h3>महाराष्ट्र शुश्रूषा-गृह नोंदणी अधिनियम 1949 अंतर्गत शुश्रूषा-गृह परवाना देणे</h3>
        </div>
    </div>

    <hr>
    <hr style="1px solid #000; height:5px; background-color:#000;">
    <h3 style="text-align: center"> FORM ‘C’ - ORIGINAL</h3>
    <h3 style="text-align: center">SEE RULE - 5 </h3>
    <p style="text-align: justify;">
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This is to certify that <strong>{{ $data->name_institute }}</strong> has been registered under the
        Bombay Nursing Home Registration Act 1949 in respect of situated at <strong>{{ $data->hospital_address }}</strong> and has been authorized to carry on the said nursing home.
    </p>

    <p style="text-align: justify;">
        This certificate of Registration shall be valid up to – {{ \Carbon\Carbon::parse($data->created_at)->addYear()->subDay()->format('d-m-Y') }}.<br>
        However, this registration shall stand cancelled if any of the conditions which are
        considered while granting the registration are found to be breached.
    </p>
    <p> Registration No: <strong>{{ $data->reg_no  }}</strong>
        <br> Date of Registration:   <span class=" ">{{\Carbon\Carbon::parse($data->created_at)->format('d-m-Y')}}</span>
        <br> Place: Head Office, M.B.M.C<br> No. Of Beds:
        <span class=" ">{{ $data->no_of_beds }}</span> </p>

    <div class="footer" style="float:right;">
        <p>(________________________ )<br> Medical Officer of Health<br> Mira Bhaindar Municipal Corporation</p>
    </div>
</body>

</html>
