<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>Receipt</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .content {
            margin-top: 30px;
        }

        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }

        .points {
            margin-top: 20px;
        }

        .points li {
            margin-bottom: 10px;
            margin-left: 5%;
        }

        p {
            font-size: 18px;
        }

        table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
            /* Ensure borders collapse to a single line */
        }

        td {
            padding: 8px 12px;
            text-align: left;
        }

        th {
            text-align: left;
            white-space: nowrap;
        }

        /* Border style only for the second table */
        .bordered-table th,
        .bordered-table td {
            border: 1px solid #000;
            /* Adding border to cells */
        }

        .sub-header {
            margin-top: 20px;
        }
    </style>
</head>

<body>

    <div class="header">
        @php
            $logoData1 = file_get_contents(public_path('admin/images/favicon.png'));
            $base641Logo = base64_encode($logoData1);
        @endphp
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left;" height="150"
            width="150">
        <div class="rox">
            <h2>MIRA BHAYANDAR MUNICIPAL CORPORATION</h2>
            <p>Indira Gandhi Bhavan, Chattrapati Shivaji Maharaj Marg, Bhayandar(W), Dist -Thane </p>
            <p>Tel Nos. 022-28192828/ 28193028/ 28181183/ 28181353/ 28145985.</p>
            <h3>आरोग्य विभाग</h3>
        </div>
    </div>

    <hr style="1px solid #000; height:5px; background-color:#000;">

    <div class="sub-header">
        <p>Receipt No.: {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;
            Date: <span>{{ \Carbon\Carbon::parse($paymentdata->created_at)->format('d/m/Y') }}</span></p>
    </div>

    <table>
        <tr>
            <th><strong>Account name :</strong></th>
            <td>Mira Bhayandar Municipal Corporation General Fund</td>
            <th><strong>Bank Name</strong></th>
            <td>Bank of Baroda</td>
        </tr>

        <tr>
            <th><strong>Account No :</strong></th>
            <td>**********0569</td>
            <th><strong>IFSC Code</strong></th>
            <td>BARB0DBBHAW</td>
        </tr>
        <tr>
            <th><strong>Application No :</strong></th>
            <td>{{ $data->application_no }}</td>
            <th><strong>Payment Date:</strong></th>
            <td>{{ \Carbon\Carbon::parse($paymentdata->created_at)->format('d/m/Y') }}</td>
        </tr>

        <tr>
            <th><strong>Applicant Name :</strong></th>
            <td>{{ $data->applicant_name }}</td>
            <th><strong>Verified Date :</strong></th>
            <td></td>
        </tr>
        <tr>
            <th><strong>Applicant Mobile No :</strong></th>
            <td>{{ $data->mobile_num }}</td>
            <th><strong>Transaction No :</strong></th>
            <td>{{ $paymentdata->orderno }}</td>
        </tr>
        <tr>
            <th><strong>Reference No :</strong></th>
            <td></td>
            <th><strong>Service Name :</strong></th>
            <td>Licensing of Nursing Homes Registration Act, 1949</td>
        </tr>
        <tr>
            <th><strong>Received From :</strong></th>
            <td></td>
        </tr>
        <tr>
            <th><strong>PTAX SAC Number :</strong></th>
            <td></td>
        </tr>
        <tr>
            <th><strong>Demand Note Reference No :</strong></th>
            <td></td>
        </tr>
    </table>

    <!-- Table with borders applied -->
    <table class="bordered-table">
        <thead>
            <tr>
                <th>Sr No</th>
                <th>Description</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>1.</td>
                <td>Certificate Charges</td>
                <td>Rs.{{ $paymentdata->amount }}</td>
            </tr>

        </tbody>
        <tfoot>
            <tr>
                <td></td>
                <td>Gross Amount</td>
                <td>Rs. {{ $paymentdata->amount }}</td>
            </tr>

        </tfoot>
    </table>
    <?php
    $number = $paymentdata->amount;
    $no = floor($number);
    $point = round($number - $no, 2) * 100;
    $hundred = null;
    $digits_1 = strlen($no);
    $i = 0;
    $str = [];
    $words = ['0' => '', '1' => 'one', '2' => 'two', '3' => 'three', '4' => 'four', '5' => 'five', '6' => 'six', '7' => 'seven', '8' => 'eight', '9' => 'nine', '10' => 'ten', '11' => 'eleven', '12' => 'twelve', '13' => 'thirteen', '14' => 'fourteen', '15' => 'fifteen', '16' => 'sixteen', '17' => 'seventeen', '18' => 'eighteen', '19' => 'nineteen', '20' => 'twenty', '30' => 'thirty', '40' => 'forty', '50' => 'fifty', '60' => 'sixty', '70' => 'seventy', '80' => 'eighty', '90' => 'ninety'];
    $digits = ['', 'hundred', 'thousand', 'lakh', 'crore'];
    while ($i < $digits_1) {
        $divider = $i == 2 ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += $divider == 10 ? 1 : 2;
        if ($number) {
            $plural = ($counter = count($str)) && $number > 9 ? 's' : null;
            $hundred = $counter == 1 && $str[0] ? ' and ' : null;
            $str[] = $number < 21 ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
        } else {
            $str[] = null;
        }
    }
    $str = array_reverse($str);
    $result = implode('', $str);
    $title = 'Amount In Word :- ';
    $points = $point ? ' and ' . $words[floor($point / 10) * 10] . ' ' . $words[$point % 10] . ' Paise' : '';
    echo '<strong>' . $title . 'Rupees ' . ucfirst(trim($result)) . $points . '</strong>';
    ?>
    <p style="margin-top:50px; text-align:center;">Note : This is Computer generated Receipt, hence no Signature
        require.
    </p>

</body>

</html>
