<x-admin.layout>
    <x-slot name="title">Payment Summary</x-slot>
    <x-slot name="heading">Payment Summary</x-slot>

    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10">

                <div class="card shadow   ">
                    {{-- Header --}}
                    <div class="card-header bg-primary  text-center py-3">
                        <h4 class="mb-0 fw-semibold text-white">
                            <i class="fa fa-wallet me-2"></i> Payment Summary
                        </h4>
                    </div>

                    {{-- Body --}}
                    <div class="card-body border-3 border-primary  px-5 py-4 ">

                        {{-- Applicant Info --}}
                        <div class="mb-3 row align-items-center">
                            <label class="col-sm-4 fw-bold text-muted">Applicant Name:</label>
                            <div class="col-sm-8">
                                <span class="fs-6 text-dark">{{ ucwords(strtolower($userdata->name ?? 'N/A')) }}</span>
                            </div>
                        </div>

                        <div class="mb-3 row align-items-center">
                            <label class="col-sm-4 fw-bold text-muted">Mobile No:</label>
                            <div class="col-sm-8">
                                <span class="fs-6 text-dark">{{ $userdata->mobile ?? 'N/A' }}</span>
                            </div>
                        </div>

                        <hr class="my-3">

                        {{-- Application Info --}}
                        <div class="mb-3 row align-items-center">
                            <label class="col-sm-4 fw-bold text-muted">Service Name:</label>
                            <div class="col-sm-8">
                                <span class="fs-6 text-dark">{{ $serviceName->service_name ?? 'N/A' }}</span>
                            </div>
                        </div>

                        <div class="mb-3 row align-items-center">
                            <label class="col-sm-4 fw-bold text-muted">Application No:</label>
                            <div class="col-sm-8">
                                <span class=" fs-6 text-dark">
                                    {{ $item->application_no ?? 'N/A' }}
                                </span>
                            </div>
                        </div>

                        <div class="mb-4 row align-items-center">
                            <label class="col-sm-4 fw-bold text-muted">Amount Payable:</label>
                            <div class="col-sm-8">
                                <span class="fs-5 fw-bold ">
                                    ₹{{ number_format($amount ?? 0, 2) }}
                                </span>
                            </div>
                        </div>

                        <hr class="my-4">

                        {{-- Payment Buttons --}}

                        @php
                            $isPayable = isset($amount) && $amount > 0;
                        @endphp

                        <div class="d-flex justify-content-center gap-3 flex-wrap mt-3">
                            <button type="button" onclick="submitPaymentForm()" class="btn {{ $isPayable ? 'btn-outline-primary' : 'btn-outline-secondary' }} px-4 py-2 shadow-sm" style="{{ !$isPayable ? 'cursor:not-allowed' : '' }}" {{ !$isPayable ? 'disabled' : '' }}>
                                <i class="fa fa-credit-card me-2"></i> Pay Online
                            </button>

                            <button type="button" $isPayable ? data-bs-toggle="modal" data-bs-target="#offlineModal" class="btn {{ $isPayable ? 'btn-outline-primary' : 'btn-outline-secondary' }} px-4 py-2 shadow-sm " style="{{ !$isPayable ? 'cursor:not-allowed' : '' }}" {{ !$isPayable ? 'disabled' : '' }}>
                                <i class="fa fa-money-bill me-2"></i> Pay Offline
                            </button>
                        </div>




                        {{-- Back Button --}}
                        <div class="text-center mt-4">
                            <a href="{{ url('my-application') }}" class="btn btn-secondary btn-sm px-3">
                                <i class="fa fa-arrow-left me-1"></i> Back to My Applications
                            </a>
                        </div>

                    </div>

                    {{-- Footer --}}
                    <div class="card-footer text-center bg-light text-muted py-2 rounded-bottom small">
                        <i class="fa fa-info-circle me-1"></i>
                        Please choose your preferred payment method to proceed.
                    </div>


                    <form method="post" name="customerData" action="{{ route('redirect-payment') }}" id="paymentForm" style="display:none;">
                        @csrf
                        <input type="hidden" name="serviceid" id="serviceid" value="{{ $serviceId }}" />
                        <input type="hidden" name="id" id="id" value="{{ $id }}" />
                        <input type="text" name="tid" id="tid" />
                        <input type="hidden" name="merchant_id" value="{{ config('payment.merchant_id') }}" />
                        <input type="hidden" name="order_id" value="{{ $order_id }}" />

                            <input type="hidden" name="amount" value="{{ $amount ?? '' }}" />

                        <input type="hidden" name="currency" value="INR" />
                        {{-- <input type="hidden" name="redirect_url" value="{{ route('success-payment') }}" /> --}}

                        <input type="hidden" name="redirect_url" value="{{ route('success-payment') }}" />

                        {{-- <input type="hidden" name="cancel_url" value="{{ route('success-payment') }}" /> --}}
                        <input type="hidden" name="cancel_url" value="{{ route('cancel-payment') }}" />

                        <input type="hidden" name="language" value="EN" />
                        <input type="hidden" name="billing_name" value="{{ $userdata->name }}" />
                        <input type="hidden" name="billing_address" value="" />
                        <input type="hidden" name="billing_city" value="" />
                        <input type="hidden" name="billing_state" value="MH" />
                        <input type="hidden" name="billing_zip" value="" />
                        <input type="hidden" name="billing_country" value="India" />
                        <input type="hidden" name="billing_tel" value="{{ $userdata->mobile }}" />
                        <input type="hidden" name="billing_email" value="{{ $userdata->email }}" />
                        <input type="hidden" name="delivery_name" value="" />
                        <input type="hidden" name="delivery_address" value="" />
                        <input type="hidden" name="delivery_city" value="" />
                        <input type="hidden" name="delivery_state" value="MH" />
                        <input type="hidden" name="delivery_zip" value="" />
                        <input type="hidden" name="delivery_country" value="India" />
                        <input type="hidden" name="delivery_tel" value="" />
                        <input type="hidden" name="merchant_param1" value="additional Info." />
                        <input type="hidden" name="merchant_param2" value="additional Info." />
                        <input type="hidden" name="merchant_param3" value="additional Info." />
                        <input type="hidden" name="merchant_param4" value="additional Info." />
                        <input type="hidden" name="merchant_param5" value="additional Info." />
                        <input type="hidden" name="promo_code" value="" />
                        <input type="hidden" name="customer_identifier" value="" />
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="offlineModal" tabindex="-1" aria-labelledby="offlineModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form id="uploadForm" method="POST" enctype="multipart/form-data" action="{{ route('upload', [$id]) }}">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="offlineModalLabel">Upload Payment Receipt</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <input type="hidden" name="statusId" id="statusId" value="{{ $id }}">
                        <input type="hidden" name="serviceId" id="serviceId" value="{{ $serviceId }}">
                        <input type="hidden" name="fees_amount" id="fees_amount" value="{{ $amount }}">
                        <div class="mb-3">
                            <label>Document Upload<span class="text-danger">*</span></label>
                            <input type="file" class="form-control" name="document_upload" required>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="submit" id="uploadBtn" class="btn btn-primary">
                            <span class="btn-text">Submit</span>
                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
 @push('scripts')
 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    function submitPaymentForm() {
        document.getElementById('paymentForm').submit();
    }

    $('#uploadForm').on('submit', function(e) {
        e.preventDefault();

        let formData = new FormData(this);
        let $uploadBtn = $('#uploadBtn');
        let $spinner = $uploadBtn.find('.spinner-border');
        let $btnText = $uploadBtn.find('.btn-text');

        // Disable button and show loader
        $uploadBtn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $btnText.text('Uploading...');

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            headers: {
                'X-CSRF-TOKEN': $('input[name="_token"]').val()
            },
            success: function(response) {
                // Restore button
                $uploadBtn.prop('disabled', false);
                $spinner.addClass('d-none');
                $btnText.text('Submit');

                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: response.message,
                        confirmButtonText: 'OK'
                    }).then(() => {
                        window.location.href = response.redirect_url;
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'Upload failed.',
                        confirmButtonText: 'OK'
                    });
                }
            },
            error: function(xhr) {
                // Restore button
                $uploadBtn.prop('disabled', false);
                $spinner.addClass('d-none');
                $btnText.text('Submit');

                if (xhr.status === 422) {
                    let errors = xhr.responseJSON.errors;
                    Swal.fire({
                        icon: 'warning',
                        title: 'Validation Error',
                        html: Object.values(errors).join('<br>'),
                        confirmButtonText: 'OK'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Something went wrong!',
                        confirmButtonText: 'OK'
                    });
                }
            }
        });
    });
</script>
@endpush
</x-admin.layout>
