<x-admin.layout>
    <x-slot name="title">Registration of objection / आक्षेप नोंदविणे</x-slot>
    <x-slot name="heading">Registration of objection / आक्षेप नोंदविणे</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card p-3">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Applicant Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="upic_id">UPIC No<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="upic_id" name="upic_id" type="text"
                                        placeholder="PNVL000045" required>
                                    <span class="text-danger is-invalid upic_id_err"></span>
                                </div> --}}
                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_full_name">Applicant Full Name /
                                        अर्जदाराचे संपूर्ण नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="applicant_full_name" name="applicant_full_name"
                                        type="text" placeholder="Enter Applicant Full Name"
                                        value="{{ $user->name }}" readonly>
                                    <span class="text-danger is-invalid applicant_full_name_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_full_address">Applicant's Full Address
                                        / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="applicant_full_address" id="applicant_full_address" cols="30" rows="2"
                                        placeholder="Enter Applicant Address" readonly>{{ $user->address }}</textarea>
                                    <span class="text-danger is-invalid applicant_full_address_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_mobile_no">Mobile Number / मोबाईल
                                        नंबर<span class="text-danger">*</span></label>
                                    <input class="form-control" id="applicant_mobile_no" name="applicant_mobile_no"
                                        oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10"
                                        minlength="10" type="text" placeholder="Enter Mobile Number"
                                        value="{{ $user->mobile }}" readonly>
                                    <span class="text-danger is-invalid applicant_mobile_no_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="email_id">Email ID / ई-मेल आयडी<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="email_id" name="email_id" type="email"
                                        value="{{ $user->email }}" placeholder="Enter Email" readonly>
                                    <span class="text-danger is-invalid email_id_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="aadhar_no">Applicant Aadhar No / अर्जदाराचा आधार
                                        नंबर</label>
                                    <input class="form-control" id="aadhar_no" name="aadhar_no"
                                        oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12"
                                        value="{{ $user->aadhar_no }}" minlength="12" type="text"
                                        placeholder="Enter Aadhar Card No" readonly>
                                    <span class="text-danger is-invalid aadhar_no_err"></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        @csrf
                        <div class="card-body">
                            <div class="col-md-4">
                                <input class="form-control" id="marchantid" name="marchantid" type="hidden"
                                    value="MBMCCORE">
                                <span class="text-danger is-invalid marchantid_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="property_no">Property No<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" id="property_no" name="property_no" type="text"
                                    placeholder="Enter Property No">
                                <span class="text-danger is-invalid property_no_err"></span>
                            </div>
                        </div>
                        <button type="Search" style="margin-left: 12px;" class="btn btn-primary w-25"
                            id="searchdetails">Search</button>
                        <br>
                    </div>


                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Property Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_owner_name">Property Owner Name /
                                        मालमत्तेच्या मालकाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="property_owner_name" name="property_owner_name"
                                        type="text" placeholder="Enter Property Owner Name" readonly>
                                    <span class="text-danger is-invalid property_owner_name_err"></span>
                                </div>


                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_address">Property Address / मालमत्तेचा
                                        पत्ता <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="property_address" id="property_address" rows="2"
                                        placeholder="Enter Property Address" readonly></textarea>
                                    <span class="text-danger is-invalid property_address_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" name="zone" id="zone"
                                        placeholder="Enter Zone" readonly>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="ward">Ward Area / प्रभाग क्षेत्र<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" name="ward" id="ward"
                                        placeholder="Enter Ward" readonly>
                                    <span class="text-danger is-invalid ward_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="city_serve_number">Property Survey No / सर्व्हे
                                        क्र.</label>
                                    <input class="form-control" id="city_serve_number" name="city_serve_number"
                                        type="text" placeholder="Enter Survey Number" readonly>
                                    <span class="text-danger is-invalid city_serve_number_err"></span>
                                </div>

                                <input type="hidden" id="warddata" name="ward_area">


                                <div class="col-md-4">
                                    <label class="col-form-label" for="house_no">House No / घर क्र<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="house_no" name="house_no" type="text"
                                        placeholder="Enter House Number" readonly>
                                    <span class="text-danger is-invalid house_no_err"></span>
                                </div>




                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_area">Property Area / मालमत्ता
                                        क्षेत्रफळ<span class="text-danger">*</span></label>
                                    <input class="form-control" id="property_area" name="property_area"
                                        type="text" placeholder="Enter Property Area" readonly>
                                    <span class="text-danger is-invalid property_area_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_usage">Property Usage / मालमत्ता
                                        वापर<span class="text-danger">*</span></label>
                                    <input class="form-control" name="property_usage" id="property_usage"
                                        placeholder="Enter Property Usage" readonly>
                                    <span class="text-danger is-invalid property_usage_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="index_number">Total Outstanding Payable /
                                        एकूण देय थकबाकी?</label>
                                    <input class="form-control" id="index_number" name="index_number" type="text"
                                        placeholder="Enter Index Number" readonly>
                                    <span class="text-danger is-invalid index_number_err"></span>
                                </div>

                                <div class="col-md-4 mt-4">
                                    <button type="button" id="payaccentech" class="btn btn-success d-none"
                                        target="_blank" onclick="payNow()">Pay</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Add Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="construction_type">Construction Type / बांधकाम
                                        प्रकार<span class="text-danger">*</span></label>
                                    <select class="form-select" name="construction_type" id="construction_type"
                                        required>
                                        <option value="">Select Construction Type</option>
                                        @php
                                            $options = [
                                                'सिमेंट कॉँक्रिट संरचना',
                                                "सिमेंट / चुना / विटांच्या भिंती व स्ल्याब
                                        चे छत",
                                                'सिमेंट / चुना / विटांच्या भिंती व टीन / कवेलु चे छत',
                                                "मातीच्या भिंतीवर
                                        टीन / कवेलु चे छत",
                                                'खुला भूखंड',
                                                'इतर',
                                            ];
                                        @endphp
                                        @foreach ($options as $option)
                                            <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid construction_type_err"></span>
                                </div>
                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="is_construction_authorized">Is Construction
                                        Authorized ? / बांधकाम अधिकृत आहे का ?<span class="text-danger">*</span></label>
                                    <select class="form-select" name="is_construction_authorized"
                                        id="is_construction_authorized" required>
                                        <option value="">Select Option</option>
                                        @php
                                        $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid is_construction_authorized_err"></span>
                                </div> --}}
                                <div class="col-md-4">
                                    <label class="col-form-label" for="is_there_water_connection">Is there a
                                        Water(Tap)
                                        Connection ? / पाणी (नळ) कनेक्शन आहे का ?<span
                                            class="text-danger">*</span></label>
                                    <select class="form-select" name="is_there_water_connection"
                                        id="is_there_water_connection" required>
                                        <option value="">Select Option</option>
                                        @php
                                            $options = ['Yes', 'No'];
                                        @endphp
                                        @foreach ($options as $option)
                                            <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid is_there_water_connection_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="date_of_commencement">Date of Commencement of
                                        Use
                                        of Building / इमारतीचा वापर सुरू झाल्याची तारीख<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="date_of_commencement" name="date_of_commencement"
                                        type="date" required>
                                    <span class="text-danger is-invalid date_of_commencement_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="no_dues_documents">Upload Certificate Of No
                                        Dues
                                        / थकबाकी नसल्याचा दाखला अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="no_dues_documents" name="no_dues_documents"
                                        type="file" required>
                                    <span class="text-danger is-invalid no_dues_documents_err"></span>
                                </div>
                                <div class="col-md-4" id="upload_section" style="display:none;">
                                    <label class="col-form-label" for="uploaded_applications">Upload Application In
                                        Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="uploaded_applications"
                                        name="uploaded_applications" type="file">
                                    <span class="text-danger is-invalid uploaded_applications_err"></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                    <div class="col-md-12">
                        <div class="form-check d-flex align-items-start">
                            <input type="checkbox" class="form-check-input mt-1" id="is_correct_info"
                                name="is_correct_info" required value="yes">
                            <label class="form-check-label ms-2" for="is_correct_info">
                                "All information provided above is correct and I shall be fully responsible
                                for any discrepancy. <br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात
                                कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                            </label>
                        </div>
                        <span class="text-danger is-invalid is_correct_info_err"></span>
                    </div>
                    <div class="form-group d-flex justify-content-center my-3" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and
                            Print</button>
                    </div>
                    <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                        <button type="reset" class="btn btn-warning">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<script>
    $('#searchdetails').on('click', function(e) {
        e.preventDefault();

        let formData = {
            marchantid: $('#marchantid').val(),
            propno: $('#property_no').val(),
            _token: $('input[name="_token"]').val()
        };

        $.ajax({
            url: '{{ route('fetch.property.details') }}',
            method: 'POST',
            data: formData,
            datatype: JSON,
            success: function(response) {
                console.log("Encrypted Data:", response.jsonData.encr_request);

                const decryptedData = JSON.parse(response.jsonData.encr_request);


                if (decryptedData && decryptedData['property_Details']) {
                    $('#property_owner_name').val(decryptedData['property_Details'].Owner_Name);
                    $('#property_address').val(decryptedData['property_Details'].Property_Address);
                    $('#new_owner_name').val(decryptedData['property_Details']
                        .Full_Address_Of_The_Property);
                    $('#address').val(decryptedData['property_Details'].Water_Connection_Size);
                    $('#ward').val(decryptedData['property_Details'].Ward);
                    $('#city_serve_number').val(decryptedData['property_Details']
                        .Property_Survey_No);
                    $('#property_area').val(decryptedData['property_Details'].Property_Area);
                    $('#house_no').val(decryptedData['property_Details'].Flat_Number);
                    $('#zone').val(decryptedData['property_Details'].Zone);
                    $('#property_usage').val(decryptedData['property_Details'].Property_Usage);
                    $('#index_number').val(decryptedData['property_Details'].OutstandingAmt);

                    const fullZone = decryptedData['property_Details'].Zone;
                    const zoneCode = fullZone.charAt(0);
                    const wardNumber = decryptedData['property_Details'].Ward.toString();
                    const sectorCode = wardNumber.length === 1 ? '0' + wardNumber : wardNumber;

                    const finalCode = zoneCode + sectorCode;

                    $('#warddata').val(finalCode);


                    const uploadedValue = parseInt($('#index_number').val());
                    const savePrintBtn = document.getElementById('saveAndPrintBtn');
                    const paybtn = document.getElementById('payaccentech');

                    if (uploadedValue === 0) {
                        savePrintBtn.style.display = 'block';
                        paybtn.style.display = 'none';
                    } else {
                        $('#payaccentech').removeClass('d-none');
                        savePrintBtn.style.display = 'none';
                        paybtn.style.display = 'block';
                    }

                } else {
                    console.error("connectionDetails is missing or undefined");
                }
            },

            error: function(xhr) {
                console.error(xhr.responseText);
            }
        });
    });


    function payNow() {
        var propNo = document.getElementById("property_no").value;
        if (propNo) {
            var url = 'https://pg.mbmc.gov.in/PropSearch.aspx?PTN=' + propNo;
            window.location.href = url;
        } else {
            alert('Please enter a property number.');
        }
    }
</script>

<script>
    document.getElementById('saveAndPrintBtn').addEventListener('click', function() {
        let isValid = true;
        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const messages = {
            applicant_name: 'Applicant name is required',
            applicant_full_address: 'Address is required',
            applicant_mobile_no: 'Mobile no. is required',
            email_id: 'Email is required',
            propno: 'This field is required',
            ward: 'Ward is required',
            property_no: 'Property no. is required',
            property_owner_name: 'Owner name is required',
            property_address: 'Address is required',
            house_no: 'House no. is required',
            property_usage: 'Property usage field is required',
            zone: 'Zone is required',
            index_number: 'This field is required',
            property_area: 'Property area is required',
            is_there_water_connection: 'This field is required',
            date_of_commencement: 'This field is required',
            construction_type: 'This field is required',
            no_dues_documents: 'Please upload the file',
            is_correct_info: 'Please accept the declaration',
        };

        Object.keys(messages).forEach(fieldName => {
            const field = addContainer.querySelector(`[name="${fieldName}"]`);
            const errorSpan = addContainer.querySelector(`.${fieldName}_err`);

            if (fieldName === 'is_correct_info') {
                if (!field || !field.checked) {
                    isValid = false;
                    if (errorSpan) errorSpan.textContent = messages[fieldName];
                } else if (errorSpan) {
                    errorSpan.textContent = '';
                }
                return;
            }

            if (field) {
                if (!field.value.trim()) {
                    isValid = false;
                    field.classList.add('is-invalid');
                    if (errorSpan) errorSpan.textContent = messages[fieldName];
                } else {
                    field.classList.remove('is-invalid');
                    if (errorSpan) errorSpan.textContent = '';
                }
            }
        });

        if (!isValid) return;

        document.getElementById('upload_section').style.display = 'block';
        document.getElementById('card-footer').style.display = 'block';

        // const addContainer = document.getElementById('addContainer');
        // if (!addContainer) return;
        const printContainerClone = addContainer.cloneNode(true);
        const uploadSection = printContainerClone.querySelector('#upload_section');
        if (uploadSection) {
            uploadSection.remove();
        }
        printContainerClone.style.fontSize = '16px';
        printContainerClone.style.lineHeight = '1.4';
        printContainerClone.style.padding = '20px';
        printContainerClone.style.margin = '0 auto';
        printContainerClone.style.background = '#fff';
        printContainerClone.style.width = '210mm';
        printContainerClone.style.minHeight = '297mm';
        printContainerClone.style.boxSizing = 'border-box';
        Array.from(printContainerClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });
        const printTitle = document.createElement('h2');
        printTitle.style.textAlign = 'center';
        printTitle.style.marginBottom = '18px';
        printTitle.style.fontSize = '18px';
        printTitle.textContent = 'RegistrationOfObjection';
        printContainerClone.insertBefore(printTitle, printContainerClone.firstChild);
        Array.from(printContainerClone.querySelectorAll('button')).forEach(btn => btn.remove());
        Array.from(printContainerClone.querySelectorAll('.card')).forEach(card => {
            card.style.background = 'white';
            card.style.boxShadow = 'none';
            card.style.border = '1px solid #ccc';
            card.style.marginBottom = '12px';
            card.style.padding = '12px';
        });

        Array.from(printContainerClone.querySelectorAll('.selected-value')).forEach(div => {
            div.classList.remove('d-none');
        });

        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printContainerClone);

        addContainer.querySelectorAll('select').forEach(originalSelect => {
            const name = originalSelect.getAttribute('name');
            if (!name) return;

            const clonedSelect = printContainerClone.querySelector(`[name="${name}"]`);
            if (!clonedSelect) return;

            const selectedOption = originalSelect.options[originalSelect.selectedIndex];
            const selectedText = selectedOption ? selectedOption.text : '—';

            const replacement = document.createElement('span');
            replacement.textContent = selectedText;
            replacement.style.display = 'inline-block';
            replacement.style.padding = '4px 8px';
            replacement.style.border = '1px solid #ccc';
            replacement.style.borderRadius = '4px';
            replacement.style.background = '#f9f9f9';
            replacement.style.minWidth = '100px';
            replacement.style.fontWeight = '500';
            replacement.style.color = '#000';

            clonedSelect.parentNode.replaceChild(replacement, clonedSelect);
        });

        html2canvas(printContainerClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const {
                jsPDF
            } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const pageWidth = pdf.internal.pageSize.getWidth();
            const pageHeight = pdf.internal.pageSize.getHeight();
            const margin = 10;
            const pdfWidth = pageWidth - margin * 2;
            const pdfHeight = pageHeight - margin * 2;
            pdf.addImage(imgData, 'JPEG', margin, margin, pdfWidth, pdfHeight);
            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                swal("Error!", 'Warning: PDF size is greater than 2 MB. Please reduce content or try again.', "error");
            }
            pdf.save('RegistrationOfObjection.pdf');
            document.getElementById('saveAndPrintBtn').style.display = 'none';
        });
    });
</script>


{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('registration-of-objection.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
