<!DOCTYPE html>
<html lang="mr">
<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
        }
        .header, .footer {
            text-align: center;
        }
        .content {
            margin-top: 30px;
        }
        /* .sub-header {
            text-align: right;
        } */
        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }
        .points {
            margin-top: 20px;
        }
        .points li {
            margin-bottom: 10px;
            margin-left:5%;
        }
        p{
            font-size:18px;
        }
        table {
        width: 100%;
        border-collapse: collapse;
        margin: 20px 0;
        font-family: 'Arial', sans-serif;
        font-size: 16px;
        }
          th, td {
        border: 1px solid #333;
        padding: 10px 12px;
        text-align: left;
        vertical-align: top;
       }
        thead {
        background-color: #f2f2f2;
       }
       th {
        background-color: #e4e9ee;
        color: black;
        font-weight: bold;
      }

    </style>
</head>
<body>

    <div class="header">
        @php
        $logoData = file_get_contents(public_path('admin/images/favicon.png'));
        $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
        $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
        $base64Logo = base64_encode($logoData);
        $base64Logo2 = base64_encode($logoData2);
        $base641Logo = base64_encode($logoData1);
        @endphp
       <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
       <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150">
       <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo"  style="float:right;margin-top:35px;" height="150" width="150">
       <div class="rox">
        <h2>भिवंडी निजामपूर शहर महानगरपालिका</h2>
        <p>भिवंडी निजामपूर शहर महानगरपालिका नवीन प्रशासकीय इमारत, धर्मवीर आनंद दिघे चौक, राजीव गांधी उड्डाणपूला समोर, काप आळी जवळ,भिवंडी, महाराष्ट्र ४२१३०३</p>
        <p>दूरध्वनी क्र.(०२५२२) २५५३१४/१५</p>
        <h3>मालमत्ता कर उतारा देणे</h3>
       </div>
    </div>
<hr>
<hr style="1px solid #000; height:5px; background-color:#000;">
    <div class="sub-header">
        <div class="row d-flex">
        <p>जा.क्र. मनपा/मा.कर/ {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/ 2025-2026
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        दि. <span >{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/y') }}</span></p>
        </div>
    </div>

    <p>प्रति<br>
        अर्जदार: {{ $data->applicant_name }} <br>
    </p>

    <p style="margin-left:20%;"><strong>विषय :</strong> मालमत्ता कर मागणीपत्र मिळणेबाबत.</p>
    <p style="margin-left:20%;"><strong>संदर्भ :</strong> आपला अर्ज दि.{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }} रोजीचा अर्ज आवक क्र  <strong> {{ $data->application_no }} </strong></p>

    <br>
<strong>महोदय,</strong>
    <div class="content">
        <p > &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;आपण मालमत्ता कर उतारा मिळविण्याची संदर्भानुसार विनंती अर्ज सादर केला आहे.सदर विनंतीच्या कर आढाव्याची अंमलबजावणी आणून सदर मालमत्ता कर उताऱ्याची प्रत देण्यात येत आहे.<br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;तरी विहित मुदतीत मालमत्ता कर भरून महापालिकेस सहकार्य करावे हि विनंती.</p>
    </div>
    <br>
    <br>
    <table border="1" cellpadding="12" cellspacing="0">
        <thead>
            <tr>
                <th>क्रमांक</th>
                <th>विवरण</th>
                <th>माहिती</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>१.</td>
                <td>मालमत्ता कर क्र.</td>
                <td>{{$data->application_no	}}</td>
            </tr>
            <tr>
                <td>२.</td>
                <td>सेक्‍टर कोड</td>
                <td></td>
            </tr>
            <tr>
                <td>३.</td>
                <td>जमीन / विकासक / स्वस्तिक मालकाचे नाव</td>
                <td>{{ $data->property_owner_name}}</td>
            </tr>
            <tr>
                <td>४.</td>
                <td>मालक धारकाचे नाव</td>
                <td>{{ $data->applicant_name}}</td>
            </tr>
            <tr>
                <td>५.</td>
                <td>स्थळपत्ता / गाळा / युनिट क्र.</td>
                <td>{{ $data->house_no}}</td>
            </tr>
             <tr>
                <td>६.</td>
                <td>मालमत्तेचे स्वरूप व वापर.</td>
                <td>{{$data->construction_type	}}</td>
             </tr>
             <tr>
                <td>७.</td>
                <td>जागेचे क्षेत्रफळ (चौ.फु.)</td>
                <td>{{$data->property_area	}}</td>
             </tr>
             <tr>
                <td>८.</td>
                <td>वाजवी भाडे (प्रति चौ.फु., प्रति महिना)</td>
                <td></td>
             </tr>
             <tr>
                <td>९.</td>
                <td>करयोग्य मूल्य (रु.)</td>
                <td></td>
             </tr>
             <tr>
                <td>१०.</td>
                <td>वार्षिक कर (रु.)</td>
                <td></td>
             </tr>
             <tr>
               <td>११.</td>
               <td>कर आकारणी वर्ष</td>
               <td>{{ $data->assessment_for_year}}</td>
             </tr>
        </tbody>
    </table>
    <div class="header" style="float: left;">
        <strong>दि.
            <p class="line">{{ \Carbon\Carbon::parse($data->created_at)->format('d') }}</p>/<p class="line">{{ \Carbon\Carbon::parse($data->created_at)->format('Y') }}</p>
        </strong>
    </div>
    <div class="footer" style="float:right;">
        <p><strong>सहायक आयुक्त</strong><br>
            <strong>................प्रभाग कार्यालय</strong><br>
       भिवंडी निजामपूर शहर महानगरपालिका</p>
    </div>

</body>
</html>
