<!DOCTYPE html>
<html lang="mr">
<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
        }
        .header, .footer {
            text-align: center;
        }
        .content {
            margin-top: 30px;
        }
        /* .sub-header {
            text-align: right;
        } */
        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }
        .points {
            margin-top: 20px;
        }
        .points li {
            margin-bottom: 10px;
            margin-left:5%;
        }
        p{
            font-size:18px;
        }
        table{
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0px;
            font-family: 'Arial',sans-serif;
            font-size: 16px;
        }
        th,td{
            border: 1px solid black;
            padding: 10px 12px;
            text-align: left;
            vertical-align: top;
        }
        thead{
            background-color: #f2f2f2;
        }
        th{
            background-color: #e4e9ee;
            color: black;
            font-weight: bold
        }
    </style>
</head>
<body>

    <div class="header">
        @php
        $logoData = file_get_contents(public_path('admin/images/favicon.png'));
        $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
        $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
        $base64Logo = base64_encode($logoData);
        $base64Logo2 = base64_encode($logoData2);
        $base641Logo = base64_encode($logoData1);
        @endphp
       <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
       <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150">
       <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo"  style="float:right;margin-top:35px;" height="150" width="150">
       <div class="rox">
        <h2>भिवंडी निजामपूर शहर महानगरपालिका</h2>
        <p>भिवंडी निजामपूर शहर महानगरपालिका नवीन प्रशासकीय इमारत, धर्मवीर आनंद दिघे चौक, राजीव गांधी उड्डाणपूला समोर, काप आळी जवळ,भिवंडी, महाराष्ट्र ४२१३०३</p>
        <p>दूरध्वनी क्र.(०२५२२) २५५३१४/१५</p>
        <h3>थकबाकी नसल्याचा दाखला(मालमत्ता)</h3>
       </div>
    </div>
<hr>
<hr style="1px solid #000; height:5px; background-color:#000;">
    <div class="sub-header">
         <div class="row d-flex">
        <p>जा.क्र. मनपा/मा.कर/ {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/ 2025-2026
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        दि. <span class="line">{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/y') }}</span></p>
        </div>
    </div>

    <p>प्रति<br>
        {{ $data->applicant_name_eng }} <br>
         {{  $data->applicant_name_mar}}
    </p>

    <p style="margin-left:20%;"><strong>विषय :</strong> मालमत्ता कर थकबाकी नसल्याचा दाखला मिळविण्याबाबत.</p>
    <p style="margin-left:20%;"><strong>संदर्भ :</strong> आपला दि. {{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }} रोजीचा अर्ज अवक क्रमांक {{$data->application_no}}</p>

    <br>

    <div class="content">
        {{-- <p >उपरोक्त संदर्भीय विषयानुसार {{ $data->road_cutting_address}}या जागेचे जाण्यायोग्य नाल्यावरती स्वच्छ टाकण्यात आले आहे.
             सदर ठिकाणी {{ $data->location_size}} व {{ $data->road_length}} मी.लांबीचा नाल्यावर स्वच्छ टाकण्यास निधीतीनुसार अस्थिरलीत परवानगी देण्यात येत आहे.</p> --}}
         <p><strong>महोदय,</strong></p>
         <P>आपण मालमत्ता कराची थकबाकी नसल्याचा दाखला मिळविण्याबाबत संदर्भानुसार विनंती अर्ज सादर केला आहे.
         या कार्यालयाकडील संगणकीय अभिलेखानुसार आपणास सदर मालमत्ता कर थकबाकीविना दाखला देण्यात येत आहे.
         हवे असल्यास याच्यावर अनुवाद किंवा अर्जाचा पूर्ण मसुदा तयार करून देऊ शकतो.
         </p>

    </div>
    <br>
    <br>
    <div class="footer" style="float: left">
        <p><strong>दिनांक:<span class="line">{{ \Carbon\Carbon::parse($data->created_at)->format('d-m-y') }}</strong></p>
    </div>
    <br>
    <br>
    <br>
    <table border="1" cellpadding="12" cellspacing="0">
        <thead>
           <tr>
             <th>क्रमांक</th>
             <th>विवरण</th>
             <th>माहिती</th>
           </tr>
        </thead>
        <tbody>
            <tr>
                 <td>१.</td>
                 <td>मालमत्ता कर क्रमांक</td>
                 <td>{{$data->property_address}}</td>
            </tr>
            <tr>
                <td>२.</td>
                <td>सब कोड</td>
                <td></td>
            </tr>
            <tr>
                <td>३.</td>
                <td>मालमत्ता धारकाचे नाव</td>
                <td>{{$data->owner_name}}</td>
            </tr>
            <tr>
                <td>४.</td>
                <td>सन २०२५–२६ अखेर मालमत्ता कराचा तपशील :</td>
                <td>{{ \Carbon\Carbon::parse($data->created_at)->format('Y') }} - 2026</td>
            </tr>
            <tr>
                <td>५.</td>
                <td>शेरा</td>
                <td></td>
            </tr>
        </tbody>
    </table>
    <div class="footer" style="float: left">
        <p><strong>दिनांक:<span class="line">{{ \Carbon\Carbon::parse($data->created_at)->format('d-m-y') }}</strong></p>
    </div>
    <div class="footer" style="float:right;">
        <p><strong>सहायक आयुक्त</strong><br>
       _________ प्रभाग कार्यालय<br>
       भिवंडी निजामपूर शहर महानगरपालिका</p>
    </div>

</body>
</html>
