<x-admin.layout>
    <x-slot name="title">Property division into sub-divisions/ उप विभागामध्ये मालमत्ता विभाजन</x-slot>
    <x-slot name="heading">Property division into sub-divisions/ उप विभागामध्ये मालमत्ता विभाजन </x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card p-3">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Applicant Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="applicantname">
                                        अर्जदारचे नाव/Applicant's name <span class="text-danger">*</span>
                                    </label>
                                    <input class="form-control" id="applicantname" name="applicantname" type="text"
                                        pattern="^[A-Za-zअ-हऀ-ॿ\s]+$"
                                        title="Only letters and spaces are allowed. No numbers or special characters."
                                        placeholder="Enter Applicant's Name" onkeypress="return isLetterOrSpace(event)"
                                        value="{{ $user->name }}" readonly>
                                    <span class="text-danger is-invalid applicantname_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="address">
                                        Applicant Address<span class="text-danger">*</span>
                                    </label>
                                    <input class="form-control" id="address" name="address" type="text"
                                        placeholder="Enter Applicant's Address"
                                        onkeypress="return isLetterOrSpace(event)" value="{{ $user->address }}"
                                        readonly>
                                    <span class="text-danger is-invalid address_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="mobile_no">
                                        Applicant Mobile No<span class="text-danger">*</span>
                                    </label>
                                    <input class="form-control" id="mobile_no" name="mobile_no" type="number"
                                        value="{{ $user->mobile }}" readonly>
                                    <span class="text-danger is-invalid mobile_no_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="email">
                                        Applicant Email <span class="text-danger">*</span>
                                    </label>
                                    <input class="form-control" id="email" name="email" type="text"
                                        value="{{ $user->email }}" readonly>
                                    <span class="text-danger is-invalid email_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="adhaarno">
                                        Applicant AdhaarNo <span class="text-danger">*</span>
                                    </label>
                                    <input class="form-control" id="adhaarno" name="adhaarno" type="text"
                                        value="{{ $user->aadhar_no }}" readonly>
                                    <span class="text-danger is-invalid adhaarno_err"></span>
                                </div>

                            </div>
                        </div>
                    </div>


                    <div class="card">
                        <div class="card-body">
                            <div class="col-md-4">
                                <input class="form-control" id="marchantid" name="marchantid" type="hidden"
                                    value="MBMCCORE">
                                <span class="text-danger is-invalid marchantid_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="propno">Property No<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" id="propno" name="propno" type="text"
                                    placeholder="Enter Property No">
                                <span class="text-danger is-invalid propno_err"></span>
                            </div>
                        </div>
                        <button type="Search" style="margin-left: 12px;" class="btn btn-primary w-25"
                            id="searchdetails">Search</button>
                        <br>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Property Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_name">Owner Name/मालकाचे नाव<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" name="property_name" id="property_name"
                                        placeholder="Enter Owner Name" readonly>
                                    <span class="text-danger is-invalid property_name_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_address">Owner Full Address/मालकाचा
                                        पूर्ण पत्ता<span class="text-danger">*</span></label>
                                    <input class="form-control" name="property_address" id="property_address"
                                        placeholder="Enter Property Address" readonly>
                                    <span class="text-danger is-invalid property_address_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_num">Property Number/मालमत्ता
                                        क्रमांक<span class="text-danger">*</span></label>
                                    <input class="form-control" name="property_num" id="property_num"
                                        placeholder="Enter Property No." readonly>
                                    <span class="text-danger is-invalid property_num_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_area">Property Area<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" name="property_area" id="property_area"
                                        placeholder="Enter Property Area" readonly>
                                    <span class="text-danger is-invalid property_area_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="flat_no">Flat_Number<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" name="flat_no" id="flat_no"
                                        placeholder="Enter Flat Number" readonly>
                                    <span class="text-danger is-invalid flat_no_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="ward">Ward / प्रभाग<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" name="ward" id="ward"
                                        placeholder="Enter Ward" readonly>
                                    <span class="text-danger is-invalid ward_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" name="zone" id="zone"
                                        placeholder="Enter Zone" readonly>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>

                                <input type="hidden" id="warddata" name="ward_area">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="outstanding_amt">
                                        Total Outstanding Payable / एकूण देय थकबाकी? <span class="text-danger">*</span>
                                    </label>
                                    <input class="form-control" name="outstanding_amt" id="outstanding_amt"
                                        placeholder="Enter Outstanding Amount" readonly>
                                    <span class="text-danger is-invalid outstanding_amt_err"></span>
                                </div>
                                <div class="col-md-4 mt-4">
                                    <button type="button" id="payaccentech" class="btn btn-success d-none"
                                        target="_blank" onclick="payNow()">Pay</button>
                                </div>

                            </div>
                        </div>
                    </div>


                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Add Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="upload_no_due_docs">No Dues Certificate/थकबाकी
                                        नसल्याचा दाखला <span class="text-danger">*</span></label>
                                    <input class="form-control" id="upload_no_due_docs" name="upload_no_due_docs"
                                        type="file">
                                    <span class="text-danger is-invalid upload_no_due_docs_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="owner_docs">Ownership Documents(Sale Deed,
                                        Partition Deed, Gift Deed, etc.)/मालकी हक्काची कागदपत्रे (खरेदीखत, वाटणीपत्र,
                                        बक्षीस
                                        पत्र इ.) <span class="text-danger">*</span></label>
                                    <input class="form-control" id="owner_docs" name="owner_docs" type="file">
                                    <span class="text-danger is-invalid owner_docs_err"></span>
                                </div>

                                <div class="col-md-4 mb-2" id="upload_section" style="display:none;">
                                    <label class="col-form-label" for="upload_prescribed_formatss">Upload Application
                                        in Prescribed Format/विहित नमुन्यातील अर्ज अपलोड करा <span
                                            class="text-danger">*</span> </label>
                                    <input class="form-control" id="upload_prescribed_formatss"
                                        name="upload_prescribed_formatss" type="file">
                                    <span class="text-danger is-invalid upload_prescribed_formatss_err"></span>
                                </div>

                            </div>
                        </div>
                    </div>

                    <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र <span
                            class="text-danger">*</span></label>
                    <div class="col-md-12">
                        <div class="form-check d-flex align-items-start">
                            <input type="checkbox" class="form-check-input mt-1" id="is_correct_info"
                                name="is_correct_info" value="yes">
                            <label class="form-check-label ms-2" for="is_correct_info">
                                All information provided above is correct and I shall be fully responsible
                                for
                                any discrepancy.<br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात
                                कुठल्याही
                                प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन.
                            </label>
                        </div>
                        <span class="text-danger is-invalid is_correct_info_err"></span>
                    </div>

                    <div class="form-group d-flex justify-content-center my-3" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                    </div>
                    <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                        <button type="reset" class="btn btn-warning">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<script>
    $('#searchdetails').on('click', function(e) {
        e.preventDefault();

        let formData = {
            marchantid: $('#marchantid').val(),
            propno: $('#propno').val(),
            _token: $('input[name="_token"]').val()
        };

        $.ajax({
            url: '{{ route('fetch.property.details') }}',
            method: 'POST',
            data: formData,
            datatype: JSON,
            success: function(response) {
                console.log("Encrypted Data:", response.jsonData.encr_request);

                const decryptedData = JSON.parse(response.jsonData.encr_request);

                if (decryptedData && decryptedData['property_Details']) {
                    $('#property_name').val(decryptedData['property_Details'].Owner_Name);
                    $('#property_address').val(decryptedData['property_Details'].Property_Address);
                    $('#property_num').val(decryptedData['property_Details'].Property_No);
                    $('#new_owner_name').val(decryptedData['property_Details']
                        .Full_Address_Of_The_Property);
                    $('#ward').val(decryptedData['property_Details'].Ward);
                    $('#owner_add').val(decryptedData['property_Details'].Property_Owner_Name);
                    $('#property_area').val(decryptedData['property_Details'].Property_Area);
                    $('#flat_no').val(decryptedData['property_Details'].Flat_Number);
                    $('#zone').val(decryptedData['property_Details'].Zone);
                    $('#outstanding_amt').val(decryptedData['property_Details'].OutstandingAmt);

                    const fullZone = decryptedData['property_Details'].Zone;
                    const zoneCode = fullZone.charAt(0);
                    const wardNumber = decryptedData['property_Details'].Ward.toString();
                    const sectorCode = wardNumber.length === 1 ? '0' + wardNumber : wardNumber;
                    const finalCode = zoneCode + sectorCode;

                    $('#warddata').val(finalCode);

                    const uploadedValue = parseInt($('#outstanding_amt').val());
                    const savePrintBtn = document.getElementById('saveAndPrintBtn');
                    const paybtn = document.getElementById('payaccentech');

                    if (uploadedValue === 0) {
                        savePrintBtn.style.display = 'block';
                        paybtn.style.display = 'none';
                    } else {
                        $('#payaccentech').removeClass('d-none');
                        savePrintBtn.style.display = 'none';
                        paybtn.style.display = 'block';
                    }

                } else {
                    console.error("connectionDetails is missing or undefined");
                }
            },

            error: function(xhr) {
                console.error(xhr.responseText);
            }
        });
    });


    function payNow() {
        var propNo = document.getElementById("propno").value;
        if (propNo) {
            var url = 'https://pg.mbmc.gov.in/PropSearch.aspx?PTN=' + propNo;
            window.location.href = url;
        } else {
            alert('Please enter a property number.');
        }
    }
</script>


<script>
    document.getElementById('saveAndPrintBtn').addEventListener('click', function() {

        let isValid = true;
        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const messages = {
            propno: 'Please enter the property number',
            applicantname: 'This field is required',
            address: 'This field is required',
            mobile_no: 'This field is required',
            adhaarno: 'This field is required',
            email: 'This field is required',
            property_name: 'This field is required',
            property_address: 'This field is required',
            property_num: 'This field is required',
            property_area: 'This field is required',
            flat_no: 'This field is required',
            ward: 'This field is required',
            zone: 'This field is required',
            outstanding_amt: 'This field is required',
            upload_no_due_docs: 'This field is required',
            owner_docs: 'This field is required',
            is_correct_info: 'Please accept the declaration',
        };

        Object.keys(messages).forEach(fieldName => {
            const field = addContainer.querySelector(`[name="${fieldName}"]`);
            const errorSpan = addContainer.querySelector(`.${fieldName}_err`);
            if (fieldName === 'is_correct_info') {
                if (!field || !field.checked) {
                    isValid = false;
                    if (errorSpan) errorSpan.textContent = messages[fieldName];
                } else if (errorSpan) {
                    errorSpan.textContent = '';
                }
                return;
            }

            if (field) {
                if (!field.value.trim()) {
                    isValid = false;
                    field.classList.add('is-invalid');
                    if (errorSpan) errorSpan.textContent = messages[fieldName];
                } else {
                    field.classList.remove('is-invalid');
                    if (errorSpan) errorSpan.textContent = '';
                }
            }
        });
        if (!isValid) return;

        document.getElementById('upload_section').style.display = 'block';
        document.getElementById('card-footer').style.display = 'block';

        // const addContainer = document.getElementById('addContainer');
        // if (!addContainer) return;

        const printContainerClone = addContainer.cloneNode(true);
        const uploadSection = printContainerClone.querySelector('#upload_section');
        if (uploadSection) {
            uploadSection.remove();
        }
        printContainerClone.style.fontSize = '16px';
        printContainerClone.style.lineHeight = '1.4';
        printContainerClone.style.padding = '20px';
        printContainerClone.style.margin = '0 auto';
        printContainerClone.style.background = '#fff';
        printContainerClone.style.width = '210mm';
        printContainerClone.style.minHeight = '297mm';
        printContainerClone.style.boxSizing = 'border-box';

        Array.from(printContainerClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        const printTitle = document.createElement('h2');
        printTitle.style.textAlign = 'center';
        printTitle.style.marginBottom = '18px';
        printTitle.style.fontSize = '18px';
        printTitle.textContent = 'Property Division Into Sub-Divisions';
        printContainerClone.insertBefore(printTitle, printContainerClone.firstChild);

        Array.from(printContainerClone.querySelectorAll('button')).forEach(btn => btn.remove());

        Array.from(printContainerClone.querySelectorAll('.card')).forEach(card => {
            card.style.background = 'white';
            card.style.boxShadow = 'none';
            card.style.border = '1px solid #ccc';
            card.style.marginBottom = '12px';
            card.style.padding = '12px';
        });

        Array.from(printContainerClone.querySelectorAll('input[type="file"]')).forEach(input => {
            const parent = input.parentNode;
            const fileName = input.files && input.files.length > 0 ? input.files[0].name :
                'No file chosen';
            const fileInfo = document.createElement('div');
            fileInfo.textContent = 'Selected file: ' + fileName;
            parent.appendChild(fileInfo);
            input.style.display = 'none';
        });

        Array.from(printContainerClone.querySelectorAll('select')).forEach(select => {
            const selected = select.options[select.selectedIndex];
            const info = document.createElement('div');
            info.textContent = 'Selected: ' + (selected ? selected.text : '');
            select.parentNode.appendChild(info);
            select.style.display = 'none';
        });

        Array.from(printContainerClone.querySelectorAll('.selected-value')).forEach(div => {
            div.classList.remove('d-none');
        });

        const note = document.createElement('div');
        note.textContent = 'Download this form and upload with your Signature.';
        note.style.fontSize = '14px';
        note.style.fontWeight = 'bold';
        note.style.textAlign = 'center';
        note.style.marginTop = '30px';
        note.style.borderTop = '1px solid #ccc';
        note.style.paddingTop = '10px';
        note.style.color = '#333';
        printContainerClone.appendChild(note);

        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printContainerClone);

        html2canvas(printContainerClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const {
                jsPDF
            } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const pageWidth = pdf.internal.pageSize.getWidth();
            const pageHeight = pdf.internal.pageSize.getHeight();
            const margin = 10;
            const pdfWidth = pageWidth - margin * 2;
            const pdfHeight = pageHeight - margin * 2;

            pdf.addImage(imgData, 'JPEG', margin, margin, pdfWidth, pdfHeight);

            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                swal("Error!",
                    'Warning: PDF size is greater than 2 MB. Please reduce content or try again.',
                    "error");
            }

            pdf.save('Property-division-into-sub-divisions.pdf');
            document.getElementById('saveAndPrintBtn').style.display = 'none';
        });
    });
</script>



{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {

        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        // if ($('#upload_section').is(':visible')) {
        //     var fileVal = $('#upload_prescribed_formatss').val();
        //     if (!fileVal) {
        //         swal("Error!", "Please upload the application document.", "error");
        //         $("#addSubmit").prop('disabled', false);
        //         return;
        //     }
        // }

        var formdata = new FormData(this);

        $.ajax({
            url: '{{ route('property-division.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                console.log('Data: ', data);
                $("#addSubmit").prop('disabled', false);
                if (!data.error2)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error2, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>

<!--mobile no validation-->
{{-- <script>
    document.getElementById("mobile_no").addEventListener("keyup", function() {
        let input = this.value;
        input = input.replace(/\D/g, "");
        if (input.length > 10) {
            input = input.substring(0, 10);
        }
        this.value = input;
        let errorSpan = document.querySelector(".mobile_no_err");
        if (input.length !== 10) {
            errorSpan.textContent = "Mobile number must be exactly 10 digits.";
        } else {
            errorSpan.textContent = "";
        }
    });
</script>

<script>
    function isLetterOrSpace(e) {
        const char = String.fromCharCode(e.which || e.keyCode);
        const regex = /^[A-Za-zअ-हऀ-ॿ\s]+$/;
        return regex.test(char);
    }
</script> --}}
