<x-admin.layout>
    <x-slot name="title">Property Division Into Sub-Division / उप विभागामध्ये मालमत्ता विभाजन</x-slot>
    <x-slot name="heading">Property Division Into Sub-Division / उप विभागामध्ये मालमत्ता विभाजन </x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Property Division Into Sub-Division / उप विभागामध्ये मालमत्ता विभाजन</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            {{-- {{dd($propertydivision)}} --}}
                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="speech_no">अर्जदारचे नाव/Applicant's name<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" id="speech_no" name="speech_no"
                                    pattern="^[A-Za-zअ-हऀ-ॿ\s]+$"
                                    title="Only letters and spaces are allowed. No numbers or special characters."
                                    placeholder="Enter Applicant's Name" onkeypress="return isLetterOrSpace(event)"
                                    value="{{ $propertydivision->applicantname }}" readonly>
                                <span class="text-danger is-invalid speech_no_err"></span>
                            </div>

                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="address">
                                    Applicant Address<span class="text-danger">*</span>
                                </label>
                                <textarea class="form-control" id="address" name="address" rows="2" placeholder="Applicant's Address" readonly> {{$propertydivision->address}} </textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="mobile_no">
                                    Applicant Mobile No<span class="text-danger">*</span>
                                </label>
                                <input class="form-control" id="mobile_no" name="mobile_no" type="number"
                                    value="{{ $propertydivision->mobile_no }}" readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="email">
                                    Applicant Email <span class="text-danger">*</span>
                                </label>
                                <input class="form-control" id="email" name="email" type="text"
                                    value="{{ $propertydivision->email }}" readonly>
                                <span class="text-danger is-invalid email_err"></span>
                            </div>

                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="adhaarno">
                                    Applicant Aadhaar No. <span class="text-danger">*</span>
                                </label>
                                <input class="form-control" id="adhaarno" name="adhaarno" type="text"
                                    value="{{ $propertydivision->adhaarno }}" readonly>
                                <span class="text-danger is-invalid adhaarno_err"></span>
                            </div>




                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="property_name">Property Owner's Name/मालकाचे नाव<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" name="property_name" id="property_name" value="{{ $propertydivision->property_name }}"
                                    placeholder="Enter Owner Name" readonly>
                                <span class="text-danger is-invalid property_name_err"></span>
                            </div>
                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="property_address">Property Owner's Address/मालकाचा
                                    पूर्ण पत्ता<span class="text-danger">*</span></label>
                                    <textarea name="property_address" class="form-control" rows="2" placeholder="Enter Property Address" readonly> {{ $propertydivision->property_address }} </textarea>
                                <span class="text-danger is-invalid property_address_err"></span>
                            </div>
                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="property_num">Property Number/मालमत्ता
                                    क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" name="property_num" id="property_num" value="{{ $propertydivision->property_num }}"
                                    placeholder="Enter Property No." readonly>
                                <span class="text-danger is-invalid property_num_err"></span>
                            </div>
                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="property_area">Property Area<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" name="property_area" id="property_area" value="{{ $propertydivision->property_area }}"
                                    placeholder="Enter Property Area" readonly>
                                <span class="text-danger is-invalid property_area_err"></span>
                            </div>
                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="flat_no">Flat_Number<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" name="flat_no" id="flat_no" value="{{ $propertydivision->flat_no }}"
                                    placeholder="Enter Flat Number" readonly>
                                <span class="text-danger is-invalid flat_no_err"></span>
                            </div>
                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="ward">Ward / प्रभाग<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" name="ward" id="ward" placeholder="Enter Ward" value="{{ $propertydivision->ward }}"
                                    readonly>
                                <span class="text-danger is-invalid ward_err"></span>
                            </div>
                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="zone">Zone / झोन<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" name="zone" id="zone" placeholder="Enter Zone" value="{{ $propertydivision->zone }}"
                                    readonly>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div>

                            <input type="hidden" id="warddata" name="ward_area" value="{{ $propertydivision->ward_area }}">

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="outstanding_amt">
                                    Total Outstanding Payable / एकूण देय थकबाकी? <span class="text-danger">*</span>
                                </label>
                                <input class="form-control" name="outstanding_amt" id="outstanding_amt"
                                    placeholder="Enter Outstanding Amount" readonly>
                                <span class="text-danger is-invalid outstanding_amt_err"></span>
                            </div> --}}


                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span
                                        class="text-danger">*</span></label>
                                <select class="form-select" name="ward_area" id="ward_area" readonly>
                                    <option value="">Select Ward Area</option>
                                    @foreach ($wards as $ward)
                                        <option {{ $propertydivision->ward_area == $ward->id ? 'selected' : '' }}
                                            value="{{ $ward->name }}">{{ $ward->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_area_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="property_name">Property owner's name/ मालमत्ता
                                    धारकाचे नाव </label>
                                <input class="form-control" id="property_name" name="property_name" type="text"
                                    value="{{ $propertydivision->property_name }}" placeholder="Enter property Name">
                                <span class="text-danger is-invalid property_name_err"></span>
                            </div>

                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="property_address">property address / मालमत्तेचा
                                    पत्ता </label>
                                <input class="form-control" id="property_address" name="property_address"
                                    type="text" value="{{ $propertydivision->property_address }}"
                                    placeholder="Enter description of property address">
                                <span class="text-danger is-invalid property_address_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="property_infom">Property Info/ मालमत्तेची
                                    माहिती<span class="text-danger">*</span></label>
                                <input class="form-control" id="property_infom" name="property_infom"
                                    value="{{ $propertydivision->property_infom }}" type="text"
                                    placeholder="Enter Death Certificate">
                                <span class="text-danger is-invalid property_infom_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="doc_uploads">Upload Agreement Copy/कराराची प्रत अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="doc_uploads" name="doc_uploads" type="file">
                                    <span class="text-danger is-invalid doc_uploads_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-3">
                                    <label class="col-form-label" for="doc_uploads">Upload Agreement Copy/कराराची प्रत अपलोड करा <span class="text-danger">*</span></label>                                    <input class="form-control" id="doc_uploads" name="doc_uploads" type="file" placeholder="Enter Work Completion Certificate / काम पूर्णतेचा प्रमाणपत्र">

                                    @if ($propertydivision->doc_upload)
                                    <a href="{{ asset('storage/' . $propertydivision->doc_upload) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                    @endif
                                    <span class="text-danger is-invalid doc_uploads_err"></span>
                                </div> --}}


                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="upload_prescribed_formatss">Upload Application in
                                    Prescribed Format/विहित नमुन्यातील अर्ज अपलोड करा <span
                                        class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="upload_prescribed_formatss" name="upload_prescribed_formatss" type="file"> --}}
                                @if ($propertydivision->upload_prescribed_formats)
                                    <a class="btn btn-sm btn-outline-primary mb-2" href="{{ asset('storage/' . $propertydivision->upload_prescribed_formats) }}"
                                        target="__blank" title="View Plan Copy">View File</a>
                                @endif
                                <span class="text-danger is-invalid upload_prescribed_formatss_err"></span>
                            </div>


                            {{-- <div class="col-md-4 mb-2 mb-2">
                                    <label class="col-form-label" for="upload_prescribed_formatss">Upload Application in Prescribed Format/विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="upload_prescribed_formatss" name="upload_prescribed_formatss" type="file">
                                    <span class="text-danger is-invalid upload_prescribed_formatss_err"></span>
                                </div> --}}

                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="upload_no_due_docs">No Dues Certificate/थकबाकी
                                    नसल्याचा दाखला <span class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="upload_no_due_docs" name="upload_no_due_docs" type="file"> --}}
                                @if ($propertydivision->upload_no_due_doc)
                                    <a class="btn btn-sm btn-outline-primary mb-2" href="{{ asset('storage/' . $propertydivision->upload_no_due_doc) }}"
                                        target="__blank" title="View Plan Copy">View File </a>
                                @endif
                                <span class="text-danger is-invalid upload_no_due_docs_err"></span>
                            </div>

                            {{-- <div class="col-md-4 mb-2 mb-2">
                                    <label class="col-form-label" for="upload_no_due_docs">No Dues Certificate/थकबाकी नसल्याचा दाखला <span class="text-danger">*</span></label>
                                    <input class="form-control" id="upload_no_due_docs" name="upload_no_due_docs" type="file">
                                    <span class="text-danger is-invalid upload_no_due_docs_err"></span>
                                </div> --}}


                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="owner_docs">Ownership Documents(Sale Deed,
                                    Partition Deed, Gift Deed, etc.)/मालकी हक्काची कागदपत्रे (खरेदीखत, वाटणीपत्र, बक्षीस
                                    पत्र इ.) <span class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="owner_docs" name="owner_docs" type="file"> --}}

                                @if ($propertydivision->owner_doc)
                                    <a class="btn btn-sm btn-outline-primary mb-2" href="{{ asset('storage/' . $propertydivision->owner_doc) }}" target="__blank"
                                        title="View Plan Copy">View File </a>
                                @endif
                                <span class="text-danger is-invalid owner_docs_err"></span>
                            </div>


                            {{-- <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="owner_docs">Ownership Documents(Sale Deed, Partition Deed, Gift Deed, etc.)/मालकी हक्काची कागदपत्रे (खरेदीखत, वाटणीपत्र, बक्षीस पत्र इ.) <span class="text-danger">*</span></label>
                                    <input class="form-control" id="owner_docs" name="owner_docs" type="file">
                                    <span class="text-danger is-invalid owner_docs_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4 mb-2">
                                    <label for="remark">Remark<span class="text-danger">*</span></label>
                                    <textarea id="Remark" name="remark" class="form-control" rows="4" required></textarea>
                                </div> --}}

                            {{-- <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="upload_prescribed_formats">Upload Application in Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="upload_prescribed_formats" name="upload_prescribed_formats" type="file">
                                    <span class="text-danger is-invalid upload_prescribed_formats_err"></span>
                                </div> --}}



                            {{-- <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="upload_gov_instructed_docs">Upload Govt . Instructed Documents / शासनाद्वारे विहित केलीली कागदपत्रे <span class="text-danger">*</span></label>
                                    <input class="form-control" id="upload_gov_instructed_docs" name="upload_gov_instructed_docs" type="file">
                                    <span class="text-danger is-invalid upload_gov_instructed_docs_err"></span>
                                </div> --}}

                            {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र  <span class="text-danger">*</span></label>
                                <div class="col-md-12">
                                    <div class="form-check d-flex align-items-start">
                                        <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes">
                                        <label class="form-check-label ms-2" for="is_correct_info">
                                            All information provided above is correct and I shall be fully responsible for any discrepancy.<br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन.
                                        </label>
                                    </div>
                                    <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                            <div class="col-md-4 mb-3">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" rows="4" placeholder="Please type remark here..." ></textarea>
                            </div>

                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-primary approveBtn"
                            data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn"
                            data-id="{{ $status->id }}">Reject</button>
                        <button type="button" id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>


<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
</script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>



{{-- Add --}}
{{-- <script>
    $("#addForm").submit(function(e) {

        e.preventDefault();
        $("#addSubmit").prop('disabled', true);



        var formdata = new FormData(this);

        $.ajax({
            url: '{{ route('property-division.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error2)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error2, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script> --}}

<!--mobile no validation-->
{{-- <script>
    document.getElementById("mobile_no").addEventListener("keyup", function() {
        let input = this.value;
        input = input.replace(/\D/g, "");
        if (input.length > 10) {
            input = input.substring(0, 10);
        }
        this.value = input;
        let errorSpan = document.querySelector(".mobile_no_err");
        if (input.length !== 10) {
            errorSpan.textContent = "Mobile number must be exactly 10 digits.";
        } else {
            errorSpan.textContent = "";
        }
    });
</script> --}}

<script>
    function isLetterOrSpace(e) {
        const char = String.fromCharCode(e.which || e.keyCode);
        const regex = /^[A-Za-zअ-हऀ-ॿ\s]+$/;
        return regex.test(char);
    }
</script>
