<!DOCTYPE html>
<html lang="mr">
<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
        }
        .header, .footer {
            text-align: center;
        }
        .content {
            margin-top: 30px;
        }
        /* .sub-header {
            text-align: right;
        } */
        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }
        .points {
            margin-top: 20px;
        }
        .points li {
            margin-bottom: 10px;
            margin-left:5%;
        }
        p{
            font-size:18px;
        }
    </style>
</head>
<body>

    <div class="header">
        @php
        $logoData = file_get_contents(public_path('admin/images/favicon.png'));
        $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
        $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
        $base64Logo = base64_encode($logoData);
        $base64Logo2 = base64_encode($logoData2);
        $base641Logo = base64_encode($logoData1);
        @endphp
       <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
       <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150">
       <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo"  style="float:right;margin-top:35px;" height="150" width="150">
       <div class="rox">
        <h2>भिवंडी निजामपूर शहर महानगरपालिका</h2>
        <p>भिवंडी निजामपूर शहर महानगरपालिका नवीन प्रशासकीय इमारत, धर्मवीर आनंद दिघे चौक, राजीव गांधी उड्डाणपूला समोर, काप आळी जवळ,भिवंडी, महाराष्ट्र ४२१३०३१</p>
        <p>दूरध्वनी क्र.(०२५२२) २५५३१४/१५</p>
        <h3>रहिवासी नसलेल्या मालमत्ताना करात सूट मिळणे</h3>
       </div>
    </div>
<hr>
<hr style="1px solid #000; height:5px; background-color:#000;">
    <div class="sub-header">
       <div class="row d-flex">
        <p>जा.क्र. मनपा/मा.कर/ {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/ 2025-2026
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        दि. <span class="line">{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/y') }}</span></p>
        </div>
    </div>

    <p>प्रति<br>
        अर्जदार: {{ $data->applicant_full_name }} <br>
    </p>

    <p style="margin-left:20%;"><strong>विषय :</strong> या जागेतील नाल्यावरील स्वच्छ व विकसितकरणासाठी परवानगी देणेबाबत.</p>
    <p style="margin-left:20%;"><strong>संदर्भ :</strong> आपला अर्ज दि.{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }}रोजी प्राप्त.</p>

    <br>

    <div class="content">
        <p >उपरोक्त संदर्भीय विषयानुसार {{ $data->road_cutting_address}}या जागेचे जाण्यायोग्य नाल्यावरती स्वच्छ टाकण्यात आले आहे.
             सदर ठिकाणी {{ $data->location_size}} व {{ $data->road_length}} मी.लांबीचा नाल्यावर स्वच्छ टाकण्यास निधीतीनुसार अस्थिरलीत परवानगी देण्यात येत आहे.</p>

        <ul class="points">
            <p style=" margin-left:5%;">1) महानगरपालिकेमार्फत मंजूर केलेल्या नकाशानुसार महानगरपालिकेच्या संबंधित कनिष्ठ अभियंता यांचे देखरेखीखाली काम करावे.</p>
            <p style=" margin-left:5%;">2) सदर नाल्याचे काम करण्यापूर्वी महानगरपालिकेकडून Level तपासून त्यानुसारच काम करावे.</p>
            <p style=" margin-left:5%;">3) सदर ठिकाणी {{ $data->road_length}} मी. रुंद रस्ता सोडून रेंच करणे आवश्यक आहे.</p>
            <p style=" margin-left:5%;">4) सदर काम विविध मुदतीत व माप दंडानुसार करून द्यावे लागेल.</p>
            <p style=" margin-left:5%;">5) सदर नाल्याची देखभाल व दुरुस्ती ५ वर्षासाठी विनामूल्य करणे अपेक्षित आहे.</p>
            <p style=" margin-left:5%;">6) सदर काम 5 दिवसात पूर्ण करावे.</p>
            <p style=" margin-left:5%;">7) सदर अटीशिवाय भंग केल्यास परवानगी रद्द करून चुकीचे काम तोडण्यात येईल याची नोंद घ्यावी.</p>
        </ul>
    </div>
    <br>
    <br>

    <div class="footer" style="float:right;">
        <p><strong>कार्यकारी अभियंता (साबां/वि)</strong><br>
        भिवंडी निजामपूर शहर महानगरपालिका</p>
    </div>

</body>
</html>
