<x-admin.layout>
    <x-slot name="title">Issuance Of Transfer Of Property Certificate By Succession / अ) दस्तऐवजाच्या आधारे मालमत्ता
        हस्तांतरण नोंद प्रमाणपत्र देणे</x-slot>
    <x-slot name="heading">अ) दस्तऐवजाच्या आधारे मालमत्ता
        हस्तांतरण नोंद प्रमाणपत्र देणे</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card p-3">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Applicant Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">

                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_full_name">Applicant's Full Name /
                                        अर्जदाराचे संपूर्ण नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="applicant_full_name" name="applicant_full_name"
                                        type="text" placeholder="Enter Applicant Full Name"
                                        value="{{ $user->name }}" readonly>
                                    <span class="text-danger is-invalid applicant_full_name_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_full_address">Applicant's Full Address
                                        /
                                        अर्जदाराचा संपूर्ण पत्ता<span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="applicant_full_address" id="applicant_full_address" cols="30" rows="2"
                                        placeholder="Enter Applicant Address" readonly>{{ $user->address }}</textarea>
                                    <span class="text-danger is-invalid applicant_full_address_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_mobile_no">Mobile Number / मोबाईल
                                        नंबर<span class="text-danger">*</span></label>
                                    <input class="form-control" id="applicant_mobile_no" name="applicant_mobile_no"
                                        value="{{ $user->mobile }}" oninput="this.value = this.value.replace(/\D/g, '')"
                                        maxlength="10" minlength="10" type="text" placeholder="Enter Mobile Number"
                                        oninput="this.value = this.value.replace(/\D/g, '')" readonly>
                                    <span class="text-danger is-invalid applicant_mobile_no_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="email_id">Email ID / ई-मेल आयडी<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="email_id" name="email_id" type="email"
                                        value="{{ $user->email }}" placeholder="Enter Email" readonly>
                                    <span class="text-danger is-invalid email_id_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="aadhar_no">Aadhar Number / आधार क्रमांक <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="aadhar_no" name="aadhar_no"
                                        oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12"
                                        minlength="12" type="text" placeholder="Enter Aadhar Card No"
                                        oninput="this.value = this.value.replace(/\D/g, '')" value="{{$user->aadhar_no ?? ''}}" readonly>
                                    <span class="text-danger is-invalid aadhar_no_err"></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        @csrf
                        <div class="card-body">
                            <div class="col-md-4">
                                <input class="form-control" id="marchantid" name="marchantid" type="hidden"
                                    value="MBMCCORE">
                                <span class="text-danger is-invalid marchantid_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="upic_id"> Property No.<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" id="upic_id" name="upic_id" type="text"
                                    placeholder="Enter Property No">
                                <span class="text-danger is-invalid upic_id_err"></span>
                            </div>
                        </div>
                        <button type="Search" style="margin-left: 12px;" class="btn btn-primary w-25"
                            id="searchdetails">Search</button>
                        <br>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Property Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_owner_name">Property Owner Name /
                                        मालमत्तेच्या मालकाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="property_owner_name" name="property_owner_name"
                                        type="text" placeholder="Enter Property Owner Name" readonly>
                                    <span class="text-danger is-invalid property_owner_name_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_address">Property Address / मालमत्तेचा
                                        पत्ता
                                        <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="property_address" id="property_address" cols="30" rows="2"
                                        placeholder="Enter Property Address" readonly></textarea>
                                    <span class="text-danger is-invalid property_address_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_no">Property No./ मालमत्ता क्र <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="property_no" name="property_no" type="text"
                                        placeholder="Enter Property Number" readonly>
                                    <span class="text-danger is-invalid property_no_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" name="zone" id="zone" readonly
                                        placeholder="Enter Zone">
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="ward">Ward Area / प्रभाग क्षेत्र<span
                                            class="text-danger">*</span></label>
                                    <input class="form-select" name="ward" id="ward" readonly
                                        placeholder="Enter Ward">
                                    <span class="text-danger is-invalid ward_err"></span>
                                </div>

                                <input type="hidden" id="warddata" name="ward_area">

                                <div class="col-md-4">
                                    <label class="col-form-label" for="survey_number">Survery No.</label>
                                    <input class="form-control" id="survey_number" name="survey_number"
                                        type="text" placeholder="Enter Survey No." readonly>
                                    <span class="text-danger is-invalid survey_number_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="house_no">House No / घर क्र<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="house_no" name="house_no" type="text"
                                        placeholder="Enter House Number" readonly>
                                    <span class="text-danger is-invalid house_no_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="name_of_seller"> Property Usage / मालमत्ता वापर* <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="name_of_seller" name="name_of_seller"
                                        type="text" readonly placeholder="Enter Property Usage">
                                    <span class="text-danger is-invalid name_of_seller_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="compensation_amount">Total Outstanding Payable
                                        /
                                        एकूण देय थकबाकी?</label>
                                    <input class="form-control" id="compensation_amount" name="compensation_amount"
                                        type="number" readonly placeholder="Total Payable Amount">
                                    <span class="text-danger is-invalid compensation_amount_err"></span>
                                </div>
                                <div class="col-md-4 mt-4">
                                    <button type="button" id="payaccentech" class="btn btn-success d-none"
                                        target="_blank" onclick="payNow()">Pay</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Add Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="date_of_notice">Date Of Notice / नोटीसाची
                                        तारीख<span class="text-danger">*</span></label>
                                    <input class="form-control datepicker" id="date_of_notice" name="date_of_notice"
                                        type="text" placeholder="Select Date Of Notice" required>
                                    <span class="text-danger is-invalid date_of_notice_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="date_of_documentation">Date Of Documentation /
                                        लेख
                                        करून दिल्याची तारीख<span class="text-danger">*</span></label>
                                    <input class="form-control datepicker" id="date_of_documentation"
                                        name="date_of_documentation" placeholder="Select Documentation Date"
                                        type="text" required>
                                    <span class="text-danger is-invalid date_of_documentation_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="name_of_buyer">Name Of Buyer / खरेदीदाराचे
                                        किंवा
                                        अभिहस्तांकतींचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="name_of_buyer" name="name_of_buyer"
                                        type="text" placeholder="Name Of Buyer" required>
                                    <span class="text-danger is-invalid name_of_buyer_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="what_are_they">What Are They?<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="what_are_they" name="what_are_they"
                                        type="text" placeholder="What are they?" required>
                                    <span class="text-danger is-invalid what_are_they_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="date_of_registration_document">Date of
                                        Registration
                                        if any Document has been Registered / कोणताही लेख नोंदण्यात आला असेल तर नोंदणीची
                                        तारीख<span class="text-danger">*</span></label>
                                    <input class="form-control datepicker" id="date_of_registration_document"
                                        name="date_of_registration_document" placeholder="Select Date Of Registration"
                                        type="text" autocomplete="off" required>
                                    <span class="text-danger is-invalid date_of_registration_document_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="place">Place / ठिकाण<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="place" name="place" type="text" placeholder="Enter Place"
                                        required>
                                    <span class="text-danger is-invalid place_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="no_from_determined_book">Number From Determined
                                        Book
                                        / निर्धारण पुस्तकातील क्रमांक</label>
                                    <input class="form-control" id="no_from_determined_book"
                                        name="no_from_determined_book" type="number" placeholder="Enter Determined Book"
                                        oninput="this.value = this.value.replace(/\D/g, '')">
                                    <span class="text-danger is-invalid no_from_determined_book_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="no_of_officer">Number of the Officer /
                                        अधिकाऱ्याची
                                        संख्या</label>
                                    <input class="form-control" id="no_of_officer" name="no_of_officer" placeholder="Enter Number Of The Officer"
                                        type="number" oninput="this.value = this.value.replace(/\D/g, '')">
                                    <span class="text-danger is-invalid no_of_officer_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="length_width_of_land">Length and Width Of Land
                                        /
                                        जमिनीची लांबी रुंदी <span class="text-danger">*</span></label>
                                    <input class="form-control" id="length_width_of_land" name="length_width_of_land"
                                        type="text" placeholder="Enter Length & Width Of Land" required>
                                    <span class="text-danger is-invalid length_width_of_land_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="border">Border / सिमा<span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="border" name="border" type="text" placeholder="Enter Border"
                                        required>
                                    <span class="text-danger is-invalid border_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="certificate_of_no_duess">Upload Certificate Of
                                        No
                                        Dues / थकबाकी नसल्याचा दाखला अपलोड करा <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="certificate_of_no_duess"
                                        name="certificate_of_no_duess" type="file" required>
                                    <span class="text-danger is-invalid certificate_of_no_duess_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="copy_of_documents">Upload Copy Of Deed Purchase
                                        Deed
                                        Prize Letter Allotment / दस्तएवाजाची प्रत (खरेदी खत / बक्षीस पत्र /वाटणी पत्र व
                                        इतर
                                        )<span class="text-danger">*</span></label>
                                    <input class="form-control" id="copy_of_documents" name="copy_of_documents"
                                        type="file" required>
                                    <span class="text-danger is-invalid copy_of_documents_err"></span>
                                </div>

                                <div class="col-md-4" id="upload_section" style="display:none;">
                                    <label class="col-form-label" for="uploaded_applications">Upload Application In
                                        Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="uploaded_applications"
                                        name="uploaded_applications" type="file">
                                    <span class="text-danger is-invalid uploaded_applications_err"></span>
                                </div>

                            </div>
                        </div>
                    </div>

                    <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                    <div class="col-md-12">
                        <div class="form-check d-flex align-items-start">
                            <input type="checkbox" class="form-check-input mt-1" id="is_correct_info"
                                name="is_correct_info" value="yes">
                            <label class="form-check-label ms-2" for="is_correct_info">
                                All information provided above is correct and I shall be fully responsible for any
                                discrepancy. <br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची
                                तफावत
                                आढळल्यास त्यास मी पूर्णतः जबाबदार असेन.
                            </label>
                        </div>
                        <span class="text-danger is-invalid is_correct_info_err"></span>
                    </div>
                    <div class="form-group my-3 d-flex justify-content-center" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                    </div>

                    <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                        <button type="reset" class="btn btn-warning">Reset</button>
                    </div>
                </form>


            </div>
        </div>
    </div>


</x-admin.layout>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<script>
    $('#searchdetails').on('click', function(e) {
        e.preventDefault();

        let formData = {
            marchantid: $('#marchantid').val(),
            propno: $('#upic_id').val(),
            _token: $('input[name="_token"]').val()
        };

        $.ajax({
            url: '{{ route('fetch.property.details') }}',
            method: 'POST',
            data: formData,
            datatype: JSON,
            success: function(response) {
                console.log("Encrypted Data:", response.jsonData.encr_request);

                const decryptedData = JSON.parse(response.jsonData.encr_request);


                if (decryptedData && decryptedData['property_Details']) {
                    $('#property_owner_name').val(decryptedData['property_Details'].Owner_Name);
                    $('#property_address').val(decryptedData['property_Details'].Property_Address);
                    $('#new_owner_name').val(decryptedData['property_Details']
                        .Full_Address_Of_The_Property);
                    $('#address').val(decryptedData['property_Details'].Water_Connection_Size);
                    $('#survey_number').val(decryptedData['property_Details'].Property_Survey_No);
                    $('#property_no').val(decryptedData['property_Details'].Property_No);
                    $('#ward').val(decryptedData['property_Details'].Ward);
                    $('#house_no').val(decryptedData['property_Details'].Flat_Number);
                    $('#zone').val(decryptedData['property_Details'].Zone);
                    $('#name_of_seller').val(decryptedData['property_Details'].Property_Usage);
                    $('#compensation_amount').val(decryptedData['property_Details'].OutstandingAmt);

                    const fullZone = decryptedData['property_Details'].Zone;
                    const zoneCode = fullZone.charAt(0);
                    const wardNumber = decryptedData['property_Details'].Ward.toString();
                    const sectorCode = wardNumber.length === 1 ? '0' + wardNumber : wardNumber;

                    const finalCode = zoneCode + sectorCode;

                    $('#warddata').val(finalCode);

                    const uploadedValue = parseInt($('#compensation_amount').val());
                    const savePrintBtn = document.getElementById('saveAndPrintBtn');
                    const paybtn = document.getElementById('payaccentech');

                    if (uploadedValue === 0) {
                        savePrintBtn.style.display = 'block';
                        paybtn.style.display = 'none';
                    } else {
                        $('#payaccentech').removeClass('d-none');
                        savePrintBtn.style.display = 'none';
                        paybtn.style.display = 'block';
                    }

                } else {
                    console.error("connectionDetails is missing or undefined");
                }
            },

            error: function(xhr) {
                console.error(xhr.responseText);
            }
        });
    });

    function payNow() {
        var propNo = document.getElementById("upic_id").value;
        if (propNo) {
            var url = 'https://pg.mbmc.gov.in/PropSearch.aspx?PTN=' + propNo;
            window.location.href = url;
        } else {
            swal("Error!", 'Please enter a property number.', 'error');
        }
    }
</script>

<script>
    document.getElementById('saveAndPrintBtn').addEventListener('click', function() {
        let isValid = true;
        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const messages = {
            applicant_full_name: "Please enter applicant full name.",
            applicant_full_address: "Please enter applicant full address.",
            applicant_mobile_no: "Please enter applicant mobile number.",
            email_id: "Please enter email ID.",
            upic_id: "This field is required.",
            property_owner_name: "Please enter property owner name.",
            property_address: "Please enter property address.",
            property_no: "Please enter property number.",
            zone: "Zone field is required.",
            ward: "Ward field is required.",
            // survey_number: "Survey no. field is required.",
            house_no: "House no. field is required.",
            name_of_seller: "Name of seller is required.",
            compensation_amount: "Total payable is required.",
            date_of_notice: "Please select date of notice.",
            date_of_documentation: "Please select date of documentation.",
            name_of_buyer: "Please enter name of buyer.",
            what_are_they: "Please enter what are they.",
            date_of_registration_document: "Please select date of registration document.",
            place: "Please enter place.",
            no_from_determined_book: "Please enter number from determined book.",
            no_of_officer: "Please enter number of officer.",
            length_width_of_land: "Please enter length and width of land.",
            border: "Please enter border details.",
            certificate_of_no_duess: 'This field is required.',
            is_correct_info: "This field is required.",
            copy_of_documents: "This field is required.",
        };

        Object.keys(messages).forEach(fieldName => {
            const field = addContainer.querySelector(`[name="${fieldName}"]`);
            const errorSpan = addContainer.querySelector(`.${fieldName}_err`);

            if (fieldName === 'is_correct_info') {
                if (!field || !field.checked) {
                    isValid = false;
                    if (errorSpan) errorSpan.textContent = messages[fieldName];
                } else if (errorSpan) {
                    errorSpan.textContent = '';
                }
                return;
            }
            if (field) {
                if (!field.value.trim()) {
                    isValid = false;
                    field.classList.add('is-invalid');
                    if (errorSpan) errorSpan.textContent = messages[fieldName];
                } else {
                    field.classList.remove('is-invalid');
                    if (errorSpan) errorSpan.textContent = '';
                }
            }
        });

        if (!isValid) return;

        document.getElementById('upload_section').style.display = 'block';
        document.getElementById('card-footer').style.display = 'block';

        // const addContainer = document.getElementById('addContainer');
        // if (!addContainer) return;
        const printContainerClone = addContainer.cloneNode(true);
        const uploadSection = printContainerClone.querySelector('#upload_section');
        if (uploadSection) {
            uploadSection.remove();
        }
        printContainerClone.style.fontSize = '12px';
        printContainerClone.style.lineHeight = '1.4';
        printContainerClone.style.padding = '15px';
        printContainerClone.style.margin = '0 auto';
        printContainerClone.style.background = '#fff';
        printContainerClone.style.width = '210mm';
        printContainerClone.style.minHeight = '297mm';
        printContainerClone.style.boxSizing = 'border-box';
        Array.from(printContainerClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '12px';
            el.style.margin = '4px 0';
        });
        const printTitle = document.createElement('h2');
        printTitle.style.textAlign = 'center';
        printTitle.style.marginBottom = '18px';
        printTitle.style.fontSize = '18px';
        printTitle.textContent = 'TransferOfSelfProperty';
        printContainerClone.insertBefore(printTitle, printContainerClone.firstChild);
        Array.from(printContainerClone.querySelectorAll('button')).forEach(btn => btn.remove());
        Array.from(printContainerClone.querySelectorAll('.card')).forEach(card => {
            card.style.background = 'white';
            card.style.boxShadow = 'none';
            card.style.border = '1px solid #ccc';
            card.style.marginBottom = '12px';
            card.style.padding = '12px';
        });

        Array.from(printContainerClone.querySelectorAll('.selected-value')).forEach(div => {
            div.classList.remove('d-none');
        });

        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printContainerClone);

        html2canvas(printContainerClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const {
                jsPDF
            } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const pageWidth = pdf.internal.pageSize.getWidth();
            const pageHeight = pdf.internal.pageSize.getHeight();
            const margin = 10;
            const pdfWidth = pageWidth - margin * 2;
            const pdfHeight = pageHeight - margin * 2;
            pdf.addImage(imgData, 'JPEG', margin, margin, pdfWidth, pdfHeight);
            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content or try again.');
            }
            pdf.save('TransferOfSelfProperty.pdf');
            document.getElementById('saveAndPrintBtn').style.display = 'none';
        });
    });
</script>


{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('transfer-selfproperty.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
