<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>Receipt</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 30px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .content {
            margin-top: 30px;
        }

        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }

        .points {
            margin-top: 20px;
        }

        .points li {
            margin-bottom: 10px;
            margin-left: 5%;
        }

        p {
            font-size: 18px;
        }

        table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
            /* Ensure borders collapse to a single line */
        }

        th,
        td {
            padding: 2px 2px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            /* Add a light grey background to header */
        }

        /* Border style only for the second table */
        .bordered-table th,
        .bordered-table td {
            border: 1px solid #000;
            /* Adding border to cells */
        }

        .sub-header {
            margin-top: 20px;
        }
        .highlight-row td {
    border: 1px solid #000 !important;
    font-weight: bold;
    background-color: #f7f7f7;
}
    </style>
</head>
@php

     $totalgrand = (float) $totalgrand;
@endphp
<body>

    <div class="header">
        @php
            $logoData1 = file_get_contents(public_path('admin/images/favicon.png'));
            $base641Logo = base64_encode($logoData1);
        @endphp
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left;" height="150" width="150">
        <div class="rox">
            <h2>MIRA BHAYANDAR MUNICIPAL CORPORATION</h2>
            <p>Indira Gandhi Bhavan, Chattrapati Shivaji Maharaj Marg, Bhayandar(W), Dist -Thane </p>
            <p>Tel Nos. 022-28192828/ 28193028/ 28181183/ 28181353/ 28145985.</p>
            <h3>बांधकाम/ विद्युत विभाग</h3>
        </div>
    </div>

    <hr style="1px solid #000; height:5px; background-color:#000;">

    <div class="sub-header">
       <table style="width: 100%; font-size: 16px; border-collapse: collapse; margin-top: 10px;">
        <tr>
            <td style="text-align: left;">
                Receipt No.: {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}
            </td>
            <td style="text-align: right;">
                Date: {{ \Carbon\Carbon::parse($paymentdata->created_at)->format('d/m/Y') }}
            </td>
        </tr>
    </table>
    </div>



    <table style="font-size: 14px">
        <tr>
            <td><strong>Account name:</strong></td>
            <td>MBMC General Fund</td>
             <td><strong>Bank Name</strong></td>
            <td>Bank of Baroda</td>
        </tr>

         <tr>
            <td><strong>Account No :</strong></td>
            <td>**********0569</td>
             <td><strong>IFSC Code</strong></td>
            <td>BARB0DBBHAW</td>
        </tr>
        <tr>
            <td><strong>Application No:</strong></td>
            <td>{{ $data->application_no }}</td>
            <td><strong>Payment Date:</strong></td>
            <td>{{ \Carbon\Carbon::parse($paymentdata->created_at)->format('d/m/Y') }}</td>
        </tr>

        <tr>
            <td><strong>Applicant Name :</strong></td>
            <td>{{ $data->f_name }}</td>
            <td><strong>Verified Date :</strong></td>
            <td>{{ \Carbon\Carbon::now()->format('d/m/Y') }}</td>
        </tr>
        <tr>
            <td><strong>Applicant Mobile No :</strong></td>
            <td>{{ $data->mobile_num }}</td>
            <td><strong>Transaction No :</strong></td>
            <td>{{ $paymentdata->orderno }}</td>
        </tr>
        <tr>
            <td><strong>Reference No :</strong></td>
            <td>0000{{ $data->id }}</td>
            <td><strong>Service Name :</strong></td>
            <td>Granting permission for telecom</td>
        </tr>
        <tr>
            <td><strong>Received From :</strong></td>
            <td>{{ $data->property_num }}</td>
        </tr>
        <tr>
            <td><strong>PTAX SAC Number :</strong></td>
            <td>{{ \Carbon\Carbon::now()->format('d/m/Y') }}</td>
        </tr>
        <tr>
            <td><strong>Demand Note Reference No :</strong></td>
            <td>MDO/PRJ/24-25/075</td>
        </tr>
    </table>

    <!-- Table with borders applied -->
    <table class="bordered-table" style="font-size: 14px">
        {{-- <thead> --}}
            <tr>
                <th>Sr No</th>
                <th>SAC Activity Code</th>
                <th>Description Of Activity</th>
                <th>Amount</th>
            </tr>
        {{-- </thead> --}}
        <tbody>

            <tr>
                <td>1.</td>
                <td></td>
                <td>RI FOR {{ $data->company_name }}</td>
                <td>Rs.{{ number_format($combinedTotalRI) }} </td>
            </tr>

            <tr>
                <td>2.</td>
                <td></td>
                <td>Chamber Fees</td>
                <td>Rs.{{ number_format($chamberfee) }}</td>
            </tr>
            <tr>
                <td>3.</td>
                <td></td>
                <td>Land Rent </td>
                <td>Rs.{{ number_format($totalLandrent) }}</td>
            </tr>
            <tr>
                <td>4.</td>
                <td></td>
                <td>Security Deposit</td>
                <td>Rs.{{number_format($combinedSecurty) }}</td>
            </tr>


           <tr class="highlight-row">
                <td colspan="2">Net Amount</td>
                <td>CGST (9%) | SGST (9%)</td>
                <td>Gross Amount</td>
            </tr>
            <tr class="highlight-row">
                <td colspan="2">Rs.{{ $netamount }}</td>
                <td>Rs.{{ number_format($cgstamount) }} | Rs.{{ number_format($cgstamount) }}</td>
                <td>Rs.{{ number_format($totalgrand) }}</td>
            </tr>
        </tbody>
    </table>
    <?php
    $number = round($totalgrand);
    $no = floor($number);
    $point = round($number - $no, 2) * 100;
    $hundred = null;
    $digits_1 = strlen($no);
    $i = 0;
    $str = [];
    $words = ['0' => '', '1' => 'one', '2' => 'two', '3' => 'three', '4' => 'four', '5' => 'five', '6' => 'six', '7' => 'seven', '8' => 'eight', '9' => 'nine', '10' => 'ten', '11' => 'eleven', '12' => 'twelve', '13' => 'thirteen', '14' => 'fourteen', '15' => 'fifteen', '16' => 'sixteen', '17' => 'seventeen', '18' => 'eighteen', '19' => 'nineteen', '20' => 'twenty', '30' => 'thirty', '40' => 'forty', '50' => 'fifty', '60' => 'sixty', '70' => 'seventy', '80' => 'eighty', '90' => 'ninety'];
    $digits = ['', 'hundred', 'thousand', 'lakh', 'crore'];
    while ($i < $digits_1) {
        $divider = $i == 2 ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += $divider == 10 ? 1 : 2;
        if ($number) {
            $plural = ($counter = count($str)) && $number > 9 ? 's' : null;
            $hundred = $counter == 1 && $str[0] ? ' and ' : null;
            $str[] = $number < 21 ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
        } else {
            $str[] = null;
        }
    }
    $str = array_reverse($str);
    $result = implode('', $str);
    $title = 'Amount In Word :- ';
    $points = $point ? ' and ' . $words[floor($point / 10) * 10] . ' ' . $words[$point % 10] . ' Paise' : '';
    echo '<strong>' . $title . "Rupees " . ucfirst(trim($result)) . $points . '</strong>';
    ?>
    <p style="margin-top:20%; text-align:center;">Note : This is Computer generated Receipt, hence no Signature require.</p>

</body>

</html>
