<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Approval Hierarchy - {{ $hierarchy->id }}</title>

    <!-- Bootstrap CSS (CDN) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', sans-serif;
            margin: 20px;
        }

        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .card-header {
            background-color: #007bff;
            color: white;
            font-size: 1.1rem;
            border-top-left-radius: 12px;
            border-top-right-radius: 12px;
        }

        table th {
            background-color: #f1f3f5;
        }

        .btn-back {
            border-radius: 20px;
            padding: 6px 20px;
        }
    </style>
</head>

<body>

    <div class="container mt-4">
        <div class="card">
            <div class="card-header">
                <strong>Approval Hierarchy Details</strong>
            </div>

            <div class="card-body">
                <div class="mb-3">
                    <p class="mb-1"><strong>Hierarchy ID:</strong> {{ $hierarchy->id }}</p>
                    @if($hierarchy->service_id)
                        <p class="mb-1"><strong>Service ID:</strong> {{ $hierarchy->service_id }}</p>
                    @endif
                    @if($hierarchy->requester_department_id)
                        <p class="mb-1"><strong>Requester Department ID:</strong> {{ $hierarchy->requester_department_id }}
                        </p>
                    @endif
                </div>

                @if(count($employees) > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Employee Name</th>
                                    <th>Designation</th>
                                    <th>Departments & Wards</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($employees as $emp)
                                    <tr>
                                        <td>{{ $emp['employee_name'] }}</td>
                                        <td>{{ $emp['designation_name'] }}</td>
                                        <td>
                                            <ul class="mb-0 ps-3">
                                                @foreach($emp['departments'] as $deptName => $data)
                                                    <li>
                                                        <strong>{{ $deptName }}</strong>
                                                        <ul class="mb-0 ps-3">
                                                            <li>Wards: {{ implode(', ', $data['wards'] ?: ['-']) }}</li>
                                                            <li>Prabhags: {{ implode(', ', $data['prabhags'] ?: ['-']) }}</li>
                                                        </ul>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                @else
                    <div class="alert alert-warning text-center">
                        No employees found for this hierarchy.
                    </div>
                @endif

            </div>

            <div class="card-footer text-end bg-white">
                <a href="{{ url()->previous() }}" class="btn btn-secondary btn-back">Back</a>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS (Optional for responsiveness) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>
