<x-admin.layout>
    <x-slot name="title">Issuance of zone certificate / झोन दाखला देणे</x-slot>
    <x-slot name="heading">Issuance of zone certificate / झोन दाखला देणे</x-slot>

        <!-- Add Form -->
        <div class="row" id="addContainer">
            <div class="col-sm-12">
                <div class="card">
                    <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                        @csrf

                        <div class="card-header">
                            <h4 class="card-title">Edit Issuance of zone certificate / झोन दाखला देणे</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                            <input type="hidden" model-id="id" value="{{ $status->id }}">

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="applicant_name">Applicant's Full Name / अर्जदाराचे संपूर्ण नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="applicant_name" name="applicant_name" pattern="^[A-Za-zअ-हऀ-ॿ\s]+$"
                                    title="Only letters and spaces are allowed. No numbers or special characters."
                                    onkeypress="return isLetterOrSpace(event)" type="text" placeholder="Enter Applicant Name" value="{{ $data->applicant_name }}" disabled>
                                    <span class="text-danger is-invalid applicant_name_err"></span>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="applicant_full_address">Applicant's Full Address / अर्जदाराचा संपूर्ण पत्ता <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="applicant_full_address" id="applicant_full_address" cols="30" rows="2"  placeholder="Enter Applicant Address" disabled >{{ $data->applicant_full_address }}</textarea>
                                    <span class="text-danger is-invalid applicant_full_address_err"></span>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नं.<span class="text-danger">*</span></label>
                                    <input class="form-control" id="mobile_no" name="mobile_no" type="number" maxlength="10"
                                    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);" placeholder="Enter Mobile Number" value="{{ $data->mobile_no }}"  disabled>
                                    <span class="text-danger is-invalid mobile_no_err"></span>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="email_id">Email ID / ई-मेल आयडी<span class="text-danger">*</span></label>
                                    <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $data->email_id }}" disabled>
                                    <span class="text-danger is-invalid email_id_err"></span>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="aadhar_no">Aadhar Number / आधार क्रमांक <span class="text-danger">*</span></label>
                                    <input class="form-control" id="aadhar_no" name="aadhar_no" type="number" onkeypress="return isNumberKey(event)"
                                    oninput="limitAadharLength(this)" placeholder="Enter Aadhar Card No" value="{{ $data->aadhar_no }}" disabled>
                                    <span class="text-danger is-invalid aadhar_no_err"></span>
                                </div>
                                {{-- <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="zone">Zone <span class="text-danger">*</span></label>
                                    <select name="zone" id="zone" class="form-select">
                                        <option value="">Select Zone</option>
                                        @php
                                            $options = ["Prabhag1", "Prabhag2", "Prabhag3", "Prabhag4", "Prabhag5", "Prabhag6"];
                                        @endphp
                                        @foreach($options as $option)
                                        <option {{ $data->zone == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div> --}}

                                 <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="maptype">Copy Types <span class="text-danger">*</span></label>
                                    <select name="maptype" id="maptype" class="form-select"  disabled>
                                        <option value="">Select Copy Types</option>
                                        @foreach($maptype as $option)
                                            <option value="{{ $option->id }}" {{ $data->maptype == $option->id ? 'selected' : '' }}>
                                                {{ $option->type }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="servey_number">सर्व्हे क्रमांक / सि.टी.एस. क्रमांक (फक्त सर्व्हे क्रमांक / सि.टी.एस क्रमांक) -<span class="text-danger">*</span></label>
                                    <input class="form-control" id="servey_number" name="servey_number" type="text" placeholder="Enter City Servey Number" value="{{ $data->servey_number }}" disabled>
                                    <span class="text-danger is-invalid servey_number_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="prescribed_formats">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                    {{-- <input class="form-control" id="prescribed_formats" name="prescribed_formats" type="file" > --}}
                                    <div><a href="{{ asset('storage/' . $data->prescribed_format) }}" target="_blank">View Document</a></div>
                                    <span class="text-danger is-invalid prescribed_formats_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="upload_city_survey_certificates">अद्यावत 7/12 उतारा. (7/12 उतारा अर्ज करण्याच्या दिनांकाचा असावा.)<span class="text-danger">*</span></label>
                                    {{-- <input class="form-control" id="upload_city_survey_certificates" name="upload_city_survey_certificates" type="file" > --}}
                                    <div><a href="{{ asset('storage/' . $data->upload_city_survey_certificate) }}" target="_blank">View Document</a></div>
                                    <span class="text-danger is-invalid upload_city_survey_certificates_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="upload_city_servey_maps">अद्यावत गटबुक नकाशा <span class="text-danger">*</span></label>
                                    {{-- <input class="form-control" id="upload_city_servey_maps" name="upload_city_servey_maps" type="file" > --}}
                                    <div><a href="{{ asset('storage/' . $data->upload_city_servey_map) }}" target="_blank">View Document</a></div>
                                    <span class="text-danger is-invalid upload_city_servey_maps_err"></span>
                                </div>

                                 <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="adhaar_card">Upload Adhaar Card<span class="text-danger">*</span></label>
                                    <div><a href="{{ asset('storage/' . $data->adhaar_cards) }}" target="_blank">View Document</a></div>
                                    {{-- <input class="form-control" id="adhaar_card" name="adhaar_card" type="file" > --}}
                                    <span class="text-danger is-invalid adhaar_card_err"></span>
                                </div>

                                  <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" maxlength="255" class="form-control" rows="4" required></textarea>
                            </div>


                                {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र  <span class="text-danger">*</span></label>
                                <div class="col-md-12">
                                    <div class="form-check d-flex align-items-start">
                                        <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" checked disabled>
                                        <label class="form-check-label ms-2" for="is_correct_info">
                                            All information provided above is correct and I shall be fully responsible for any discrepancy.<br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन.
                                        </label>
                                    </div>
                                    <span class="text-danger is-invalid is_correct_info_err"></span>
                                </div> --}}

                            </div>
                        </div>
                        <div class="card-footer">
                          <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button id="btnCancel" class="btn btn-warning">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

</x-admin.layout>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
     document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });

        $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>

{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route("town-planing-zone-certificate.update", $data->id) }}';
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function()
            {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data)
            {
                $("#addSubmit").prop('disabled', false);
                if (!data.error2)
                    swal("Successful!", data.success, "success")
                        .then((action) => {
                            window.location.href = '{{ route("my-application") }}';
                        });
                else
                    swal("Error!", data.error2, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>

<!--applicant name-->
<script>
    function isLetterOrSpace(e) {
        const char = String.fromCharCode(e.which || e.keyCode);
        const regex = /^[A-Za-zअ-हऀ-ॿ\s]+$/;
        return regex.test(char);
    }
</script>

<!--adhar card no validation-->
<script>

    function isNumberKey(evt) {
        var charCode = evt.which ? evt.which : evt.keyCode;

        if (charCode < 48 || charCode > 57) {
            evt.preventDefault();
            return false;
        }
        return true;
    }


    function limitAadharLength(input) {
        if (input.value.length > 12) {
            input.value = input.value.slice(0, 12);
        }
    }
</script>



