<x-admin.layout>
    <x-slot name="title">Track Application</x-slot>
    <x-slot name="heading">Track Application</x-slot>

    <div class="row">
        <div class="col-12">
            <div class="card">

                {{-- 🔹 Track Application Section --}}
                <div class="card-header">
                    <h4 class="mb-0">Track Your Application</h4>
                </div>

                <div class="card-body">
                    {{-- Vertical Form - Mobile Friendly --}}
                    <form action=" " method="GET" class="row g-3">

                        {{-- Mobile Number --}}
                         @if(!$isUserRole)
                        <div class="col-12 col-sm-6 col-md-4">
                            <label for="mobile_no" class="form-label fw-semibold">Mobile Number</label>
                            <input type="text" name="mobile_no" id="mobile_no" class="form-control" placeholder="Enter Mobile Number" value="{{ request('mobile_no') }}">
                        </div>
                        @endif

                        {{-- Application Number --}}
                        <div class="col-12 col-sm-6 col-md-4">
                            <label for="application_no" class="form-label fw-semibold">Application Number</label>
                            <input type="text" name="application_no" id="application_no" class="form-control" placeholder="Enter Application Number" value="{{ request('application_no') }}">
                        </div>

                        {{-- Buttons --}}
                        <div class="col-12 col-sm-12 col-md-4 d-flex flex-wrap gap-2 align-items-end">
                            <button type="submit" class="btn btn-primary flex-grow-1">Search</button>
                            <a href="{{ url()->current() }}" class="btn btn-secondary flex-grow-1">Reset</a>
                        </div>

                    </form>
                </div>

                {{-- 🔹 Application Result Table --}}
                @if (!empty($applications))
                    <div class="card-body mt-3">
                        <div class="table-responsive">
                            <table id="buttons-datatables" class="table table-bordered table-striped align-middle nowrap">
                                <thead class="table-light">
                                    <tr>
                                        <th>Sr No</th>
                                        <th>Application Number</th>
                                        <th>Applicant Name</th>
                                        <th>Mobile Number</th>
                                        {{-- <th>Department</th> --}}
                                        <th>Service</th>
                                        <th>Status</th>
                                        <th>Approvers</th> <!-- New column -->
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($applications as $key => $app)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $app['application_no'] }}</td>
                                            <td>{{ @$app['applicant_name'] }}</td>
                                            <td>{{ @$app['mobile_no'] }}</td>
                                            {{-- <td>{{ @$app['department_name'] ?? '-' }}</td> --}}
                                            <td>{{ @$app['service_name'] ?? '-' }}</td>
                                            <td>
                                                @if ($app['status'] == 'Approved')
                                                    <span class="badge bg-success">Approved</span>
                                                @elseif($app['status'] == 'Rejected')
                                                    <span class="badge bg-danger">Rejected</span>
                                                @else
                                                    <span class="badge bg-warning text-dark">Pending</span>
                                                @endif
                                            </td>
                                         <td>
                                            @if (!empty($app['approvers']))
                                                @foreach ($app['approvers'] as $approver)
                                                    @php
                                                        $badgeClass = match ($approver['status']) {
                                                            'Approved' => 'bg-success',
                                                            'Rejected' => 'bg-danger',
                                                            default => 'bg-warning text-dark',
                                                        };
                                                    @endphp

                                                    <div class="mb-2">
                                                        <span class="badge {{ $badgeClass }}">
                                                            @if(!$isUserRole) {{ $approver['name'] }} @endif
                                                            ({{ $approver['role'] }}) - {{ $approver['status'] }}
                                                        </span>

                                                        @if(!empty($approver['remark']) && !$isUserRole)
                                                            <div class="small text-muted mt-1">
                                                                <i class="fa fa-comment"></i> {{ $approver['remark'] }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            @else
                                                -
                                            @endif
                                        </td>

                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    </div>
                @elseif(request()->hasAny(['mobile_no', 'application_no']))
                    <div class="card-body text-center mt-3">
                        <h5>No Applications Found</h5>
                    </div>
                @endif

            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            // Allow only numbers for mobile field
            document.getElementById('mobile_no').addEventListener('input', function() {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
        </script>
    @endpush

</x-admin.layout>
