<x-admin.layout>
    <x-slot name="title">Auto Renewal of Trade License / व्यवसाय परवाना स्वयंनुतनीकरण</x-slot>
    <x-slot name="heading">Auto Renewal of Trade License / व्यवसाय परवाना स्वयंनुतनीकरण</x-slot>

        <!-- Add Form -->
        <div class="row" id="addContainer">
            <div class="col-sm-12">
                <div class="card">
                    <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                        @csrf

                        <div class="card-header">
                            <h4 class="card-title">Add Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">

                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_full_name">Applicant Full Name / अर्जदाराचे संपूर्ण नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="applicant_full_name" name="applicant_full_name" type="text" placeholder="Enter Applicant Full Name" required>
                                    <span class="text-danger is-invalid applicant_full_name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा संपूर्ण पत्ता <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="address" id="address" cols="30" rows="2" placeholder="Enter  Address" required></textarea>
                                    <span class="text-danger is-invalid address_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                    <input class="form-control" id="mobile_no" name="mobile_no" type="text" placeholder="Enter Mobile Number" oninput="this.value = this.value.replace(/\D/g, '')" minlength="10" maxlength="10" required>
                                    <span class="text-danger is-invalid mobile_no_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="email_id">Email ID / ई-मेल आयडी<span class="text-danger">*</span></label>
                                    <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" required>
                                    <span class="text-danger is-invalid email_id_err"></span>
                                </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="aadhar_no">Aadhar No / आधार नंबर  <span class="text-danger">*</span></label>
                                    <input class="form-control" id="aadhar_no" name="aadhar_no" type="text" placeholder="Enter Aadhar Card No" oninput="this.value = this.value.replace(/\D/g, '')" minlength="12" maxlength="12" required>
                                    <span class="text-danger is-invalid aadhar_no_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <select class="form-select" name="zone" id="zone" required>
                                        <option value="">Select Zone</option>

                                        @foreach($zones as $zone)
                                        <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div> --}}
                                <div class="col-md-4">
                                    <label class="col-form-label" for="ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <select class="form-select" name="ward" id="ward" required>
                                        <option value="">Select Ward Area</option>

                                        @foreach($wards as $ward)
                                        <option value="{{ $ward->id }}">{{ $ward->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid ward_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="current_permission_no">Current Permission No / चालू परवाना क्र <span class="text-danger">*</span></label>
                                    <input class="form-control" id="current_permission_no" name="current_permission_no" type="text" placeholder="Enter Current Permission No" required>
                                    <span class="text-danger is-invalid current_permission_no_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="current_permission_date">Current Permission Date / चालू परवाना दिनांक <span class="text-danger">*</span></label>
                                    <input class="form-control" id="current_permission_date" name="current_permission_date" type="date" placeholder="Enter Current Permission Date" required>
                                    <span class="text-danger is-invalid current_permission_date_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="current_permission_expiry_date">Current Permission Expiry Date / चालू परवाना समाप्ती दिनांक<span class="text-danger">*</span></label>
                                    <input class="form-control" id="current_permission_expiry_date" name="current_permission_expiry_date" type="date" placeholder="Enter Current Permission Expiry Date" required>
                                    <span class="text-danger is-invalid current_permission_expiry_date_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="current_permission_validity_date">Current permission validity extended upto date / चालू परवाना मुदत कधी पर्यंत वाढवायची ती तारीख<span class="text-danger">*</span></label>
                                    <input class="form-control" id="current_permission_validity_date" name="current_permission_validity_date" type="date" placeholder="Enter Current permission validity extended upto date" required>
                                    <span class="text-danger is-invalid current_permission_validity_date_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="business_start_date">Date of business start / व्यवसाय सुरु केल्याची तारीख <span class="text-danger">*</span></label>
                                    <input class="form-control" id="business_start_date" name="business_start_date" type="date" placeholder="Enter Date of business start" required>
                                    <span class="text-danger is-invalid business_start_date_err"></span>
                                </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="business_or_trade_name">Business or trade_name / व्यवसायाचे किंवा व्यापाराचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="business_or_trade_name" name="business_or_trade_name" type="text" placeholder="Enter Business or trade_name" required>
                                    <span class="text-danger is-invalid business_or_trade_name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="permission_detail">Permission details / परवान्याचा तपशील <span class="text-danger">*</span></label>
                                    <input class="form-control" id="permission_detail" name="permission_detail" type="text" placeholder="Enter Permission details" required>
                                    <span class="text-danger is-invalid permission_detail_err"></span>
                                </div>
{{--
                                <div class="col-md-4">
                                    <label class="col-form-label" for="plot_no">Plot or bhukhand no / प्लॉट किंवा भूखंड क्र. <span class="text-danger">*</span></label>
                                    <input class="form-control" id="plot_no" name="plot_no" type="text" placeholder="Enter Plot or bhukhand no" required>
                                    <span class="text-danger is-invalid plot_no_err"></span>
                                </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="description_of_trade_place">trade place description / व्यवसाय जागेचे संपूर्ण वर्णन<span class="text-danger">*</span></label>
                                    <input class="form-control" id="description_of_trade_place" name="description_of_trade_place" type="text" placeholder="Enter trade place description" required>
                                    <span class="text-danger is-invalid description_of_trade_place_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="is_preveious_permission_declined_by_council">is previouly permission declined by council ? / यापूर्वी अर्जात नमूद जागेला व्यवसाय परवाना नाकारला आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="is_preveious_permission_declined_by_council" id="is_preveious_permission_declined_by_council" required>
                                        <option value="">Select Option</option>
                                        @php
                                        $options = ["Yes", "No"];
                                        @endphp
                                        @foreach($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid is_preveious_permission_declined_by_council_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="previous_permission_decline_reason">Previous permission decline reason / परवाना नाकारण्याचे कारण<span class="text-danger">*</span></label>
                                    <input class="form-control" id="previous_permission_decline_reason" name="previous_permission_decline_reason" type="text" placeholder="Enter Previous permission decline reason" required>
                                    <span class="text-danger is-invalid previous_permission_decline_reason_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="is_place_owned_by_council">Is place owned by council ? / जागा पालिकेच्या मालकीची आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="is_place_owned_by_council" id="is_place_owned_by_council" required>
                                        <option value="">Select Option</option>
                                        @php
                                        $options = ["Yes", "No"];
                                        @endphp
                                        @foreach($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid is_place_owned_by_council_err"></span>
                                </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="is_any_dues_pending_of_council">Is any dues pending of council ? / आपल्याकडे पालिकेची थकबाकी आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="is_any_dues_pending_of_council" id="is_any_dues_pending_of_council" required>
                                        <option value="">Select Option</option>
                                        @php
                                        $options = ["Yes", "No"];
                                        @endphp
                                        @foreach($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid is_any_dues_pending_of_council_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="trade_or_business_type">Trade or business type of new permission / व्यवसायाचा प्रकार <span class="text-danger">*</span></label>
                                    <select class="form-select" name="trade_or_business_type" id="trade_or_business_type" required>
                                        @php
                                            $options = ["असोसिएट्स", "आईस्क्रिम पार्लर", "इंजिनियरींग वर्क्स", "इंटिरियल", "इतर", "इलेक्ट्रिकल", "इलेक्ट्रीक अँड हार्डवेअर", "इंशुरन्स", "उपहारगृह", "ऑप्टीकल", "ओल्ड् पेपर मार्ट", "कंट्रक्शन", "कपडा विक्री", "कपड्याचे दुकान", "कांदा-बटाटा दुकान", "कारखाना", "किराणा दुकान", "कुरीअर सर्विस", "कॅटरींग सर्विसेस", "केक शॉप", "केशकर्तनालय / सलुन", "कोल्ड्रींग अँड आईस्क्रीम", "क्लासेस", "क्लीनर", "खादयपदार्थ विक्री", "खानावळ", "गॅरेज", "चक्की", "चाइनीज पॉईंट", "चाय पॉईंट", "चिकन शॉप", "जनरल स्टोर", "जिम फिटनेस", "टेलर", "नर्सरी", "पान बिडी शॉप", "पुस्तक विक्री", "फर्निचर दुकान", "फर्निचर वर्क", "फाटो शॉप", "बांगडी बनविणे", "बेकरी", "बेकरी शॉप / बेकरी प्रोडक्टस", "ब्युटी पार्लर", "मटण शॉप", "मटण-चिकन शॉप", "मसाला विक्री", "मॅन्युफॅक्चरींग", "मेटल पार्ट वर्क", "मेडिकल", "रबर प्रोडक्ट", "रेडीमेंड गारमेंट", "रेस्टॉरंट", "लाँड्री", "लॉजिंग / बोर्डींग", "वेल्डींग", "सायकल रिपेरींग", "सिट कवर असेसरीज", "सेल्स सर्विस", "स्टील फर्निचर", "स्टेनलेस स्टील", "स्टेशनरी", "स्नॅक्स सेंटर", "स्विट मार्ट / मिठाईचे दुकान", "हार्डवेअर"]
                                        @endphp
                                        <option value="">Select a value ...</option>
                                        @foreach($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid trade_or_business_type_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_no">Property Number / मालमत्ता क्र<span class="text-danger">*</span></label>
                                    <input class="form-control" id="property_no" name="property_no" type="number" placeholder="Enter Property Number" required>
                                    <span class="text-danger is-invalid property_no_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="remark">Remark / शेरा</label>
                                    <input class="form-control" id="remark" name="remark" type="text" placeholder="Enter Remark">
                                    <span class="text-danger is-invalid remark_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="application_documents">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा<span class="text-danger">*</span></label>
                                    <input class="form-control" id="application_documents" name="application_documents" type="file" required>
                                    <span class="text-danger is-invalid application_documents_err"></span>
                                </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="no_dues_documents">Upload Certificate Of No Dues / थकबाकी नसल्याचा दाखला अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="no_dues_documents" name="no_dues_documents" type="file" required>
                                    <span class="text-danger is-invalid no_dues_documents_err"></span>
                                </div>

                                 <div class="col-md-4" id="upload_section" style="display:none;">
                                    <label class="col-form-label" for="prescribed_docs">Upload Application In
                                        Prescribed
                                        Format / विहित नमुन्यातील अर्ज अपलोड करा <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="prescribed_docs" name="prescribed_docs"
                                        type="file" required>
                                    <span class="text-danger is-invalid prescribed_docs_err"></span>
                                </div>

                                <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                                <div class="col-md-12">
                                    <div class="form-check d-flex align-items-start">
                                        <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" required>
                                        <label class="form-check-label ms-2" for="is_correct_info">
                                            "All information provided above is correct and I shall be fully responsible for any discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                                        </label>
                                    </div>
                                    <span class="text-danger is-invalid is_correct_info_err"></span>
                                </div>

                            </div>
                        </div>
                         <div class="form-group" style="text-align: center;">
                            <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                        </div>
                        <div class="card-footer" id="card-footer" style="display:none;">
                            <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                            <button type="reset" class="btn btn-warning">Reset</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

</x-admin.layout>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

         if ($('#upload_section').is(':visible')) {
        var fileVal = $('#prescribed_docs').val();
        if (!fileVal) {
            swal("Error!", "Please upload the application document.", "error");
            $("#addSubmit").prop('disabled', false);
            return;
        }
    }

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route("trade-autorenewal-license.store") }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function()
            {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data)
            {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                        .then((action) => {
                            window.location.href = '{{ route("my-application") }}';
                        });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
    attachGlobalValidation('#addForm', '#saveAndPrintBtn', {
        containerId: 'addContainer',
        printTitle: 'Trade-autorenewal-license',
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', () => {

    // --- Detect field type based on name/id/placeholder ---
    function detectFieldType(input) {
        const s = ((input.name || '') + ' ' + (input.id || '') + ' ' + (input.placeholder || '')).toLowerCase();
        if (/\baadhaar|\baadhar|\baadhar_no|\baadhar_num|\baadhar-number/.test(s)) return 'aadhar';
        if (/\bmobile|\bmobile_no|\bcontact|\bcontact_no|\bphone|\btelephone|\btel/.test(s)) return 'phone';
        if (/\bemail|\be-mail|\bmail|\balternet_email|\balternate_email|\bemail_id/.test(s)) return 'email';
        return null;
    }

    // --- Get associated error span ---
    function getErrorSpan(input) {
        if (input.name) {
            const spanByName = document.querySelector(`.${input.name}_err`);
            if (spanByName) return spanByName;
        }
        if (input.id) {
            const spanById = document.querySelector(`.${input.id}_err`);
            if (spanById) return spanById;
        }
        return input.closest('div')?.querySelector('span.text-danger') || null;
    }

    // --- Validation rules ---
    function validateValueByType(value, type, required, input) {
        // Aadhaar logic (skip numeric check if file input)
        if (type === 'aadhar') {
            if (input.type === 'file') {
                if (required && !input.files.length) return 'This field is required';
                return '';
            } else {
                if (required && value === '') return 'Aadhaar number is required';
                if (value && !/^\d{12}$/.test(value)) return 'Enter a valid 12-digit Aadhaar number';
                return '';
            }
        }

        if (type === 'phone') {
            if (required && value === '') return 'Mobile number is required';
            if (value && !/^[6-9]\d{9}$/.test(value)) return 'Enter a valid 10-digit mobile number';
            return '';
        }

        if (type === 'email') {
            if (required && value === '') return 'Email is required';
            if (value && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value)) return 'Enter a valid email address';
            return '';
        }

        return '';
    }

    // --- Validate a single field ---
    function validateField(input) {
        const type = detectFieldType(input);
        const required = input.hasAttribute('required');
        const value = (input.value || '').trim();

        let err = '';
        if (type) {
            err = validateValueByType(value, type, required, input);
        } else if (required) {
            if (input.type === 'file' && !input.files.length) {
                err = 'This field is required';
            } else if (input.type !== 'checkbox' && value === '') {
                err = 'This field is required';
            }
        }

        const span = getErrorSpan(input);
        if (span) {
            span.textContent = err;
            span.style.display = err ? 'block' : 'none';
        }

        if (err) {
            input.classList.add('is-invalid');
            input.setAttribute('aria-invalid', 'true');
        } else {
            input.classList.remove('is-invalid');
            input.removeAttribute('aria-invalid');
        }

        return !err;
    }

    // --- Validate all visible fields (including checkbox rule) ---
    function validateAllFields(form) {
        let allValid = true;
        const inputs = Array.from(form.querySelectorAll('input, textarea, select'));

        inputs.forEach(field => {
            if (field.offsetParent === null) return; // skip hidden fields

            // ✅ Special rule for checkbox (is_correct_info)
            if (field.type === 'checkbox' && (field.id === 'is_correct_info' || field.name === 'is_correct_info')) {
                const errorSpan = getErrorSpan(field);
                if (!field.checked) {
                    if (errorSpan) {
                        errorSpan.textContent = 'Please accept the declaration.';
                        errorSpan.style.display = 'block';
                    }
                    allValid = false;
                } else {
                    if (errorSpan) {
                        errorSpan.textContent = '';
                        errorSpan.style.display = 'none';
                    }
                }
                return;
            }

            // ✅ Normal validation for all other fields
            if (!validateField(field)) allValid = false;
        });

        return allValid;
    }

    // --- Attach input/blur events ---
    const allInputs = Array.from(document.querySelectorAll('input, textarea, select'));
    allInputs.forEach(input => {
        input.addEventListener('input', () => validateField(input));
        input.addEventListener('blur', () => validateField(input));

        // ✅ If checkbox is checked later, hide error immediately
        if (input.type === 'checkbox' && (input.id === 'is_correct_info' || input.name === 'is_correct_info')) {
            input.addEventListener('change', () => {
                const span = getErrorSpan(input);
                if (span && input.checked) {
                    span.textContent = '';
                    span.style.display = 'none';
                }
            });
        }
    });

    // Expose global function
    window.validateAllFields = validateAllFields;

});
</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    const currentDate = document.getElementById("current_permission_date");
    const expiryDate = document.getElementById("current_permission_expiry_date");
    const validityDate = document.getElementById("current_permission_validity_date");

    const errCurrent = document.querySelector(".current_permission_date_err");
    const errExpiry = document.querySelector(".current_permission_expiry_date_err");
    const errValidity = document.querySelector(".current_permission_validity_date_err");

    // Set min for expiry date based on current permission date
    currentDate.addEventListener("change", function() {
        if (this.value) {
            const minExpiry = new Date(this.value);
            minExpiry.setDate(minExpiry.getDate() + 1); // next day
            expiryDate.min = minExpiry.toISOString().split("T")[0];
            expiryDate.value = ""; // reset if previously invalid
            errCurrent.textContent = "";
        }
    });

    // Validate expiry date
    expiryDate.addEventListener("change", function() {
        if (currentDate.value && new Date(this.value) <= new Date(currentDate.value)) {
            this.value = "";
            errExpiry.textContent = "Expiry Date must be after Current Permission Date.";
        } else {
            errExpiry.textContent = "";
            // set min for validity date
            const minValidity = new Date(this.value);
            minValidity.setDate(minValidity.getDate() + 1);
            validityDate.min = minValidity.toISOString().split("T")[0];
        }
    });

    // Validate validity date
    validityDate.addEventListener("change", function() {
        const curDate = currentDate.value ? new Date(currentDate.value) : null;
        const expDate = expiryDate.value ? new Date(expiryDate.value) : null;
        const valDate = new Date(this.value);

        if (curDate && valDate <= curDate) {
            this.value = "";
            errValidity.textContent = "Validity Date must be after Current Permission Date.";
        } else if (expDate && valDate <= expDate) {
            this.value = "";
            errValidity.textContent = "Validity Date must be after Expiry Date.";
        } else {
            errValidity.textContent = "";
        }
    });
});
</script>

