<x-admin.layout>
    <x-slot name="title">New Trade License Permission / नवीन व्यवसाय परवाना मिळणे</x-slot>
    <x-slot name="heading">New Trade License Permission / नवीन व्यवसाय परवाना मिळणे</x-slot>

        <!-- Add Form -->
        <div class="row" id="addContainer">
            <div class="col-sm-12">
                <div class="card">
                    <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                        @csrf

                        <div class="card-header">
                            <h4 class="card-title">Edit Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">

                            <input type="hidden" model-id="id" value="{{ $status->id }}">

                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_full_name">Applicant Full Name / अर्जदाराचे संपूर्ण नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="applicant_full_name" name="applicant_full_name" type="text" placeholder="Enter Applicant Full Name" value="{{ $data->applicant_full_name }}" required="" disabled="" readonly="">
                                    <span class="text-danger is-invalid applicant_full_name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा संपूर्ण पत्ता <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="address" id="address" cols="30" rows="2"  placeholder="Enter  Address" required="" disabled="" readonly="">{{ $data->address }}</textarea>
                                    <span class="text-danger is-invalid address_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="office_address">Applicant's Full Office Address / अर्जदाराचा संपूर्ण कार्यालयीन पत्ता <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="office_address" id="office_address" cols="30" rows="2" placeholder="Enter Office Address" required="" disabled="" readonly="">{{ $data->office_address }}</textarea>
                                    <span class="text-danger is-invalid office_address_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                    <input class="form-control" id="mobile_no" name="mobile_no"  oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text" placeholder="Enter Mobile Number" required="" disabled="" readonly="" value="{{ $data->mobile_no }}">
                                    <span class="text-danger is-invalid mobile_no_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="email_id">Email ID / ई-मेल आयडी<span class="text-danger">*</span></label>
                                    <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $data->email_id }}" required>
                                    <span class="text-danger is-invalid email_id_err"></span>
                                </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="aadhar_no">Aadhar No / आधार नंबर  <span class="text-danger">*</span></label>
                                    <input class="form-control" id="aadhar_no" name="aadhar_no"  oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text" placeholder="Enter Aadhar Card No"  value="{{ $data->aadhar_no }}" required="" disabled="" readonly="">
                                    <span class="text-danger is-invalid aadhar_no_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="business_start_date">Date of business start / व्यवसाय सुरु केल्याची तारीख <span class="text-danger">*</span></label>
                                    <input class="form-control" id="business_start_date" name="business_start_date" type="date" placeholder="Enter Date of business start" value="{{ $data->business_start_date }}" required>
                                    <span class="text-danger is-invalid business_start_date_err"></span>
                                </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="business_or_trade_name">Business or trade_name / व्यवसायाचे किंवा व्यापाराचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="business_or_trade_name" name="business_or_trade_name" type="text" placeholder="Enter Business or trade_name" value="{{ $data->business_or_trade_name }}" required="" disabled="" readonly="">
                                    <span class="text-danger is-invalid business_or_trade_name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="area_size">New permission place area size (sqr mtr) / परवान्यासाठी अर्ज केलेल्या जागेचे क्षेत्रफळ(चौ .मी .)  <span class="text-danger">*</span></label>
                                    <input class="form-control" id="area_size" name="area_size" type="number" placeholder="Enter New permission place area size (sqr mtr)" value="{{ $data->area_size }}" required="" disabled="" readonly="">
                                    <span class="text-danger is-invalid area_size_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="new_permission_details">New permission details / नवीन परवान्याचा तपशील <span class="text-danger">*</span></label>
                                    <input class="form-control" id="new_permission_details" name="new_permission_details" type="text" placeholder="Enter New permission details" value="{{ $data->new_permission_details }}" required="" disabled="" readonly="">
                                    <span class="text-danger is-invalid new_permission_details_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <select class="form-select" name="zone" id="zone" required>
                                        <option value="">Select Zone</option>
                                        @foreach($zones as $zone)
                                        <option value="{{ $zone->name }}" {{ $data->zone == $zone->name ? 'selected' : '' }}>{{ $zone->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div> --}}
                                <div class="col-md-4">
                                    <label class="col-form-label" for="ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <select class="form-select" name="ward" id="ward" required="" disabled="" readonly="">
                                        <option value="">Select Ward Area</option>
                                        @foreach($wards as $ward)
                                        <option value="{{ $ward->id }}" {{ $data->ward == $ward->id ? 'selected' : '' }}>{{ $ward->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid ward_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="plot_no">Plot or bhukhand no / प्लॉट किंवा भूखंड क्र. <span class="text-danger">*</span></label>
                                    <input class="form-control" id="plot_no" name="plot_no" type="text" placeholder="Enter Plot or bhukhand no" value="{{ $data->plot_no }}" required>
                                    <span class="text-danger is-invalid plot_no_err"></span>
                                </div> --}}

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="city_servye_no">City Servye Number / सिटी सर्व्हे क्र.</label>
                                    <input class="form-control" id="city_servye_no" name="city_servye_no" type="text" placeholder="Enter City Servye Number" value="{{ $data->city_servye_no }}" required>
                                    <span class="text-danger is-invalid city_servye_no_err"></span>
                                </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="description_of_new_trade_place">New trade place description / नवीन व्यवसाय जागेचे संपूर्ण वर्णन<span class="text-danger">*</span></label>
                                    <input class="form-control" id="description_of_new_trade_place" name="description_of_new_trade_place" type="text" placeholder="Enter New trade place description" value="{{ $data->description_of_new_trade_place }}" required="" disabled="" readonly="">
                                    <span class="text-danger is-invalid description_of_new_trade_place_err"></span>
                                </div>
{{--
                                <div class="col-md-4">
                                    <label class="col-form-label" for="is_preveious_permission_declined_by_council">is previouly permission declined by council ? / यापूर्वी अर्जात नमूद जागेला व्यवसाय परवाना नाकारला आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="is_preveious_permission_declined_by_council" id="is_preveious_permission_declined_by_council" required>
                                        <option value="">Select Option</option>
                                        <option value="Yes" {{ $data->is_preveious_permission_declined_by_council == "Yes" ? 'selected' : '' }}>Yes</option>
                                        <option value="No" {{ $data->is_preveious_permission_declined_by_council == "No" ? 'selected' : '' }}>No</option>
                                    </select>
                                    <span class="text-danger is-invalid is_preveious_permission_declined_by_council_err"></span>
                                </div> --}}

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="previous_permission_decline_reason">Previous permission decline reason / परवाना नाकारण्याचे कारण<span class="text-danger">*</span></label>
                                    <input class="form-control" id="previous_permission_decline_reason" name="previous_permission_decline_reason" type="text" placeholder="Enter Previous permission decline reason " value="{{ $data->previous_permission_decline_reason }}" required>
                                    <span class="text-danger is-invalid previous_permission_decline_reason_err"></span>
                                </div> --}}

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="is_place_owned_by_council">Is place owned by council ? / जागा पालिकेच्या मालकीची आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="is_place_owned_by_council" id="is_place_owned_by_council" required>
                                        <option value="">Select Option</option>
                                        <option value="Yes" {{ $data->is_place_owned_by_council == "Yes" ? 'selected' : '' }}>Yes</option>
                                        <option value="No" {{ $data->is_place_owned_by_council == "No" ? 'selected' : '' }}>No</option>
                                    </select>
                                    <span class="text-danger is-invalid is_place_owned_by_council_err"></span>
                                </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="is_any_dues_pending_of_council">Is any dues pending of council ? / आपल्याकडे पालिकेची थकबाकी आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="is_any_dues_pending_of_council" id="is_any_dues_pending_of_council" required="" disabled="" readonly="">
                                        <option value="">Select Option</option>
                                        <option value="Yes" {{ $data->is_any_dues_pending_of_council == "Yes" ? 'selected' : '' }}>Yes</option>
                                        <option value="No" {{ $data->is_any_dues_pending_of_council == "No" ? 'selected' : '' }}>No</option>
                                    </select>
                                    <span class="text-danger is-invalid is_any_dues_pending_of_council_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="trade_or_business_type">Trade or business type of new permission / व्यवसायाचा प्रकार <span class="text-danger">*</span></label>
                                    <select class="form-select" name="trade_or_business_type" id="trade_or_business_type" required="" disabled="" readonly="">
                                        <option value="">Select a value ...</option>

                                        @php
                                            $options = ["असोसिएट्स", "आईस्क्रिम पार्लर", "इंजिनियरींग वर्क्स", "इंटिरियल", "इतर", "इलेक्ट्रिकल", "इलेक्ट्रीक अँड हार्डवेअर", "इंशुरन्स", "उपहारगृह", "ऑप्टीकल", "ओल्ड् पेपर मार्ट", "कंट्रक्शन", "कपडा विक्री", "कपड्याचे दुकान", "कांदा-बटाटा दुकान", "कारखाना", "किराणा दुकान", "कुरीअर सर्विस", "कॅटरींग सर्विसेस", "केक शॉप", "केशकर्तनालय / सलुन", "कोल्ड्रींग अँड आईस्क्रीम", "क्लासेस", "क्लीनर", "खादयपदार्थ विक्री", "खानावळ", "गॅरेज", "चक्की", "चाइनीज पॉईंट", "चाय पॉईंट", "चिकन शॉप", "जनरल स्टोर", "जिम फिटनेस", "टेलर", "नर्सरी", "पान बिडी शॉप", "पुस्तक विक्री", "फर्निचर दुकान", "फर्निचर वर्क", "फाटो शॉप", "बांगडी बनविणे", "बेकरी", "बेकरी शॉप / बेकरी प्रोडक्टस", "ब्युटी पार्लर", "मटण शॉप", "मटण-चिकन शॉप", "मसाला विक्री", "मॅन्युफॅक्चरींग", "मेटल पार्ट वर्क", "मेडिकल", "रबर प्रोडक्ट", "रेडीमेंड गारमेंट", "रेस्टॉरंट", "लाँड्री", "लॉजिंग / बोर्डींग", "वेल्डींग", "सायकल रिपेरींग", "सिट कवर असेसरीज", "सेल्स सर्विस", "स्टील फर्निचर", "स्टेनलेस स्टील", "स्टेशनरी", "स्नॅक्स सेंटर", "स्विट मार्ट / मिठाईचे दुकान", "हार्डवेअर"];
                                        @endphp

                                        @foreach($options as $option)
                                        <option {{ $data->trade_or_business_type == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid trade_or_business_type_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="is_any_partnership_in_trade">Is any partnership in trade ? / भागीदारी आहे का?<span class="text-danger">*</span></label>
                                    <select class="form-select" name="is_any_partnership_in_trade" id="is_any_partnership_in_trade" required>
                                        <option value="">Select Option</option>
                                        <option value="Yes" {{ $data->is_any_partnership_in_trade == "Yes" ? 'selected' : '' }}>Yes</option>
                                        <option value="No" {{ $data->is_any_partnership_in_trade == "No" ? 'selected' : '' }}>No</option>
                                    </select>
                                    <span class="text-danger is-invalid is_any_partnership_in_trade_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="partner_count">Partner count / भागीदारांची संख्या <span class="text-danger">*</span></label>
                                    <input class="form-control" id="partner_count" name="partner_count" type="number" placeholder="Enter Partner count" value="{{ $data->partner_count }}" required>
                                    <span class="text-danger is-invalid partner_count_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="partner_names">Partner Names / भागीदारांची नावे<span class="text-danger">*</span></label>
                                    <input class="form-control" id="partner_names" name="partner_names" type="text" placeholder="Enter Partner Names" value="{{ $data->partner_names }}" required>
                                    <span class="text-danger is-invalid partner_names_err"></span>
                                </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_tax_no">Property tax no / मालमत्ता क्रमांक<span class="text-danger">*</span></label>
                                    <input class="form-control" id="property_tax_no" name="property_tax_no" type="number" placeholder="Enter Property tax no" value="{{ $data->property_tax_no }}" required="" disabled="" readonly="">
                                    <span class="text-danger is-invalid property_tax_no_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="no_dues_documents">Upload Certificate Of No Dues / थकबाकी नसल्याचा दाखला अपलोड करा <span class="text-danger">*</span></label>
                                    <div><a href="{{ asset('storage/' . $data->no_dues_document) }}" target="_blank">View Document</a></div>
                                    {{-- <input class="form-control" id="no_dues_documents" name="no_dues_documents" type="file"> --}}
                                    <span class="text-danger is-invalid no_dues_documents_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="application_document">Upload Certificate of no outstanding debts/योग्य प्रकारे भरलेले अर्ज अपलोड करा<span class="text-danger">*</span></label>
                                    <div><a href="{{ asset('storage/' . $data->application_document) }}" target="_blank">View Document</a></div>
                                    {{-- <input class="form-control" id="application_document" name="application_documents" type="file"> --}}
                                    <span class="text-danger is-invalid application_document_err"></span>
                                </div>

                                <div class="col-md-4"  >
                                    <label class="col-form-label" for="prescribed_docs">Upload Application In
                                        Prescribed
                                        Format / विहित नमुन्यातील अर्ज अपलोड करा <span
                                            class="text-danger">*</span></label>
                                    <div><a href="{{ asset('storage/' . $data->prescribed_doc) }}" target="_blank">View Document</a></div>
                                            {{-- <input class="form-control" id="prescribed_docs" name="prescribed_docs"
                                        type="file"> --}}
                                    <span class="text-danger is-invalid prescribed_docs_err"></span>
                                </div>

                                <div class="col-md-3">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" rows="4"></textarea>
                            </div>


                                {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                                <div class="col-md-12">
                                    <div class="form-check d-flex align-items-start">
                                        <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" checked required name="is_correct_info" value="yes">
                                        <label class="form-check-label ms-2" for="is_correct_info">
                                            "All information provided above is correct and I shall be fully responsible for any discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                                        </label>
                                    </div>
                                    <span class="text-danger is-invalid is_correct_info_err"></span>
                                </div> --}}

                            </div>
                        </div>
                        <div class="card-footer">
                          <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button id="btnCancel" class="btn btn-warning">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

</x-admin.layout>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
</script>
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>


{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route("trade-new-license.update", $data->id) }}';
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function()
            {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data)
            {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                        .then((action) => {
                            window.location.href = '{{ route("my-application") }}';
                        });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>

