<x-admin.layout>
    <x-slot name="title">NOC for Pandol/ Mandap / मंडपासाठी ना हरकत प्रमाणपत्र</x-slot>
    <x-slot name="heading">NOC for Pandol/ Mandap / मंडपासाठी ना हरकत प्रमाणपत्र</x-slot>
    @php
        $can_update = Auth::check() && Auth::user()->hasRole('Clerk');
        $approve_require_fields = !empty($data->agnishamak_police_date) && !empty($data->agnishamak_javak_kramank) && !empty($data->stanikpolice_javak_kramank) && !empty($data->stanikpolice_date) && !empty($data->sambandhit_javak_kramank) && !empty($data->sambandhit_date);
    @endphp
    <style>
        .form_select_readonly {
            cursor: not-allowed;
            pointer-events: none;
        }
    </style>
    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Edit Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            <input type="hidden" model-id="id" value="{{ $status->id }}">

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">
                                    Applicant / Public Mandal / Organization Of Full Name & Designation<br>
                                    अर्जदाराचे / सार्वजनिक मंडळाचे / संस्थेचे पूर्ण नाव व पद <span class="text-danger">*</span>
                                </label>
                                <textarea class="form-control" id="applicant_name" name="applicant_name" rows="3" placeholder="Enter Full Name and Designation" readonly required>{{ $data->applicant_name }}</textarea>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_mobile">Applicant/Public Mandal/
                                    Organization Mobile No / अर्जदाराचे/सार्वजनिक मंडळाचे/संस्थेचा मोबाइल क्रमांक<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="applicant_mobile" name="applicant_mobile" placeholder="Enter Mobile Number" readonly maxlength="10" value="{{ $data->applicant_mobile }}" required>
                                <span class="text-danger is-invalid applicant_mobile_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_email">Applicant/Public Mandal/
                                    Organization Email / अर्जदाराचा / सार्वजनिक मंडळाचा / संस्थेचा ई-मेल<span class="text-danger">*</span></label>
                                <input type="email" class="form-control" id="applicant_email" name="applicant_email" placeholder="Enter Email" readonly value="{{ $data->applicant_email }}" required>
                                <span class="text-danger is-invalid applicant_email_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address">Applicant/Public Mandal/
                                    Organization Address / अर्जदाराचा / सार्वजनिक मंडळाचा / संस्थेचा पत्ता<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="applicant_address" name="applicant_address" placeholder="Enter Address" value="{{ $data->applicant_address }}" readonly required>
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="event_name">Name of the festival or event / उत्सव किंवा कार्यक्रमाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="event_name" name="event_name" type="text" placeholder="Enter festival or event Name" value="{{ $data->event_name }}" required>
                                    <span class="text-danger is-invalid event_name_err"></span>
                                </div> --}}




                            <div class="col-md-4">
                                <label class="col-form-label" for="ward_area">Prabhag Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <select class="form-select form_select_readonly" name="ward_area" id="ward_area" readonly required>
                                    <option value="">Select Prabhag Area</option>
                                    @foreach ($wards as $ward)
                                        <option value="{{ $ward->id }}" {{ $data->ward_area == $ward->id ? 'selected' : '' }}>{{ $ward->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_area_err"></span>
                            </div>

                            <!-- Mandap Details -->
                            <div class="col-12 pt-3">
                                <h5 class="fw-bold">2. Pandal / Stage Details / मंडप तपशील</h5>
                                <hr>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="stage_address">
                                    Mandap / Stage Erection Place / मंडप उभारण्याचे ठिकाण
                                    <span class="text-danger">*</span>
                                </label>
                                <textarea class="form-control" readonly name="stage_address" id="stage_address" rows="2" placeholder="Enter Stage Address" required>{{ $data->stage_address }}</textarea>
                                <span class="text-danger is-invalid stage_address_err"></span>
                            </div>


                            <div class="col-md-8">
                                <label class="col-form-label" for="stage_permission_date">
                                    Pandal / Stage Duration (From - To) / मंडपाचा कालावधी (पासून - पर्यंत) <span class="text-danger">*</span>
                                </label>
                                <div class="d-flex gap-2">
                                    <input type="date" class="form-control" id="stage_permission_date" name="stage_permission_date" readonly value="{{ $data->stage_permission_date }}" required>
                                    <input type="date" class="form-control" id="stage_permission_end_date" name="stage_permission_end_date" readonly value="{{ $data->stage_permission_end_date }}" required>
                                </div>
                                <div class="d-flex gap-2">
                                    <span class="text-danger is-invalid stage_permission_date_err w-100"></span>
                                    <span class="text-danger is-invalid stage_permission_end_date_err w-100"></span>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="stage_dimensions">
                                    Pandol Size (Length × Width × Height) / मंडपाचा आकार (लांबी × रुंदी × उंची)
                                    <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control" id="stage_height" name="stage_height" placeholder="Length × Width × Height" readonly value="{{ $data->stage_height }}" required>
                                <span class="text-danger is-invalid stage_height_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="concerned_local_police_station">
                                    Concerned m Local Police Station Office / संबंधित स्थानिक पोलीस ठाणे कार्यालयाचा
                                    तपशील
                                    <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control" id="concerned_traffic_police_station" name="concerned_traffic_police_station" placeholder="Enter Concerned Local Police Station Office" readonly value="{{ $data->concerned_traffic_police_station }} ">
                                <span class="text-danger is-invalid other_police_station_err"></span>
                            </div>


                            <!-- Registration Details -->
                            <div class="col-12 pt-3">
                                <h5 class="fw-bold">3. Registration Details / नोंदणी तपशील</h5>
                                <hr>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="commissioner_name">Name registered with the
                                    Hon. Charity Commissioner / मंडळाचे मा. धर्मादाय आयुक्तांकडील नोंदवलेले नाव
                                    <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="commissioner_name" value="{{ $data->commissioner_name }}" readonly name="commissioner_name" required>
                                <span class="text-danger is-invalid commissioner_name_err"></span>
                            </div>

                             <div class="col-md-4">
                                <label class="col-form-label" for="registration_no">Registration Number from
                                    Hon. Charity Commissioner / मंडळाचा मा. धर्मादाय आयुक्तांकडील नोंदणी क्रमांक
                                    <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="registration_no" value="{{ $data->registration_no }}"  name="registration_no" readonly  required>
                                <span class="text-danger is-invalid registration_no_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="registration_date">
                                    Registration Date / नोंदणीची तारीख <span class="text-danger">*</span>
                                </label>
                                <input type="date" class="form-control" id="registration_date" value="{{ $data->registration_date }}" readonly name="registration_date" required>
                                <span class="text-danger is-invalid registration_date_err"></span>
                            </div>


                            <!-- Additional Questions -->
                            <div class="col-md-4">
                                <label class="col-form-label" for="last_year_permission">
                                    Was Pandal Permission granted last year? / मागील वर्षी मंडप उभारण्यासाठी परवानगी
                                    दिली होती का?
                                    <span class="text-danger">*</span>
                                </label>
                                <select class="form-select form_select_readonly" id="last_year_permission" readonly name="last_year_permission" required>
                                    <option value="">Select Option</option>
                                    <option value="Yes" {{ old('last_year_permission', $data->last_year_permission ?? '') == 'Yes' ? 'selected' : '' }}>
                                        Yes / होय</option>
                                    <option value="No" {{ old('last_year_permission', $data->last_year_permission ?? '') == 'No' ? 'selected' : '' }}>
                                        No / नाही</option>
                                </select>
                                <span class="text-danger is-invalid last_year_permission_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="ganesh_murti_type">
                                    Ganesh Murti Details (Shadu Mati / POP) / गणेश मूर्तीचा तपशील (शाडू माती / पी. ओ.
                                    पी)
                                    <span class="text-danger">*</span>
                                </label>
                                <select class="form-select form_select_readonly" id="ganesh_murti_type" readonly name="ganesh_murti_type" required>
                                    <option value="">Select Type</option>
                                    <option value="Shadu Mati" {{ old('ganesh_murti_type', $data->ganesh_murti_type ?? '') == 'Shadu Mati' ? 'selected' : '' }}>
                                        Shadu Mati / शाडू माती
                                    </option>
                                    <option value="POP" {{ old('ganesh_murti_type', $data->ganesh_murti_type ?? '') == 'POP' ? 'selected' : '' }}>
                                        POP / पी.ओ.पी
                                    </option>
                                </select>
                                <span class="text-danger is-invalid ganesh_murti_type_err"></span>
                            </div>

                            <div class="col-md-4" id="murti_height_div" style="display: none;">
                                <label for="murti_height" class="form-label">Murti Height (Feet) / मूर्तीची उंची <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="murti_height" name="murti_height" placeholder="Enter Height" readonly value="{{ $data->murti_height }}">
                                <span class="text-danger is-invalid murti_height_err"></span>
                            </div>


                            <!-- Uploads Section -->
                            <div class="col-12 pt-3">
                                <h5 class="fw-bold">4. Document Uploads / कागदपत्र अपलोड</h5>
                                <hr>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="location_map_documents">उभारवयाच्या मंडपाच्या ठिकाणाचा नकाशा<span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->location_map_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="location_map_documents" name="location_map_documents"
                                    type="file"> --}}
                                <span class="text-danger is-invalid location_map_documents_err"></span>
                            </div>



                            <div class="col-md-4">
                                <label class="col-form-label" for="board_registration_documents">संस्था नोंदणी प्रमाणपत्र <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->board_registration_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="board_registration_documents"
                                    name="board_registration_documents" type="file"> --}}
                                <span class="text-danger is-invalid board_registration_documents_err"></span>
                            </div>






                            <div class="col-md-4" id="last_year_copy_div" style="@if($data->last_year_permission == "No") display: none;@endif">
                                <label class="col-form-label" for="mandap_documents">मागील वर्षी मंडप उभारणेस दिलेल्या परवानगीची प्रत<span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->mandap_documents) }}" target="_blank">View
                                        Document</a></div>
                                {{-- <input class="form-control" id="mandap_documents" name="mandap_documents"
                                    type="file" required> --}}
                                <span class="text-danger is-invalid mandap_documents_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="local_polic_documents">स्थानिक पोलीस ठाणे यांचेकडील ना-हरकत दाखला<span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->local_polic_documents) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="local_polic_documents" name="local_polic_documents"
                                    type="file" required> --}}
                                <span class="text-danger is-invalid local_polic_documents_err"></span>
                            </div>



                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="no_objection_documents">No objection certificate from the owner of the premises / जागेच्या मालकाचा ना हरकत दाखला<span class="text-danger">*</span></label>
                                    <div><a href="{{ asset('storage/' . $data->no_objection_document) }}" target="_blank">View Document</a></div>
                                    <input class="form-control" id="no_objection_documents" name="no_objection_documents" type="file">
                                    <span class="text-danger is-invalid no_objection_documents_err"></span>
                                </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="traffic_last_year_noObjection_documents">वाहतूक पोलीस ठाणे यांचेकडील ना-हरकत दाखला</label>
                                <div><a href="{{ asset('storage/' . $data->traffic_last_year_noObjection_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="traffic_last_year_noObjection_documents"
                                    name="traffic_last_year_noObjection_documents" type="file"> --}}
                                <span class="text-danger is-invalid traffic_last_year_noObjection_documents_err"></span>
                            </div>



                            <div class="col-md-4">
                                <label class="col-form-label" for="fire_last_year_noObjection_documents">महापालिकेचे अग्निशमन दलाचा ना-हरकत दाखला</label>
                                <div><a href="{{ asset('storage/' . $data->fire_last_year_noObjection_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="fire_last_year_noObjection_documents"
                                    name="fire_last_year_noObjection_documents" type="file"> --}}
                                <span class="text-danger is-invalid fire_last_year_noObjection_documents_err"></span>
                            </div>

                            <div class="col-md-6" id="upload_section">
                                <label class="col-form-label" for="prescribed_doc">Upload Application In Prescribed <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->prescribed_doc) }}" target="_blank">View Document</a></div>
                                <span class="text-danger is-invalid prescribed_doc_err"></span>
                            </div>
                        </div>






                        <div class="col-12 pt-3 mt-2">
                            <h5 class="fw-bold">5. Javak Kramk Details / कागदपत्र</h5>
                            <hr>
                        </div>


                        {{-- @if (Auth::check() && Auth::user()->hasRole('Clerk'))
    @if (empty($data->agnishamak_javak_kramank))
        <div class="row mb-3">
            <div class="col-md-12 fw-bold">
                अग्निशामक दलाचा ना हरकत दाखला<span class="text-danger">*</span>
            </div>

            <div class="col-md-6 mt-2">
                <label>जावक क्रमांक</label>
               <input type="text" name="agnishamak_javak_kramank" class="form-control" value="{{ $data->agnishamak_javak_kramank }}" placeholder="Enter Javak Kramank" {{ empty($data->agnishamak_javak_kramank) ? '' : 'readonly' }}>
            </div>

            <div class="col-md-6 mt-2">
                <label>दिनांक</label>
 <input type="date"
                   name="agnishamak_police_date"
                   class="form-control"
                   value="{{ old('agnishamak_police_date', $data->agnishamak_police_date ? \Carbon\Carbon::parse($data->agnishamak_police_date)->format('Y-m-d') : '') }}"
                   {{ !empty($data->agnishamak_police_date) ? 'readonly' : '' }}>
            </div>
        </div>
    @else
        <div class="row mb-3">
            <div class="col-md-12 fw-bold">
                अग्निशामक दलाचा ना हरकत दाखला<span class="text-danger">*</span>
            </div>

            <div class="col-md-6 mt-2">
                <label>जावक क्रमांक</label>
<input type="text" name="agnishamak_javak_kramank" class="form-control" value="{{ $data->agnishamak_javak_kramank }}" placeholder="Enter Javak Kramank" readonly>
            </div>

            <div class="col-md-6 mt-2">
                <label>दिनांक</label>
 <input type="date"
                   name="agnishamak_police_date"
                   class="form-control"
                   value="{{ old('agnishamak_police_date', $data->agnishamak_police_date ? \Carbon\Carbon::parse($data->agnishamak_police_date)->format('Y-m-d') : '') }}"
                   {{ !empty($data->agnishamak_police_date) ? 'readonly' : '' }}>            </div>
        </div>
    @endif
@endif




@if (Auth::check() && Auth::user()->hasRole('Clerk'))
    @if (empty($data->stanikpolice_javak_kramank))
        <div class="row mb-3">
            <div class="col-md-12 fw-bold">
                स्थानिक पोलीस ठाण्याकडील ना हरकत दाखला <span class="text-danger">*</span>
            </div>

            <div class="col-md-6 mt-2">
                <label>जावक क्रमांक</label>
<input type="text" name="stanikpolice_javak_kramank"
       class="form-control"
       value="{{ old('stanikpolice_javak_kramank', $data->stanikpolice_javak_kramank) }}"
       placeholder="Enter Javak Kramank"
       {{ !empty($data->stanikpolice_javak_kramank) ? 'readonly' : '' }}>            </div>

            <div class="col-md-6 mt-2">
                <label>दिनांक</label>
              <input type="date" name="stanikpolice_date"
       class="form-control"
       value="{{ old('stanikpolice_date', $data->stanikpolice_date) }}"
       {{ !empty($data->stanikpolice_date) ? 'readonly' : '' }}>
            </div>
        </div>
    @else
        <div class="row mb-3">
            <div class="col-md-12 fw-bold">
                स्थानिक पोलीस ठाण्याकडील ना हरकत दाखला <span class="text-danger">*</span>
            </div>

            <div class="col-md-6 mt-2">
                <label>जावक क्रमांक</label>
                <input type="text" name="stanikpolice_javak_kramank" class="form-control" value="{{ $data->stanikpolice_javak_kramank }}" placeholder="Enter Javak Kramank" readonly>
            </div>

            <div class="col-md-6 mt-2">
                <label>दिनांक</label>
                <input type="date" name="stanikpolice_date" class="form-control" value="{{ $data->stanikpolice_date }}" readonly>
            </div>
        </div>
    @endif
@endif



@if (Auth::check() && Auth::user()->hasRole('Clerk'))
    @if (empty($data->sambandhit_javak_kramank))
        <div class="row mb-3">
            <div class="col-md-12 fw-bold">
                संबंधित वाहतूक पोलिसांचा ना हरकत दाखला <span class="text-danger">*</span>
            </div>

            <div class="col-md-6 mt-2">
                <label>जावक क्रमांक</label>
                <input type="text" name="sambandhit_javak_kramank" class="form-control" placeholder="Enter Javak Kramank">
            </div>

            <div class="col-md-6 mt-2">
                <label>दिनांक</label>
               <input type="date"
       name="sambandhit_date"
       class="form-control"
       value="{{ old('sambandhit_date', $data->sambandhit_date ? \Carbon\Carbon::parse($data->sambandhit_date)->format('Y-m-d') : '') }}">
            </div>
        </div>
    @else
        <div class="row mb-3">
            <div class="col-md-12 fw-bold">
                संबंधित वाहतूक पोलिसांचा ना हरकत दाखला <span class="text-danger">*</span>
            </div>

            <div class="col-md-6 mt-2">
                <label>जावक क्रमांक</label>
                <input type="text" name="sambandhit_javak_kramank" class="form-control" value="{{ $data->sambandhit_javak_kramank }}" placeholder="Enter Javak Kramank" readonly>
            </div>

            <div class="col-md-6 mt-2">
                <label>दिनांक</label>
               <input type="date"
       name="sambandhit_date"
       class="form-control"
       value="{{ old('sambandhit_date', $data->sambandhit_date ? \Carbon\Carbon::parse($data->sambandhit_date)->format('Y-m-d') : '') }}">
            </div>
        </div>
    @endif
@endif --}}
                        <!--kishroi end backup codde-->




                        <div class="row mb-3">
                            <div class="col-md-12 fw-bold">
                                अग्निशामक दलाचा ना हरकत दाखला<span class="text-danger">*</span>
                            </div>

                            <div class="col-md-3 mt-2">
                                <label>जावक क्रमांक<span class="text-danger">*</span></label>
                                <input type="text" name="agnishamak_javak_kramank" class="form-control" value="{{ $data->agnishamak_javak_kramank }}" placeholder="Enter Javak Kramank" @if (!$can_update) readonly @endif>
                                <span class="text-danger is-invalid agnishamak_javak_kramank_err"></span>
                            </div>

                            <div class="col-md-3 mt-2">
                                <label>दिनांक<span class="text-danger">*</span></label>
                                <input type="date" name="agnishamak_police_date" class="form-control" value="{{ old('agnishamak_police_date', $data->agnishamak_police_date ? \Carbon\Carbon::parse($data->agnishamak_police_date)->format('Y-m-d') : '') }}" @if (!$can_update) readonly @endif>
                                <span class="text-danger is-invalid agnishamak_police_date_err"></span>

                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-12 fw-bold">
                                स्थानिक पोलीस ठाण्याकडील ना हरकत दाखला <span class="text-danger">*</span>
                            </div>

                            <div class="col-md-3 mt-2">
                                <label>जावक क्रमांक<span class="text-danger">*</span></label>
                                <input type="text" name="stanikpolice_javak_kramank" class="form-control" value="{{ old('stanikpolice_javak_kramank', $data->stanikpolice_javak_kramank) }}" placeholder="Enter Javak Kramank" @if (!$can_update) readonly @endif>
                                <span class="text-danger is-invalid stanikpolice_javak_kramank_err"></span>
                            </div>

                            <div class="col-md-3 mt-2">
                                <label>दिनांक<span class="text-danger">*</span></label>
                                <input type="date" name="stanikpolice_date" class="form-control" value="{{ old('stanikpolice_date', $data->stanikpolice_date) }}" @if (!$can_update) readonly @endif>
                                <span class="text-danger is-invalid stanikpolice_date_err"></span>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-12 fw-bold">
                                संबंधित वाहतूक पोलिसांचा ना हरकत दाखला <span class="text-danger">*</span>
                            </div>

                            <div class="col-md-3 mt-2">
                                <label>जावक क्रमांक<span class="text-danger">*</span></label>
                                <input type="text" name="sambandhit_javak_kramank" class="form-control" value="{{ old('sambandhit_javak_kramank', $data->sambandhit_javak_kramank) }}" placeholder="Enter Javak Kramank" @if (!$can_update) readonly @endif>
                                <span class="text-danger is-invalid sambandhit_javak_kramank_err"></span>
                            </div>

                            <div class="col-md-3 mt-2">
                                <label>दिनांक<span class="text-danger">*</span></label>
                                <input type="date" name="sambandhit_date" class="form-control" value="{{ old('sambandhit_date', $data->sambandhit_date ? \Carbon\Carbon::parse($data->sambandhit_date)->format('Y-m-d') : '') }}" @if (!$can_update) readonly @endif>
                                <span class="text-danger is-invalid sambandhit_date_err"></span>
                            </div>
                        </div>

                        <hr>


                        <div class="col-md-6">
                            <label for="remark">Remark<span class="text-danger">*</span></label>
                            <textarea id="Remark" name="remark" class="form-control" rows="4"></textarea>
                        </div>






                        {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="annexures">annexure -1 / घोषणापत्र </label>
                                    <div><a href="{{ asset('storage/' . $data->annexure) }}" target="_blank">View Document</a></div>
                                    <input class="form-control" id="annexures" name="annexures" type="file">
                                    <span class="text-danger is-invalid annexures_err"></span>
                                </div> --}}

                        {{-- <label class="col-form-label" for="is_correct_info">स्वीकरण:</label>
                        <div class="col-md-12">
                            <div class="form-check d-flex align-items-start">
                                <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" checked
                                    required name="is_correct_info" value="yes">
                                <label class="form-check-label ms-2" for="is_correct_info">
                                    "All information provided above is correct and I shall be fully responsible for any
                                    discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची
                                    तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                                </label>
                            </div>
                            <span class="text-danger is-invalid is_correct_info_err"></span>
                        </div> --}}
                    </div>
            </div>
            <div class="card-footer">

                <button type="button" class="btn btn-primary approveBtn" @if ($can_update && !$approve_require_fields) disabled @endif data-id="{{ $status->id }}">Approve</button>
                <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                {{-- <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button> --}}
                {{-- <button type="reset" class="btn btn-warning">Reset</button> --}}
                <button type="button" id="btnCancel" class="btn btn-warning">Cancel</button>
                @if ($can_update)
                    <button type="submit" class="btn btn-secondary" id="addSubmit">Update</button>
                @endif
            </div>
            </form>
        </div>
    </div>
    </div>


    <!-- Modal -->
    <!-- Modal -->
    <div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Download Your Rejection Note Certificate</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-footer">
                    <a href="{{ array_key_exists($data->service_id, $servicename) && $servicename[$data->service_id] != '' ? route($servicename[$data->service_id], encrypt($data->id)) : '#' }}" class="btn btn-primary btn-sm p-1" style="display:block;">
                        Rejected Certificate Download
                    </a>

                    {{-- <button type="button" class="btn btn-danger ">Reject</button> --}}
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

</x-admin.layout>



<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });

    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route('trade-noc-mandap.update', $data->id) }}';
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Updated Sucessfully!',
                    text: response.message,
                    confirmButtonText: 'OK'
                }).then(() => {
                    window.location.href = '{{ route('pendinglist') }}';
                });
            },
            statusCode: {
                422: function(response) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(response.responseJSON.errors);
                },
                500: function() {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occurred!", "Something went wrong, please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
<!--hdie and show magil vershi mandap ubharnes-->
<script>
    document.getElementById('last_year_permission').addEventListener('change', function() {
        var permission = this.value;
        var fileDiv = document.getElementById('last_year_copy_div');
        var fileInput = document.getElementById('mandap_documents');

        if (permission === 'Yes') {
            fileDiv.style.display = 'block';
            fileInput.required = true;
        } else {
            fileDiv.style.display = 'none';
            fileInput.required = false;
            fileInput.value = ''; // Clear file if user changes to No
        }
    });
</script>
<!--ganesh murti basis hide and show height filed-->
<script>
    function toggleMurtiHeight() {
        var selected = $('#ganesh_murti_type').val();
        if (selected === 'Shadu Mati' || selected === 'POP') {
            $('#murti_height_div').show();
        } else {
            $('#murti_height_div').hide();
            $('#murti_height').val('');
        }
    }

    // Trigger on page load
    $(document).ready(function() {
        toggleMurtiHeight(); // Initial check
        $('#ganesh_murti_type').on('change', toggleMurtiHeight); // On change
    });
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

{{-- <script>
    document.getElementById('saveAndPrintBtn').addEventListener('click', function () {
        document.getElementById('upload_section').style.display = 'block';
        document.getElementById('card-footer').style.display = 'block';




        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;
        const printContainerClone = addContainer.cloneNode(true);
        printContainerClone.style.fontSize = '16px';
        printContainerClone.style.lineHeight = '1.4';
        printContainerClone.style.padding = '20px';
        printContainerClone.style.margin = '0 auto';
        printContainerClone.style.background = '#fff';
        printContainerClone.style.width = '210mm';
        printContainerClone.style.minHeight = '297mm';
        printContainerClone.style.boxSizing = 'border-box';
        Array.from(printContainerClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });
        const printTitle = document.createElement('h2');
        printTitle.style.textAlign = 'center';
        printTitle.style.marginBottom = '18px';
        printTitle.style.fontSize = '18px';
        printTitle.textContent = 'PWD Electrical for Strom Drain Water ';
        printContainerClone.insertBefore(printTitle, printContainerClone.firstChild);
        Array.from(printContainerClone.querySelectorAll('button')).forEach(btn => btn.remove());
        Array.from(printContainerClone.querySelectorAll('.card')).forEach(card => {
            card.style.background = 'white';
            card.style.boxShadow = 'none';
            card.style.border = '1px solid #ccc';
            card.style.marginBottom = '12px';
            card.style.padding = '12px';
        });
        Array.from(printContainerClone.querySelectorAll('input[type="file"]')).forEach(input => {
            const parent = input.parentNode;
            const fileName = input.files && input.files.length > 0 ? input.files[0].name : 'No file chosen';
            const fileInfo = document.createElement('div');
            fileInfo.textContent = 'Selected file: ' + fileName;
            parent.appendChild(fileInfo);
            input.style.display = 'none';
        });

        Array.from(printContainerClone.querySelectorAll('select')).forEach(select => {
            const selected = select.options[select.selectedIndex];
            const info = document.createElement('div');
            info.textContent = 'Selected: ' + (selected ? selected.text : '');
            select.parentNode.appendChild(info);
            select.style.display = 'none';
        });

        Array.from(printContainerClone.querySelectorAll('.selected-value')).forEach(div => {
            div.classList.remove('d-none');
        });

        Array.from(printContainerClone.querySelectorAll('input[type="checkbox"]')).forEach(checkbox => {
            const info = document.createElement('div');
            info.textContent = checkbox.checked ? 'Checked' : 'Not checked';
            checkbox.parentNode.appendChild(info);
            checkbox.style.display = 'none';
        });
        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printContainerClone);
        html2canvas(printContainerClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const pageWidth = pdf.internal.pageSize.getWidth();
            const pageHeight = pdf.internal.pageSize.getHeight();
            const margin = 10;
            const pdfWidth = pageWidth - margin * 2;
            const pdfHeight = pageHeight - margin * 2;
            pdf.addImage(imgData, 'JPEG', margin, margin, pdfWidth, pdfHeight);
            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content or try again.');
            }
            pdf.save('NOC_for_Pandol_Mandap.pdf');
            document.getElementById('saveAndPrintBtn').style.display = 'none';
        });
    });

    function updateSelectedValue(selectId) {
        var select = document.getElementById(selectId);
        var selectedText = select.options[select.selectedIndex] ? select.options[select.selectedIndex].text : '';
        var selectedDiv = document.getElementById(selectId + '_selected');
        if (!selectedDiv) {
            selectedDiv = document.createElement('div');
            selectedDiv.id = selectId + '_selected';
            selectedDiv.className = 'selected-value';
            select.parentNode.appendChild(selectedDiv);
        }
        selectedDiv.textContent = 'Selected: ' + selectedText;
        selectedDiv.classList.remove('d-none');
    }

    document.getElementById('authorization').addEventListener('change', function () {
        updateSelectedValue('authorization');
    });

    updateSelectedValue('authorization');
</script> --}}

<!--validation script-->
<!--applicant name script-->

<script>
    document.getElementById('applicant_name').addEventListener('input', function(e) {

        this.value = this.value.replace(/[^A-Za-z\u0900-\u097F\s]/g, '');
    });
</script>

<!--mobile no validation-->
<script>
    document.getElementById('applicant_mobile').addEventListener('input', function(e) {
        // Remove all non-numeric characters
        this.value = this.value.replace(/[^0-9]/g, '');

        // Limit to 10 digits
        if (this.value.length > 10) {
            this.value = this.value.slice(0, 10);
        }
    });
</script>
<!--email validation-->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const emailField = document.getElementById('applicant_email');
        const errorSpan = document.querySelector('.applicant_email_err');

        emailField.addEventListener('input', function() {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

            if (!emailRegex.test(emailField.value.trim())) {
                errorSpan.textContent = "Please enter a valid email address.";
            } else {
                errorSpan.textContent = "";
            }
        });
    });
</script>

<!--approve reject button code -->
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });

    //reject script//
    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            $('#rejectModal').modal('show');
                            // window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
    //kishori code //
    $(document).ready(function() {
        let currentStatusId = null;

        // Reject button click → open modal
        // $('.rejectBtn').on('click', function () {
        //     currentStatusId = $(this).data('id');
        //     $('#rejectModal').modal('show');
        // });

        // // Directly on Reject (No Confirm)
        // $('#rejectModal').on('click', '.rejectBtn', function () {
        //     let remark = $('#Remark').val();

        //     if (remark !== null && remark.trim() !== '') {
        //         $.ajax({
        //             url: '/reject-item/' + currentStatusId,
        //             type: 'POST',
        //             data: {
        //                 _token: '{{ csrf_token() }}',
        //                 remark: remark
        //             },
        //             success: function (response) {
        //                 // पहले PDF download

        //                 window.location.href = '/download-rejection-certificate/' + currentStatusId;

        //                 // फिर success message और redirect
        //                 Swal.fire({
        //                     icon: 'success',
        //                     title: 'Success!',
        //                     text: response.message,
        //                     confirmButtonText: 'OK'
        //                 }).then(() => {
        //                     window.location.href = response.redirect_url;
        //                 });

        //                 // $('#rejectModal').modal('hide');
        //             },
        //             error: function (xhr) {
        //                 Swal.fire({
        //                     icon: 'error',
        //                     title: 'Error!',
        //                     text: 'Error: ' + xhr.responseText,
        //                     confirmButtonText: 'OK'
        //                 });
        //             }
        //         });
        //     } else {
        //         Swal.fire({
        //             icon: 'warning',
        //             title: 'Warning!',
        //             text: 'Please Add Remark',
        //             confirmButtonText: 'OK'
        //         });
        //     }
        // });
    });
</script>
