<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        p {
            margin-top: 1px;
        }

        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
        }

        .header,

        .footer {
            text-align: center;
        }

        .content {
            margin-top: 0px;
        }

        /* .sub-header {
            text-align: right;
        } */
        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }

        .points {
            margin-top: 20px;
        }

        .points li {
            margin-bottom: 7px;
            margin-left: 5%;
        }

        p {
            font-size: 18px;
        }
    </style>
</head>

<body>

    <div class="header">
        @php
            $logoData = file_get_contents(public_path('admin/images/favicon.png'));
            $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
            $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
            $base64Logo = base64_encode($logoData);
            $base64Logo2 = base64_encode($logoData2);
            $base641Logo = base64_encode($logoData1);
        @endphp
        {{-- <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150"
            width="150"> --}}
             {{-- <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150"> --}}
        {{-- <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo" style="float:right;margin-top:35px;" height="150"
            width="150"> --}}
            <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" style="float:left;margin-top:30px;"height="120" width="150">
        <div class="rox">
            <h2>मिरा भाईंदर महानगरपालिका</h2>
            <p>स्व.इंदिरा गांधी भवन,मुख्य कार्यालय, छत्रपती शिवाजी महाराज मार्ग, भाईंदर (प.), ता. ठाणे-४०११०१</p>
            <p>दूरध्वनी क्र.२८१९२४८</p>
            {{-- <h3>मंडपासाठी ना हरकत प्रमाणपत्र</h3> --}}
              <h3 style="margin-left: 8rem">मंडपासाठी ना हरकत प्रमाणपत्र</h3>
        </div>
    </div>
    <hr>
    <hr style="1px solid #000; height:5px; background-color:#000;">

    <div class="sub-header">
        <p>जा.क्र. मनपा/प्र.का.{{$data->ward_area}} / {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/2025-2026
            <span style="float:right;">
                दि. {{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }}
            </span>
        </p>
    </div>

    <p>प्रति,<br>
        {{ $data->applicant_name }}<br>
        {{ $data->applicant_address }}
    </p>

    <p style="margin-left:20%;"><strong>विषय :</strong> सार्वजनिक उत्सव साजरा करणेकरीता मंडप उभारणेस परवानगी देणेबाबत.
    </p>

    {{-- <div style="display: flex; margin-left:20%;">
        <p style="margin: 0 10px 0 0;"><strong>संदर्भ :</strong></p>
        <ol class="points" style="margin: 0; padding-left: 0;width:80%">
            <li>महापालिकेचे आदेश जा.क्र.मनपा/अवि/447/2025-26 दि.01/08/2025</li>
            <li>महापालिकेचे सुधारित आदेश जा. क्र. मनपा/अवि/ /2025-26 दि. ….. /08/2025</li>
            <li>आपला दि.{{ \Carbon\Carbon::parse($data->created_at)->format('d-m-Y') }} रोजी प्राप्त झालेला अर्ज.</li>
            <li>स्थानिक पोलीस ठाणे, यांचेकडील ना-हरकत दाखला जावक क्र. 954 दि.22/07/2025</li>
            <li>पोलीस वाहतूक शाखा, यांचेकडील ना-हरकत दाखला जावक क्र. 1241 दि.24/07/2025</li>
            <li>महानगरपालिका अग्निशमन दलाचे ना-हरकत दाखला जावक क्र. 278 दि. 05/08/2025</li>
        </ol>
    </div> --}}
    <div style="display: flex; margin-left:20%;">
        <!-- Scanner Image/Icon -->


        <!-- Text Content -->
        <div>
            <p style="margin: 0 10px 0 0;"><strong>संदर्भ :</strong></p>
            <ol class="points" style="margin: 0; padding-left: 0; width: 80%;">
                <li>महापालिकेचे आदेश जा.क्र.मनपा/अवि/447/2025-26 दि.01/08/2025</li>
                <li>महापालिकेचे सुधारित आदेश जा. क्र. मनपा/अवि/ /2025-26 दि.08/08/2025</li>
                <li>आपला दि.{{ \Carbon\Carbon::parse($data->created_at)->format('d-m-Y') }} रोजी प्राप्त झालेला अर्ज क्र..<strong>{{$data->application_no}}</strong>
                </li>
                {{-- <li>स्थानिक पोलीस ठाणे, यांचेकडील ना-हरकत दाखला जावक क्र.
                    <strong>{{$data->stanikpolice_javak_kramank}}</strong>
                    दि.<strong>{{ \Carbon\Carbon::parse($data->stanikpolice_date)->format('d-m-Y') }}</strong></b>
                </li>
                <li>पोलीस वाहतूक शाखा, यांचेकडील ना-हरकत दाखला जावक क्र.
                    <strong>{{$data->sambandhit_javak_kramank}}</strong>
                    दि.<strong>{{ \Carbon\Carbon::parse($data->sambandhit_date)->format('d-m-Y') }}</strong></b>
                </li>
                <li>महानगरपालिका अग्निशमन दलाचे ना-हरकत दाखला जावक क्र.
                    <strong>{{$data->agnishamak_javak_kramank}}</strong>
                        दि.<strong>{{ \Carbon\Carbon::parse($data->agnishamak_police_date)->format('d-m-Y') }}</strong></b>
                </li> --}}
     <li>
    स्थानिक पोलीस ठाणे, यांचेकडील ना-हरकत दाखला जावक क्र.
    <strong>{{ $data->stanikpolice_javak_kramank }}</strong>
    दि.
    @if(!empty($data->stanikpolice_date))
        <strong>{{ \Carbon\Carbon::parse($data->stanikpolice_date)->format('d-m-Y') }}</strong>
    @endif
</li>

<li>
    पोलीस वाहतूक शाखा, यांचेकडील ना-हरकत दाखला जावक क्र.
    <strong>{{ $data->sambandhit_javak_kramank }}</strong>
    दि.
    @if(!empty($data->sambandhit_date))
        <strong>{{ \Carbon\Carbon::parse($data->sambandhit_date)->format('d-m-Y') }}</strong>
    @endif
</li>

<li>
    महानगरपालिका अग्निशमन दलाचे ना-हरकत दाखला जावक क्र.
    <strong>{{ $data->agnishamak_javak_kramank }}</strong>
    दि.
    @if(!empty($data->agnishamak_police_date))
        <strong>{{ \Carbon\Carbon::parse($data->agnishamak_police_date)->format('d-m-Y') }}</strong>
    @endif
</li>


            </ol>
        </div>
    </div>
    </br>
    </br>


    <div class="content">
        <p>वरील संदर्भिय विषयानुसार आपणांस कळविण्यात येते की, मिरा-भाईंदर महानगरपालिका क्षेत्रात स्थळ :-
            <b>{{$data->stage_address}}</b> या ठिकाणी असलेल्या सार्वजनिक
            @php
                use Carbon\Carbon;

                $startDate = Carbon::parse($data->stage_permission_date);
                $endDate = Carbon::parse($data->stage_permission_end_date);
                $totalDays = $startDate->diffInDays($endDate) + 1;
            @endphp
            रस्त्यावर/ पदपथावर दि.
            <b><strong>{{ \Carbon\Carbon::parse($data->stage_permission_date)->format('d-m-Y') }}</strong></b> ते
            दि.<b><strong>{{ \Carbon\Carbon::parse($data->stage_permission_end_date)->format('d-m-Y') }}</strong></b>
            पर्यंत (एकुण <b><strong>{{ $totalDays }}</strong></b> दिवस) मंडप/स्टेज उभारणेस


            खालील अटी-शर्तीनुसार परवानगी देण्यात येत आहे.
        </p>

        <p><strong>मंडप उभारणेसाठीच्या अटीशर्ती :</strong></p>
        <ol class="points">
            <li>आपल्या सार्वजनिक उत्सव मंडळाची नोंदणी असणे आवश्यक आहे.</li>
            <li>मंडप परवानगीची प्रत मंडपाच्या दर्शनी भागांवर प्रदर्शित करणे बंधनकारक आहे.</li>
            <li>प्रस्तावित मंडप/ स्टेजची रुंदी रस्त्याच्या ¼ पेक्षा अधिक असणार नाही. या मर्यादेच्या आतील आकारमानाचे
                मंडप/ स्टेज
                उभारण्यास परवानगी देण्यात येत आहे. (सार्वजनिक वाहतुकीस अडथळा येणार नाही व नागरिकांना त्यापासून उपद्रव
                तसेच आक्षेपार्ह
                होणार नाही याची दक्षता घेण्यात यावी.)</li>
            <li>ज्या प्रस्तावित मंडप/ स्टेज इ. उभारणीची जागा ही परिवहन सेवेच्या बस मार्गावर असेल त्या रस्त्यावर मंडप/
                स्टेज इ.
                उभारणेकरीता किमान 12 फुट रुंद जागा ही बसेस, रिक्षा व सार्वजनिक वाहतुकीतील ट्रॅककरीता उपलब्ध राहील, याची
                दक्षता घेण्यात
                यावी.
            </li>
            <li>मंडप/स्टेज इ. उभारणी करताना ते रोड जंक्शनपासून किमान रस्त्याच्या रुंदीच्या अर्धे याप्रमाणे जंक्शनपासून
                लांब राहील यांची
                दक्षता घेण्यात यावी. जेणेकरुन वाहने वळविणे सोपे होईल.
            </li>
            <li>कोणत्याही ठिकाणी 8 फुट व त्यापेक्षा कमी असलेल्या रस्त्याच्या जागेत मंडप/ स्टेज इ. उभारणेस मनाई आहे.
                मंडप/ स्टेज इ. अंतर
                विद्युत तार व डी.पी. बॉक्स पेक्षा 6 फुट अंतरावर ठेवणे बंधनकारक आहे.</li>
            <li>मंडप/ स्टेज इ. उभारणी करण्यासाठी कोणत्याही ठिकाणाचा सिमेंट काँक्रिट रस्ता अथवा पॅसेज असलेल्या
                पृष्ठभागावर खोदाई मनाई
                आहे. मंडप उभारतांना वाळूने भरलेल्या ड्रमवर मंडप/ स्टेज याकरीता आवश्यक असणारे बांबू रोवून त्यापासून अथवा
                पुर्वनियोजित
                व्यवस्थापनाप्रमाणे मंडप/ स्टेज याकरीता बांबू रोवण्यात यावेत. रस्ते/ सार्वजनिक खोदाई करुन मंडप/ स्टेज इ.
                उभारणी केल्याचे
                निदर्शनास आल्यास रस्ते अनधिकृतपणे खोदाईबाबत कायदेशीर कारवाई करण्यात येईल.
            </li>
            <li>ज्या ठिकाणी पक्क्या स्वरुपाचे रस्ते दुभाजक आहेत, अशा ठिकाणी पदपथ व दुभाजक यामधील रस्त्याच्या भागातील 12
                फुटा व्यतिरिक्त
                उर्वरित मंडपाची उभारणी करावी.
            </li>
        </ol>

        <p><strong>कायदेशीर कारवाई :</strong></p>
        <ol class="points" start="9">
            <li>परवानगी दिल्या व्यतिरिक्त किंवा परवानगी शिवाय मंडप/स्टेज उभारल्यास स्थानिक पोलिस अधिकाऱ्यांच्या मदतीने,
                अनधिकृत वा वाढीव
                मंडप/ स्टेज काढून टाकण्यात येतील. तसेच संबंधितांवर योग्य ती कायदेशीर कारवाई करण्यात येईल.
            </li>
            <li>मंडप व्यतिरिक्त रस्त्यावर कमानी उभारणेस परवानगी नसल्याने, कमानी उभारल्यास ती तात्काळ स्थानिक पोलिस
                अधिकाऱ्यांच्या मदतीने
                काढून टाकण्यात येईल.</li>
        </ol>

        <p><strong>विद्युत जोडणी/ रोषणाई बाबतच्या अटीशर्ती :</strong></p>
        <ol class="points" start="11">
            <li>मंडपाकरीता विद्युत जोडणी महापालिकेच्या कोणत्याही रस्त्यावरील विद्युत पोलमधुन घेता येणार नाही. असे आढळून
                आल्यास संबंधीत
                मंडळावर दंडात्मक कारवाई करुन त्यांची परवानगी रद्द करण्यात येईल.
            </li>
            <li>महानगरपालिकेच्या विद्युत विभागामार्फत, उभारण्यात आलेल्या मंडपातील विद्युत संच मांडणीची तपासणी करण्यात
                येईल. जर त्यामध्ये
                त्रृटी असल्यास विद्युत त्रृटीची पूर्तता करुन घेणे बंधनकारक राहील.
            </li>
            <li>झाडांवर व विद्युत पोलवर विद्युत रोषणाई करण्यास मनाई आहे. झाडांवर व विद्युत पोलवर रोषणाई केली असल्याचे
                आढळून आल्यास ती
                तात्काळ काढून टाकण्याची कारवाई करण्यात येईल.
            </li>
        </ol>

        <p><strong>पर्यावरण विषयक अटीशर्ती:</strong></p>
        <ol class="points" start="14">
            <li>पर्यावरण संवर्धनाच्या दृष्टीने सार्वजनिक उत्सव मंडळाने स्थापन करावयाची मूर्ती, सजावट आणि देखावे शक्यतो
                शाडू माती /
                पर्यावरणपूरक साहित्याने घडविलेली असावी असे आवाहन करण्यात येत आहे.
            </li>
            <li>मिरा भाईंदर महानगरपालिकिा कार्यक्षेत्रात 6 फूट उंची पेक्षा कमी उंचीच्या सर्व मूर्त्यांचे विसर्जन हे
                कृत्रिम तलावातच केले
                जाईल याबाबत आवश्यक ती खबरदारी घ्यावी, असे निर्देश देण्यात येत आहेत.
            </li>
            <li>मोठ्या आकाराच्या मुर्तीची प्राणप्रतिष्ठा करण्यात आल्यास सदर मुर्तीऐवजी विसर्जनासाठी प्रतिकात्मक स्वरुपात
                लहान मूर्तीचा
                वापर करावा. तसेच प्रतिष्ठापित मुर्तीचा वापर पुढील वर्षी करण्याबाबत आवाहन करण्यात येत आहे.</li>
            <li> मंडप परिसरातील स्वच्छते बाबत खबरदारी/ काळजी घेऊन अस्वच्छता निर्माण होऊ नये याकरीता कचऱ्याचे तीन
                स्वतंत्र डबे ठेवावेत.
                (ओला कचऱ्यासाठी हिरवा डबा, सुका कचऱ्यासाठी निळा डबा, घातक/ रासायनिक कचऱ्यासाठी लाल डबा) तसेच पर्यावरण
                विषयक सर्व
                नियमांचे पालन करणे बंधनकारक आहे.
            </li>
            <li>मुर्ती विसर्जनच्या वेळी पुष्पहार, निर्माल्य व सजावट साहित्य पाण्यामध्ये न सोडता महापालिकेने ठेवण्यात
                आलेल्या निर्माल्य
                कलशात टाकण्यात यावे.
            </li>
        </ol>

        <p><strong>ध्वनीक्षेपक बाबत अटीशर्ती :</strong></p>
        <ol class="points" start="19">
            <li>ध्वनीक्षेपकाची परवानगी संबंधीत स्थानिक पोलीस स्टेशन मधून घेणे बंधनकारक आहे.
            </li>
            <li>ध्वनी प्रदुषण तसेच इतर प्रदुषण होणार नाही याची सर्वस्वी जबाबदारी मंडळाची राहील.</li>
        </ol>


        <p><strong>बोर्ड/ बॅनर बाबत अटीशर्ती:</strong></p>
        <ol class="points" start="21">
            <li>मंडपाच्या प्रवेशद्वारा जवळ एकच बॅनर लावण्याची परवानगी देण्यात येत आहे. इतर ठिकाणी रस्त्यावर कमान लावणेस
                व बॅनर प्रदर्शित करणेस प्रतिबंध आहे.

        </ol>

        <p><strong>इतर कार्यपध्दती:</strong></p>
        <ol class="points" start="22">
            <li>अग्निसुरक्षा नियमांचे पालन करणेची जबाबदारी आपली राहिल.</li>
            <li>उत्सव कालावधीमध्ये मा. न्यायालयाकडून व राज्य शासनाकडून वेळोवेळी जारी करणेत येणाऱ्या आदेशाचे पालन करणे
                बंधनकारक राहिल.</li>
            <li>{{@$dataone->remark}}</li>


            <p>वरील अटीशर्तींचे भंग झाल्यास सदरची परवानगी रद्द करुन उचित नियमानुसार कारवाई करण्यात येईल.</p>
    </div>

    @php

        // Encrypt the ID
        $encryptedId = encrypt($data->id);

        // Generate route with encrypted ID and query param using URL::temporarySignedRoute (optional for security)
        $downloadUrlWithParam = route('trade-noc-mandap.download_certificate', ['id' => $encryptedId]) . '?download=pdf';

        // Generate QR Code SVG
        $qrSvg = QrCode::format('svg')->size(100)->margin(1)->generate($downloadUrlWithParam);
    @endphp

    <!-- QR Code aligned to top-right -->
    <div style="width: 100%; margin-top: 40px;">
        <div style="float: right; text-align: center;">
            {!! $qrSvg !!}
            {{-- <p style="font-size: 12px;">QR कोड स्कॅन करून प्रमाणपत्र डाउनलोड करा</p> --}}
        </div>
    </div>


    <div style="clear: both;"></div>

    <!-- Footer aligned at bottom -->
    <div style="width: 100%; position: relative; margin-top: 100px;">
        <!-- Left Footer -->
        <div style="float: left; width: 45%;">
            <p>
                <strong>प्रत माहितीस्तव</strong><br>
                विद्युत विभाग<br>
                मिरा भायंदर महानगरपालिका
            </p>
        </div>

        <!-- Right Footer (Signature block) -->
        <div style="float: right; width: 45%; text-align: right;">
            <p><strong>कार्यकारी अभियंता (साबां/वि)</strong><br>
             मिरा-भाईंदर महानगरपालिका</p>
        </div>
    </div>
</body>
</html>
