<x-admin.layout>
    <x-slot name="title">Plumber License / प्लंबर परवाना</x-slot>
    <x-slot name="heading"> Plumber License / प्लंबर परवाना</x-slot>
    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" value="{{ $data->applicant_name }}" placeholder="Enter Applicant Name" required disabled readonly>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="address" name="address" type="text" placeholder="Enter Name Of New Owner" required disabled readonly>{{ $data->address }} </textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Applicant Mobile No / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $data->mobile_no }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text"
                                    placeholder="Enter Mobile Number" required disabled readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Applicant EmailID / ईमेल आयडी<span class="text-danger"></span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $data->email_id }}" required disabled readonly>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Applicant Adhaar No / आधार क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" value='{{ $data->aadhar_no }}' oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text"
                                    placeholder="Enter Aadhar Card No" required disabled readonly>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>

                        </div>
                    </div>
                    <div class="card-header">
                        <h4 class="card-title">Add Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                <input class="form-control" name="zone" id="zone" value='{{ $data->zone }}' placeholder="Enter Zone" required disabled readonly>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="house_no">House Number </label> {{-- <span class="text-danger">*</span> --}}
                                    <input type="number" class="form-control" value='{{ $data->house_no }}' id="house_no" name="house_no" placeholder="Enter House Number" required disabled readonly>
                                    <span class="text-danger" id="house_no_error"></span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="land_mark">Land Mark <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" value='{{ $data->land_mark }}' id="land_mark" name="land_mark" placeholder="Enter Landmark" required disabled readonly>
                                    <span class="text-danger" id="land_mark_error"></span>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="education_qualification">Educational Qualification / शैक्षणिक पात्रता</label>
                                <input class="form-control" id="education_qualification" value='{{ $data->education_qualification }}' name="education_qualification" type="text" placeholder="Enter Educational Qualification" disabled readonly>
                                <span class="text-danger is-invalid education_qualification_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="education_institutation">Educational Institution / शैक्षणिक संस्था</label>
                                <input class="form-control" id="education_institutation" value='{{ $data->education_institutation }}' name="education_institutation" type="text" placeholder="Enter Educational Institution" disabled readonly>
                                <span class="text-danger is-invalid education_institutation_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="training_institute_name">Name of industrial training institute / औद्योगिक प्रशिक्षण संस्थेचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="training_institute_name" value='{{ $data->training_institute_name }}' name="training_institute_name" type="text" placeholder="Enter Name of industrial training institute"
                                    required disabled readonly>
                                <span class="text-danger is-invalid training_institute_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="year_of_passing">Passing Year / उत्तीर्ण झाल्याचे वर्ष<span class="text-danger">*</span></label>
                                <input class="form-control" id="year_of_passing" value='{{ $data->year_of_passing }}' name="year_of_passing" type="text" placeholder="Enter Year Of Passing"
                                    oninput="this.value = this.value.replace(/\D/g, '')" maxlength="4" minlength="4" required disabled readonly>
                                <span class="text-danger is-invalid year_of_passing_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="have_experience">Have Experience / अनुभव आहे का ? <span class="text-danger">*</span></label>
                                <select class="form-select" name="have_experience" id="have_experience" required disabled>
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['Yes', 'No'];
                                    @endphp
                                    @foreach ($options as $option)
                                        <option value="{{ $option }}" {{ $data->have_experience == $option ? 'selected' : '' }}>{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid have_experience_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="nodues_documents">Educational documents certificate and experience certificate / शैक्षणिक कागदपत्रांचे प्रमाणपत्र आणि अनुभव प्रमाणपत्र <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->nodues_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="nodues_documents" name="nodues_documents" type="file" required> --}}
                                <span class="text-danger is-invalid nodues_documents_err"></span>
                            </div>


                            <div class="col-md-4">
                                    <label class="col-form-label" for="resident_document">Resident Documents/राहणीसंबंधी दस्तऐवज</label>
                                    <div><a href="{{ asset('storage/' . $data->resident_document) }}" target="_blank">View Document</a></div>
                                    {{-- <input class="form-control" id="prev_water_bill" name="prev_water_bill" type="file"> --}}
                                    <span class="text-danger is-invalid resident_document_err"></span>
                                </div>



                            <div class="col-md-4">
                                <label class="col-form-label" for="application_documents">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->application_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="application_documents" name="application_documents" type="file" required> --}}
                                <span class="text-danger is-invalid application_documents_err"></span>
                            </div>

                            

                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" rows="4" required></textarea>
                            </div>

                            {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" required name="is_correct_info" value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        {{-- <button type="submit" class="btn btn-primary" id="addSubmit">Update</button> --}}
                        {{-- <button type="reset" class="btn btn-warning">Reset</button> --}}
                        <button id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>




{{-- Add --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);

        var updateUrl = '{{ route('trade-plumber-license.update', $data->id) }}';
        formdata.append('_method', 'PUT');

        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });

    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
