<x-admin.layout>
    <x-slot name="title">Urban Areas Tree Protection/शहरी भागात वृक्ष संरक्षण</x-slot>
    <x-slot name="heading">Urban Areas Tree Protection/शहरी भागात वृक्ष संरक्षण</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Add Details</h4>
                    </div>
                    <div class="card-body">


                        {{-- <div class="col-md-4">
                            <label class="col-form-label" for="zone">Zone Id / झोन<span class="text-danger">*</span></label>
                            <select class="form-select" name="zone" id="zone">
                                <option value="">Select Zone</option>
                                @foreach ($zones as $zone)
                                    <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                        @endforeach
                        </select>
                        <span class="text-danger is-invalid zone_err"></span>
                    </div> --}}
                    <div class="mb-3 row">

                        <div class="col-md-3">
                            <label class="col-form-label" for="title_of_application">Title of Applicant<span class="text-danger">*</span></label>
                            <select name="title_of_application" id="title_of_application" class="form-select" required>
                                <option value="" disabled selected> -- Select -- </option>
                                <option value="mr">Mr</option>
                                <option value="mrs">Mrs</option>
                                <option value="ms">Ms</option>
                            </select>
                            <span class="text-danger is-invalid title_of_application_err"></span>
                        </div>

                        <div class="col-md-3">
                            <label class="col-form-label" for="f_name">First Name <span class="text-danger">*</span></label>
                            <input class="form-control" id="f_name" name="f_name" type="text" placeholder="Enter First Name" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                            <span class="text-danger is-invalid f_name_err"></span>
                        </div>

                        <div class="col-md-3">
                            <label class="col-form-label" for="m_name">Middle Name</label>
                            <input class="form-control" id="m_name" name="m_name" type="text" placeholder="Enter Middle Name" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                            <span class="text-danger is-invalid m_name_err"></span>
                        </div>

                        <div class="col-md-3">
                            <label class="col-form-label" for="l_name">Last Name <span class="text-danger">*</span></label>
                            <input class="form-control" id="l_name" name="l_name" type="text" placeholder="Enter Last Name" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                            <span class="text-danger is-invalid l_name_err"></span>
                        </div>

                        <div class="col-md-3">
                            <label class="col-form-label" for="flat_no">Plot/Flat No <span class="text-danger">*</span></label>
                            <input class="form-control" id="flat_no" name="flat_no" type="text" placeholder="Enter Plot/Flat No" required>
                            <span class="text-danger is-invalid flat_no_err"></span>
                        </div>

                        <div class="col-md-3">
                            <label class="col-form-label" for="building_no">Name of the Building/Colony<span class="text-danger">*</span></label>
                            <input class="form-control" id="building_no" name="building_no" type="text" placeholder="Enter Name of the Building/Colony" required>
                            <span class="text-danger is-invalid building_no_err"></span>
                        </div>

                        <div class="col-md-3">
                            <label class="col-form-label" for="area">Name of the Area<span class="text-danger">*</span></label>
                            <input class="form-control" id="area" name="area" type="text" placeholder="Name of the Area" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                            <span class="text-danger is-invalid area_err"></span>
                        </div>

                        <div class="col-md-3">
                            <label class="col-form-label" for="city">Name of City<span class="text-danger">*</span></label>
                            <input class="form-control" id="city" name="city" type="text" placeholder="Enter Name of City" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')" required>
                            <span class="text-danger is-invalid city_err"></span>
                        </div>
                        <div class="col-md-3">
                            <label class="col-form-label" for="pincode">Pin Code<span class="text-danger">*</span></label>
                            <input
                                class="form-control"
                                id="pincode"
                                name="pincode"
                                type="text"
                                placeholder="Enter Pincode"
                                required
                                minlength="6"
                                maxlength="6"
                                pattern="\d{6}"
                                oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 6)"
                            >
                            <span class="text-danger is-invalid pincode_err"></span>
                        </div>
                        <div class="col-md-3">
                            <label class="col-form-label" for="landmark">Near By Landmark<span class="text-danger">*</span></label>
                            <input class="form-control" id="landmark" name="landmark" type="text" placeholder="Enter Near By Landmark" required>
                            <span class="text-danger is-invalid landmark_err"></span>
                        </div>
                        <div class="col-md-3">
                            <label class="col-form-label" for="gut_number">City Survey/ Gut Number<span class="text-danger">*</span></label>
                            <input class="form-control" id="gut_number" name="gut_number" type="text" placeholder="Enter City Survey/ Gut Number" required>
                            <span class="text-danger is-invalid gut_number_err"></span>
                        </div>
                        <div class="col-md-3">
                            <label class="col-form-label" for="mobile_no">Mobile No</label><span class="text-danger">*</span>
                            <input class="form-control" id="mobile_no" name="mobile_no" type="text" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" placeholder="Enter Mobile Number" required>
                            <span class="text-danger is-invalid mobile_no_err"></span>
                        </div>

                        <div class="col-md-3">
                            <label class="col-form-label" for="email">Email<span class="text-danger">*</span></label>
                            <input class="form-control" id="email" name="email" type="email" placeholder="Enter Email" required>
                            <span class="text-danger is-invalid email_err"></span>
                        </div>

                        {{-- <div class="col-md-3">
                            <label class="col-form-label" for="type_application">Type of Applicant <span class="text-danger">*</span></label>
                            <select id="type_application" name="type_application" class="form-control" required>
                                <option value="" disabled selected>Select Applicant Type</option>

                                <option value="Citizen">
                                    Citizen
                                </option>
                                <option value="Builder">
                                    Builder
                                </option>
                                <option value="Advertising Media">
                                    Advertising Media
                                </option>
                                <option value="Other">
                                    Other
                                </option>
                            </select>
                            <span class="text-danger is-invalid type_application_err"></span>
                        </div> --}}

                        {{-- <div class="col-md-3">
                            <label class="col-form-label" for="type_application">Type of Applicant <span class="text-danger">*</span></label>
                            <select id="type_application" name="type_application" class="form-control" required>
                                <option value="" disabled selected>--Select Applicant Type--</option>

                                <option value="सोसायटी / घरांच्या परिसरातील झाडे तोडणे / पुर्नरोपण / छाटणी करणे">
                                    अ.सोसायटी / घरांच्या परिसरातील झाडे तोडणे / पुर्नरोपण / छाटणी करणे.
                                </option>
                                <option value="विकासकामातील झाडे तोडणे/ पुर्नरोपण करणे">
                                    ब. विकासकामातील झाडे तोडणे/ पुर्नरोपण करणे.
                                </option>
                                
                            </select>
                            <span class="text-danger is-invalid type_application_err"></span>
                        </div> --}}


                        {{-- <div class="col-md-3">
                            <label class="col-form-label" for="reason_trim">Reason For Trimming <span class="text-danger">*</span></label>
                            <select id="reason_trim" name="reason_trim" class="form-control" required>
                                <option value="" disabled selected>Select Reason for Trimming</option>

                                <option value="Trimming Down Dangerous Branches">
                                    Trimming Down Dangerous Branches
                                </option>
                                <option value="Obstruction To Electrical Wires">
                                    Obstruction To Electrical Wires
                                </option>
                                <option value="Obstruction To Construction">
                                    Obstruction To Construction
                                </option>
                                <option value="Obstruction To Hoardings">
                                    Obstruction To Hoardings
                                </option>
                                <option value="Other">
                                    Other
                                </option>
                            </select>
                            <span class="text-danger is-invalid reason_trim_err"></span>
                        </div> --}}


                         {{-- <div class="col-md-3">
                            <label class="col-form-label" for="owner">Tree height<span class="text-danger">*</span></label>
                            <select name="owner" id="owner" class="form-select" required>
                                <option value="" disabled selected> -- Select -- </option>
                                <option value="private">Private</option>
                                <option value="corporation">Corporation</option>
                                <option value="government">Government</option>
                                <option value="semi_govt">Semi Govt</option>
                            </select>
                            <span class="text-danger is-invalid owner_err"></span>

                        </div> --}}



                       
                
        <!-- Dropdown 1: Type of Applicant -->
        <div class="col-md-3">
            <label class="col-form-label" for="type_application">Type of Applicant <span class="text-danger">*</span></label>
            <select id="type_application" name="type_application" class="form-control" required>
                <option value="" disabled selected>-- Select Applicant Type --</option>
                @foreach($vrukshtypes->pluck('type')->unique() as $type)
                    <option value="{{ $type }}">{{ $type }}</option>
                @endforeach
            </select>
            <span class="text-danger is-invalid type_application_err"></span>
        </div>

        <!-- Dropdown 2: Reason For Trimming -->
        <div class="col-md-3">
            <label class="col-form-label" for="reason_trim">Reason For Trimming <span class="text-danger">*</span></label>
            <select id="reason_trim" name="reason_trim" class="form-control" required>
                <option value="" disabled selected>-- Select Reason --</option>
            </select>
            <span class="text-danger is-invalid reason_trim_err"></span>
        </div>
    

                    <!-- Dropdown 3: Tree Height -->
                <div class="col-md-3" id="tree_height_section" style="display: none;">
                    <label class="col-form-label" for="tree_height">Tree Height <span class="text-danger">*</span></label>
                    <select name="tree_height" id="tree_height" class="form-control" >
                        <option value="" disabled selected>-- Select Tree Height --</option>
                    </select>
                    <span class="text-danger is-invalid tree_height_err"></span>
                </div>

                   <div class="col-md-3" id="other_tree_box" >
                        <label class="col-form-label" for="type_of_tree">No of Trees <span class="text-danger">*</span></label>
                        <input type="text" name="type_of_tree" id="type_of_tree" class="form-control" placeholder="Enter no of tree">
                        <span class="text-danger is-invalid type_of_tree_err"></span>
                    </div>



<div class="row" id="vruksh_todne_fields" style="display:none;">
    <div class="col-md-3">
        <label class="col-form-label" for="new_plant">नवीन वृक्षारोपण करायचे आहे का?</label>
        <select name="new_plant" id="new_plant" class="form-control">
            <option value="" disabled selected>-- निवडा --</option>
            <option value="होय">होय</option>
            <option value="नाही">नाही</option>
        </select>
    </div>

    <div class="col-md-3">
        <label class="col-form-label" for="space_available">वृक्षारोपणासाठी जागा उपलब्ध आहे का?</label>
        <select name="space_available" id="space_available" class="form-control">
            <option value="" disabled selected>-- निवडा --</option>
            <option value="होय">होय</option>
            <option value="नाही">नाही</option>
        </select>
    </div>
</div>

<!-- वृक्ष पुनःरोपण Fields -->
<div class="row" id="vruksh_punharoopan_fields" style="display:none;">
    <div class="col-md-3">
        <label class="col-form-label" for="new_replant">नवीन वृक्ष पुनःरोपण करायचे आहे का?</label>
        <select name="new_replant" id="new_replant" class="form-control">
            <option value="" disabled selected>-- निवडा --</option>
            <option value="होय">होय</option>
            <option value="नाही">नाही</option>
        </select>
    </div>

    <div class="col-md-3">
        <label class="col-form-label" for="space_replant">वृक्ष पुनःरोपणासाठी जागा उपलब्ध आहे का?</label>
        <select name="space_replant" id="space_replant" class="form-control">
            <option value="" disabled selected>-- निवडा --</option>
            <option value="होय">होय</option>
            <option value="नाही">नाही</option>
        </select>
    </div>
</div>






                        <!-- Reason For Trimming Dropdown -->
                        {{-- <div class="col-md-3">
                            <label class="col-form-label" for="reason_trim">Reason For Trimming <span class="text-danger">*</span></label>
                            <select id="reason_trim" name="reason_trim" class="form-control" required>
                                <option value="" disabled selected>Select Reason for Trimming</option>

                                <option value="Trimming Down Dangerous Branches">
                                    Trimming Down Dangerous Branches
                                </option>
                                <option value="Obstruction To Electrical Wires">
                                    Obstruction To Electrical Wires
                                </option>
                                <option value="Obstruction To Construction">
                                    Obstruction To Construction
                                </option>
                                <option value="Obstruction To Hoardings">
                                    Obstruction To Hoardings
                                </option>
                                <option value="Other">
                                    Other
                                </option>
                            </select>
                            <span class="text-danger is-invalid reason_trim_err"></span>
                        </div> --}}

                        {{-- <div class="col-md-3">
                            <label class="col-form-label" for="owner">Type of Owner<span class="text-danger">*</span></label>
                            <select name="owner" id="owner" class="form-select" required>
                                <option value="" disabled selected> -- Select -- </option>
                                <option value="private">Private</option>
                                <option value="corporation">Corporation</option>
                                <option value="government">Government</option>
                                <option value="semi_govt">Semi Govt</option>
                            </select>
                            <span class="text-danger is-invalid owner_err"></span>

                        </div> --}}

                        {{-- <div class="col-md-3">
                            <label class="col-form-label" for="type_of_tree">Type of Tree<span class="text-danger">*</span></label>
                            <select name="type_of_tree" id="type_of_tree" class="form-select" required>
                                <option value="" disabled selected> -- Select -- </option>
                                <option value="fruit">Fruit Tree</option>
                                <option value="other">Other Tree</option>
                            </select>
                            <span class="text-danger is-invalid type_of_tree_err"></span>
                        </div> --}}

                        







                        <div class="col-mb-3">
                            <label class="col-form-label fw-bold">
                                List of Documents (Attachment) For Tree Branches Trimming <span class="text-danger">*</span>
                            </label>
                            <div class="alert alert-info p-2">
                                <strong>Note:</strong> Upload Below Files only <strong>pdf, jpg, jpeg</strong>, etc. Max up to <strong>2MB</strong>.
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="col-form-label" for="paid_receipts">Current Year Property Tax Paid Receipt <span class="text-danger">*</span></label>
                            <input type="file" onchange="validateFileSize(this, 2)" class="form-control" id="paid_receipts" name="paid_receipts" accept="image/*" required>
                            <span class="text-danger is-invalid paid_receipts_err"></span>
                        </div>
                        <div class="col-md-3">
                            <label class="col-form-label" for="photo_trees">Photograph of Tree <span class="text-danger">*</span></label>
                            <input type="file" onchange="validateFileSize(this, 2)" class="form-control" id="photo_trees" name="photo_trees" accept="image/*" required>
                            <span class="text-danger is-invalid photo_trees_err"></span>
                        </div>
                        <div class="col-md-3">
                            <label class="col-form-label" for="aadhars">Aadhaar Card <span class="text-danger">*</span></label>
                            <input type="file" onchange="validateFileSize(this, 2)" class="form-control" id="aadhars" name="aadhars" accept="image/*" required>
                            <span class="text-danger is-invalid aadhars_err"></span>
                        </div>
                        <div class="col-md-3">
                            <label class="col-form-label" for="building_permissions">Building Permission<span class="text-danger">*</span></label>
                            <input type="file" onchange="validateFileSize(this, 2)" class="form-control" id="building_permissions" name="building_permissions" accept="image/*" required>
                            <span class="text-danger is-invalid building_permissions_err"></span>
                        </div>
                        <div class="col-md-3">
                            <label class="col-form-label" for="plan_constructions">Sanctioned Plan of Construction <span class="text-danger">*</span></label>
                            <input type="file" onchange="validateFileSize(this, 2)" class="form-control" id="plan_constructions" name="plan_constructions" accept="image/*" required>
                            <span class="text-danger is-invalid plan_constructions_err"></span>
                        </div>
                        <div class="col-md-3">
                            <label class="col-form-label" for="noc_letters">NOC Letter <span class="text-danger">*</span></label>
                            <input type="file" onchange="validateFileSize(this, 2)" class="form-control" id="noc_letters" name="noc_letters" accept="image/*" required>
                            <span class="text-danger is-invalid noc_letters_err"></span>
                        </div>

                        <div class="col-md-4" id="upload_section" style="display:none;">
                            <label class="col-form-label" for="prescribed_docs">Upload Application In
                                Prescribed
                                Format / विहित नमुन्यातील अर्ज अपलोड करा <span
                                    class="text-danger">*</span></label>
                            <input class="form-control" id="prescribed_docs" name="prescribed_docs"
                                type="file" required>
                            <span class="text-danger is-invalid prescribed_docs_err"></span>
                        </div>


                        <label class="col-form-label" for="is_correct_info"><b>Terms And Conditions</b></label>

                        <br>
                    <div class="col-md-12">
                        <div class="form-check d-flex align-items-start">
                            <input type="checkbox" class="form-check-input mt-1" id="selectAll">
                            <label class="form-check-label ms-2" for="selectAll">
                                Select All
                            </label>
                        </div>
                        <br>

                        {{-- 2. Item Checkboxes (THESE WILL BE SUBMITTED AND SAVED) --}}

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input checkItem @error('item1') is-invalid @enderror" name="item1" value="1" {{ old('item1') ? 'checked' : '' }}>
                            <label class="form-check-label">In case of any kind of accident or loss of life or damage to government and private property and damage to electric wire, phone wire, cable etc. while cutting the said tree, it will be the responsibility of the applicant to compensate the same.</label>
                            @error('item1')
                                <span class="text-danger mt-1 d-block">{{ $message }}</span>
                            @enderror
                        </div>
                        <br>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input checkItem @error('item2') is-invalid @enderror" name="item2" value="2" {{ old('item2') ? 'checked' : '' }}>
                            <label class="form-check-label">In case of any kind of dispute regarding the ownership of the land or the trees or if any objection or objection is raised by the interested parties, the applicant will be responsible for the same.</label>
                            @error('item2')
                                <span class="text-danger mt-1 d-block">{{ $message }}</span>
                            @enderror
                        </div>
                        <br>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input checkItem @error('item3') is-invalid @enderror" name="item3" value="3" {{ old('item3') ? 'checked' : '' }}>
                            <label class="form-check-label">Under the provisions of section 8 sub-section 3 (c) of the Maharashtra Urban Area Tree Preservation Act, 1975, the act of felling a tree shall remain valid for one month from the date of the said permission.</label>
                            @error('item3')
                                <span class="text-danger mt-1 d-block">{{ $message }}</span>
                            @enderror
                        </div>
                        <br>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input checkItem @error('item4') is-invalid @enderror" name="item4" value="3" {{ old('item4') ? 'checked' : '' }}>
                            <label class="form-check-label">After pruning the tree, the branches, leaves and wood chips of the tree should be picked up immediately.</label>
                            @error('item4')
                                <span class="text-danger mt-1 d-block">{{ $message }}</span>
                            @enderror
                        </div>
                        <br>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input checkItem @error('item5') is-invalid @enderror" name="item5" value="3" {{ old('item5') ? 'checked' : '' }}>
                            <label class="form-check-label">In the presence of the garden assistant of the park department or the representative of the park department, the process of cutting the said tree should be done.</label>
                            @error('item5')
                                <span class="text-danger mt-1 d-block">{{ $message }}</span>
                            @enderror
                        </div>
                        <br>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input checkItem @error('item6') is-invalid @enderror" name="item6" value="3" {{ old('item6') ? 'checked' : '' }}>
                            <label class="form-check-label">It should be noted that in case of pruning of tree branches in excess of the permit, legal action will be taken against you as per the rules for violation of Section 21 (1) of the Maharashtra (Urban Area) Protection and Preservation of Trees Act, 1975.</label>
                            @error('item6')
                                <span class="text-danger mt-1 d-block">{{ $message }}</span>
                            @enderror
                        </div>
                        <br>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input checkItem @error('item7') is-invalid @enderror" name="item7" value="3" {{ old('item7') ? 'checked' : '' }}>
                            <label class="form-check-label">If there are birds, nests of birds on the trees, they should be shifted to a suitable place with the advice of wildlife experts. So that vigilance should be taken to ensure that there is no loss/damage to biodiversity at that place. It should also be noted that in case of any such damage/accident, the applicant will be fully responsible for it.</label>
                            @error('item7')
                                <span class="text-danger mt-1 d-block">{{ $message }}</span>
                            @enderror
                        </div>
                        <br>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input checkItem @error('item8') is-invalid @enderror" name="item8" value="3" {{ old('item8') ? 'checked' : '' }}>
                            <label class="form-check-label">Tree trimming should not be done on Sundays and public holidays.</label>
                            @error('item8')
                                <span class="text-danger mt-1 d-block">{{ $message }}</span>
                            @enderror
                        </div>
                        <br>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input checkItem @error('item9') is-invalid @enderror" name="item9" value="3" {{ old('item9') ? 'checked' : '' }}>
                            <label class="form-check-label">If the above conditions are acceptable, the tree should be felled.</label>
                            @error('item9')
                                <span class="text-danger mt-1 d-block">{{ $message }}</span>
                            @enderror
                        </div>

                        {{-- The JavaScript remains the same, as it only uses the ID to check/uncheck the others --}}
                        <script>
                            document.getElementById('selectAll').addEventListener('change', function() {
                                let checkboxes = document.querySelectorAll('.checkItem');
                                checkboxes.forEach(checkbox => {
                                    checkbox.checked = this.checked;
                                });
                            });
                        </script>

                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" required>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                    <span class="text-danger is-invalid is_correct_info_err"></span>
                                </div>
                            </div>

                    </div>
            </div>
            <div class="form-group" style="text-align: center;">
                <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
            </div>
            <div class="card-footer" id="card-footer" style="display:none;">
                <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                <button type="reset" class="btn btn-warning">Reset</button>
            </div>
            </form>
        </div>
    </div>
    </div>

</x-admin.layout>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="{{ asset('admin/js/save_print.js') }}"></script>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        attachGlobalValidation('#addForm', '#saveAndPrintBtn', {
            containerId: 'addContainer',
            printTitle: 'treeprotection',
        });
    });

    function validateFileSize(input, maxSizeMB) {
        if (input.files[0].size > maxSizeMB * 1024 * 1024) {
            alert("File too large! Max size " + maxSizeMB + "MB");
            input.value = "";
            return false;
        }
        return true;
    }
</script>
<script>
    function displayFileName(input) {
        const fileNameDisplay = document.getElementById(input.id.replace('_pics', '_file_name'));
        if (input.files.length > 0) {
            // .name property only provides the file name, not the path
            fileNameDisplay.textContent = 'Selected: ' + input.files[0].name;
            fileNameDisplay.style.color = 'green';
        } else {
            fileNameDisplay.textContent = 'No file selected';
            fileNameDisplay.style.color = 'gray';
        }
    }
</script>

{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        if ($('#upload_section').is(':visible')) {
            var fileVal = $('#prescribed_docs').val();
            if (!fileVal) {
                swal("Error!", "Please upload the application document.", "error");
                $("#addSubmit").prop('disabled', false);
                return;
            }
        }

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('tree-protection.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
           success: function(data) {
    $("#addSubmit").prop('disabled', false);
    if (!data.error)
        swal("Successful!", data.success || "Operation completed successfully!", "success")
        .then(() => {
            window.location.href = '{{ route('my-application') }}';
        });
    else
        swal("Error!", data.error || "Something went wrong!", "error");
},
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>

{{-- <script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('type_application');
    const reasonSelect = document.getElementById('reason_trim');
    const treeSelect = document.getElementById('tree_height');

    // 🌳 When "Type of Applicant" changes
    typeSelect.addEventListener('change', function() {
        const type = this.value;

        reasonSelect.innerHTML = '<option value="" disabled selected>Loading...</option>';
        treeSelect.innerHTML = '<option value="" disabled selected>-- Select Tree Height --</option>';

        // ✅ Use query parameter instead of path (handles Marathi properly)
        fetch(`{{ url('/get-vruksh-names') }}?type=${encodeURIComponent(type)}`)
            .then(res => res.json())
            .then(data => {
                reasonSelect.innerHTML = '<option value="" disabled selected>-- Select Reason --</option>';
                if (data.length > 0) {
                    data.forEach(name => {
                        reasonSelect.innerHTML += `<option value="${name}">${name}</option>`;
                    });
                } else {
                    reasonSelect.innerHTML = '<option value="">No options available</option>';
                }
            })
            .catch(() => {
                reasonSelect.innerHTML = '<option value="">Error Loading Data</option>';
            });
    });

    // 🌿 When "Reason For Trimming" changes
    reasonSelect.addEventListener('change', function() {
        const name = this.value;

        treeSelect.innerHTML = '<option value="" disabled selected>Loading...</option>';

        // ✅ Again using query parameter for safety
        fetch(`{{ url('/get-vruksh-subnames') }}?name=${encodeURIComponent(name)}`)
            .then(res => res.json())
            .then(data => {
                treeSelect.innerHTML = '<option value="" disabled selected>-- Select Tree Height --</option>';
                if (data.length > 0) {
                    data.forEach(sub => {
                        treeSelect.innerHTML += `<option value="${sub}">${sub}</option>`;
                    });
                } else {
                    treeSelect.innerHTML = '<option value="">No options available</option>';
                }
            })
            .catch(() => {
                treeSelect.innerHTML = '<option value="">Error Loading Data</option>';
            });
    });
});
</script> --}}

<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('type_application');
    const reasonSelect = document.getElementById('reason_trim');
    const treeSelect = document.getElementById('tree_height');
    const treeHeightSection = document.getElementById('tree_height_section');

    // 🌿 Extra conditional sections
    const todneFields = document.getElementById('vruksh_todne_fields');
    const punharoopanFields = document.getElementById('vruksh_punharoopan_fields');

    // 🌳 When Type of Applicant changes
    typeSelect.addEventListener('change', function() {
        const type = this.value;

        // Reset all
        reasonSelect.innerHTML = '<option value="" disabled selected>Loading...</option>';
        treeSelect.innerHTML = '<option value="" disabled selected>-- Select Tree Height --</option>';
        treeHeightSection.style.display = 'none';
        todneFields.style.display = 'none';
        punharoopanFields.style.display = 'none';

        fetch(`{{ url('/get-vruksh-names') }}?type=${encodeURIComponent(type)}`)
            .then(res => res.json())
            .then(data => {
                reasonSelect.innerHTML = '<option value="" disabled selected>-- Select Reason --</option>';
                if (data.length > 0) {
                    data.forEach(name => {
                        reasonSelect.innerHTML += `<option value="${name}">${name}</option>`;
                    });
                } else {
                    reasonSelect.innerHTML = '<option value="">No options available</option>';
                }
            })
            .catch(() => {
                reasonSelect.innerHTML = '<option value="">Error Loading Data</option>';
            });
    });

    // 🌿 When Reason For Trimming changes
    reasonSelect.addEventListener('change', function() {
        const name = this.value.trim();

        // Hide all first
        treeHeightSection.style.display = 'none';
        todneFields.style.display = 'none';
        punharoopanFields.style.display = 'none';

        // ✅ 1. If "धोकादायक झाडे मुळासहित काढणे"
        if (name === 'धोकादायक झाडे मुळासहित काढणे') {
            treeHeightSection.style.display = 'block';

            treeSelect.innerHTML = '<option value="" disabled selected>Loading...</option>';
            fetch(`{{ url('/get-vruksh-subnames') }}?name=${encodeURIComponent(name)}`)
                .then(res => res.json())
                .then(data => {
                    treeSelect.innerHTML = '<option value="" disabled selected>-- Select Tree Height --</option>';
                    if (data.length > 0) {
                        data.forEach(sub => {
                            treeSelect.innerHTML += `<option value="${sub}">${sub}</option>`;
                        });
                    } else {
                        treeSelect.innerHTML = '<option value="">No options available</option>';
                    }
                })
                .catch(() => {
                    treeSelect.innerHTML = '<option value="">Error Loading Data</option>';
                });
        }

        // ✅ 2. If "वृक्ष तोडणे"
        else if (name === 'वृक्ष तोडणे') {
            todneFields.style.display = 'flex';
        }

        // ✅ 3. If "वृक्ष पुनःरोपण"
        else if (name === 'वृक्ष पुनःरोपण') {
            punharoopanFields.style.display = 'flex';
        }

        // ✅ 4. Else everything stays hidden
        else {
            treeHeightSection.style.display = 'none';
            todneFields.style.display = 'none';
            punharoopanFields.style.display = 'none';
        }
    });
});
</script>





<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>





