<!DOCTYPE html>
<html lang="mr">
<head>
<meta charset="UTF-8">
<title>Receipt</title>
<style>
    @page { size: A4; margin: 15mm; }
    body { font-family: 'Mangal', Devanagari, serif; font-size: 14px; margin: 0; color: #000; }

    .header { text-align: center; margin-bottom: 5px; position: relative; }
    .header img { position: absolute; left: 0; top: 0; height: 90px; width: 90px; }
    .header h2, .header p { margin: 0; line-height: 1.3; }
    .header h2 { font-size: 20px; text-transform: uppercase; }
    .header h3 { margin-top: 5px; font-size: 18px; font-weight: 600; }

    hr { border: 1px solid #000; margin: 10px 0; }

    .sub-header { font-size: 14px; margin-bottom: 5px; }

    table { width: 100%; border-collapse: collapse; }
    td, th { padding: 6px 8px; vertical-align: middle; }
    th { background-color: #f2f2f2; border: 1px solid #000; text-align: center; }
    td { border: 1px solid #000; }

    .no-border td { border: none !important; }

    .text-right { text-align: right; }
    .text-center { text-align: center; }

    .footer-note {
        margin-top: 25px;
        text-align: center;
        font-size: 13px;
        border-top: 1px solid #000;
        padding-top: 8px;
    }

    .amount-words {
        margin-top: 10px;
        font-weight: bold;
    }
</style>
</head>
<body>

<div class="header">
    @php
        $logoData1 = file_get_contents(public_path('admin/images/favicon.png'));
        $base641Logo = base64_encode($logoData1);
    @endphp
    <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo">
    <h2>MIRA BHAYANDAR MUNICIPAL CORPORATION</h2>
    <p>Indira Gandhi Bhavan, Chattrapati Shivaji Maharaj Marg, Bhayandar (W), Dist - Thane</p>
    <p>Tel Nos. 022-28192828 / 28193028 / 28181183 / 28181353 / 28145985</p>
    <h3>( बांधकाम / विद्युत ) विभाग</h3>
</div>

<hr>

<div class="sub-header">
    <p>
        <strong>Receipt No.:</strong> {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}
        <span style="float:right;"><strong>Date:</strong> {{ \Carbon\Carbon::parse($paymentdata->created_at)->format('d/m/Y') }}</span>
    </p>
</div>

<table class="no-border">
    <tr>
        <td><strong>Account Name:</strong></td><td>Mira Bhayandar Municipal Corporation General Fund</td>
        <td><strong>Bank Name:</strong></td><td>Bank of Baroda</td>
    </tr>
    <tr>
        <td><strong>Account No:</strong></td><td>**********0569</td>
        <td><strong>IFSC Code:</strong></td><td>BARB0DBBHAW</td>
    </tr>
    <tr>
        <td><strong>Application No:</strong></td><td>{{ $data->application_no }}</td>
        <td><strong>Payment Date:</strong></td><td>{{ \Carbon\Carbon::parse($paymentdata->created_at)->format('d/m/Y') }}</td>
    </tr>
    <tr>
        <td><strong>Applicant Name:</strong></td><td>{{ collect([$data->f_name, $data->m_name, $data->l_name])->filter()->join(' ') }}</td>
        <td><strong>Transaction No:</strong></td><td>{{ $paymentdata->orderno }}</td>
    </tr>
    <tr>
        <td><strong>Mobile No:</strong></td><td>{{ $data->mobile_num }}</td>
        <td><strong>Service Name:</strong></td><td>Urban Areas Tree Protection</td>
    </tr>
    <tr>
        <td><strong>No of Trees:</strong></td><td>{{ $data->type_of_tree }}</td>
        <td><strong>Reference No:</strong></td><td></td>
    </tr>
</table>

<br>

{{-- ✅ MAIN AMOUNT TABLE --}}
@php
    $isTrimOrDanger = (
        isset($data->type_application)
        && $data->type_application === 'सोसायटी / घरांच्या परिसरातील झाडे तोडणे / पुर्नरोपण / छाटणी करणे.'
        && in_array($data->reason_trim, [
            'वृक्षाची छाटणी करणे',
            'वृक्षांची छाटणी (फांद्या) उचलणे',
            'धोकादायक झाडे मुळासहित काढणे'
        ])
    );
@endphp

<table>
    <thead>
        @if($isTrimOrDanger)
            <tr>
                <th>Sr No</th>
                <th>Description</th>
                <th class="text-right">Rate / Tree (₹)</th>
                <th class="text-center">No of Trees</th>
                <th class="text-right">Total (₹)</th>
            </tr>
        @else
            <tr>
                <th>Sr No</th>
                <th>Description</th>
                <th class="text-right">Yes Amount (₹)</th>
                <th class="text-right">No Amount (₹)</th>
                <th class="text-right">Rate / Tree (₹)</th>
                <th class="text-center">No of Trees</th>
                <th class="text-right">Total (₹)</th>
            </tr>
        @endif
    </thead>

    <tbody>
        @if($isTrimOrDanger)
            {{-- ✅ Short Design for trimming/dangerous tree --}}
            <tr>
                <td class="text-center">1</td>
                <td>वृक्ष निधी</td>
                <td class="text-right">{{ number_format($rate, 2) }}</td>
                <td class="text-center">{{ $treeCount }}</td>
                <td class="text-right">
                    {{ number_format($vrukshaNidhi, 2) }}<br>
                    <small>({{ $treeCount }} × {{ number_format($rate, 2) }})</small>
                </td>
            </tr>
            <tr>
                <td class="text-center">2</td>
                <td>पाहणी फी</td>
                <td class="text-right">{{ number_format($pahaniFeeRate, 2) }}</td>
                <td class="text-center">{{ $treeCount }}</td>
                <td class="text-right">
                    {{ number_format($pahaniFee, 2) }}<br>
                    <small>({{ $treeCount }} × {{ number_format($pahaniFeeRate, 2) }})</small>
                </td>
            </tr>
        @else
            {{-- ✅ Full yes/no table --}}
            <tr>
                <td class="text-center">1</td>
                <td>वृक्ष निधी</td>
                <td class="text-right">{{ number_format($yesAmount, 2) }}</td>
                <td class="text-right">{{ number_format($noAmount, 2) }}</td>
                <td class="text-right">{{ number_format($vrukshaNidhiRate, 2) }}</td>
                <td class="text-center">{{ $treeCount }}</td>
                <td class="text-right">{{ number_format($vrukshaNidhi, 2) }}</td>
            </tr>
            <tr>
                <td class="text-center">2</td>
                <td>पाहणी फी</td>
                <td class="text-right">—</td>
                <td class="text-right">—</td>
                <td class="text-right">{{ number_format($pahaniFeeRate, 2) }}</td>
                <td class="text-center">{{ $treeCount }}</td>
                <td class="text-right">{{ number_format($pahaniFee, 2) }}</td>
            </tr>
        @endif
    </tbody>

    <tfoot>
        <tr>
            @if($isTrimOrDanger)
                <td colspan="4" class="text-right"><strong>एकूण (Total)</strong></td>
                <td class="text-right"><strong>{{ number_format($total, 2) }}</strong></td>
            @else
                <td colspan="6" class="text-right"><strong>एकूण (Total)</strong></td>
                <td class="text-right"><strong>{{ number_format($total, 2) }}</strong></td>
            @endif
        </tr>
    </tfoot>
</table>

<div class="amount-words">
    @php
        $number = $paymentdata->amount;
        $no = floor($number);
        $point = round($number - $no, 2) * 100;
        $hundred = null;
        $digits_1 = strlen($no);
        $i = 0;
        $str = [];
        $words = ['0'=>'','1'=>'one','2'=>'two','3'=>'three','4'=>'four','5'=>'five','6'=>'six','7'=>'seven','8'=>'eight','9'=>'nine','10'=>'ten','11'=>'eleven','12'=>'twelve','13'=>'thirteen','14'=>'fourteen','15'=>'fifteen','16'=>'sixteen','17'=>'seventeen','18'=>'eighteen','19'=>'nineteen','20'=>'twenty','30'=>'thirty','40'=>'forty','50'=>'fifty','60'=>'sixty','70'=>'seventy','80'=>'eighty','90'=>'ninety'];
        $digits = ['', 'hundred', 'thousand', 'lakh', 'crore'];
        while ($i < $digits_1) {
            $divider = $i == 2 ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = ($counter = count($str)) && $number > 9 ? 's' : null;
                $hundred = $counter == 1 && $str[0] ? ' and ' : null;
                $str[] = $number < 21
                    ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred
                    : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else {
                $str[] = null;
            }
        }
        $str = array_reverse($str);
        $result = implode('', $str);
        $points = $point ? ' and ' . $words[floor($point / 10) * 10] . ' ' . $words[$point % 10] . ' Paise' : '';
        echo '<strong>Amount In Word :- Rupees ' . ucfirst(trim($result)) . $points . '</strong>';
    @endphp
</div>

<p class="footer-note">Note : This is a computer-generated receipt. No signature required.</p>

</body>
</html>
