<x-admin.layout>
    <x-slot name="title">Urban Areas Tree Protection/शहरी भागात वृक्ष संरक्षण</x-slot>
    <x-slot name="heading">Urban Areas Tree Protection/शहरी भागात वृक्ष संरक्षण</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Edit Details</h4>
                    </div>
                    <div class="card-body">
                            <input type="hidden" model-id="id" value="{{ $status->id }}">
                        {{-- <div class="col-md-4">
                            <label class="col-form-label" for="zone">Zone Id / झोन<span class="text-danger">*</span></label>
                            <select class="form-select" name="zone" id="zone">
                                <option value="">Select Zone</option>
                                @foreach ($zones as $zone)
                                    <option @if ($treeProtection->zone == $zone->name) selected @endif value="{{ $zone->name }}">{{ $zone->name }}</option>
                                @endforeach
                            </select>
                            <span class="text-danger is-invalid zone_err"></span>
                        </div> --}}
                        <div class="mb-3 row">

                            <div class="col-md-3">
                                <label class="col-form-label" for="title_of_application">Title of Applicant<span class="text-danger">*</span></label>
                                <select name="title_of_application" id="title_of_application" class="form-select" disabled>
                                    <option value="" disabled selected> -- Select -- </option>
                                    <option value="mr" {{ $treeProtection->title_of_application == 'mr' ? 'selected' : '' }}>Mr</option>
                                    <option value="mrs"{{ $treeProtection->title_of_application == 'mrs' ? 'selected' : '' }}>Mrs</option>
                                    <option value="ms"{{ $treeProtection->title_of_application == 'ms' ? 'selected' : '' }}>Ms</option>
                                </select>
                                <span class="text-danger is-invalid title_of_application_err"></span>

                            </div>
                            <div class="col-md-3">
                                <label class="col-form-label" for="f_name">First Name <span class="text-danger">*</span></label>
                                <input class="form-control" id="f_name" name="f_name" type="text" placeholder="Enter First Name" value="{{ $treeProtection->f_name ?? '' }}" readonly>
                                <span class="text-danger is-invalid f_name_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="m_name">Middle Name</label>
                                <input class="form-control" id="m_name" name="m_name" type="text" placeholder="Enter Middle Name" value="{{ $treeProtection->m_name ?? '' }}" readonly>
                                <span class="text-danger is-invalid m_name_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="l_name">Last Name <span class="text-danger">*</span></label>
                                <input class="form-control" id="l_name" name="l_name" type="text" placeholder="Enter Last Name" value="{{ $treeProtection->l_name ?? '' }}" readonly>
                                <span class="text-danger is-invalid l_name_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="flat_no">Plot/Flat No <span class="text-danger">*</span></label>
                                <input class="form-control" id="flat_no" name="flat_no" type="text" placeholder="Enter Last Name" value="{{ $treeProtection->flat_no ?? '' }}" readonly>
                                <span class="text-danger is-invalid flat_no_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="building_no">Name of the Building/Colony<span class="text-danger">*</span></label>
                                <input class="form-control" id="building_no" name="building_no" type="text" placeholder="Enter Last Name" value="{{ $treeProtection->building_no ?? '' }}" readonly>
                                <span class="text-danger is-invalid building_no_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="area">Name of the Area<span class="text-danger">*</span></label>
                                <input class="form-control" id="area" name="area" type="text" placeholder="Enter Last Name" value="{{ $treeProtection->area ?? '' }}" readonly>
                                <span class="text-danger is-invalid area_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="city">Name of City<span class="text-danger">*</span></label>
                                <input class="form-control" id="city" name="city" type="text" placeholder="Enter Last Name" value="{{ $treeProtection->city ?? '' }}" readonly>
                                <span class="text-danger is-invalid citye_err"></span>
                            </div>
                            <div class="col-md-3">
                                <label class="col-form-label" for="pincode">Pin Code<span class="text-danger">*</span></label>
                                <input class="form-control" id="pincode" name="pincode" type="number" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" placeholder="Enter Pincode" value="{{ $treeProtection->pincode ?? '' }}" readonly>
                                <span class="text-danger is-invalid pincode_err"></span>
                            </div>
                            <div class="col-md-3">
                                <label class="col-form-label" for="landmark">Near By Landmark<span class="text-danger">*</span></label>
                                <input class="form-control" id="landmark" name="landmark" type="text" placeholder="Enter Lamd mark" value="{{ $treeProtection->landmark ?? '' }}" readonly>
                                <span class="text-danger is-invalid landmark_err"></span>
                            </div>
                            <div class="col-md-3">
                                <label class="col-form-label" for="gut_number">City Survey/ Gut Number<span class="text-danger">*</span></label>
                                <input class="form-control" id="gut_number" name="gut_number" type="text" placeholder="Enter City" value="{{ $treeProtection->gut_number ?? '' }}" readonly>
                                <span class="text-danger is-invalid gut_number_err"></span>
                            </div>
                            <div class="col-md-3">
                                <label class="col-form-label" for="mobile_num">Mobile No</label><span class="text-danger">*</span>
                                <input class="form-control" id="mobile_num" name="mobile_num" type="text" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" placeholder="Enter Mobile Number" value="{{ $treeProtection->mobile_num ?? '' }}" readonly>
                                <span class="text-danger is-invalid mobile_numo_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="email">Email<span class="text-danger">*</span></label>
                                <input class="form-control" id="email" name="email" type="email" placeholder="Enter Email" value="{{ $treeProtection->email ?? '' }}" readonly>
                                <span class="text-danger is-invalid email_err"></span>
                            </div>

                           


                           <!-- Type of Applicant -->
<div class="col-md-3">
    <label class="col-form-label" for="type_application">
        Type of Applicant <span class="text-danger">*</span>
    </label>
    <select id="type_application" name="type_application" class="form-control" readonly>
        <option value="">-- Select Applicant Type --</option>
        <option value="{{ $treeProtection->type_application ?? '' }}" selected>
            {{ $treeProtection->type_application ?? '' }}
        </option>
    </select>
    <span class="text-danger is-invalid type_application_err"></span>
</div>

<!-- Reason For Trimming -->
<div class="col-md-3">
    <label class="col-form-label" for="reason_trim">
        Reason For Trimming <span class="text-danger">*</span>
    </label>
    <select id="reason_trim" name="reason_trim" class="form-control" readonly>
        <option value="">-- Select Reason --</option>
        <option value="{{ $treeProtection->reason_trim ?? '' }}" selected>
            {{ $treeProtection->reason_trim ?? '' }}
        </option>
    </select>
    <span class="text-danger is-invalid reason_trim_err"></span>
</div>


 <div class="col-md-3" id="other_tree_box">
    <label class="col-form-label" for="type_of_tree">
        No of Trees <span class="text-danger">*</span>
    </label>
    <input type="text" 
           name="type_of_tree" 
           id="type_of_tree" 
           class="form-control" 
           value="{{ $treeProtection->type_of_tree ?? '' }}" 
           placeholder="Enter no of tree" 
           readonly>
    <span class="text-danger is-invalid type_of_tree_err"></span>
</div>

{{-- ===================== सोसायटी / घरांच्या परिसरातील झाडे ===================== --}}
@if(!empty($treeProtection) 
    && $treeProtection->type_application == 'सोसायटी / घरांच्या परिसरातील झाडे तोडणे / पुर्नरोपण / छाटणी करणे.' 
    && $treeProtection->reason_trim == 'वृक्ष तोडणे')
    <div class="row" id="vruksh_todne_fields" style="display:flex;">
        <div class="col-md-3">
            <label class="col-form-label">नवीन वृक्षारोपण करायचे आहे का?</label>
            <input type="text" class="form-control" 
                   value="{{ $treeProtection->new_plant ?? '' }}" readonly>
        </div>

        <div class="col-md-3">
            <label class="col-form-label">वृक्षारोपणासाठी जागा उपलब्ध आहे का?</label>
            <input type="text" class="form-control" 
                   value="{{ $treeProtection->space_available ?? '' }}" readonly>
        </div>
    </div>
@elseif(!empty($treeProtection) 
    && $treeProtection->type_application == 'सोसायटी / घरांच्या परिसरातील झाडे तोडणे / पुर्नरोपण / छाटणी करणे.' 
    && $treeProtection->reason_trim == 'वृक्ष पुर्नरोपण करणे')
    <div class="row" id="vruksh_punharoopan_fields" style="display:flex;">
        <div class="col-md-3">
            <label class="col-form-label">नवीन वृक्ष पुनःरोपण करायचे आहे का?</label>
            <input type="text" class="form-control" 
                   value="{{ $treeProtection->new_replant ?? '' }}" readonly>
        </div>

        <div class="col-md-3">
            <label class="col-form-label">वृक्ष पुनःरोपणासाठी जागा उपलब्ध आहे का?</label>
            <input type="text" class="form-control" 
                   value="{{ $treeProtection->space_replant ?? '' }}" readonly>
        </div>
    </div>
@endif

{{-- ===================== धोकादायक झाडे मुळासहित काढणे ===================== --}}
@if(!empty($treeProtection) 
    && $treeProtection->type_application == 'सोसायटी / घरांच्या परिसरातील झाडे तोडणे / पुर्नरोपण / छाटणी करणे.' 
    && $treeProtection->reason_trim == 'धोकादायक झाडे मुळासहित काढणे')
    <div class="col-md-3" id="tree_height_section" style="display:flex;">
        <label class="col-form-label" for="tree_height">
            Tree Height <span class="text-danger">*</span>
        </label>
        <select name="tree_height" id="tree_height" class="form-control" disabled>
            <option value="">-- Select Tree Height --</option>
            <option value="{{ $treeProtection->tree_height ?? '' }}" selected>
                {{ $treeProtection->tree_height ?? '' }}
            </option>
        </select>
        <span class="text-danger is-invalid tree_height_err"></span>
    </div>
@else
    <div class="col-md-3" id="tree_height_section" style="display:none;">
        <label class="col-form-label" for="tree_height">
            Tree Height <span class="text-danger">*</span>
        </label>
        <select name="tree_height" id="tree_height" class="form-control" disabled>
            <option value="">-- Select Tree Height --</option>
        </select>
        <span class="text-danger is-invalid tree_height_err"></span>
    </div>
@endif








                            {{-- <div class="col-md-3">
                                <label class="col-form-label" for="owner">Type of Owner<span class="text-danger">*</span></label>
                                <select name="owner" id="owner" class="form-select" disabled>
                                    <option value="" disabled selected> -- Select -- </option>
                                    <option value="private" {{ $treeProtection->owner == 'private' ? 'selected' : '' }}>Private</option>
                                    <option value="corporation" {{ $treeProtection->owner == 'corporation' ? 'selected' : '' }}>Corporation</option>
                                    <option value="government" {{ $treeProtection->owner == 'government' ? 'selected' : '' }}>Government</option>
                                    <option value="semi_govt" {{ $treeProtection->owner == 'semi_govt' ? 'selected' : '' }}>Semi Govt</option>
                                </select>
                                <span class="text-danger is-invalid owner_err"></span>

                            </div> --}}

                           {{-- <div class="col-md-3" id="tree_height_section" 
     style="{{ isset($treeProtection->tree_height) ? 'display:flex;' : 'display:none;' }}">
    <label class="col-form-label" for="tree_height">
        Tree Height <span class="text-danger">*</span>
    </label>
    <select name="tree_height" id="tree_height" class="form-control" disabled>
        <option value="">-- Select Tree Height --</option>
        <option value="{{ $treeProtection->tree_height ?? '' }}" selected>
            {{ $treeProtection->tree_height ?? '' }}
        </option>
    </select>
    <span class="text-danger is-invalid tree_height_err"></span>
</div> --}}



                            {{-- @if(!empty($treeProtection))
    <div class="row" id="vruksh_todne_fields" style="display:flex;">
        <div class="col-md-3">
            <label class="col-form-label">नवीन वृक्षारोपण करायचे आहे का?</label>
            <input type="text" class="form-control" 
                   value="{{ $treeProtection->new_plant ?? '' }}" readonly>
        </div>

        <div class="col-md-3">
            <label class="col-form-label">वृक्षारोपणासाठी जागा उपलब्ध आहे का?</label>
            <input type="text" class="form-control" 
                   value="{{ $treeProtection->space_available ?? '' }}" readonly>
        </div>
    </div>
@endif --}}



{{-- @if(!empty($treeProtection))
    <div class="row" id="vruksh_punharoopan_fields" style="display:flex;">
        <div class="col-md-3">
            <label class="col-form-label">नवीन वृक्ष पुनःरोपण करायचे आहे का?</label>
            <input type="text" class="form-control" 
                   value="{{ $treeProtection->new_replant ?? '' }}" readonly>
        </div>

        <div class="col-md-3">
            <label class="col-form-label">वृक्ष पुनःरोपणासाठी जागा उपलब्ध आहे का?</label>
            <input type="text" class="form-control" 
                   value="{{ $treeProtection->space_replant ?? '' }}" readonly>
        </div>
    </div>
@endif --}}



                            {{-- <div class="col-md-3">
                                <label class="col-form-label" for="type_of_tree">Type of Tree<span class="text-danger">*</span></label>
                                <select name="type_of_tree" id="type_of_tree" class="form-select" disabled>
                                    <option value="" disabled selected> -- Select -- </option>
                                    <option value="fruit" {{ $treeProtection->type_of_tree == 'fruit' ? 'selected' : '' }}>Fruit Tree</option>
                                    <option value="other" {{ $treeProtection->type_of_tree == 'other' ? 'selected' : '' }}>Other Tree</option>
                                    <span class="text-danger is-invalid type_of_treel_err"></span>

                                </select>
                            </div> --}}
                           


                            <div class="col-mb-3">
                                <label class="col-form-label fw-bold">
                                    List of Documents (Attachment) For Tree Branches Trimming <span class="text-danger">*</span>
                                </label>
                                <div class="alert alert-info p-2">
                                    <strong>Note:</strong> Upload Below Files only <strong>pdf, jpg, jpeg</strong>, etc. Max up to <strong>5MB</strong>.
                                </div>
                            </div>
                                <div class="col-md-3">
                                    <label class="col-form-label" for="paid_receipt">Current Year Property Tax Paid Receipt <span class="text-danger">*</span></label>
                                    @if ($treeProtection->paid_receipt)
                                        <div>
                                            <a href="{{ asset('storage/' . $treeProtection->paid_receipt) }}" target="_blank" class="btn btn-info btn-sm">
                                                View Document
                                            </a>
                                        </div>
                                    @endif
                                    <span class="text-danger is-invalid paid_receipt_err"></span>
                                </div>

                                <div class="col-md-3">
                                    <label class="col-form-label" for="photo_tree">Photograph of Tree <span class="text-danger">*</span></label>
                                    @if ($treeProtection->photo_tree)
                                        <div>
                                            <a href="{{ asset('storage/' . $treeProtection->photo_tree) }}" target="_blank" class="btn btn-info btn-sm">
                                                View Document
                                            </a>
                                        </div>
                                    @endif
                                    <span class="text-danger is-invalid photo_tree_err"></span>
                                </div>

                                <div class="col-md-3">
                                    <label class="col-form-label" for="aadhar">Aadhaar Card <span class="text-danger">*</span></label>
                                    @if ($treeProtection->aadhar)
                                        <div>
                                            <a href="{{ asset('storage/' . $treeProtection->aadhar) }}" target="_blank" class="btn btn-info btn-sm">
                                                View Document
                                            </a>
                                        </div>
                                    @endif
                                    <span class="text-danger is-invalid aadhar_err"></span>
                                </div>

                                <div class="col-md-3">
                                    <label class="col-form-label" for="building_permission">Building Permission</label>
                                    @if ($treeProtection->building_permission)
                                        <div>
                                            <a href="{{ asset('storage/' . $treeProtection->building_permission) }}" target="_blank" class="btn btn-info btn-sm">
                                                View Document
                                            </a>
                                        </div>
                                    @endif
                                    <span class="text-danger is-invalid building_permission_err"></span>
                                </div>

                                <div class="col-md-3">
                                    <label class="col-form-label" for="plan_construction">Sanctioned Plan of Construction <span class="text-danger">*</span></label>
                                    @if ($treeProtection->plan_construction)
                                        <div>
                                            <a href="{{ asset('storage/' . $treeProtection->plan_construction) }}" target="_blank" class="btn btn-info btn-sm">
                                                View Document
                                            </a>
                                        </div>
                                    @endif
                                    <span class="text-danger is-invalid plan_construction_err"></span>
                                </div>

                                <div class="col-md-3">
                                    <label class="col-form-label" for="noc_letter">NOC Letter <span class="text-danger">*</span></label>
                                    @if ($treeProtection->noc_letter)
                                        <div>
                                            <a href="{{ asset('storage/' . $treeProtection->noc_letter) }}" target="_blank" class="btn btn-info btn-sm">
                                                View Document
                                            </a>
                                        </div>
                                    @endif
                                    <span class="text-danger is-invalid noc_letter_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="prescribed_docs">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                    @if ($treeProtection->prescribed_doc)
                                        <div>
                                            <a href="{{ asset('storage/' . $treeProtection->prescribed_doc) }}" target="_blank" class="btn btn-info btn-sm">
                                                View Document
                                            </a>
                                        </div>
                                    @endif
                                    <span class="text-danger is-invalid prescribed_docs_err"></span>
                                </div>


                        @if(Auth::check() && Auth::user()->hasRole('User'))
                            <label class="col-form-label" for="is_correct_info"><b>Terms And Conditions</b></label>

                            <br>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="selectAll" name="select_all" checked>
                                    <label class="form-check-label ms-2" for="selectAll">
                                        Select All
                                    </label>
                                </div>
                                <br>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input checkItem" name="item1" value="1" checked>
                                    <label class="form-check-label">In case of any kind of accident or loss of life or damage to government and private property and damage to electric wire, phone wire, cable etc. while cutting the said tree, it will be the responsibility of the applicant to compensate the same.</label>
                                </div>
                                <br>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input checkItem" name="item2" value="2" checked>
                                    <label class="form-check-label">In case of any kind of dispute regarding the ownership of the land or the trees or if any objection or objection is raised by the interested parties, the applicant will be responsible for the same.</label>
                                </div>
                                <br>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input checkItem" name="item3" value="3" checked>
                                    <label class="form-check-label">Under the provisions of section 8 sub-section 3 (c) of the Maharashtra Urban Area Tree Preservation Act, 1975, the act of felling a tree shall remain valid for one month from the date of the said permission.</label>
                                </div>
                                <br>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input checkItem" name="item3" value="3" checked>
                                    <label class="form-check-label">After pruning the tree, the branches, leaves and wood chips of the tree should be picked up immediately.</label>
                                </div>
                                <br>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input checkItem" name="item3" value="3" checked>
                                    <label class="form-check-label">In the presence of the garden assistant of the park department or the representative of the park department, the process of cutting the said tree should be done.</label>
                                </div>
                                <br>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input checkItem" name="item3" value="3" checked>
                                    <label class="form-check-label">It should be noted that in case of pruning of tree branches in excess of the permit, legal action will be taken against you as per the rules for violation of Section 21 (1) of the Maharashtra (Urban Area) Protection and Preservation of Trees Act, 1975.</label>
                                </div>
                                <br>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input checkItem" name="item3" value="3" checked>
                                    <label class="form-check-label">If there are birds, nests of birds on the trees, they should be shifted to a suitable place with the advice of wildlife experts. So that vigilance should be taken to ensure that there is no loss/damage to biodiversity at that place. It should also be noted that in case of any such damage/accident, the applicant will be fully responsible for it.</label>
                                </div>
                                <br>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input checkItem" name="item3" value="3" checked>
                                    <label class="form-check-label">Tree trimming should not be done on Sundays and public holidays.</label>
                                </div>
                                <br>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input checkItem" name="item3" value="3" checked>
                                    <label class="form-check-label">If the above conditions are acceptable, the tree should be felled.</label>
                                </div>
                                <!-- JavaScript to handle select all functionality -->
                                <script>
                                    document.getElementById('selectAll').addEventListener('change', function() {
                                        let checkboxes = document.querySelectorAll('.checkItem');
                                        checkboxes.forEach(checkbox => {
                                            checkbox.checked = this.checked;
                                        });
                                    });
                                </script>


                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div>
                        @endif
                        <div class="col-md-3">
                            <label for="remark">Remark<span class="text-danger">*</span></label>
                            <textarea id="Remark" maxlength="255" name="remark" class="form-control" rows="4" required></textarea>
                        </div>
                        </div>
                    </div>
                    <div class="card-footer">
                         <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });

</script>
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>


{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);


        var formdata = new FormData(this);
        var updateUrl = '{{ route('tree-protection.update', $treeProtection->id) }}';
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
