<x-admin.layout>
    <x-slot name="title">Verify Payment Receipt</x-slot>
    <x-slot name="heading">Verify Payment Receipt</x-slot>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Verify Payment Receipt</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="alternative-pagination" class="table table-bordered align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Sr No</th>
                                    <th>Application No</th>
                                    <th>Service Name</th>
                                    <th>Date</th>
                                    <th>Fees </th>
                                    <th>Reciept</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($datas as $data)
                                    @php $status = $data->statuses; @endphp
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $data->application_no ?? 'N/A' }}</td>
                                        <td style="white-space: normal; word-wrap: break-word;">
                                            {{ @$status->serviceName->service_name }}
                                        </td>
                                        <td>
                                            {{ isset($status->receipt_uploaded_at) ? date('d-m-Y h:i A', strtotime($status->receipt_uploaded_at)) : '' }}
                                        </td>
                                        <td> {{ @$status->fees_amount }}</td>
                                        <td>
                                            <a href="{{ asset('storage/' . $status->offlinereceipt) }}" target="_blank" class="btn btn-primary btn-sm p-1">
                                                <i class="fa fa-download"></i> Receipt
                                            </a>
                                        </td>
                                        <td>
                                            @if (@$status->receipt_status == 0)
                                                <div class="d-flex gap-2">
                                                    <button class="btn btn-sm btn-success verify-btn" data-id="{{ $status->id }}" data-status="1">
                                                        <i class="fa fa-check me-1"></i> Approve
                                                    </button>
                                                    <button class="btn btn-sm btn-danger verify-btn" data-id="{{ $status->id }}" data-status="2">
                                                        <i class="fa fa-times me-1"></i> Reject
                                                    </button>
                                                </div>
                                            @else
                                                {!! $status->getReceiptBadgeAttribute() !!}
                                            @endif
                                        </td>

                                    </tr>
                                @empty
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Include SweetAlert2 and jQuery --}}
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function() {
            let table = $('#alternative-pagination').DataTable();

            // Apply default ordering by Date column (4th column, index 3)
            table.order([3, 'desc']).draw();

            $('.verify-btn').click(function() {
                const statusId = $(this).data('id');
                const receiptStatus = $(this).data('status');
                const $row = $(this).closest('tr'); // target the current row

                Swal.fire({
                    title: receiptStatus == 1 ? 'Approve Receipt?' : 'Reject Receipt?',
                    input: 'textarea',
                    inputLabel: 'Enter Remark (mandatory)',
                    inputPlaceholder: 'Type your remark here...',
                    inputValidator: (value) => {
                        if (!value) return 'Remark is required!';
                    },
                    showCancelButton: true,
                    confirmButtonText: 'Submit',
                    preConfirm: (remark) => {
                        return $.ajax({
                            url: "{{ route('verify-payment-reciept.verify', ['status' => '__id__']) }}".replace('__id__', statusId),
                            method: 'POST',
                            data: {
                                receipt_status: receiptStatus,
                                receipt_remark: remark,
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(res) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success!',
                                    text: res.message
                                });

                                // Remove the row from DataTable without reload
                                table.row($row).remove().draw();
                            },
                            error: function(err) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: err.responseJSON?.message || 'Something went wrong!'
                                });
                            }
                        });
                    }
                });
            });
        });
    </script>



</x-admin.layout>
