<x-admin.layout>
    <x-slot name="title">Usage Change / वापरामध्ये बदल करणे</x-slot>
    <x-slot name="heading">Usage Change / वापरामध्ये बदल करणे</x-slot>
    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">

                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" value="{{ $user->name }}" placeholder="Enter Applicant Name" required>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="address" name="address" type="text" placeholder="Enter Name Of New Owner" required>{{ $user->address }} </textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Applicant Mobile No / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $user->mobile }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text"
                                    placeholder="Enter Mobile Number" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Applicant EmailID / ईमेल आयडी<span class="text-danger"></span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $user->email }}" required>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Applicant Adhaar No / आधार क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" value='{{ $user->aadhar_no }}' oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text"
                                    placeholder="Enter Aadhar Card No" required>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>

                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">

                            @csrf
                            <div class="col-md-4">
                                <input class="form-control" id="marchantid" name="marchantid" type="hidden" value="MBMCCORE">
                                <span class="text-danger is-invalid marchantid_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="connection_no">Connection No<span class="text-danger">*</span></label>
                                <input class="form-control" id="connection_no" name="connection_no" type="text" placeholder="Enter Connection Number" >
                                <span class="text-danger is-invalid connection_no_err"></span>
                                <input type="hidden" name="Water_Connection_Number" id='Water_Connection_Number'>
                            </div>

                            <button type="Search" class="btn btn-primary mt-2" id="searchdetails">Search</button>
                        </div>
                    </div>



                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Water Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_owner_name">Owner Name/मालकाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="property_owner_name" name="property_owner_name" type="text" placeholder="Enter Owner Name"  readonly>
                                    <span class="text-danger is-invalid property_owner_name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Full_Address_Of_The_Property"> Owner Address/मालकाचा पत्ता<span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="Full_Address_Of_The_Property" id="Full_Address_Of_The_Property" cols="30" rows="2" placeholder="Enter  Address"  readonly></textarea>
                                    <span class="text-danger is-invalid Full_Address_Of_The_Property_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Ward" id="Ward" placeholder="Enter Ward Area"  readonly>
                                    <span class="text-danger is-invalid Ward_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <input class="form-control" name="zone" id="zone" placeholder="Enter Zone"  readonly>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Size">Water Connection Size<span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Size" name="Water_Connection_Size" type="text" placeholder="Enter Water Connection Size"  readonly>
                                    <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Connection_Type">Connection Type<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Connection_Type" id="Connection_Type" type="text" placeholder="Enter Connection Type"  readonly>
                                    <span class="text-danger is-invalid Connection_Type_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Usage">Water Connection Usage <span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Usage" name="Water_Connection_Usage" type="text" placeholder="Enter Water Connection Usage"  readonly>
                                    <span class="text-danger is-invalid Water_Connection_Usage_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="OutstandingAmt"> Total Outstanding Payable/ एकूण थकबाकी बिल भरले?<span class="text-danger">*</span></label>
                                    <input class="form-control" id="OutstandingAmt" name="OutstandingAmt" type="text"  readonly>
                                    <span class="text-danger is-invalid OutstandingAmt_err"></span>
                                </div>

                                <div class="col-md-4 mt-4">
                                    <button type="button" id="payaccentech" class="btn btn-success" target="_blank"
                                        onclick="window.location.href='https://watertax.nagarkaryavali.com/FrmWTConnSearch.aspx?@=AD65C7423AEA4530E3CB0528C8EFFFE4185BBCFBFA074578B362FC23AB6A7765'">Pay</button>
                                </div>

                            </div>
                        </div>
                    </div>

                    {{-- <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data"> --}}
                    @csrf

                    {{-- <div class="card-header">
                        <h4 class="card-title">Add Details</h4>
                    </div> --}}
                    <div class="card-header">
                        <h4 class="card-title">Connection Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name"> Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" placeholder="Enter Applicant Name" required>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address"> Applicant Full Address/ अर्जदाराचा पूर्ण पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_address" name="applicant_address" type="text" placeholder="Enter Applicant Name" required>
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text" placeholder="Enter Mobile Number" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Email Id / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" required>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Aadhar No / आधार क्र <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text" placeholder="Enter Aadhar Card No" required>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="total_connection">Total Connections/एकूण कनेक्शन <span class="text-danger">*</span></label>
                                <input class="form-control" id="total_connection" name="total_connection" type="text" placeholder="Enter Plot Number" >
                                <span class="text-danger is-invalid total_connection_err"></span>
                            </div>


                             {{-- <div class="col-md-4">
                            <label class="col-form-label" for="Water_Connection_Size">
                                Water Connection Type <span class="text-danger">*</span>
                            </label>
                            <select class="form-control" id="Water_Connection_Size_Count" name="Water_Connection_Size_Count">
                                <option value="">-- Select --</option>
                                <option value="5000">घरगुती</option>
                                <option value="5000">वाणिज्य </option>
                            </select>
                            <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                        </div> --}}


                        <div class="col-md-4">
    <label class="col-form-label" for="Water_Connection_Size_Count">
        Water Connection Type <span class="text-danger">*</span>
    </label>
    <select class="form-control" id="Water_Connection_Size_Count" name="Water_Connection_Size_Count" required>
        <option value="">-- Select --</option>
        <option value="5000" data-label="घरगुती">घरगुती</option>
        <option value="5000" data-label="वाणिज्य">वाणिज्य</option>
    </select>
    <input type="hidden" id="Water_Connection_Label_one" name="Water_Connection_Label_one">
    <span class="text-danger is-invalid Water_Connection_Size_err"></span>
</div>




                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="water_connection_no">Connection No / कनेक्शन क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" id="water_connection_no" name="water_connection_no" type="text" placeholder="CNNP01B0000001" required>
                                <span class="text-danger is-invalid water_connection_no_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="property_owner_name">Property Owner Name / मालमत्ता मालकाचे नाव <span class="text-danger">*</span></label>
                                <input class="form-control" id="property_owner_name" name="property_owner_name" type="text" placeholder="Enter Property Owner Name" required>
                                <span class="text-danger is-invalid property_owner_name_err"></span>
                            </div> --}}
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="address">Owner Full Address/ मालकाचा पूर्ण पत्ता<span class="text-danger">*</span></label>
                                <textarea class="form-control" name="address" id="address" cols="30" rows="2" placeholder="Enter  Address" required></textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <select class="form-select" name="zone" id="zone" required>
                                        <option value="">Select Zone</option>

                                        @foreach ($zones as $zone)
                                        <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div> --}}
                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <select class="form-select" name="ward_area" id="ward_area" required>
                                        <option value="">Select Ward Area</option>

                                        @foreach ($wards as $ward)
                                        <option value="{{ $ward->name }}">{{ $ward->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid ward_area_err"></span>
                                </div> --}}



                            <div class="col-md-4">
                                <label class="col-form-label" for="house_no">House No / घर क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="house_no" name="house_no" type="text" placeholder="Enter House Number" >
                                <span class="text-danger is-invalid house_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="landmark">Landmark / जवळची खूण<span class="text-danger">*</span></label>
                                <input class="form-control" id="landmark" name="landmark" type="text" placeholder="Enter Landmark" >
                                <span class="text-danger is-invalid landmark_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="property_no">Property Number/ मालमत्ता क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="property_no" name="property_no" type="text" placeholder="Enter House Number" required>
                                <span class="text-danger is-invalid property_no_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="water_usage">Old Usage of Water Connection/पाण्याच्या कनेक्शनचा जुना वापर<span class="text-danger">*</span></label>
                                <select class="form-select" name="water_usage" id="water_usage" >
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['औध्योगिक व्यवसायासाठी', 'घरघुती वापरा साठी', 'बिगर घरघुती वापरासाठी', 'वाणिज्य'];
                                    @endphp

                                    @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid water_usage_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="new_water_con_usage">New Usage of Water Connection/ पाणी जोडणीचा नवीन वापर<span class="text-danger">*</span></label>
                                <select class="form-select" name="new_water_con_usage" id="new_water_con_usage" >
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['औध्योगिक व्यवसायासाठी', 'घरघुती वापरा साठी', 'बिगर घरघुती वापरासाठी', 'वाणिज्य'];
                                    @endphp

                                    @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid new_water_con_usage_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="sub_usage">Old Water Sub Usage/ जुना पाण्याचा उप वापर<span class="text-danger">*</span></label>
                                <select class="form-select" name="sub_usage" id="sub_usage" required>
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['अनिवासी', 'कार्यशाळा', 'केंद्र सरकारी', 'खुला भूखंड', 'गोदाम', 'दुकान', 'निवासी', 'राज्य सरकारी'];
                                    @endphp

                                    @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid sub_usage_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="new_sub_usage"> New Water Sub Usage/नवीन पाण्याचा उप-वापर <span class="text-danger">*</span></label>
                                <select class="form-select" name="new_sub_usage" id="new_sub_usage" >
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['अनिवासी व्यवसाय', 'औद्योगीक', 'निवासी', 'विशेष प्रवर्ग (शैक्षणिक संस्था,शासकीय,निमशासकीय कार्यालय,पथसंस्था,इतर)', 'व्यावसायिक अथवा वाणिज्य'];
                                    @endphp

                                    @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid new_sub_usage_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="water_connection_size">Connection Size/ कनेक्शन आकार<span class="text-danger">*</span></label>
                                <select class="form-select" name="water_connection_size" id="water_connection_size" required>
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['15mm', '20mm', '25mm', '40mm', '50mm', '80mm', '100mm', '150mm', '300mm'];
                                    @endphp

                                    @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid water_connection_size_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="no_of_existing_con">Number of Existing Water Connection /विद्यमान पाणी जोडणींची संख्या<span class="text-danger">*</span></label>
                                <input class="form-control" id="no_of_existing_con" name="no_of_existing_con" type="text" placeholder="Enter Number Of Users For New Tap Connection" >
                                <span class="text-danger is-invalid no_of_existing_con_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="current_connection_is_illegal">If Any Criminal Judicial Issues exist on Connection/ कनेक्शनवर कोणतेही फौजदारी न्यायिक मुद्दे असल्यास<span class="text-danger"></span></label>
                                <select class="form-select" name="current_connection_is_illegal" id="current_connection_is_illegal" >
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['Yes', 'No'];
                                    @endphp

                                    @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid current_connection_is_illegal_err"></span>
                            </div>

                            <div class="col-md-4" id="upload_section" style="display:none;">
                                <label class="col-form-label" for="application_documents">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <input class="form-control" id="application_documents" name="application_documents" type="file" >
                                <span class="text-danger is-invalid application_documents_err"></span>
                            </div>




                            {{--

                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_is_on_rent">Is Applicant On Rent / अर्जदार भाड्याने आहे का ?<span class="text-danger">*</span></label>
                                    <select class="form-select" name="applicant_is_on_rent" id="applicant_is_on_rent" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp

                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid applicant_is_on_rent_err"></span>
                                </div>



                                <div class="col-md-4">
                                    <label class="col-form-label" for="place_belongs_to_municipal">Place Belongs To Municipal Council Limit / सदर जागा नगरपरिषदेच्या हद्दीत आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="place_belongs_to_municipal" id="place_belongs_to_municipal" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp

                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid place_belongs_to_municipal_err"></span>
                                </div>


                                <div class="col-md-4">
                                    <label class="col-form-label" for="any_police_complaint">Is Any Police Or Court Complaint About Property Connection / मालमत्तेच्या कनेक्शनबद्दल कोणतीही पोलीस किंवा न्यायालयीन तक्रार आहे का ? * <span class="text-danger">*</span></label>
                                    <select class="form-select" name="any_police_complaint" id="any_police_complaint" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp

                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid any_police_complaint_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="nodues_documents">Upload Certificate Of No Dues / थकबाकी नसल्याचा दाखला अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="nodues_documents" name="nodues_documents" type="file" required>
                                    <span class="text-danger is-invalid nodues_documents_err"></span>
                                </div>

                               --}}

                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" >
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                              <span class="text-danger is-invalid is_correct_info_err d-block mt-1"></span>
                            </div>

                        </div>
                    </div>
                    <div class="form-group" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                    </div>
                    <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                        <button type="reset" class="btn btn-warning">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

{{-- <script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn = document.getElementById('saveAndPrintBtn');
    const form = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');

    const errorMessages = {
        connection_no: 'Connection No is Required',
        property_owner_name: 'Property Owner is Required',
        Full_Address_Of_The_Property: 'Full Address is Required',
        Ward: 'Ward is Required',
        zone: 'Zone is Required',
        Water_Connection_Size: 'Water Connection is Required',
        Connection_Type: 'Connection Type is Required',
        Water_Connection_Usage: 'Water Connection Usage is Required',
        OutstandingAmt: 'Outstanding is Required',
        total_connection: 'Total Connection is Required',
        house_no: 'House is Required',
        landmark: 'Landmark is Required',
        water_usage: 'Water Usage is Required',
        new_water_con_usage: 'New Water is Required',
        sub_usage: 'Sub Usage is Required',
        new_sub_usage: 'New Sub Usage is Required',
        no_of_existing_con: 'No of Connection is Required',
        current_connection_is_illegal: 'Current Connection is Required',
        is_correct_info: 'Please accept the Declaration'
    };

    if (!saveBtn || !form) return;

    // Remove all existing error messages
    function clearErrors() {
        form.querySelectorAll('.error-msg').forEach(el => el.remove());
    }

    // Show error message below field
    function showError(field, message) {
    if (field.name === 'is_correct_info') {
        const errSpan = document.querySelector('.is_correct_info_err');
        if (errSpan) errSpan.textContent = message;
        return;
    }

    let errorEl = document.createElement('span');
    errorEl.className = 'error-msg text-danger d-block mt-1';
    errorEl.textContent = message;

    const next = field.nextElementSibling;
    if (next && next.classList.contains('error-msg')) next.remove();

    field.insertAdjacentElement('afterend', errorEl);
}

    saveBtn.addEventListener('click', function (e) {
        e.preventDefault();

        // Remove file input temporarily
        if (fileInput) fileInput.removeAttribute('required');

        clearErrors();

        let isValid = true;

        // Loop through required fields
        for (const fieldName in errorMessages) {
            const field = form.querySelector(`[name="${fieldName}"]`);
            if (field) {
                const isEmpty = !field.value || (field.type === 'checkbox' && !field.checked);
                if (isEmpty) {
                    showError(field, errorMessages[fieldName]);
                    field.focus();
                    isValid = false;
                }
            }
        }

        if (!isValid) {
            if (fileInput) fileInput.setAttribute('required', 'required');
            return; 
        }

        
        const uploadSection = document.getElementById('upload_section');
        const cardFooter = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter) cardFooter.style.display = 'block';

        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const printClone = addContainer.cloneNode(true);
        const uploadSectionInClone = printClone.querySelector('#upload_section');
if (uploadSectionInClone) {
    uploadSectionInClone.remove();
} 

        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        Array.from(printClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of water change connection usage';
        printClone.insertBefore(printTitle, printClone.firstChild);

        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });

     
printClone.querySelectorAll('select').forEach(selectClone => {
 
    const originalSelect = form.querySelector(`[name="${selectClone.name}"]`);
    let selectedValue = '';
    if (originalSelect) {
        selectedValue = originalSelect.options[originalSelect.selectedIndex]?.text || '';
    }

   
    const input = document.createElement('input');
    input.type = 'text';
    input.value = selectedValue;
    input.readOnly = true;
    input.style.width = '100%';
    input.style.padding = '4px 8px';
    input.style.margin = '4px 0';
    input.style.border = '1px solid #ccc';
    input.style.borderRadius = '4px';

   
    selectClone.parentNode.replaceChild(input, selectClone);
});


        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;

            pdf.addImage(
                imgData, 'JPEG',
                margin, margin,
                pdf.internal.pageSize.getWidth() - margin * 2,
                pdf.internal.pageSize.getHeight() - margin * 2
            );

            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content.');
            }

            pdf.save('Water_Change_Connection_UsageCertificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });
});
</script> --}}


<script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn = document.getElementById('saveAndPrintBtn');
    const form = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');
    const isCorrectInfo = document.getElementById('is_correct_info');
    const declarationError = document.querySelector('.is_correct_info_err');

    const errorMessages = {
        connection_no: 'Connection No is Required',
        property_owner_name: 'Property Owner is Required',
        Full_Address_Of_The_Property: 'Full Address is Required',
        Ward: 'Ward is Required',
        zone: 'Zone is Required',
        Water_Connection_Size: 'Water Connection is Required',
        Connection_Type: 'Connection Type is Required',
        Water_Connection_Usage: 'Water Connection Usage is Required',
        OutstandingAmt: 'Outstanding is Required',
        total_connection: 'Total Connection is Required',
        house_no: 'House is Required',
        landmark: 'Landmark is Required',
        water_usage: 'Water Usage is Required',
        new_water_con_usage: 'New Water is Required',
        sub_usage: 'Sub Usage is Required',
        new_sub_usage: 'New Sub Usage is Required',
        no_of_existing_con: 'No of Connection is Required',
       // current_connection_is_illegal: 'Current Connection is Required',
        is_correct_info: 'Please accept the Declaration'
    };

    if (!saveBtn || !form) return;

    // ✅ Clear all error messages
    function clearErrors() {
        form.querySelectorAll('.error-msg').forEach(el => el.remove());
        if (declarationError) declarationError.textContent = '';
    }

    // ✅ Show error message below field
    function showError(field, message) {
        if (field.name === 'is_correct_info') {
            if (declarationError) declarationError.textContent = message;
            return;
        }

        let errorEl = document.createElement('span');
        errorEl.className = 'error-msg text-danger d-block mt-1';
        errorEl.textContent = message;

        const next = field.nextElementSibling;
        if (next && next.classList.contains('error-msg')) next.remove();

        field.insertAdjacentElement('afterend', errorEl);
    }

    // ✅ Hide error message when Declaration checkbox is checked
    if (isCorrectInfo) {
        isCorrectInfo.addEventListener('change', function () {
            if (this.checked && declarationError) {
                declarationError.textContent = '';
            }
        });
    }

    saveBtn.addEventListener('click', function (e) {
        e.preventDefault();
        if (fileInput) fileInput.removeAttribute('required');
        clearErrors();

        let isValid = true;

        // ✅ Validate all required fields
        for (const fieldName in errorMessages) {
            const field = form.querySelector(`[name="${fieldName}"]`);
            if (field) {
                const isEmpty = !field.value || (field.type === 'checkbox' && !field.checked);
                if (isEmpty) {
                    showError(field, errorMessages[fieldName]);
                    if (isValid) field.focus();
                    isValid = false;
                }
            }
        }

        if (!isValid) {
            if (fileInput) fileInput.setAttribute('required', 'required');
            return;
        }

        // === PDF generation section ===
        const uploadSection = document.getElementById('upload_section');
        const cardFooter = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter) cardFooter.style.display = 'block';

        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const printClone = addContainer.cloneNode(true);
        const uploadSectionInClone = printClone.querySelector('#upload_section');
        if (uploadSectionInClone) uploadSectionInClone.remove();

        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        Array.from(printClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of water change connection usage';
        printClone.insertBefore(printTitle, printClone.firstChild);

        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });

        // Replace select with readonly input
        printClone.querySelectorAll('select').forEach(selectClone => {
            const originalSelect = form.querySelector(`[name="${selectClone.name}"]`);
            let selectedValue = '';
            if (originalSelect) {
                selectedValue = originalSelect.options[originalSelect.selectedIndex]?.text || '';
            }

            const input = document.createElement('input');
            input.type = 'text';
            input.value = selectedValue;
            input.readOnly = true;
            input.style.width = '100%';
            input.style.padding = '4px 8px';
            input.style.margin = '4px 0';
            input.style.border = '1px solid #ccc';
            input.style.borderRadius = '4px';

            selectClone.parentNode.replaceChild(input, selectClone);
        });

        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;

            pdf.addImage(
                imgData, 'JPEG',
                margin, margin,
                pdf.internal.pageSize.getWidth() - margin * 2,
                pdf.internal.pageSize.getHeight() - margin * 2
            );

            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content.');
            }

            pdf.save('Water_Change_Connection_UsageCertificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });
});
</script>






{{-- Add --}}
<script>
    $('#searchdetails').on('click', function(e) {
        e.preventDefault();

        let formData = {
            marchantid: $('#marchantid').val(),
            connection_no: $('#connection_no').val(),
            _token: $('input[name="_token"]').val()
        };

        $.ajax({
            url: '{{ route('fetch.water.details') }}',
            method: 'POST',
            data: formData,
            datatype: JSON,
            success: function(response) {
                console.log("Encrypted Data:", response.jsonData.encr_request);

                const decryptedData = JSON.parse(response.jsonData.encr_request); // Replace with actual decryption function

                console.log("Decrypted Data:", decryptedData['connectionDetails'].Water_Connection_Number);

                if (decryptedData && decryptedData['connectionDetails']) {
                    $('#Connection_Type').val(decryptedData['connectionDetails'].Connection_Type);
                    $('#Water_Connection_Number').val(decryptedData['connectionDetails'].Water_Connection_Number);
                    $('#House_Number').val(decryptedData['connectionDetails'].House_Number);
                    $('#property_owner_name').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    $('#Full_Address_Of_The_Property').val(decryptedData['connectionDetails'].Full_Address_Of_The_Property);
                    $('#Water_Connection_Size').val(decryptedData['connectionDetails'].Water_Connection_Size);
                    $('#Water_Connection_Usage').val(decryptedData['connectionDetails'].Water_Connection_Usage);
                    $('#zone').val(decryptedData['connectionDetails'].Zone);
                    $('#Ward').val(decryptedData['connectionDetails'].Ward);
                    $('#OutstandingAmt').val(decryptedData['connectionDetails'].OutstandingAmt);
                    // $('#water_connection_no').val(decryptedData['connectionDetails'].Water_Connection_Number);
                    // $('#property_owner_name').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    // $('#new_owner_name').val(decryptedData['connectionDetails'].Full_Address_Of_The_Property);
                    // $('#address').val(decryptedData['connectionDetails'].Water_Connection_Size);
                    // $('#house_no').val(decryptedData['connectionDetails'].Water_Connection_Usage);
                    // $('#owner_add').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    // $('#ward').val(decryptedData['connectionDetails'].Ward);
                } else {
                    console.error("connectionDetails is missing or undefined");
                }
            },

            error: function(xhr) {
                console.error(xhr.responseText);
            }
        });
    });


    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('water-change-connection-usage.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>

<script>
$(document).ready(function(){
    // Allow only numbers in total_connection
    $('#total_connection').on('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '');
    });

    // Allow only numbers in house_no
    $('#house_no').on('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
});
</script>

<script>
document.getElementById('Water_Connection_Size_Count').addEventListener('change', function() {
    let selectedOption = this.options[this.selectedIndex];
    let label = selectedOption.getAttribute('data-label');
    document.getElementById('Water_Connection_Label_one').value = label || '';
});
</script>

