<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .content {
            margin-top: 30px;
        }

        /* .sub-header {
            text-align: right;
        } */
        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }

        .points {
            margin-top: 20px;
        }

        .points li {
            margin-bottom: 10px;
            margin-left: 5%;
        }

        p {
            font-size: 16px;
        }
    </style>
</head>

<body>

    <div class="header">
        @php
            $logoData = file_get_contents(public_path('admin/images/favicon.png'));
            $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
            $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
            $base64Logo = base64_encode($logoData);
            $base64Logo2 = base64_encode($logoData2);
            $base641Logo = base64_encode($logoData1);
        @endphp
        <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" style="float:left;margin-top:35px;" height="150" width="150">
        {{-- <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150"> --}}
        {{-- <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo"  style="float:right;margin-top:35px;" height="150" width="150"> --}}
        <div class="rox">
            <h2>मिरा भाईंदर महानगरपालिका</h2>
            <p>स्व.इंदिरा गांधी भवन,मुख्य कार्यालय, छत्रपती शिवाजी महाराज मार्ग, भाईंदर (प.),ता.ठाणे-४०११०१</p>
            <p>दूरध्वनी क्र.२८१९२४८</p>
            <h3 style="margin-left: 8rem">मालकी हक्कात बदल करणे</h3>
        </div>
    </div>
    <hr>
    <hr style="1px solid #000; height:5px; background-color:#000;">
    <div class="sub-header">
        <div class="row d-flex">
            <p>जा.क्र.मनपा/पापू व मलनि/{{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/ 2025-2026
                <span style="float: right">दि. {{ \Carbon\Carbon::parse($data->created_at)->format('d/m/y') }}</span></p>
        </div>
    </div>

    <p>प्रति<br>
        अर्जदार: {{ $data->applicant_name }} <br>
    </p>

    <p style="margin-left:20%;"><strong>विषय :</strong> मालकी हक्कात बदल करणे. (फक्त पाणी देयकात नाव बदल करीता).</p>
    <p style="margin-left:20%;"><strong>संदर्भ :</strong> आपला अर्ज दि. {{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }} रोजी प्राप्त.</p>

    <strong>महोदय,</strong>

    <div class="content">
        <p> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;उपरोक्त संदर्भानुसार आपणांस कळविण्यात येते की, महानगरपालिकेच्या जलजोडणी मागणी रजिस्टर ग्राहक क्र. -<strong>{{ $data->connection_no }}</strong>
            श्री. <b>{{ $data->Property_Owner_Name }} </b>ह्या नावाची नोंद
            आपण सादर केलेल्या कागदपत्राप्रमाणे व मालमत्ता नावात बदल झालेला असल्याने जलजोडणी ग्राहक नावात बदल करून
            सदरची जलजोडणी खालील अटीशर्तीच्या अधीन राहून आपल्या नावे श्री./श्रीम.- <b>{{ $data->New_Property_Owner_Name}} </b>
            करण्यात येत आहे.</p>

        <b>अटीशर्ती</b>

        <ul class="points">
            <p style=" margin-left:5%;">1) मालकीहक्काबाबत काहीही वाद निर्माण झाल्यास त्याची सर्वस्वी जबाबदारी आपणावर राहील.</p>
            <p style=" margin-left:5%;">2) महानगरपालिकेचा "पाणीपट्टी भरण्याची जबाबदारी आपणावर राहील.</p>
            <p style=" margin-left:5%;">3) जलजोडणी धारकाचे नावांत बदल केल्याने मालकी हक्क सिद्ध होतो असे नाही. तर केवळ पाणीपट्टी देयके
                कोणत्या नावे देणेची व कोणत्या नावे वसुल करावयाची एवढाच उद्देश आहे.</p>
            <p style=" margin-left:5%;">4) नाव बदल करणेकामी आवश्यक फी रु.{{$data->Water_Connection_Size_Count}}/- प्रति जल जोडनी महापालिकेत भरणा करावी.</p>
            <p style=" margin-left:5%;">5) पाणीपट्टी देयक हस्तांतरण करणे कामी सादर केलेली कागदपत्रे खोटी, बोगस अथवा दिशाभूल करणारी असल्यास
                दिलेला हस्तांतरण आदेश कोणतीही पुर्व सुचना न देता तात्काळ रद्द करणेत येऊन पुर्वीच्या पाणीपट्टी धारकाचे नावे
                मनपा दफ्तरी नोंद करण्यात येईल व कायदेशीर कार्यवाही करण्यात येईल.
                .</p>
        </ul>
    </div>

    <div class="footer" style="float:right;">
        <p><strong>कार्यकारी अभियंता</strong><br>
        मिरा-भाईंदर महानगरपालिका</p>
    </div>
    

</body>

</html>
