<x-admin.layout>
    <x-slot name="title">Making Change In Ownership / मालकी हक्कात बदल करणे</x-slot>
    <x-slot name="heading">Making Change In Ownership / मालकी हक्कात बदल करणे</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" value="{{ $data->applicant_name }}" placeholder="Enter Applicant Name" required disabled readonly>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="address" name="address" type="text" placeholder="Enter Name Of New Owner" required disabled readonly>{{ $data->address }} </textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Applicant Mobile No / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $data->mobile_no }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text"
                                    placeholder="Enter Mobile Number" required disabled readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Applicant EmailID / ईमेल आयडी<span class="text-danger"></span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $data->email_id }}" required disabled readonly>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Applicant Adhaar No / आधार क्रमांक</label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" value='{{ $data->aadhar_no }}' oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text"
                                    placeholder="Enter Aadhar Card No" disabled readonly>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>

                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">

                            <form class="theme-form" name="detailfetch" id="detailfetch" enctype="multipart/form-data">
                                @csrf
                                <div class="col-md-4">
                                    <input class="form-control" id="marchantid" name="marchantid" type="hidden" value="MBMCCORE">
                                    <span class="text-danger is-invalid marchantid_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="connection_no">Connection No<span class="text-danger">*</span></label>
                                    <input class="form-control" id="connection_no" name="connection_no" value='{{ $data->connection_no }}' type="text" placeholder="Enter Connection No" disabled readonly>
                                    <span class="text-danger is-invalid connection_no_err"></span>
                                </div>

                                {{-- <button type="Search" class="btn btn-primary mt-2" id="searchdetails">Search</button> --}}
                            </form>

                        </div>
                    </div>



                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Water Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="Property_Owner_Name">New Owner Name/मालकाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="Property_Owner_Name" value="{{ $data->Property_Owner_Name }}" name="Property_Owner_Name" type="text" placeholder="Enter Owner Name" required disabled readonly>
                                    <span class="text-danger is-invalid Property_Owner_Name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Full_Address_Of_The_Property"> Owner Address/मालकाचा पत्ता<span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="Full_Address_Of_The_Property" id="Full_Address_Of_The_Property" cols="30" rows="2" placeholder="Enter  Address" required disabled readonly>{{ $data->Full_Address_Of_The_Property }}</textarea>
                                    <span class="text-danger is-invalid Full_Address_Of_The_Property_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Ward" id="Ward" value="{{ $data->Ward }}" placeholder="Enter Ward Area" required disabled readonly>
                                    <span class="text-danger is-invalid Ward_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <input class="form-control" name="zone" id="zone" value="{{ $data->zone }}" placeholder="Enter Zone" required disabled readonly>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Size">Water Connection Size<span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Size" value="{{ $data->Water_Connection_Size }}" name="Water_Connection_Size" type="text" placeholder="Enter Water Connection Size" required disabled
                                        readonly>
                                    <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Connection_Type">Connection Type<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Connection_Type" value="{{ $data->Connection_Type }}" id="Connection_Type" type="text" placeholder="Enter Connection Type" required disabled readonly>
                                    <span class="text-danger is-invalid Connection_Type_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Usage">Water Connection Usage <span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Usage" value="{{ $data->Water_Connection_Usage }}" name="Water_Connection_Usage" type="text" placeholder="Enter Water Connection Usage" required disabled
                                        readonly>
                                    <span class="text-danger is-invalid Water_Connection_Usage_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="OutstandingAmt"> Total Outstanding Payable/ एकूण थकबाकी बिल भरले?<span class="text-danger">*</span></label>
                                    <input class="form-control" id="OutstandingAmt" value="{{ $data->OutstandingAmt }}" name="OutstandingAmt" type="text" required disabled readonly>
                                    <span class="text-danger is-invalid OutstandingAmt_err"></span>
                                </div>

                            </div>
                        </div>
                    </div>


                    <div class="card-header">
                        <h4 class="card-title">Connection Details</h4>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            <!-- Total Connection -->
                            <div class="col-md-4">
                                <label class="col-form-label" for="total_connection">Total Connection / एकूण कनेक्शन <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="total_connection" value="{{ $data->total_connection }}" name="total_connection" placeholder="Enter total connections" required disabled readonly>
                                <span class="text-danger is-invalid total_connection_err"></span>
                            </div>

<div class="col-md-4">
    <label class="col-form-label" for="Water_Connection_Size_Count">
        Water Connection Type <span class="text-danger">*</span>
    </label>
    <select class="form-control" id="Water_Connection_Size_Count" name="Water_Connection_Size_Count" disabled>
        <option value="">-- Select --</option>
        <option value="3000" {{ $data->Water_Connection_Size_Count == '3000' ? 'selected' : '' }}>घारगुती</option>
        <option value="5000" {{ $data->Water_Connection_Size_Count == '5000' ? 'selected' : '' }}>वाणिज्य</option>
    </select>
    <span class="text-danger is-invalid Water_Connection_Size_Count_err"></span>
</div>
                 {{-- <div class="col-md-4">
    <label class="col-form-label" for="New_Property_Owner_Name">
        New Property Owner Name <span class="text-danger">*</span>
    </label>

    @if(auth()->user()->hasRole('Clerk'))
        <input class="form-control" 
               id="New_Property_Owner_Name" 
               name="New_Property_Owner_Name" 
               type="text" 
               placeholder="Enter Owner Name" 
               value="{{ $data->New_Property_Owner_Name ?? $data->Property_Owner_Name }}" 
               required
        >
    @else
        <input class="form-control" 
               id="New_Property_Owner_Name" 
               name="New_Property_Owner_Name" 
               type="text" 
               placeholder="Enter Owner Name" 
               value="{{ $data->New_Property_Owner_Name ?? $data->Property_Owner_Name }}" 
               required 
               disabled 
               readonly
        >
    @endif

    <span class="text-danger is-invalid New_Property_Owner_Name_err"></span>
</div> --}}









                            <div class="col-md-4">
                                <label class="col-form-label" for="property_no">Property Number / मालमत्ता क्र <span class="text-danger">*</span></label>
                                <input class="form-control" id="property_no" value="{{ $data->property_no }}" name="property_no" type="text" placeholder="Enter Property Number" required disabled readonly>
                                <span class="text-danger is-invalid property_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="sub_usage">Water Sub Usage / पाणी उपवापर</label>
                                <input class="form-control" id="sub_usage" value="{{ $data->sub_usage }}" name="sub_usage" type="text" placeholder="Enter sub_usage" required disabled readonly>
                                <span class="text-danger is-invalid sub_usage_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="existing_water_bill">Existing Water Bill / विद्यमान पाणी बिल<span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->existing_water_bill) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="existing_water_bill"  name="existing_water_bill" type="file" required> --}}
                                <span class="text-danger is-invalid existing_water_bill_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="tax_bill_or_transfer_order">Property Tax Bill / Property tax Name Change Transfer Order. / मालमत्ता कराचे देयक / मालमत्ता हस्तांतरण आदेश<span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->tax_bill_or_transfer_order) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="tax_bill_or_transfer_order" name="tax_bill_or_transfer_order" type="file" required> --}}
                                <span class="text-danger is-invalid tax_bill_or_transfer_order_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="stamp_paper_or_noobjection_cert">500 Bond Stamp Paper / No Objection Certificate from Existing Connection Holder / विद्यमान नळ धारका कडुन 500 रु. चे करारनामा स्टँम्प पेपर / ना हरकत प्रमाणपत्र<span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->stamp_paper_or_noobjection_cert) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="stamp_paper_or_noobjection_cert" name="stamp_paper_or_noobjection_cert" type="file" required> --}}
                                <span class="text-danger is-invalid stamp_paper_or_noobjection_cert_err"></span>
                            </div>
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_doc">Aadhar Card / आधार कार्ड <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->aadhar_doc) }}" target="_blank">View Document</a></div>
                                <span class="text-danger is-invalid aadhar_doc_err"></span>
                            </div> --}}
                            <div class="col-md-4">
                                <label class="col-form-label" for="electricity_bill_or_pan_card">Aadhar Card / Electricity Bill / Pan Card. / आधार कार्ड / वीज बिल / पॅन कार्ड<span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->electricity_bill_or_pan_card) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="electricity_bill_or_pan_card" name="electricity_bill_or_pan_card" type="file" required> --}}
                                <span class="text-danger is-invalid electricity_bill_or_pan_card_err"></span>
                            </div>

                             <div class="col-md-4">
                            
                                <label class="col-form-label" for="comment">Upload Application In Prescribed Format<span class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="application_document" name="application_document" type="file" required> --}}
                                 <div><a href="{{ asset('storage/' . $data->application_document) }}" target="_blank">View Document</a></div>
                                <span class="text-danger is-invalid comment_err"></span>
                           
                        </div>



                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" rows="4" required></textarea>
                            </div>
                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="nodues_documents">Upload Certificate Of No Dues / थकबाकी नसल्याचा दाखला अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="nodues_documents" name="nodues_documents" type="file" required>
                                    <span class="text-danger is-invalid nodues_documents_err"></span>
                                </div> --}}

                            {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" required>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy.<br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>
                    {{-- <div class="form-group" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                    </div> --}}
                    <div class="card-footer">
                        <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        {{-- <button type="submit" class="btn btn-primary" id="addSubmit">Update</button> --}}
                        {{-- <button type="reset" class="btn btn-warning">Reset</button> --}}
                           <button id="btnCancel" class="btn btn-warning">Cancel</button>
                        
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>




{{-- Add --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
      document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route('water-change-ownership.update', $data->id) }}';
        formdata.append('_method', 'PUT');

        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            }
        });

    });

    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();
            let New_Property_Owner_Name = $('#New_Property_Owner_Name').val();
            
            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    test:'please New Owner Name',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
