<x-admin.layout>
    <x-slot name="title">Making Change In Water Connection Size / नळजोडणी आकारामध्ये बदल करणे</x-slot>
    <x-slot name="heading">Making Change In Water Connection Size / नळजोडणी आकारामध्ये बदल करणे</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" value="{{ $data->applicant_name }}" type="text" placeholder="Enter Applicant Name" required disabled readonly>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="address" name="address" value="{{ $data->address }}" type="text" placeholder="Enter Name Of New Owner" required disabled readonly> {{ $data->address }} </textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text" placeholder="Enter Mobile Number"
                                    value="{{ $data->mobile_no }}" required disabled readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Email Id / ईमेल आयडी<span class="text-danger"></span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $data->email_id }}" required disabled readonly>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="new_owner_name">Name Of New Owner / मिळकतीच्या नवीन मालकाचे नाव  <span class="text-danger">*</span></label>
                                    <input class="form-control" id="new_owner_name" name="new_owner_name" type="text" placeholder="Enter Name Of New Owner " value="{{ $data->new_owner_name }}" required>
                                    <span class="text-danger is-invalid new_owner_name_err"></span>
                                </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Aadhar Number / आधार क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text" placeholder="Enter Aadhar Card No"
                                    value="{{ $data->aadhar_no }}" required disabled readonly>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>

                            <div class="card-header">
                                <h4 class="card-title">Connection Details</h4>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="connection_no">Connection No<span class="text-danger">*</span></label>
                                <input class="form-control" id="connection_no" value="{{ $data->connection_no }}" name="connection_no" type="text" placeholder="Enter Connection No" disabled readonly>
                                <span class="text-danger is-invalid connection_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Property_Owner_Name">Owner Name/मालकाचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="Property_Owner_Name" value="{{ $data->Property_Owner_Name }}" name="Property_Owner_Name" type="text" placeholder="Enter Owner Name" required disabled readonly>
                                <span class="text-danger is-invalid Property_Owner_Name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Full_Address_Of_The_Property"> Owner Address/मालकाचा पत्ता<span class="text-danger">*</span></label>
                                <textarea class="form-control" name="Full_Address_Of_The_Property" value="{{ $data->Full_Address_Of_The_Property }}" id="Full_Address_Of_The_Property" cols="30" rows="2" placeholder="Enter  Address" required disabled readonly>{{ $data->Full_Address_Of_The_Property }}</textarea>
                                <span class="text-danger is-invalid Full_Address_Of_The_Property_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <input class="form-control" name="Ward" id="Ward" value="{{ $data->Ward }}" placeholder="Enter Ward Area" required disabled readonly>
                                <span class="text-danger is-invalid Ward_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                <input class="form-control" name="zone" value="{{ $data->zone }}" id="zone" placeholder="Enter Zone" required disabled readonly>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Water_Connection_Size">Water Connection Size<span class="text-danger">*</span></label>
                                <input class="form-control" id="Water_Connection_Size" value="{{ $data->Water_Connection_Size }}" name="Water_Connection_Size" type="text" placeholder="Enter Water Connection Size" required disabled readonly>
                                <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Connection_Type">Connection Type<span class="text-danger">*</span></label>
                                <input class="form-control" name="Connection_Type" value="{{ $data->Connection_Type }}" id="Connection_Type" type="text" placeholder="Enter Connection Type" required disabled readonly>
                                <span class="text-danger is-invalid Connection_Type_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Water_Connection_Usage">Water Connection Usage <span class="text-danger">*</span></label>
                                <input class="form-control" id="Water_Connection_Usage" value="{{ $data->Water_Connection_Usage }}" name="Water_Connection_Usage" type="text" placeholder="Enter Water Connection Usage" required disabled
                                    readonly>
                                <span class="text-danger is-invalid Water_Connection_Usage_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="OutstandingAmt"> Total Outstanding Payable/ एकूण थकबाकी बिल भरले?<span class="text-danger">*</span></label>
                                <input class="form-control" id="OutstandingAmt" value="{{ $data->OutstandingAmt }}" name="OutstandingAmt" type="text" required disabled readonly>
                                <span class="text-danger is-invalid OutstandingAmt_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="old_tap_size">Old Connection Size / जुना कनेक्शन आकार<span class="text-danger">*</span></label>
                                <select class="form-select" name="old_tap_size" id="old_tap_size" required disabled>
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['15mm', '20mm', '25mm', '40mm', '50mm', '80mm', '100mm', '150mm', '300mm'];
                                    @endphp
                                    @foreach ($options as $option)
                                        <option {{ $data->old_tap_size == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid old_tap_size_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="new_tap_size">New Connection Size / नवीन कनेक्शन आकार<span class="text-danger">*</span></label>
                                <select class="form-select" name="new_tap_size" id="new_tap_size" required disabled>
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['15mm', '20mm', '25mm', '40mm', '50mm', '80mm', '100mm', '150mm', '300mm'];
                                    @endphp
                                    @foreach ($options as $option)
                                        <option {{ $data->new_tap_size == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid new_tap_size_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="house_no">Property Tax Number/ मालमत्ता कर क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="house_no" name="house_no" type="text" placeholder="Enter House Number" value="{{ $data->house_no }}" required="">
                                <span class="text-danger is-invalid house_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="current_connection_is_authorized">Usage of Water Connection / पाण्याच्या कनेक्शनचा वापर <span class="text-danger">*</span></label>
                                <select class="form-select" name="current_connection_is_authorized" id="current_connection_is_authorized" required>
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['Yes', 'No'];
                                    @endphp
                                    @foreach ($options as $option)
                                        <option {{ $data->current_connection_is_authorized == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid current_connection_is_authorized_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="applicant_or_tenant">Water Sub Usage/ पाण्याचा उप-वापर <span class="text-danger">*</span></label>
                                <select class="form-select" name="applicant_or_tenant" value="{{ $data->applicant_or_tenant }}" id="applicant_or_tenant" required disabled>
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['Yes', 'No'];
                                    @endphp
                                    @foreach ($options as $option)
                                        <option {{ $data->applicant_or_tenant == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid applicant_or_tenant_err"></span>
                            </div> --}}


                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="no_of_user">Required no of Water Connection/ आवश्यक पाणी कनेक्शनची संख्या<span class="text-danger">*</span></label>
                                <input class="form-control" id="no_of_user" value="{{ $data->no_of_user }}" name="no_of_user" type="number" placeholder="Enter Number Of Users For New Tap Connection" value="{{ $data->no_of_user }}" required
                                    disabled readonly>
                                <span class="text-danger is-invalid no_of_user_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="existing_connection_detail">Number of Existing Water Connection/ विद्यमान पाणी जोडणींची संख्या<span class="text-danger">*</span></label>
                                <input class="form-control" id="existing_connection_detail" value="{{ $data->existing_connection_detail }}" name="existing_connection_detail" type="number" placeholder="Enter Number Of Tap Connection"
                                    value="{{ $data->existing_connection_detail }}" required disabled readonly>
                                <span class="text-danger is-invalid existing_connection_detail_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <select class="form-select" name="zone" id="zone" required>
                                        <option value="">Select Zone</option>

                                        @foreach ($zones as $zone)
                                        <option {{ $data->zone == $zone->name ? 'selected' : '' }} value="{{ $zone->name }}">{{ $zone->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div> --}}
                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <select class="form-select" name="ward_area" id="ward_area" required>
                                        <option value="">Select Ward Area</option>

                                        @foreach ($wards as $ward)
                                        <option {{ $data->ward_area == $ward->name ? 'selected' : '' }} value="{{ $ward->name }}">{{ $ward->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid ward_area_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="plot_no">Plot Number / प्लॅाट नं किंवा हिस्सा नं <span class="text-danger">*</span></label>
                                    <input class="form-control" id="plot_no" name="plot_no" type="text" placeholder="Enter Plot Number" value="{{ $data->plot_no }}" required>
                                    <span class="text-danger is-invalid plot_no_err"></span>
                                </div>












                                <div class="col-md-4">
                                    <label class="col-form-label" for="criminal_judicial_issue">Criminal Judicial Issues About Existing Tap Connection / मिळकतीस सध्या असलेल्या नळ कनेक्शनाबाबत काही फौजदारी किंवा न्यायालयीन बाबी सुरु आहेत का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="criminal_judicial_issue" id="criminal_judicial_issue" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option {{ $data->criminal_judicial_issue == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid criminal_judicial_issue_err"></span>
                                </div>







                                <div class="col-md-4">
                                    <label class="col-form-label" for="new_tap_connection">Detail Of New Tap Connection / मिळकतीस नवीन मागणी केलेल्या नळ कनेक्शनचा तपशील <span class="text-danger">*</span></label>
                                    <select class="form-select" name="new_tap_connection" id="new_tap_connection" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["औध्योगिक व्यवसायासाठी", "घरघुती वापरा साठी", "बिगर घरघुती वापरासाठी", "वाणिज्य"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option {{ $data->new_tap_connection == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid new_tap_connection_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="place_belongs_to_municipal">Place Belongs To Municipal Council Limit / सदर जागा नगरपरिषदेच्या हद्दीत आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="place_belongs_to_municipal" id="place_belongs_to_municipal" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option {{ $data->place_belongs_to_municipal == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid place_belongs_to_municipal_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="comment">Comment / टिप्पणी</label>
                                    <input class="form-control" id="comment" name="comment" type="text" placeholder="Enter Comment " value="{{ $data->comment }}">
                                    <span class="text-danger is-invalid comment_err"></span>
                                </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="application_documents">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->application_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="application_documents" name="application_documents" type="file"> --}}
                                <span class="text-danger is-invalid application_documents_err"></span>
                            </div>
                            {{--
                                <div class="col-md-4">
                                    <label class="col-form-label" for="nodues_documents">Upload Certificate Of No Dues / थकबाकी नसल्याचा दाखला अपलोड करा <span class="text-danger">*</span></label>
                                    <div><a href="{{ asset('storage/' . $data->nodues_document) }}" target="_blank">View Document</a></div>
                                    <input class="form-control" id="nodues_documents" name="nodues_documents" type="file">
                                    <span class="text-danger is-invalid nodues_documents_err"></span>
                                </div> --}}
                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" maxlength="255" name="remark" class="form-control" maxlength="255" rows="4" required></textarea>
                            </div>

                            {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" checked required class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        {{-- <button type="submit" class="btn btn-primary" id="addSubmit">Update</button> --}}
                        {{-- <button type="reset" class="btn btn-warning">Reset</button> --}}
                        <button id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>




{{-- Add --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
     document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route('water-connection-size-change.update', $data->id) }}';
        formdata.append('_method', 'PUT');

        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });

    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
