<x-admin.layout>
    <x-slot name="title"> Complaint Of Defective Water Meter / नादुरुस्त मिटर तक्रार करणे</x-slot>
    <x-slot name="heading">Complaint Of Defective Water Meter / नादुरुस्त मिटर तक्रार करणे </x-slot>
    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">

                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">

                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" value="{{ $user->name }}" placeholder="Enter Applicant Name" required>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="address" name="address" type="text" placeholder="Enter Name Of New Owner" required>{{ $user->address }} </textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Applicant Mobile No / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $user->mobile }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text"
                                    placeholder="Enter Mobile Number" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Applicant EmailID / ईमेल आयडी<span class="text-danger"></span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $user->email }}" required>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Applicant Adhaar No / आधार क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" value='{{ $user->aadhar_no }}' oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text"
                                    placeholder="Enter Aadhar Card No" required>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>

                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">

                            @csrf
                            <div class="col-md-4">
                                <input class="form-control" id="marchantid" name="marchantid" type="hidden" value="MBMCCORE">
                                <span class="text-danger is-invalid marchantid_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="connection_no">Connection No<span class="text-danger">*</span></label>
                                <input class="form-control" id="connection_no" name="connection_no" type="text" placeholder="Enter Connection No" >
                                <span class="text-danger is-invalid connection_no_err"></span>
                            </div>

                            <button type="Search" class="btn btn-primary mt-2" id="searchdetails">Search</button>
                        </div>
                    </div>



                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Water Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="Property_Owner_Name">Owner Name/मालकाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="Property_Owner_Name" name="Property_Owner_Name" type="text" placeholder="Enter Owner Name"  readonly>
                                    <span class="text-danger is-invalid Property_Owner_Name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Full_Address_Of_The_Property"> Owner Address/मालकाचा पत्ता<span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="Full_Address_Of_The_Property" id="Full_Address_Of_The_Property" cols="30" rows="2" placeholder="Enter  Address"  readonly></textarea>
                                    <span class="text-danger is-invalid Full_Address_Of_The_Property_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Ward" id="Ward" placeholder="Enter Ward Area"  readonly>
                                    <span class="text-danger is-invalid Ward_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <input class="form-control" name="zone" id="zone" placeholder="Enter Zone"  readonly>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Size">Water Connection Size<span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Size" name="Water_Connection_Size" type="text" placeholder="Enter Water Connection Size"  readonly>
                                    <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Connection_Type">Connection Type<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Connection_Type" id="Connection_Type" type="text" placeholder="Enter Connection Type"  readonly>
                                    <span class="text-danger is-invalid Connection_Type_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Usage">Water Connection Usage <span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Usage" name="Water_Connection_Usage" type="text" placeholder="Enter Water Connection Usage"  readonly>
                                    <span class="text-danger is-invalid Water_Connection_Usage_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="OutstandingAmt"> Total Outstanding Payable/ एकूण थकबाकी बिल भरले?<span class="text-danger">*</span></label>
                                    <input class="form-control" id="OutstandingAmt" name="OutstandingAmt" type="text"  readonly>
                                    <span class="text-danger is-invalid OutstandingAmt_err"></span>
                                </div>
                                <div class="col-md-4 mt-4">
                                    <button type="button" id="payaccentech" class="btn btn-success" target="_blank"
                                        onclick="window.location.href='https://watertax.nagarkaryavali.com/FrmWTConnSearch.aspx?@=AD65C7423AEA4530E3CB0528C8EFFFE4185BBCFBFA074578B362FC23AB6A7765'">Pay</button>
                                </div>

                            </div>
                        </div>
                    </div>

                    {{-- <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data"> --}}
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Connection Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="water_connection_no">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="water_connection_no" name="water_connection_no" type="text" placeholder="enter Applicant full Name" required>
                                <span class="text-danger is-invalid water_connection_no_err"></span>
                            </div> --}}
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="owner_name">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <input class="form-control" id="owner_name" name="owner_name" type="text" placeholder="Enter Name Of New Owner" required>
                                <span class="text-danger is-invalid owner_name_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text" placeholder="Enter Mobile Number" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Email Id / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" required>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Aadhar Number / आधार नंबर <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text" placeholder="Enter Aadhar Card No" required>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div> --}}


                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <select class="form-select" name="zone" id="zone" required>
                                        <option value="">Select Zone</option>

                                        @foreach ($zones as $zone)
                                        <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div> --}}
                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <select class="form-select" name="ward_area" id="ward_area" required>
                                        <option value="">Select Ward Area</option>

                                        @foreach ($wards as $ward)
                                        <option value="{{ $ward->name }}">{{ $ward->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid ward_area_err"></span>
                                </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="plot_no">Total Connection / एकूण कनेक्शन<span class="text-danger">*</span></label>
                                <input class="form-control" id="plot_no" name="plot_no" type="text" placeholder="Enter total connection" >
                                <span class="text-danger is-invalid plot_no_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="house_no">Connection Number / कनेक्शन क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" id="house_no" name="house_no" type="text" placeholder="Enter connection Number" required>
                                <span class="text-danger is-invalid house_no_err"></span>
                            </div> --}}
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="owner_name">Owner Name / मालकाचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" name="owner_name" id="owner_name" cols="30" rows="2" placeholder="Enter owner name">
                                <span class="text-danger is-invalid owner_name_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="owner_full_add">Owner Full Address / मालकाचा पूर्ण पत्ता<span class="text-danger">*</span></label>
                                <textarea class="form-control" name="owner_full_add" id="owner_full_add" cols="30" rows="2" placeholder="Enter owner name"></textarea>
                                <span class="text-danger is-invalid owner_full_add_err"></span>
                            </div> --}}
                            <div class="col-md-4">
                                <label class="col-form-label" for="landmark">Landmark / जवळची खूण<span class="text-danger"></span></label>
                                <input class="form-control" id="landmark" name="landmark" type="text" placeholder="Enter Landmark" >
                                <span class="text-danger is-invalid landmark_err"></span>
                            </div>
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <select class="form-select" name="ward_area" id="ward_area" required>
                                    <option value="">Select Ward Area</option>

                                    @foreach ($wards as $ward)
                                        <option value="{{ $ward->name }}">{{ $ward->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_area_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                <select class="form-select" name="zone" id="zone" required>
                                    <option value="">Select Zone</option>

                                    @foreach ($zones as $zone)
                                        <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div> --}}


                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="address">Full Address Of The Property / मिळकतीचा संपुर्ण पत्ता  <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="address" id="address" cols="30" rows="2"  placeholder="Enter  Address"></textarea>
                                    <span class="text-danger is-invalid address_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="place_belongs_to_municipal">Place Belongs To Municipal Council Limit / सदर जागा नगरपरिषदेच्या हद्दीत आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="place_belongs_to_municipal" id="place_belongs_to_municipal" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid place_belongs_to_municipal_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="current_connection_is_illegal">Currently Existed Tap Connection Unauthorized / मिळकतीस सध्या अस्तित्वात असलेले नळ कनेक्शन अनाधिकृत होते काय ?<span class="text-danger">*</span></label>
                                    <select class="form-select" name="current_connection_is_illegal" id="current_connection_is_illegal" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid current_connection_is_illegal_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_or_tenant">Applicant Or Tenant / अर्जदार / भाडेकरु आहेत काय ?<span class="text-danger">*</span></label>
                                    <select class="form-select" name="applicant_or_tenant" id="applicant_or_tenant" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid applicant_or_tenant_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="criminal_judicial_issue">Criminal Judicial Issues About Existing Tap Connection / मिळकतीस सध्या असलेल्या नळ कनेक्शनाबाबत काही फौजदारी किंवा न्यायालयीन बाबी सुरु आहेत का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="criminal_judicial_issue" id="criminal_judicial_issue" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid criminal_judicial_issue_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="current_tap_detail">Currently Existing Tap Connection Detail / मिळकतीस सध्या अस्तित्वात असलेल्या नळ कनेक्शनचा तपशील <span class="text-danger">*</span></label>
                                    <select class="form-select" name="current_tap_detail" id="current_tap_detail" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["बांधकाम", "औद्योगीक", "निवासी", "विशेष प्रवर्ग (शैक्षणिक संस्था,शासकीय,निमशासकीय कार्यालय,पथसंस्था,इतर)", "व्यावसायिक अथवा वाणिज्य"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid current_tap_detail_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="property_no">Number Of Existing Water Connection / विद्यमान पाणी कनेक्शनची संख्या <span class="text-danger">*</span></label>
                                <input class="form-control" id="property_no" name="property_no" type="text" placeholder="Enter Property No" required>
                                <span class="text-danger is-invalid property_no_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="meter_reading">Meter Reading / मीटर रीडिंग <span class="text-danger">*</span></label>
                                <input class="form-control" id="meter_reading" name="meter_reading" type="text" placeholder="Enter Meter Reading" >
                                <span class="text-danger is-invalid meter_reading_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="meter_reading">Meter Reading /मीटर रीडिंग <span class="text-danger">*</span></label>
                                <select class="form-control" id="meter_reading" name="meter_reading">
                                    <option value="">--Select--</option>
                                    {{-- <option value="200">15 ते 25</option>
                                    <option value="250">40 ते 50</option> --}}
                                    <option value="200">१५.० ते २५.० मी.मी.</option>
                                    <option value="250">४०.० ते ५०.० मी.मी.</option>
                                </select>
                                <span class="text-danger is-invalid meter_reading_err"></span>
                            </div>


                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="size"> Size / आकार <span class="text-danger">*</span></label>
                                    <select class="form-select" name="size" id="size" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["15mm", "20mm", "25mm", "40mm", "50mm", "80mm", "100mm", "150mm", "300mm"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid size_err"></span>
                                </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="current_con_auth">Currently Existing Connection Unauthorization / सध्या विद्यमान कनेक्शन अनधिकृत आहे!!<span class="text-danger">*</span></label>
                                <select name="current_con_auth" id="current_con_auth" class="form-control" >
                                    <option value="">--select un authorization connection ---</option>
                                    <option value="Yes">Yes / होय</option>
                                    <option value="No">No / नाही</option>
                                </select>
                                <span class="text-danger is-invalid current_con_auth_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="test_report">Upload Test Report / चाचणी अहवाल अपलोड करा <span class="text-danger">*</span></label>
                                <input class="form-control" id="test_reports" name="test_reports" type="file" >
                                <span class="text-danger is-invalid test_report_err"></span>
                            </div>

                             <div class="col-md-4" id="upload_section" style="display:none;">
                                <label class="col-form-label" for="application_documents">Upload In the prescribed format/ विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <input class="form-control" id="application_documents" name="application_documents" type="file" >
                                <span class="text-danger is-invalid application_documents_err"></span>
                            </div>

                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info"  name="is_correct_info" value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err d-block mt-1"></span>                            </div>
                            </div>
                    </div>
                    <div class="form-group" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                    </div>
                  <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                        <button type="reset" class="btn btn-warning">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>


{{-- <script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn = document.getElementById('saveAndPrintBtn');
    const form = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');

    if (!saveBtn || !form) return;

    saveBtn.addEventListener('click', function () {
        // Remove existing error messages
        form.querySelectorAll('.text-danger').forEach(el => el.remove());

        let isValid = true;

        // List of fields and messages
        const validations = {
            connection_no: 'Connection No is Required',
            Property_Owner_Name: 'Property Owner is Required',
            Full_Address_Of_The_Property: 'Full Address is Required',
            Ward: 'Ward is Required',
            zone: 'Zone is Required',
            Water_Connection_Size: 'Water Connection Size is Required',
            Connection_Type: 'Connection Type is Required',
            Water_Connection_Usage: 'Water Connection Usage is Required',
            OutstandingAmt: 'Outstanding is Required',
            plot_no: 'Plot No is Required',
            landmark: 'Landmark is Required',
            meter_reading: 'Meter Reading is Required',
            current_con_auth: 'Current is Required',
            test_reports: 'Test Report is Required',
            is_correct_info: 'Please accept the Declaration'
        };

        // Validate each field
        for (const [fieldId, message] of Object.entries(validations)) {
            const field = document.getElementById(fieldId);
            if (!field) continue;

            // Special case for checkbox (like is_correct_info)
            const value = field.type === 'checkbox' ? field.checked : field.value.trim();

            if (!value) {
                isValid = false;
                const errorDiv = document.createElement('div');
                errorDiv.className = 'text-danger';
                errorDiv.textContent = message;
                field.insertAdjacentElement('afterend', errorDiv);
            }
        }

        if (!isValid) {
            // Stop here, do not generate PDF
            return;
        }

        // Temporarily remove required for file input if exists
        if (fileInput) fileInput.removeAttribute('required');

        // Show upload section and footer
        const uploadSection = document.getElementById('upload_section');
        const cardFooter = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter) cardFooter.style.display = 'block';

        // Clone container for PDF
        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const printClone = addContainer.cloneNode(true);

 const uploadSectionInClone = printClone.querySelector('#upload_section');
if (uploadSectionInClone) {
    uploadSectionInClone.remove();
}        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        Array.from(printClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        // Add title
        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of water defective meter';
        printClone.insertBefore(printTitle, printClone.firstChild);

        // Remove buttons & style cards
        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });

        // Show hidden selected values
        printClone.querySelectorAll('.selected-value').forEach(div => {
            div.classList.remove('d-none');
        });

        // Prepare container for html2canvas
        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        // Generate PDF
        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;

            pdf.addImage(
                imgData, 'JPEG',
                margin, margin,
                pdf.internal.pageSize.getWidth() - margin * 2,
                pdf.internal.pageSize.getHeight() - margin * 2
            );

            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content.');
            }

            pdf.save('Water Defective MeterCertificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });
});
</script> --}}

{{-- <script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn = document.getElementById('saveAndPrintBtn');
    const form = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');

    if (!saveBtn || !form) return;

    saveBtn.addEventListener('click', function () {
        // Remove previous error messages (except predefined spans)
        form.querySelectorAll('.text-danger:not(.is_correct_info_err)').forEach(el => el.remove());
        form.querySelector('.is_correct_info_err').textContent = '';

        let isValid = true;

        const validations = {
            connection_no: 'Connection No is Required',
            Property_Owner_Name: 'Property Owner is Required',
            Full_Address_Of_The_Property: 'Full Address is Required',
            Ward: 'Ward is Required',
            zone: 'Zone is Required',
            Water_Connection_Size: 'Water Connection Size is Required',
            Connection_Type: 'Connection Type is Required',
            Water_Connection_Usage: 'Water Connection Usage is Required',
            OutstandingAmt: 'Outstanding is Required',
            plot_no: 'Plot No is Required',
            landmark: 'Landmark is Required',
            meter_reading: 'Meter Reading is Required',
            current_con_auth: 'Current is Required',
            test_reports: 'Test Report is Required',
            is_correct_info: 'Please accept the Declaration'
        };

        for (const [fieldId, message] of Object.entries(validations)) {
            const field = document.getElementById(fieldId);
            if (!field) continue;

            const value = field.type === 'checkbox' ? field.checked : field.value.trim();

            if (!value) {
                isValid = false;

                if (fieldId === 'is_correct_info') {
                    // Show message inside predefined span for declaration checkbox
                    const errSpan = document.querySelector('.is_correct_info_err');
                    if (errSpan) errSpan.textContent = message;
                } else {
                    const errorDiv = document.createElement('div');
                    errorDiv.className = 'text-danger';
                    errorDiv.textContent = message;
                    field.insertAdjacentElement('afterend', errorDiv);
                }
            }
        }

        if (!isValid) return;

        if (fileInput) fileInput.removeAttribute('required');

        const uploadSection = document.getElementById('upload_section');
        const cardFooter = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter) cardFooter.style.display = 'block';

        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const printClone = addContainer.cloneNode(true);

        const uploadSectionInClone = printClone.querySelector('#upload_section');
        if (uploadSectionInClone) uploadSectionInClone.remove();

        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        Array.from(printClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of water defective meter';
        printClone.insertBefore(printTitle, printClone.firstChild);

        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });

        printClone.querySelectorAll('.selected-value').forEach(div => {
            div.classList.remove('d-none');
        });

        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;

            pdf.addImage(
                imgData, 'JPEG',
                margin, margin,
                pdf.internal.pageSize.getWidth() - margin * 2,
                pdf.internal.pageSize.getHeight() - margin * 2
            );

            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content.');
            }

            pdf.save('Water Defective MeterCertificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });
});
</script> --}}

{{-- <script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn = document.getElementById('saveAndPrintBtn');
    const form = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');

    if (!saveBtn || !form) return;

    saveBtn.addEventListener('click', function () {
        // Remove previous error messages (except predefined spans)
        form.querySelectorAll('.text-danger:not(.is_correct_info_err)').forEach(el => el.remove());
        form.querySelector('.is_correct_info_err').textContent = '';

        let isValid = true;

        const validations = {
            connection_no: 'Connection No is Required',
            Property_Owner_Name: 'Property Owner is Required',
            Full_Address_Of_The_Property: 'Full Address is Required',
            Ward: 'Ward is Required',
            zone: 'Zone is Required',
            Water_Connection_Size: 'Water Connection Size is Required',
            Connection_Type: 'Connection Type is Required',
            Water_Connection_Usage: 'Water Connection Usage is Required',
            OutstandingAmt: 'Outstanding is Required',
            plot_no: 'Plot No is Required',
            landmark: 'Landmark is Required',
            meter_reading: 'Meter Reading is Required',
            current_con_auth: 'Current is Required',
            test_reports: 'Test Report is Required',
            is_correct_info: 'Please accept the Declaration'
        };

        for (const [fieldId, message] of Object.entries(validations)) {
            const field = document.getElementById(fieldId);
            if (!field) continue;

            const value = field.type === 'checkbox' ? field.checked : field.value.trim();

            if (!value) {
                isValid = false;

                if (fieldId === 'is_correct_info') {
                    const errSpan = document.querySelector('.is_correct_info_err');
                    if (errSpan) errSpan.textContent = message;
                } else {
                    const errorDiv = document.createElement('div');
                    errorDiv.className = 'text-danger';
                    errorDiv.textContent = message;
                    field.insertAdjacentElement('afterend', errorDiv);
                }
            }
        }

        if (!isValid) return;

        if (fileInput) fileInput.removeAttribute('required');

        const uploadSection = document.getElementById('upload_section');
        const cardFooter = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter) cardFooter.style.display = 'block';

        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const printClone = addContainer.cloneNode(true);

        const uploadSectionInClone = printClone.querySelector('#upload_section');
        if (uploadSectionInClone) uploadSectionInClone.remove();

        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        Array.from(printClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of water defective meter';
        printClone.insertBefore(printTitle, printClone.firstChild);

        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });

        printClone.querySelectorAll('.selected-value').forEach(div => {
            div.classList.remove('d-none');
        });

        // 🟢 Ensure "current_con_auth" selected value appears in the PDF
        const currentConAuthField = document.getElementById('current_con_auth');
        if (currentConAuthField) {
            const selectedValue = currentConAuthField.value;
            const selectedText = currentConAuthField.options[currentConAuthField.selectedIndex]?.text || '';

            // Set same selection in cloned select
            const clonedSelect = printClone.querySelector('#current_con_auth');
            if (clonedSelect && selectedValue) {
                clonedSelect.value = selectedValue;
            }

            // Display text version clearly
            let authDisplay = printClone.querySelector('#current_con_auth_display');
            if (!authDisplay) {
                authDisplay = document.createElement('div');
                authDisplay.id = 'current_con_auth_display';
                authDisplay.style.marginTop = '10px';
                authDisplay.style.fontSize = '16px';
                authDisplay.style.fontWeight = 'bold';
                authDisplay.style.border = '1px solid #ccc';
                authDisplay.style.padding = '8px';
                authDisplay.style.borderRadius = '4px';
                authDisplay.style.background = '#f9f9f9';
                authDisplay.textContent = `Currently Existing Connection Unauthorized: ${selectedText}`;
                printClone.appendChild(authDisplay);
            } else {
                authDisplay.textContent = `Currently Existing Connection Unauthorized: ${selectedText}`;
            }
        }

        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;

            pdf.addImage(
                imgData, 'JPEG',
                margin, margin,
                pdf.internal.pageSize.getWidth() - margin * 2,
                pdf.internal.pageSize.getHeight() - margin * 2
            );

            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content.');
            }

            pdf.save('Water Defective MeterCertificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });
});
</script> --}}

{{-- <script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn = document.getElementById('saveAndPrintBtn');
    const form = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');

    if (!saveBtn || !form) return;

    saveBtn.addEventListener('click', function () {
        // Remove previous error messages
        form.querySelectorAll('.text-danger:not(.is_correct_info_err)').forEach(el => el.remove());
        form.querySelector('.is_correct_info_err').textContent = '';

        let isValid = true;

        const validations = {
            connection_no: 'Connection No is Required',
            Property_Owner_Name: 'Property Owner is Required',
            Full_Address_Of_The_Property: 'Full Address is Required',
            Ward: 'Ward is Required',
            zone: 'Zone is Required',
            Water_Connection_Size: 'Water Connection Size is Required',
            Connection_Type: 'Connection Type is Required',
            Water_Connection_Usage: 'Water Connection Usage is Required',
            OutstandingAmt: 'Outstanding is Required',
            plot_no: 'Plot No is Required',
            landmark: 'Landmark is Required',
            meter_reading: 'Meter Reading is Required',
            current_con_auth: 'Current is Required',
            test_reports: 'Test Report is Required',
            is_correct_info: 'Please accept the Declaration'
        };

        for (const [fieldId, message] of Object.entries(validations)) {
            const field = document.getElementById(fieldId);
            if (!field) continue;

            const value = field.type === 'checkbox' ? field.checked : field.value.trim();

            if (!value) {
                isValid = false;

                if (fieldId === 'is_correct_info') {
                    const errSpan = document.querySelector('.is_correct_info_err');
                    if (errSpan) errSpan.textContent = message;
                } else {
                    const errorDiv = document.createElement('div');
                    errorDiv.className = 'text-danger';
                    errorDiv.textContent = message;
                    field.insertAdjacentElement('afterend', errorDiv);
                }
            }
        }

        if (!isValid) return;

        if (fileInput) fileInput.removeAttribute('required');

        const uploadSection = document.getElementById('upload_section');
        const cardFooter = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter) cardFooter.style.display = 'block';

        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const printClone = addContainer.cloneNode(true);

        const uploadSectionInClone = printClone.querySelector('#upload_section');
        if (uploadSectionInClone) uploadSectionInClone.remove();

        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        Array.from(printClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of water defective meter';
        printClone.insertBefore(printTitle, printClone.firstChild);

        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });

        // ✅ Show selected text for "meter_reading"
        const meterReadingField = document.getElementById('meter_reading');
        if (meterReadingField) {
            const selectedText = meterReadingField.options[meterReadingField.selectedIndex]?.text || '';
            const clonedSelect = printClone.querySelector('#meter_reading');
            if (clonedSelect) {
                clonedSelect.insertAdjacentHTML(
                    'afterend',
                    `<div style="
                        margin-top:6px;
                        font-size:16px;
                        font-weight:bold;
                        border:1px solid #ccc;
                        padding:8px;
                        border-radius:4px;
                        background:#f9f9f9;
                    ">Meter Reading: ${selectedText}</div>`
                );
                clonedSelect.remove(); // remove dropdown from PDF
            }
        }

        // ✅ Show selected text for "current_con_auth"
        const currentConAuthField = document.getElementById('current_con_auth');
        if (currentConAuthField) {
            const selectedText = currentConAuthField.options[currentConAuthField.selectedIndex]?.text || '';
            const clonedSelect = printClone.querySelector('#current_con_auth');
            if (clonedSelect) {
                clonedSelect.insertAdjacentHTML(
                    'afterend',
                    `<div style="
                        margin-top:6px;
                        font-size:16px;
                        font-weight:bold;
                        border:1px solid #ccc;
                        padding:8px;
                        border-radius:4px;
                        background:#f9f9f9;
                    ">Currently Existing Connection Unauthorized: ${selectedText}</div>`
                );
                clonedSelect.remove();
            }
        }

        // Create hidden container for print
        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        // Generate PDF
        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;

            pdf.addImage(
                imgData, 'JPEG',
                margin, margin,
                pdf.internal.pageSize.getWidth() - margin * 2,
                pdf.internal.pageSize.getHeight() - margin * 2
            );

            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content.');
            }

            pdf.save('Water Defective Meter Certificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });
});
</script> --}}

<script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn = document.getElementById('saveAndPrintBtn');
    const form = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');

    if (!saveBtn || !form) return;

    saveBtn.addEventListener('click', function () {
        // Remove previous error messages
        form.querySelectorAll('.text-danger:not(.is_correct_info_err)').forEach(el => el.remove());
        form.querySelector('.is_correct_info_err').textContent = '';

        let isValid = true;

        const validations = {
            connection_no: 'Connection No is Required',
            Property_Owner_Name: 'Property Owner is Required',
            Full_Address_Of_The_Property: 'Full Address is Required',
            Ward: 'Ward is Required',
            zone: 'Zone is Required',
            Water_Connection_Size: 'Water Connection Size is Required',
            Connection_Type: 'Connection Type is Required',
            Water_Connection_Usage: 'Water Connection Usage is Required',
            OutstandingAmt: 'Outstanding is Required',
            plot_no: 'Plot No is Required',
           // landmark: 'Landmark is Required',
            meter_reading: 'Meter Reading is Required',
            current_con_auth: 'Current is Required',
            test_reports: 'Test Report is Required',
            is_correct_info: 'Please accept the Declaration'
        };

        // Basic validation loop
        for (const [fieldId, message] of Object.entries(validations)) {
            const field = document.getElementById(fieldId);
            if (!field) continue;

            const value = field.type === 'checkbox' ? field.checked : field.value.trim();

            if (!value) {
                isValid = false;

                if (fieldId === 'is_correct_info') {
                    const errSpan = document.querySelector('.is_correct_info_err');
                    if (errSpan) errSpan.textContent = message;
                } else {
                    const errorDiv = document.createElement('div');
                    errorDiv.className = 'text-danger';
                    errorDiv.textContent = message;
                    field.insertAdjacentElement('afterend', errorDiv);
                }
            }
        }

        if (!isValid) return;

        if (fileInput) fileInput.removeAttribute('required');

        const uploadSection = document.getElementById('upload_section');
        const cardFooter = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter) cardFooter.style.display = 'block';

        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const printClone = addContainer.cloneNode(true);

        const uploadSectionInClone = printClone.querySelector('#upload_section');
        if (uploadSectionInClone) uploadSectionInClone.remove();

        // Page layout styling
        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        Array.from(printClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        // Title
        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of water defective meter';
        printClone.insertBefore(printTitle, printClone.firstChild);

        // Clean visuals
        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });

        /* ✅ METER READING: Show value inside textbox-style box */
        const meterReadingField = document.getElementById('meter_reading');
        if (meterReadingField) {
            const selectedText = meterReadingField.options[meterReadingField.selectedIndex]?.text || '';
            const clonedSelect = printClone.querySelector('#meter_reading');
            if (clonedSelect) {
                clonedSelect.insertAdjacentHTML(
                    'afterend',
                    `<div style="
                        margin-top:5px;
                        font-size:16px;
                        border:1px solid #ccc;
                        padding:5px 10px;
                        border-radius:4px;
                        background:#fff;
                        display:inline-block;
                        min-width:150px;
                    ">${selectedText}</div>`
                );
                clonedSelect.remove();
            }
        }

        /* ✅ CURRENT CONNECTION AUTH: Show value inside textbox-style box */
        const currentConAuthField = document.getElementById('current_con_auth');
        if (currentConAuthField) {
            const selectedText = currentConAuthField.options[currentConAuthField.selectedIndex]?.text || '';
            const clonedSelect = printClone.querySelector('#current_con_auth');
            if (clonedSelect) {
                clonedSelect.insertAdjacentHTML(
                    'afterend',
                    `<div style="
                        margin-top:5px;
                        font-size:16px;
                        border:1px solid #ccc;
                        padding:5px 10px;
                        border-radius:4px;
                        background:#fff;
                        display:inline-block;
                        min-width:100px;
                    ">${selectedText}</div>`
                );
                clonedSelect.remove();
            }
        }

        // Prepare hidden print container
        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        // Generate PDF
        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;

            pdf.addImage(
                imgData, 'JPEG',
                margin, margin,
                pdf.internal.pageSize.getWidth() - margin * 2,
                pdf.internal.pageSize.getHeight() - margin * 2
            );

            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content.');
            }

            pdf.save('Water Defective Meter Certificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });
});
</script>














{{-- Add --}}
<script>
    $('#searchdetails').on('click', function(e) {
        e.preventDefault();

        let formData = {
            marchantid: $('#marchantid').val(),
            connection_no: $('#connection_no').val(),
            _token: $('input[name="_token"]').val()
        };

        $.ajax({
            url: '{{ route('fetch.water.details') }}',
            method: 'POST',
            data: formData,
            datatype: JSON,
            success: function(response) {
                console.log("Encrypted Data:", response.jsonData.encr_request);

                const decryptedData = JSON.parse(response.jsonData.encr_request);

                console.log("Decrypted Data:", decryptedData['connectionDetails'].Water_Connection_Number);

                if (decryptedData && decryptedData['connectionDetails']) {
                    $('#Connection_Type').val(decryptedData['connectionDetails'].Connection_Type);
                    $('#House_Number').val(decryptedData['connectionDetails'].House_Number);
                    $('#Property_Owner_Name').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    $('#Full_Address_Of_The_Property').val(decryptedData['connectionDetails'].Full_Address_Of_The_Property);
                    $('#Water_Connection_Size').val(decryptedData['connectionDetails'].Water_Connection_Size);
                    $('#Water_Connection_Usage').val(decryptedData['connectionDetails'].Water_Connection_Usage);
                    $('#zone').val(decryptedData['connectionDetails'].Zone);
                    $('#Ward').val(decryptedData['connectionDetails'].Ward);
                    $('#OutstandingAmt').val(decryptedData['connectionDetails'].OutstandingAmt);
                    // $('#water_connection_no').val(decryptedData['connectionDetails'].Water_Connection_Number);
                    // $('#owner_name').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    // $('#owner_full_add').val(decryptedData['connectionDetails'].Full_Address_Of_The_Property);
                    // $('#house_no').val(decryptedData['connectionDetails'].Water_Connection_Size);
                    // // $('#house_no').val(decryptedData['connectionDetails'].Water_Connection_Usage);
                    // $('#ward').val(decryptedData['connectionDetails'].Ward);
                } else {
                    console.error("connectionDetails is missing or undefined");
                }
            },

            error: function(xhr) {
                console.error(xhr.responseText);
            }
        });
    });


    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('water-defective-meter.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const existingConInput = document.getElementById('plot_no');

    if (existingConInput) {
        existingConInput.addEventListener('input', function (e) {
            // Remove any non-digit characters
            this.value = this.value.replace(/[^0-9]/g, '');
        });
    }
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const existingConInput = document.getElementById('meter_reading');

    if (existingConInput) {
        existingConInput.addEventListener('input', function (e) {
            // Remove any non-digit characters
            this.value = this.value.replace(/[^0-9]/g, '');
        });
    }
});
</script>