<x-admin.layout>
    <x-slot name="title"> Complaint Of Defective Water Meter / नादुरुस्त मिटर तक्रार करणे</x-slot>
    <x-slot name="heading">Complaint Of Defective Water Meter / नादुरुस्त मिटर तक्रार करणे </x-slot>
    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">form</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" value="{{ $data->applicant_name }}" placeholder="Enter Applicant Name" required disabled readonly>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="address" name="address" type="text" placeholder="Enter Name Of New Owner" required disabled readonly>{{ $data->address }} </textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Applicant Mobile No / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $data->mobile_no }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text"
                                    placeholder="Enter Mobile Number" required disabled readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Applicant EmailID / ईमेल आयडी<span class="text-danger"></span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $data->email_id }}" required disabled readonly>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Applicant Adhaar No / आधार क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" value='{{ $data->aadhar_no }}' oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text"
                                    placeholder="Enter Aadhar Card No" required disabled readonly>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>

                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">

                            @csrf
                            <div class="col-md-4">
                                <input class="form-control" id="marchantid" name="marchantid" type="hidden" value="MBMCCORE">
                                <span class="text-danger is-invalid marchantid_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="connection_no">Connection No<span class="text-danger">*</span></label>
                                <input class="form-control" id="connection_no" value='{{ $data->connection_no }}' name="connection_no" type="text" placeholder="Enter Connection No" disabled readonly>
                                <span class="text-danger is-invalid connection_no_err"></span>
                            </div>

                            {{-- <button type="Search" class="btn btn-primary mt-2" id="searchdetails">Search</button> --}}
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Water Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="Property_Owner_Name">Owner Name/मालकाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="Property_Owner_Name" value='{{ $data->Property_Owner_Name }}' name="Property_Owner_Name" type="text" placeholder="Enter Owner Name" required disabled readonly>
                                    <span class="text-danger is-invalid Property_Owner_Name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Full_Address_Of_The_Property"> Owner Address/मालकाचा पत्ता<span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="Full_Address_Of_The_Property" value='{{ $data->Full_Address_Of_The_Property }}' id="Full_Address_Of_The_Property" cols="30" rows="2" placeholder="Enter  Address" required disabled readonly>{{ $data->Full_Address_Of_The_Property }}</textarea>
                                    <span class="text-danger is-invalid Full_Address_Of_The_Property_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Ward" id="Ward" value='{{ $data->Ward }}' placeholder="Enter Ward Area" required disabled readonly>
                                    <span class="text-danger is-invalid Ward_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <input class="form-control" name="zone" id="zone" value='{{ $data->zone }}' placeholder="Enter Zone" required disabled readonly>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Size">Water Connection Size<span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Size" value='{{ $data->Water_Connection_Size }}' name="Water_Connection_Size" type="text" placeholder="Enter Water Connection Size" required disabled
                                        readonly>
                                    <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Connection_Type">Connection Type<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Connection_Type" id="Connection_Type" value='{{ $data->Connection_Type }}' type="text" placeholder="Enter Connection Type" required disabled readonly>
                                    <span class="text-danger is-invalid Connection_Type_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Usage">Water Connection Usage <span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Usage" value='{{ $data->Water_Connection_Usage }}' name="Water_Connection_Usage" type="text" placeholder="Enter Water Connection Usage" required disabled
                                        readonly>
                                    <span class="text-danger is-invalid Water_Connection_Usage_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="OutstandingAmt"> Total Outstanding Payable/ एकूण थकबाकी बिल भरले?<span class="text-danger">*</span></label>
                                    <input class="form-control" id="OutstandingAmt" value='{{ $data->OutstandingAmt }}' name="OutstandingAmt" type="text" required disabled readonly>
                                    <span class="text-danger is-invalid OutstandingAmt_err"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-header">
                        <h4 class="card-title">Connection Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">

                            <div class="col-md-4">
                                <label class="col-form-label" for="plot_no">Total Connection / एकूण कनेक्शन<span class="text-danger">*</span></label>
                                <input class="form-control" id="plot_no" value='{{ $data->plot_no }}' name="plot_no" type="text" placeholder="Enter total connection" required disabled readonly>
                                <span class="text-danger is-invalid plot_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="landmark">Landmark / जवळची खूण<span class="text-danger"></span></label>
                                <input class="form-control" id="landmark" value='{{ $data->landmark }}' name="landmark" type="text" placeholder="Enter Landmark" required disabled readonly>
                                <span class="text-danger is-invalid landmark_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="meter_reading">Meter Reading / मीटर रीडिंग <span class="text-danger">*</span></label>
                                <input class="form-control" id="meter_reading" value='{{ $data->meter_reading }}' name="meter_reading" type="text" placeholder="Enter Meter Reading" required disabled readonly>
                                <span class="text-danger is-invalid meter_reading_err"></span>
                            </div> --}}


                            @php
                               
                                $meterOptions = [
                                    '200' => '१५.० ते २५.० मी.मी.',
                                    '250' => '४०.० ते ५०.० मी.मी.',
                                ];

                                
                                $displayMeter = $meterOptions[$data->meter_reading] ?? '';
                            @endphp

                            <div class="col-md-4">
                                <label class="col-form-label" for="meter_reading">Meter Reading / मीटर रीडिंग <span class="text-danger">*</span></label>
                                <input class="form-control" 
                                    id="meter_reading" 
                                    value="{{ $displayMeter }}" 
                                    name="meter_reading" 
                                    type="text" 
                                    placeholder="Enter Meter Reading" 
                                    required 
                                    disabled 
                                    readonly>
                                <span class="text-danger is-invalid meter_reading_err"></span>
                            </div>





                            <div class="col-md-4">
                                <label class="col-form-label" for="current_con_auth">Currently Existing Connection Unauthorization / सध्या विद्यमान कनेक्शन अनधिकृत आहे!!<span class="text-danger">*</span></label>
                                <select name="current_con_auth" id="current_con_auth" class="form-control" disabled>
                                    <option value="">--select un authorization connection ---</option>
                                    <option value="Yes" {{ $data->current_con_auth == 'Yes' ? 'selected' : '' }}>Yes / होय</option>
                                    <option value="No" {{ $data->current_con_auth == 'No' ? 'selected' : '' }}>No / नाही</option>
                                </select>
                                <span class="text-danger is-invalid current_con_auth_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="test_report">Upload Test Report / चाचणी अहवाल अपलोड करा <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->test_report) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="test_report" name="test_report" type="file" required> --}}
                                <span class="text-danger is-invalid test_report_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="application_documents">Upload In the prescribed form/ विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->application_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="application_documents" name="application_documents" type="file" required> --}}
                                <span class="text-danger is-invalid application_documents_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" maxlength="255" class="form-control" rows="4" required></textarea>
                            </div>

                            {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" required name="is_correct_info" value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        {{-- <button type="submit" class="btn btn-primary" id="addSubmit">Update</button> --}}
                        {{-- <button type="reset" class="btn btn-warning">Reset</button> --}}
                          <button id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>




{{-- Add --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route('water-defective-meter.update', $data->id) }}';
        formdata.append('_method', 'PUT');

        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });

    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
