<x-admin.layout>
    <x-slot name="title">Complaint Of Illegal Water Connection / अनधिकृत नळ जोडणी तक्रार</x-slot>
    <x-slot name="heading">Complaint Of Illegal Water Connection / अनधिकृत नळ जोडणी तक्रार</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_name">Complainant's full name / तक्रारदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="applicant_name" name="applicant_name" type="text" value="{{ $data->applicant_name }}" placeholder="Enter Applicant Name" required disabled readonly>
                                    <span class="text-danger is-invalid applicant_name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="address">Complainant's Full Address / तक्रारदाराचे पूर्ण पत्ता <span class="text-danger">*</span></label>
                                    <textarea class="form-control" id="address" name="address" value="{{ $data->address }}" type="text" placeholder="Enter Name Of New Owner" required disabled readonly>{{ $data->address }} </textarea>
                                    <span class="text-danger is-invalid address_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="mobile_no">Applicant Mobile No / मोबाईल नंबर<span class="text-danger">*</span></label>
                                    <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $data->mobile_no }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text"
                                        placeholder="Enter Mobile Number" required disabled readonly>
                                    <span class="text-danger is-invalid mobile_no_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="email_id"> Applicant EmailID / ईमेल आयडी</label>
                                    <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $data->email_id }}" required disabled readonly>
                                    <span class="text-danger is-invalid email_id_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="aadhar_no">Applicant Adhaar No / आधार क्रमांक <span class="text-danger">*</span></label>
                                    <input class="form-control" id="aadhar_no" name="aadhar_no" value='{{ $data->aadhar_no }}' oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text"
                                        placeholder="Enter Aadhar Card No" required disabled readonly>
                                    <span class="text-danger is-invalid aadhar_no_err"></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone"> Ward Area / प्रभाग क्षेत्र <span class="text-danger">*</span></label>
                                    <input class="form-control" id="zone" name="zone" value='{{ $data->zone }}' maxlength="12" minlength="12" type="text" placeholder="Enter Aadhar Card No" required disabled readonly>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>
                            </div>

                            {{-- <div class="card">
                                <div class="card-body">
                                    @csrf
                                    <div class="col-md-4">
                                        <input class="form-control" id="marchantid" name="marchantid" type="hidden" value="MBMCCORE">
                                        <span class="text-danger is-invalid marchantid_err"></span>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="col-form-label" for="connection_no">Connection No<span class="text-danger">*</span></label>
                                        <input class="form-control" id="connection_no" name="connection_no" value="{{ $data->connection_no }}" type="text" placeholder="Enter Connection No">
                                        <span class="text-danger is-invalid connection_no_err"></span>
                                    </div>

                                    <button type="Search" class="btn btn-primary mt-2  w-25" id="searchdetails">Search</button>
                                </div>
                            </div> --}}
                            {{--
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="Property_Owner_Name">Owner Name/मालकाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="Property_Owner_Name" name="Property_Owner_Name" type="text" placeholder="Enter Owner Name" value="{{ $data->Property_Owner_Name }}" required disabled readonly>
                                    <span class="text-danger is-invalid Property_Owner_Name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Full_Address_Of_The_Property"> Owner Address/मालकाचा पत्ता<span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="Full_Address_Of_The_Property" id="Full_Address_Of_The_Property" cols="30" rows="2" placeholder="Enter  Address" required disabled readonly> {{ $data->Full_Address_Of_The_Property }} </textarea>
                                    <span class="text-danger is-invalid Full_Address_Of_The_Property_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Ward">Ward Area / प्रभाग क्षेत्र</label>
                                    <input class="form-control" name="Ward" id="Ward" value="{{ $data->Ward }}" placeholder="Enter Ward Area" required disabled readonly>
                                    <span class="text-danger is-invalid Ward_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन</label>
                                    <input class="form-control" name="zone" id="zone" value="{{ $data->zone }}" placeholder="Enter Zone" required disabled readonly>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Size">Water Connection Size</label>
                                    <input class="form-control" id="Water_Connection_Size" name="Water_Connection_Size" value="{{ $data->Water_Connection_Size }}" type="text" placeholder="Enter Water Connection Size" required disabled readonly>
                                    <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                                </div>
                                

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Connection_Type">Connection Type</label>
                                    <input class="form-control" name="Connection_Type" id="Connection_Type" value="{{ $data->Connection_Type }}" type="text" placeholder="Enter Connection Type" required disabled readonly>
                                    <span class="text-danger is-invalid Connection_Type_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Usage">Water Connection Usage</label>
                                    <input class="form-control" id="Water_Connection_Usage" value="{{ $data->Water_Connection_Usage }}" name="Water_Connection_Usage" type="text" placeholder="Enter Water Connection Usage" required disabled readonly>
                                    <span class="text-danger is-invalid Water_Connection_Usage_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="OutstandingAmt"> Total Outstanding Payable/ एकूण थकबाकी बिल भरले?</label>
                                    <input class="form-control" id="OutstandingAmt" name="OutstandingAmt" value="{{ $data->OutstandingAmt }}" type="text" required disabled readonly>
                                    <span class="text-danger is-invalid OutstandingAmt_err"></span>
                                </div>
                            </div> --}}
                            {{-- <div class="col-md-4 mt-4">
                                <button type="button" id="payaccentech" class="btn btn-success" target="_blank"
                                    onclick="window.location.href='https://watertax.nagarkaryavali.com/FrmWTConnSearch.aspx?@=AD65C7423AEA4530E3CB0528C8EFFFE4185BBCFBFA074578B362FC23AB6A7765'">Pay</button>
                            </div> --}}

                            <div class="col-md-4">
    <label class="col-form-label" for="Water_Connection_Size">
        Water Connection Size <span class="text-danger">*</span>
    </label>
    <select class="form-control" id="Water_Connection_Size" name="Water_Connection_Size">
        <option value="">-- Select --</option>
        <option value="151588" {{ $data->Water_Connection_Size == '151588' ? 'selected' : '' }}>घरगुती 1 इंच</option>
        <option value="78765"  {{ $data->Water_Connection_Size == '78765' ? 'selected' : '' }}>घरगुती 1/2 इंच</option>
    </select>
    <span class="text-danger is-invalid Water_Connection_Size_err"></span>
</div>

                            <div class="card-body">
                                <div class="mb-3 row">

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="total_connection">Total illegal connections<span class="text-danger">*</span></label>
                                        <input class="form-control" id="total_connection" name="total_connection" value='{{ $data->total_connection }}' type="text" placeholder="Enter total illegal connections" disabled readonly >
                                        <span class="text-danger is-invalid total_connection_err"></span>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="info_unauth_con">Information about Unauthorized connection</label>
                                        <input class="form-control" id="info_unauth_con" value='{{ $data->info_unauth_con }}' name="info_unauth_con" type="text" placeholder="Enter Information about Unauthorized connection" disabled readonly>
                                        <span class="text-danger is-invalid info_unauth_con_err"></span>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="plot_no">Plot NO</label>
                                        <input class="form-control" id="plot_no" value='{{ $data->plot_no }}' name="plot_no" type="text" placeholder="Enter Plot NO" disabled readonly>
                                        <span class="text-danger is-invalid plot_no_err"></span>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="house_no">House Number / घर नं <span class="text-danger">*</span></label>
                                        <input class="form-control" id="house_no" name="house_no" value='{{ $data->house_no }}' type="text" placeholder="Enter House Number" disabled readonly>
                                        <span class="text-danger is-invalid house_no_err"></span>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="landmark">Landmark / महत्त्वाची खूण</label>
                                        <input class="form-control" name="landmark" value='{{ $data->landmark }}' id="landmark" placeholder="Enter Landmark" disabled readonly>
                                        <span class="text-danger is-invalid landmark_err"></span>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="address_property">Full Address Of Property<span class="text-danger">*</span></label>
                                        <textarea class="form-control" id="address_property" name="address_property" cols="2" type="text" placeholder="Enter Full Address Of Property " disabled readonly>{{ $data->address_property }}</textarea>
                                        <span class="text-danger is-invalid address_property_err"></span>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="existing_tap_con_details">Existing tap connection details/ विद्यमान टॅप कनेक्शन तपशील</label>
                                        <select class="form-select" name="existing_tap_con_details" id="existing_tap_con_details" disabled>
                                            <option value="" selected>Select option</option>
                                            @php
                                                $options = ['Yes', 'No'];
                                            @endphp
                                            @foreach ($options as $option)
                                                <option value="{{ $option }}" {{ $option == $data->existing_tap_con_details ? 'selected' : '' }}>{{ $option }}</option>
                                            @endforeach
                                        </select>
                                        <span class="text-danger is-invalid existing_tap_con_details_err"></span>
                                        <div class="selected-value d-none" id="existing_tap_con_details_selected"></div>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="existing_top_con_unautorized">Existing tap connections are unauthorized./विद्यमान टॅप कनेक्शन अनधिकृत आहेत</label>
                                        <select class="form-select" name="existing_top_con_unautorized" id="existing_top_con_unautorized" disabled>
                                            <option value="" selected>Select option</option>
                                            @php
                                                $options = ['Yes', 'No'];
                                            @endphp
                                            @foreach ($options as $option)
                                                <option value="{{ $option }}" {{ $option == $data->existing_top_con_unautorized ? 'selected' : '' }}>{{ $option }}</option>
                                            @endforeach
                                        </select>
                                        <span class="text-danger is-invalid existing_top_con_unautorized_err"></span>
                                        <div class="selected-value d-none" id="existing_top_con_unautorized_selected"></div>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="unauthorized_is_tenant">Is the holder of unauthorized tap connection a tenant/ अनधिकृत नळ कनेक्शन धारक भाडेकरू आहे का?</label>
                                        <select class="form-select" name="unauthorized_is_tenant" id="unauthorized_is_tenant" disabled>
                                            <option value="" selected>Select option</option>
                                            @php
                                                $options = ['Yes', 'No'];
                                            @endphp
                                            @foreach ($options as $option)
                                                <option value="{{ $option }}" {{ $option == $data->unauthorized_is_tenant ? 'selected' : '' }}>{{ $option }}</option>
                                            @endforeach
                                        </select>
                                        <span class="text-danger is-invalid unauthorized_is_tenant_err"></span>
                                        <div class="selected-value d-none" id="unauthorized_is_tenant_selected"></div>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="criminal_judicial_issue">Criminal or Judicial issues about existing tap connection/विद्यमान नळ कनेक्शनबद्दल फौजदारी किंवा न्यायालयीन मुद्दे</label>
                                        <select class="form-select" name="criminal_judicial_issue" id="criminal_judicial_issue" disabled>
                                            <option value="" selected>Select option</option>
                                            @php
                                                $options = ['Yes', 'No'];
                                            @endphp
                                            @foreach ($options as $option)
                                                <option value="{{ $option }}" {{ $option == $data->criminal_judicial_issue ? 'selected' : '' }}>{{ $option }}</option>
                                            @endforeach
                                        </select>
                                        <span class="text-danger is-invalid criminal_judicial_issue_err"></span>
                                        <div class="selected-value d-none" id="criminal_judicial_issue_selected"></div>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="col-form-label" for="application_documents">Upload Document/Photo / दस्तऐवज/फोटो अपलोड करा<span class="text-danger">*</span></label>
                                        <div><a href="{{ asset('storage/' . $data->application_document) }}" target="_blank">View Document</a></div>
                                        {{-- <input class="form-control" id="application_documents" name="application_documents" type="file" required> --}}
                                        <span class="text-danger is-invalid application_documents_err"></span>
                                    </div>
                                    
                                        <div class="col-md-4">
                                            <label class="col-form-label" for="comment">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा </label>
                                            <div><a href="{{ asset('storage/' . $data->comment) }}" target="_blank">View Document</a></div>
                                            {{-- <input class="form-control" id="comment" name="comment" type="file" required> --}}
                                            <span class="text-danger is-invalid comment_err"></span>
                                        </div>
                                   

                                </div>

                                {{--
                            <div class="col-md-4">
                                <label class="col-form-label" for="application_documents">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <input class="form-control" id="application_documents" name="application_documents" type="file">
                                <span class="text-danger is-invalid application_documents_err"></span>
                            </div> --}}

                                <div class="col-md-4">
                                    <label for="remark">Remark<span class="text-danger">*</span></label>
                                    <textarea id="Remark" name="remark" maxlength="255" class="form-control" rows="4" required></textarea>
                                </div>


                                {{--
                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_or_tenant">Is the holder of unauthorized tap connection a tenant/ अनधिकृत नळ कनेक्शन धारक भाडेकरू आहे का?<span class="text-danger">*</span></label>
                                    <select class="form-select" name="applicant_or_tenant" id="applicant_or_tenant" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option {{ $data->applicant_or_tenant == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid applicant_or_tenant_err"></span>
                                </div> --}}







                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="place_belongs_to_municipal">Place Belongs To Municipal Council Limit / सदर जागा नगरपरिषदेच्या हद्दीत आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="place_belongs_to_municipal" id="place_belongs_to_municipal" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option {{ $data->place_belongs_to_municipal == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid place_belongs_to_municipal_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="comment">Comment / टिप्पणी</label>
                                    <input class="form-control" id="comment" name="comment" type="text" placeholder="Enter Comment " value="{{ $data->comment }}">
                                    <span class="text-danger is-invalid comment_err"></span>
                                </div> --}}



                                {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                                <div class="col-md-12">
                                    <div class="form-check d-flex align-items-start">
                                        <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" checked required name="is_correct_info" value="yes">
                                        <label class="form-check-label ms-2" for="is_correct_info">
                                            "All information provided above is correct and I shall be fully responsible for any discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                            असेन."
                                        </label>
                                    </div>
                                    <span class="text-danger is-invalid is_correct_info_err"></span>
                                </div> --}}

                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                            <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                            {{-- <button type="submit" class="btn btn-primary" id="addSubmit">Update</button> --}}
                            {{-- <button type="reset" class="btn btn-warning">Reset</button> --}}
                            <button id="btnCancel" class="btn btn-warning">Cancel</button>
                        </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>




{{-- Add --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>

     document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);

        var updateUrl = '{{ route('water-illegal-connection.update', $data->id) }}';
        formdata.append('_method', 'PUT');

        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });

    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
