<x-admin.layout>
    <x-slot name="title">New Water Connection / नविन नळजोडणी</x-slot>
    <x-slot name="heading">New Water Connection / नविन नळजोडणी</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_full_name">Applicant Full Name / अर्जदाराचे संपूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_full_name" value="{{ $data->applicant_full_name }}" name="applicant_full_name" type="text" placeholder="Enter Applicant Full Name" required disabled readonly>
                                <span class="text-danger is-invalid applicant_full_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Aadhar No / आधार नंबर <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" value="{{ $data->aadhar_no }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text"
                                    placeholder="Enter Aadhar Card No" required disabled readonly>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $data->mobile_no }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text"
                                    placeholder="Enter Mobile Number" required disabled readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id">Email ID / ई-मेल आयडी</label>
                                <input class="form-control" id="email_id" name="email_id" value="{{ $data->email_id }}" type="email" placeholder="Enter Email" disabled readonly>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>


                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <select class="form-select" name="zone" id="zone" required >
                                        <option value="">Select Zone</option>

                                        @foreach ($zones as $zone)
                                        <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div> --}}
                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <select class="form-select" name="ward_area" id="ward_area" required>
                                        <option value="">Select Ward Area</option>

                                        @foreach ($wards as $ward)
                                        <option value="{{ $ward->name }}">{{ $ward->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid ward_area_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="city_servey_no">City Survey Number / सिटी सर्व्हे क्र.<span class="text-danger">*</span></label>
                                <input class="form-control" id="city_servey_no" name="city_servey_no" type="text" placeholder="Enter City Survey Number" required>
                                <span class="text-danger is-invalid city_servey_no_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा संपूर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" name="address" id="address" cols="30" rows="2" placeholder="Enter  Address" required disabled readonly>{{ $data->address }}</textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="landmark">Landmark / हद्द खूण</label>
                                <input class="form-control" id="landmark" value="{{ $data->landmark }}" name="landmark" type="text" placeholder="Enter Landmark" disabled readonly>
                                <span class="text-danger is-invalid landmark_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="no_of_flats_shops">Number of Flats / Shops. / फ्लॅट्स / दुकानांची संख्या.<span class="text-danger">*</span></label>
                                <input class="form-control" id="no_of_flats_shops" value="{{ $data->no_of_flats_shops }}" name="no_of_flats_shops" type="text" placeholder="Enter Number of Flats / Shops" required disabled readonly>
                                <span class="text-danger is-invalid no_of_flats_shops_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="property_no">Property Number / मालमत्ता क्र.<span class="text-danger">*</span></label>
                                <input class="form-control" id="property_no" value="{{ $data->property_no }}" name="property_no" type="text" placeholder="Enter Property Number" required disabled readonly>
                                <span class="text-danger is-invalid property_no_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="total_person">Total Person / एकूण व्यक्ती<span class="text-danger">*</span></label>
                                <input class="form-control" id="total_person" name="total_person" type="number" placeholder="Enter Total Person" required>
                                <span class="text-danger is-invalid total_person_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="distance">Distance / अंतर<span class="text-danger">*</span></label>
                                <input class="form-control" id="distance" name="distance" type="text" placeholder="Enter Distance" required>
                                <span class="text-danger is-invalid distance_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="water_connection_use">Usage Of Water Connection / पाणी कनेक्शनचा वापर<span class="text-danger">*</span></label>
                                <select class="form-select" name="water_connection_use" id="water_connection_use" required disabled>
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['अनिवासी व्यवसाय', 'औद्योगीक', 'निवासी', 'विशेष प्रवर्ग (शैक्षणिक संस्था,शासकीय,निमशासकीय कार्यालय,पथसंस्था,इतर)', 'व्यावसायिक अथवा वाणिज्य'];
                                    @endphp
                                    @foreach ($options as $option)
                                        <option value="{{ $option }}" {{ $option == $data->water_connection_use ? 'selected' : '' }}>{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid water_connection_use_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="water_connection_sub_use">Sub usage Of Water Connection / पाणी कनेक्शनचा वापर<span class="text-danger">*</span></label>
                                <select class="form-select" name="water_connection_sub_use" id="water_connection_sub_use" required disabled>
                                    <option value="">Select option</option>
                                    @php
                                        $subUse = $data->water_connection_sub_use ? $data->water_connection_sub_use : '-';
                                    @endphp
                                    <option value="{{ $subUse }}" selected>{{ $subUse }}</option>
                                </select>
                                <span class="text-danger is-invalid water_connection_sub_use_err"></span>
                            </div>
                            {{-- @if ($secondApprover || $thirdApprover)
                                <div class="col-md-4">
                                    <label class="col-form-label" for="road_repair_type">Road repair type / रस्ता दुरुस्ती प्रकार<span class="text-danger">*</span></label>
                                    <select class="form-select" name="road_repair_type" id="road_repair_type" required {{$thirdApprover ? 'disabled' : ''}}>
                                        <option value="">Select option</option>
                                        <option value="tar" {{$data->road_repair_type == 'tar' ? 'selected' : ''}}>Tar / डांबर</option>
                                        <option value="cc" {{$data->road_repair_type == 'cc' ? 'selected' : ''}}>cement concrete / सिमेंट काँक्रीट</option>
                                    </select>
                                    <span class="text-danger is-invalid road_repair_type_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="road_repair_length">road length / रस्त्याची लांबी<span class="text-danger">*</span></label>
                                    <select class="form-select" name="road_repair_length" id="road_repair_length" required {{$thirdApprover ? 'disabled' : ''}}>
                                        <option value="">Select option</option>
                                        <option value="1" {{$data->road_repair_length == '1' ? 'selected' : ''}}>1</option>
                                        <option value="2" {{$data->road_repair_length == '2' ? 'selected' : ''}}>1/2</option>
                                    </select>
                                    <span class="text-danger is-invalid road_repair_length_err"></span>
                                </div>
                            @endif --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="pipe_size">Pipe Size / पाईपचा आकार <span class="text-danger">*</span></label>
                                {{-- <select class="form-select" name="pipe_size" id="pipe_size" required disabled>
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['15mm', '20mm', '25mm', '40mm', '50mm', '80mm', '100mm', '150mm', '300mm'];
                                    @endphp
                                    @foreach ($options as $option)
                                        <option value="{{ $option }}" {{ $option == $data->pipe_size ? 'selected' : '' }}>{{ $option }}</option>
                                    @endforeach
                                </select> --}}
                                <select class="form-select" name="pipe_size" id="pipe_size" required disabled>
                                    <option value="">Select option</option>
                                    @php
                                        $options = [
                                            '1/2' => '1/2 inch',
                                            '1' => '1 inch',
                                        ]; // key = database value, value = display text
                                    @endphp

                                    @foreach ($options as $value => $label)
                                        <option value="{{ $value }}" {{ $data->pipe_size == $value ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </select>

                                <span class="text-danger is-invalid pipe_size_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="no_of_tap">Required No Of Tap Connection / नळजोडणी ची आवश्यक संख्या <span class="text-danger">*</span></label>
                                <input class="form-control" type="number" value="{{ $data->no_of_tap }}" name="no_of_tap" id="no_of_tap" placeholder="Enter Required No Of Tap Connection" required disabled readonly>
                                <span class="text-danger is-invalid no_of_tap_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="current_no_of_tap">Number Of Existing Tap Connections / नळजोडणी सध्याची एकूण संख्या <span class="text-danger">*</span></label>
                                <input class="form-control" type="number" value="{{ $data->current_no_of_tap }}" name="current_no_of_tap" id="current_no_of_tap" placeholder="EnterNumber Of Existing Tap Connections" required disabled readonly>
                                <span class="text-danger is-invalid current_no_of_tap_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="prabhag">Prabhag / प्रभाग <span class="text-danger">*</span></label>
                                <select class="form-select" name="prabhag" id="prabhag" required disabled>
                                    <option value="">Select option</option>
                                    <option value="{{ $data->prabhag }}" selected>{{ $data->prabhag }}</option>
                                </select>
                                <span class="text-danger is-invalid prabhag_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="wards">ward / वॉर्ड <span class="text-danger">*</span></label>
                                <select class="form-select" name="wards" id="wards" required disabled>
                                    <option value="">Select option</option>
                                    <option value="{{ $data->ward_area }}" selected>{{ $data->ward_area }}</option>
                                </select>
                                <span class="text-danger is-invalid wards_err"></span>
                            </div> --}}

                            <div class="col-md-4">
    <label class="col-form-label" for="prabhag">Prabhag / प्रभाग <span class="text-danger">*</span></label>
    <select class="form-select" name="prabhag" id="prabhag" required disabled>
        <option value="">Select option</option>
        @if(!empty($prabhagName))
            <option value="{{ $data->prabhag }}" selected>{{ $prabhagName }}</option>
        @endif
    </select>
    <span class="text-danger is-invalid prabhag_err"></span>
</div>

<div class="col-md-4">
    <label class="col-form-label" for="wards">Ward / वॉर्ड <span class="text-danger">*</span></label>
    <select class="form-select" name="wards" id="wards" required disabled>
        <option value="">Select option</option>
        @if(!empty($wardName))
            <option value="{{ $data->ward_area }}" selected>{{ $wardName }}</option>
        @endif
    </select>
    <span class="text-danger is-invalid wards_err"></span>
</div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="total_tenants">Total Tenants / एकूण भाडेकरू<span class="text-danger">*</span></label>
                                <input class="form-control" id="total_tenants" name="total_tenants" type="number" placeholder="Enter Total Tenants" required>
                                <span class="text-danger is-invalid total_tenants_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="water_connection_no">Existing Water Connection No / पूर्वीचा पाणी कनेक्शन क्र<span class="text-danger"></span></label>
                                <input class="form-control" id="water_connection_no" value="{{ $data->water_connection_no }}" name="water_connection_no" type="text" placeholder="CNNP01B0000001" disabled readonly>
                                <span class="text-danger is-invalid water_connection_no_err"></span>
                            </div>

                            <div class="col-md-4" id="upload_section" style="display:none;">
                                <label class="col-form-label" for="written_application_document">Upload Application in the prescribed format / विहित नमून्यातील अर्ज<span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->written_application_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="written_application_document" name="written_application_document" type="file"> --}}
                                <span class="text-danger is-invalid written_application_document_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="address_proof">Electricity Bill / Aadhar Card/ Voter ID / Ration Card / वीज बिल / आधार कार्ड / मतदार ओळखपत्र / रेशन कार्ड <span class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="address_proof" name="address_proof" type="file" required> --}}
                                <div><a href="{{ asset('storage/' . $data->address_proof) }}" target="_blank">View Document</a></div>
                                <span class="text-danger is-invalid address_proof_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="ownership_document">Upload Land ownership documents / मालकी हक्काची कागदपत्रे अपलोड करा <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->ownership_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="ownership_document" name="ownership_document" type="file" required> --}}
                                <span class="text-danger is-invalid ownership_document_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="no_dues_document">Upload Certificate Of No Dues / थकबाकी नसल्याचा दाखला अपलोड करा <span class="text-danger">*</span></label>
                                <input class="form-control" id="no_dues_document" name="no_dues_document" type="file" required>
                                <span class="text-danger is-invalid no_dues_document_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="stamp_karnama">100Rs Stamp Kararnama / १०० रुपयांचा करनामा स्टॅम्प.<span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->stamp_karnama) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="stamp_karnama" name="stamp_karnama" type="file" required> --}}
                                <span class="text-danger is-invalid stamp_karnama_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="oc_and_cc">O/C and CC Certificate / bandkam praranbh patra / Bhogavata dakhala / O/C आणि CC प्रमाणपत्र / बांधकाम प्रारंभ पत्र / भोगवटा दाखला.</label>
                                <div><a href="{{ asset('storage/' . $data->oc_and_cc) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="oc_and_cc" name="oc_and_cc" type="file" required> --}}
                                <span class="text-danger is-invalid oc_and_cc_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="structure_photo">Upload Structure Photo/ स्ट्रक्चर फोटो अपलोड करा<span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->structure_photo) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="structure_photo" name="structure_photo" type="file"> --}}
                                <span class="text-danger is-invalid structure_photo_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="jote_doc">Upload Tillage certificate / जोते प्रमाणपत्र अपलोड करा <span class="text-danger">*</span></label>
                                <input class="form-control" id="jote_doc" name="jote_doc" type="file" required>
                                <span class="text-danger is-invalid jote_doc_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-6" id="upload_section" style="display:none;"> --}}
                                <div class="col-md-4">
                                <label class="col-form-label" for="written_application_documents">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->written_application_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="uploaded_applications" name="uploaded_applications" type="file"> --}}
                                <span class="text-danger is-invalid written_application_documents_err"></span>
                            </div>





                 {{-- @if(auth()->user()->hasRole('JuniorEngineer'))
                    <div class="col-md-4">     
                      <label for="jramount"><strong>Road Repair (रस्ता दुरुस्ती):</strong></label>
                        <select name="jramount" id="jramount" class="form-select">
                            <option value="">-- Select --</option>
                            <option value="12024">डांबरी रस्ता</option>
                            <option value="15069">सिमेंट काँक्रीट</option>
                        </select>
                    </div>

                   <div class="col-md-4">     
                       <label for="running meter"><strong>Running Meter (रनिंग मीटर):</strong></label>
                        <input type="text" name="running_meter" id="running_meter" 
                            class="form-control" placeholder="Enter Running Meter">
                    </div>
                @endif --}}

                {{-- @if(auth()->user()->hasRole('JuniorEngineer'))
    <div class="col-md-4">     
        <label for="jramount"><strong>Road Repair (रस्ता दुरुस्ती):</strong></label>
        <select name="jramount" id="jramount" class="form-select">
            <option value="">-- Select --</option>
            <option value="12024" {{ (isset($data->jramount) && $data->jramount == 12024) ? 'selected' : '' }}>डांबरी रस्ता</option>
            <option value="15069" {{ (isset($data->jramount) && $data->jramount == 15069) ? 'selected' : '' }}>सिमेंट काँक्रीट</option>
        </select>
    </div>

    <div class="col-md-4">     
        <label for="running_meter"><strong>Running Meter (रनिंग मीटर):</strong></label>
        <input type="text" name="running_meter" id="running_meter" 
            class="form-control" placeholder="Enter Running Meter" 
            >
    </div>
@elseif (Auth::user()->role == 'DeputyEngineer' || Auth::user()->role == 'ExecutiveEngineer')
    <div class="col-md-4">     
        <label for="jramount"><strong>Road Repair (रस्ता दुरुस्ती):</strong></label>
        <select class="form-select" disabled readonly>
            <option value="">-- Select --</option>
            <option value="12024" {{ (isset($data->jramount) && $data->jramount == 12024) ? 'selected' : '' }}>डांबरी रस्ता</option>
            <option value="15069" {{ (isset($data->jramount) && $data->jramount == 15069) ? 'selected' : '' }}>सिमेंट काँक्रीट</option>
        </select>
    </div>

    <div class="col-md-4">     
        <label for="running_meter"><strong>Running Meter (रनिंग मीटर):</strong></label>
        <input type="text" class="form-control" value="{{ $data->running_meter ?? '' }}" readonly disabled>
    </div>
@endif --}}


{{-- 👷 For Junior Engineer (Editable Fields) --}}
@if(auth()->user()->hasRole('JuniorEngineer'))
    <div class="col-md-4">     
        <label for="jramount"><strong>Road Repair (रस्ता दुरुस्ती):</strong></label>
        <select name="jramount" id="jramount" class="form-select">
            <option value="">-- Select --</option>
            <option value="12024" {{ (isset($data->jramount) && $data->jramount == 12024) ? 'selected' : '' }}>डांबरी रस्ता</option>
            <option value="15069" {{ (isset($data->jramount) && $data->jramount == 15069) ? 'selected' : '' }}>सिमेंट काँक्रीट</option>
        </select>
    </div>

    <div class="col-md-4">     
        <label for="running_meter"><strong>Running Meter (रनिंग मीटर):</strong></label>
        <input type="text" 
               name="running_meter" 
               id="running_meter" 
               class="form-control" 
               placeholder="Enter Running Meter"
               value="{{ old('running_meter', $data->running_meter ?? '') }}">
    </div>

{{-- 🧰 For Deputy / Executive Engineer (View Only) --}}
@elseif(auth()->user()->hasRole('DeputyEngineer') || auth()->user()->hasRole('ExecutiveEngineer'))
    <div class="col-md-4">     
        <label for="jramount"><strong>Road Repair (रस्ता दुरुस्ती):</strong></label>
        <select class="form-select" id="jramount" disabled readonly>
            <option value="">-- Select --</option>
            <option value="12024" {{ (isset($data->jramount) && $data->jramount == 12024) ? 'selected' : '' }}>डांबरी रस्ता</option>
            <option value="15069" {{ (isset($data->jramount) && $data->jramount == 15069) ? 'selected' : '' }}>सिमेंट काँक्रीट</option>
        </select>
    </div>

    <div class="col-md-4">     
        <label for="running_meter"><strong>Running Meter (रनिंग मीटर):</strong></label>
        <input type="text" 
               class="form-control" 
               id="running_meter"
               value="{{ $data->running_meter ?? '' }}" 
               readonly disabled>
    </div>
@endif



                            



                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" rows="4" required></textarea>
                            </div>

                            {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" required>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        {{-- <button type="submit" class="btn btn-primary updateBtn" id="addSubmit">Update</button> --}}
                        {{-- <button type="reset" class="btn btn-warning">Reset</button> --}}
                         <button id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>


{{-- Add --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
     document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route('water-new-connection.update', $data->id) }}';

        formdata.append('_method', 'PUT');

        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });

    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();
            let jramount = $('#jramount').val();
         
            let running_meter = $('#running_meter').val();
             
            let update;

            if (remark.trim() !== ''){
                $.ajax({
                    url: "{{route('water.updateRoad')}}",
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        formId: {{$data->id}},
                        road_repair_type: $('#road_repair_type').val(),
                        road_repair_length: $('#road_repair_length').val(),
                         jramount: jramount,
                         running_meter:running_meter
                    },
                    success: function(response) {
                        $.ajax({
                            url: '/approve-item/' + statusId,
                            type: 'POST',
                            data: {
                                _token: '{{ csrf_token() }}',
                                remark: remark,
                                 jramount: jramount,
                                 running_meter:running_meter
                            },
                            success: function(response) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success!',
                                    text: response.message,
                                    confirmButtonText: 'OK'
                                }).then(() => {
                                    window.location.href = response.redirect_url;
                                });
                            },
                            error: function(xhr) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: 'Error: ' + xhr.responseText,
                                    confirmButtonText: 'OK'
                                });
                            }
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            }else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }

            // if (remark.trim() !== '') {
            //     $.ajax({
            //         url: '/approve-item/' + statusId,
            //         type: 'POST',
            //         data: {
            //             _token: '{{ csrf_token() }}',
            //             remark: remark
            //         },
            //         success: function(response) {
            //             Swal.fire({
            //                 icon: 'success',
            //                 title: 'Success!',
            //                 text: response.message,
            //                 confirmButtonText: 'OK'
            //             }).then(() => {
            //                 window.location.href = response.redirect_url;
            //             });
            //         },
            //         error: function(xhr) {
            //             Swal.fire({
            //                 icon: 'error',
            //                 title: 'Error!',
            //                 text: 'Error: ' + xhr.responseText,
            //                 confirmButtonText: 'OK'
            //             });
            //         }
            //     });
            // } else {
            //     Swal.fire({
            //         icon: 'warning',
            //         title: 'Warning!',
            //         text: 'Please Add Remark',
            //         confirmButtonText: 'OK'
            //     });
            // }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>

<script>
    
$(document).ready(function () {
    // Prevent letters and special characters
    $('#running_meter').on('input', function () {
        let value = $(this).val();

        // Replace anything that is NOT a digit
        value = value.replace(/[^0-9]/g, '');
        $(this).val(value);
    });

    // Optional: On form submit validation
    $('#addForm').on('submit', function (e) {
        let runningMeter = $('#running_meter').val().trim();

        if (runningMeter === '') {
            e.preventDefault();
            $('.running_meter_err').text('Running Meter is required');
        } else {
            $('.running_meter_err').text('');
        }
    });
});
</script>

    

