<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .content {
            margin-top: 30px;
        }

        /* .sub-header {
            text-align: right;
        } */
        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }

        .points {
            margin-top: 20px;
        }

        .points li {
            margin-bottom: 10px;
            margin-left: 5%;
        }

        p {
            font-size: 18px;
        }
    </style>
</head>

<body>

    <div class="header">
        @php
            $logoData = file_get_contents(public_path('admin/images/favicon.png'));
            $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
            $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
            $base64Logo = base64_encode($logoData);
            $base64Logo2 = base64_encode($logoData2);
            $base641Logo = base64_encode($logoData1);
        @endphp
        <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" style="float:left;margin-top:35px;" height="150" width="150">
        {{-- <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150"> --}}
        {{-- <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo"  style="float:right;margin-top:35px;" height="150" width="150"> --}}
        <div class="rox">
            <h2>मिरा भाईंदर महानगरपालिका</h2>
            <p>स्व.इंदिरा गांधी भवन,मुख्य कार्यालय, छत्रपती शिवाजी महाराज मार्ग, भाईंदर (प.),ता.ठाणे-४०११०१</p>
            <p>दूरध्वनी क्र.२८१९२४८</p>
            <h3 style="margin-left: 8rem">पाणी पुरवठा व मलनिःसारण विभाग</h3>
        </div>
    </div>
    <hr>
    <hr style="1px solid #000; height:5px; background-color:#000;">
    <div class="sub-header">
        <div class="row d-flex">
            <p>जा.क्र.मनपा/पापू व मलनि/{{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/ 2025-2026
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                दि. <span class="line">{{ \Carbon\Carbon::parse($data->created_at)->format('d/m') }}</span> / <span class="line">{{ \Carbon\Carbon::parse($data->created_at)->format('Y') }}</span></p>
        </div>
    </div>

    <p>प्रति<br>
        {{ $data->applicant_full_name }} <br>
        {{-- पाणी पुरवठा व मलनिसारण विभाग --}}
    </p>

    <p style="margin-left:20%;"><strong>विषय :</strong> नविन जलजोडणी करणेबाबत.</p>
    <p style="margin-left:20%;"><strong>संदर्भ :</strong> १) नविन जलजोडणी अर्ज क्र.{{ $data->application_no }} दिनांक{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }}
        <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;२) नविन जलजोडणी शुल्क मागणी पत्र जा.क्रं. म.न.पा. पापु व मलनि{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }}
        {{-- <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;३) नविन जलजोडणी शुल्क भरणा पावती क्र.{{ $data->application_no }} --}}
         <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;३) नविन जलजोडणी शुल्क भरणा पावती क्र. {{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}
       
        .&nbsp;&nbsp;&nbsp;दिनांक{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }}
    </p>

    <br>

    <div class="content">
        <p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;आपणास ह्या आदेशान्वये कळविण्यात येते की,
            <b>{{ $data->landmark }}</b>
            हया इमारतीची/घरास <b>{{ $data->distance }} </b>{{$data->pipe_size}}.इंच
            व्यासाची <b> {{ $data->water_connection_use }} </b> जलजोडणी संदर्भिय आदेशान्वये मंजूर झालेली असुन ती जोडण्यात यावी व तसा अहवाल मिटर टेस्टींग
            रिपोर्टसह या कार्यालयात जलजोडणी झाल्यानंतर सात दिवसाच्या आत सादर करावा. जलजोडणी करणेपूर्वी जलजोडणी
            शुल्क भरणा पावती व मिटर टेस्टींग रिपोर्ट इत्यादी तपासून घ्यावे. महानगरपालिकेच्या वितरण जलवाहीनीपर्यंत जलजोडणी
            अंथरणे कामी आवश्यक असलेले साहित्य ग्राहकाने स्वतःच्या खाजगी प्लंबर मार्फत स्वखर्चाने करण्यात यावे.
            महानगरपालिका फक्त वितरण जलवाहीनीवर बोरींग करून देईल. पाणी पुरवठा विभागामार्फत स्व. विलासराव देशमुख
            भवन, जांगीड एनक्लेव्ह, कनकिया रोड, मिरारोड (पूर्व) या ठिकाणी नवीन मिटर /फॉल्टी मिटर तपासणी करिता मिटर टेस्टींग
            लॅब उपलब्ध आहे. सदर लॅब मधून मिटर तपासणी केल्यानंतर प्रमाणपत्र प्राप्त करुन घ्यावे.
        </p>

    </div>
    <br>
    <br>

    <div class="footer" style="float:right;">
        <p><strong>कार्यकारी अभियंता</strong><br>
            (पा. पु. व मलनि)<br>
            मिरा-भाईंदर महानगरपालिका</p>
    </div>
    <br>
    <br>
    <br>
    <p>
        प्रत :-<br>
        १) सेक्रेटरी चेअरमन.................... <br>
        ...........<br>
        श्री.<br>
        २) Property Tax No ..............<br>
        Consumer Number (ग्राहक क्रमांक)......... <br>
        श्री.........<br>
        (लिपिक) <br>
        पाणी पुरवठा व मलनिसारण विभाग<br>
        मेस्त्रीच्या अहवालानुसार मागणी रजिस्टरला नोंद घेऊन नियमीत देयके पाठविण्यात यावी.<br>

    </p>

</body>

</html>
