<x-admin.layout>
    <x-slot name="title">Complaint Of Water Pressure / पाण्याची दबाव क्षमता तक्रार (नलजोडणी दुरुस्ती / स्थलांतर)</x-slot>
    <x-slot name="heading">Complaint Of Water Pressure / पाण्याची दबाव क्षमता तक्रार (नलजोडणी दुरुस्ती / स्थलांतर)</x-slot>
   
    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">

                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">

                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" value="{{ $user->name }}" placeholder="Enter Applicant Name" required>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="address" name="address" type="text" placeholder="Enter Name Of New Owner" required>{{ $user->address }} </textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Applicant Mobile No / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $user->mobile }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text"
                                    placeholder="Enter Mobile Number" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Applicant EmailID / ईमेल आयडी<span class="text-danger"></span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $user->email }}" required>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Applicant Adhaar No / आधार क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" value='{{ $user->aadhar_no }}' oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text"
                                    placeholder="Enter Aadhar Card No" required>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>

                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">

                            @csrf
                            <div class="col-md-4">
                                <input class="form-control" id="marchantid" name="marchantid" type="hidden" value="MBMCCORE">
                                <span class="text-danger is-invalid marchantid_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="connection_no">Connection No<span class="text-danger">*</span></label>
                                <input class="form-control" id="connection_no" name="connection_no" type="text" placeholder="Enter Connection No" >
                                <span class="text-danger is-invalid connection_no_err"></span>
                            </div>

                            <button type="Search" class="btn btn-primary mt-2" id="searchdetails">Search</button>
                        </div>
                    </div>



                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Water Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_owner_name">Owner Name/मालकाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="property_owner_name" name="property_owner_name" type="text" placeholder="Enter Owner Name"  readonly>
                                    <span class="text-danger is-invalid property_owner_name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Full_Address_Of_The_Property"> Owner Address/मालकाचा पत्ता<span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="Full_Address_Of_The_Property" id="Full_Address_Of_The_Property" cols="30" rows="2" placeholder="Enter  Address"  readonly></textarea>
                                    <span class="text-danger is-invalid Full_Address_Of_The_Property_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Ward" id="Ward" placeholder="Enter Ward Area"  readonly>
                                    <span class="text-danger is-invalid Ward_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <input class="form-control" name="zone" id="zone" placeholder="Enter Zone"  readonly>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Size">Water Connection Size<span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Size" name="Water_Connection_Size" type="text" placeholder="Enter Water Connection Size"  readonly>
                                    <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Connection_Type">Connection Type<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Connection_Type" id="Connection_Type" type="text" placeholder="Enter Connection Type"  readonly>
                                    <span class="text-danger is-invalid Connection_Type_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Usage">Water Connection Usage <span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Usage" name="Water_Connection_Usage" type="text" placeholder="Enter Water Connection Usage"  readonly>
                                    <span class="text-danger is-invalid Water_Connection_Usage_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="OutstandingAmt"> Total Outstanding Payable/ एकूण थकबाकी बिल भरले?<span class="text-danger">*</span></label>
                                    <input class="form-control" id="OutstandingAmt" name="OutstandingAmt" type="text"  readonly>
                                    <span class="text-danger is-invalid OutstandingAmt_err"></span>
                                </div>
                                <div class="col-md-4 mt-4">
                                    <button type="button" id="payaccentech" class="btn btn-success" target="_blank"
                                        onclick="window.location.href='https://watertax.nagarkaryavali.com/FrmWTConnSearch.aspx?@=AD65C7423AEA4530E3CB0528C8EFFFE4185BBCFBFA074578B362FC23AB6A7765'">Pay</button>
                                </div>

                            </div>
                        </div>
                    </div>

                    {{-- <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data"> --}}
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Add Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="total_connection">Total Connection Number / एकूण कनेक्शन क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" id="total_connection" name="total_connection" type="text" placeholder="Total Connection Number / एकूण कनेक्शन क्रमांक" >
                                <span class="text-danger is-invalid total_connection_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="landmark">Landmark / जवळची खूण </label>
                                <input class="form-control" id="landmark" name="landmark" type="text" placeholder="Enter Landmark">
                                <span class="text-danger is-invalid landmark_err"></span>
                            </div>


                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="panycha_type_add">पाण्याचा प्रकार / Type of Permission</label>
                                    <select class="form-select" id="panycha_type_add" name="panycha_type_add">
                                        <option value="">--Select Type--</option>
                                        <option value="दुरुस्ती परवानगी">दुरुस्ती परवानगी</option>
                                        <option value="स्थानांतरण परवानगी">स्थानांतरण परवानगी</option>
                                    </select>
                                    <span class="text-danger is-invalid panycha_type_err"></span>
                                </div> --}}


                                <div class="col-md-4">
                                    <label class="col-form-label" for="panycha_type_add">पाण्याचा प्रकार / Type of Permission<span class="text-danger">*</span></label>
                                    <select class="form-select" id="panycha_type_add" name="panycha_type_add">
                                        <option value="">--Select Type--</option>
                                        <option value="दुरुस्ती परवानगी(Domestic - 1inch)">दुरुस्ती परवानगी(Domestic - 1inch)</option>
										 <option value="दुरुस्ती परवानगी(Domestic - 1/2inch)">दुरुस्ती परवानगी(Domestic - 1/2inch)</option>
										  <option value="दुरुस्ती परवानगी(Commercial - 1inch)">दुरुस्ती परवानगी(Commercial - 1inch)</option>
										   <option value="दुरुस्ती परवानगी(Commercial - 1/2inch)">दुरुस्ती परवानगी(Commercial - 1/2inch)</option>
										   
                                        <option value="स्थानांतरण परवानगी(Domestic - 1inch)">स्थानांतरण परवानगी(Domestic - 1inch)</option>
										    <option value="स्थानांतरण परवानगी(Domestic - 1/2inch)">स्थानांतरण परवानगी(Domestic - 1/2inch)</option>
											
											<option value="स्थानांतरण परवानगी(Commercial - 1inch)">स्थानांतरण परवानगी(Commercial - 1inch)</option>
										    <option value="स्थानांतरण परवानगी(Commercial - 1/2inch)">स्थानांतरण परवानगी(Commercial - 1/2inch)</option>
                                    </select>
                                    <span class="text-danger is-invalid panycha_type_err"></span>
                                </div>


                                <div class="col-md-4">
                                <label class="col-form-label" for="prev_water_bill">Water Tax Bill/पाणी बिल देयक </label>
                                <input class="form-control" id="prev_water_bills" name="prev_water_bills" type="file">
                                <span class="text-danger is-invalid prev_water_bill_err"></span>
                            </div>














                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="water_connection_no">Name of the Owner / मालकाचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="water_connection_no" name="water_connection_no" type="text" placeholder="Name of the Owner" required>
                                <span class="text-danger is-invalid water_connection_no_err"></span>
                            </div> --}}
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="property_owner_name">Total Consumer No. / एकूण ग्राहक क्र.<span class="text-danger">*</span></label>
                                <input class="form-control" id="property_owner_name" name="property_owner_name" type="text" placeholder="Enter Property Owner Name" required>
                                <span class="text-danger is-invalid property_owner_name_err"></span>
                            </div> --}}
                            {{-- <div class="col-md-4">
                                <label for="col-form-label" class="comment">Consumer Number/ग्राहक संख्या<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="comment" name="comment" placeholder="Enter Consumer Number" required>
                                <span class="text-danger is-invalid comment_err"></span>
                            </div> --}}
                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="comment">Comment / टिप्पणी</label>
                                    <input class="form-control" id="comment" name="comment" type="text" placeholder="Enter Comment">
                                    <span class="text-danger is-invalid comment_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text" placeholder="Enter Mobile Number" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Aadhar Card / आधार नंबर <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text" placeholder="Enter Aadhar Card No" required>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Email Id / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" required>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                <select class="form-select" name="zone" id="zone" required>
                                    <option value="">Select Zone</option>

                                    @foreach ($zones as $zone)
                                        <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div> --}}
                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <select class="form-select" name="ward_area" id="ward_area" required>
                                        <option value="">Select Ward Area</option>

                                        @foreach ($wards as $ward)
                                        <option value="{{ $ward->name }}">{{ $ward->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid ward_area_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="plot_no">Plot Number / प्लॅाट नं किंवा हिस्सा नं <span class="text-danger">*</span></label>
                                <input class="form-control" id="plot_no" name="plot_no" type="text" placeholder="Enter Plot Number" required>
                                <span class="text-danger is-invalid plot_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="house_no">House Number / घर नं <span class="text-danger">*</span></label>
                                <input class="form-control" id="house_no" name="house_no" type="text" placeholder="Enter House Number" required>
                                <span class="text-danger is-invalid house_no_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="landmark">Landmark / जवळची खूण<span class="text-danger">*</span></label>
                                <input class="form-control" id="landmark" name="landmark" type="text" placeholder="Enter Landmark" required>
                                <span class="text-danger is-invalid landmark_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Full Address Of The Property / मिळकतीचा संपुर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" name="address" id="address" cols="30" rows="2" placeholder="Enter  Address" required></textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="tap_size">Tap Size / नळ आकार <span class="text-danger">*</span></label>
                                <select class="form-select" name="tap_size" id="tap_size" required>
                                    <option value="">Select option</option>
                                    @php
                                        $options = ['15mm', '20mm', '25mm', '40mm', '50mm', '80mm', '100mm', '150mm', '300mm'];
                                    @endphp
                                    @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid tap_size_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="current_connection_is_illegal">Currently Existed Tap Connection Unauthorized / मिळकतीस सध्या अस्तित्वात असलेले नळ कनेक्शन अनाधिकृत होते काय ?  <span class="text-danger">*</span></label>
                                    <select class="form-select" name="current_connection_is_illegal" id="current_connection_is_illegal" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid current_connection_is_illegal_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_is_on_rent">Is Applicant a Tenant / अर्जदार भाडेकरू आहे ?<span class="text-danger">*</span></label>
                                    <select class="form-select" name="applicant_is_on_rent" id="applicant_is_on_rent" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid applicant_is_on_rent_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="criminal_judicial_issue">Criminal Judicial Issues About Existing Tap Connection / मिळकतीस सध्या असलेल्या नळ कनेक्शनाबाबत काही फौजदारी किंवा न्यायालयीन बाबी सुरु आहेत का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="criminal_judicial_issue" id="criminal_judicial_issue" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid criminal_judicial_issue_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="tap_size">Tap Size / नळ आकार <span class="text-danger">*</span></label>
                                    <select class="form-select" name="tap_size" id="tap_size" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["15mm", "20mm", "25mm", "40mm", "50mm", "80mm", "100mm", "150mm", "300mm"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid tap_size_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="current_existing_tap_type">Currently Existing Tap Connection Detail / मिळकतीस सध्या अस्तित्वात असलेल्या नळ कनेक्शनचा तपशील <span class="text-danger">*</span></label>
                                    <select class="form-select" name="current_existing_tap_type" id="current_existing_tap_type" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["बांधकाम", "औद्योगीक", "निवासी", "विशेष प्रवर्ग (शैक्षणिक संस्था,शासकीय,निमशासकीय कार्यालय,पथसंस्था,इतर)", "व्यावसायिक"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid current_existing_tap_type_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="place_belongs_to_municipal">Place Belongs To Municipal Council Limit / सदर जागा नगरपरिषदेच्या हद्दीत आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="place_belongs_to_municipal" id="place_belongs_to_municipal" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid place_belongs_to_municipal_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="comment">Comment / टिप्पणी</label>
                                    <input class="form-control" id="comment" name="comment" type="text" placeholder="Enter Comment">
                                    <span class="text-danger is-invalid comment_err"></span>
                                </div> --}}

                           <div class="col-md-4" id="upload_section" style="display:none;">
                                <label class="col-form-label" for="application_documents">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <input class="form-control" id="application_documents" name="application_documents" type="file" >
                                <span class="text-danger is-invalid application_documents_err"></span>
                            </div>

                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info"  name="is_correct_info" value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                               <span class="text-danger is-invalid is_correct_info_err d-block mt-1"></span>
                            </div>

                        </div>
                    </div>
                   <div class="form-group" style="text-align: center;">
                            <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                        </div>
                        <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                        <button type="reset" class="btn btn-warning">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>




{{-- <script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn   = document.getElementById('saveAndPrintBtn');
    const form      = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');   

    if (!saveBtn || !form) return;  // important safety guard

    saveBtn.addEventListener('click', function () {
        // 1️⃣ Temporarily remove required only if the input exists
        if (fileInput) fileInput.removeAttribute('required');

        // 2️⃣ Validate main form
        if (!form.checkValidity()) {
            form.reportValidity();
            if (fileInput) fileInput.setAttribute('required', 'required');
            return;
        }

        // 3️⃣ Show upload section and footer
        const uploadSection = document.getElementById('upload_section');
        const cardFooter    = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter)    cardFooter.style.display    = 'block';

        // 4️⃣ Clone the container to generate PDF
        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const printClone = addContainer.cloneNode(true);
        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        Array.from(printClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        // Add title
        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of water pressure complaint';
        printClone.insertBefore(printTitle, printClone.firstChild);

        // Remove buttons & style cards
        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });

        // Show hidden selected values
        printClone.querySelectorAll('.selected-value').forEach(div => {
            div.classList.remove('d-none');
        });

        // Prepare container for html2canvas
        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        // 5️⃣ Generate PDF
        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;

            pdf.addImage(
                imgData, 'JPEG',
                margin, margin,
                pdf.internal.pageSize.getWidth() - margin * 2,
                pdf.internal.pageSize.getHeight() - margin * 2
            );

            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content.');
            }

            pdf.save('Water Pressure ComplaintCertificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            // 6️⃣ Restore required if the input exists
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });
});
</script> --}}



{{-- <script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn   = document.getElementById('saveAndPrintBtn');
    const form      = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');   

    if (!saveBtn || !form) return;

    // 🔹 Custom error messages mapping
    const messages = {
        connection_no: 'Connection No is Required',
        property_owner_name: 'Owner Name is Required',
        Full_Address_Of_The_Property: 'Address is Required',
        Ward: 'Ward is Required',
        zone: 'Zone is Required',
        Water_Connection_Size: 'Water Connection Size is Required',
        Connection_Type: 'Connection Type is Required',
        Water_Connection_Usage: 'Water Connection Usage is Required',
        OutstandingAmt: 'Outstanding Amount is Required',
        total_connection: 'Connection is Required',
        panycha_type_add: 'Type is Required',
        is_correct_info: 'Please Accept the Declaration'
    };

    // 🔹 Function to show validation errors
    function showValidationErrors() {
        let valid = true;

        // Remove old messages
        form.querySelectorAll('.error-message').forEach(el => el.remove());

        // Loop through all fields
        Object.keys(messages).forEach(field => {
            const input = form.querySelector(`[name="${field}"]`);
            if (input) {
                let isEmpty = false;

                if (input.type === 'checkbox' || input.type === 'radio') {
                    const checked = form.querySelectorAll(`[name="${field}"]:checked`);
                    isEmpty = checked.length === 0;
                } else {
                    isEmpty = !input.value.trim();
                }

                if (isEmpty) {
                    valid = false;
                    const msg = document.createElement('div');
                    msg.className = 'error-message';
                    msg.style.color = 'red';
                    msg.style.fontSize = '13px';
                    msg.textContent = messages[field];

                    // ✅ Special placement for checkbox message
                    if (field === 'is_correct_info') {
                        const errContainer = form.querySelector('.is_correct_info_err');
                        if (errContainer) {
                            errContainer.textContent = messages[field];
                        } else {
                            input.closest('.col-md-12').appendChild(msg);
                        }
                    } else {
                        input.insertAdjacentElement('afterend', msg);
                    }
                } else {
                    // Clear old error text if any
                    if (field === 'is_correct_info') {
                        const errContainer = form.querySelector('.is_correct_info_err');
                        if (errContainer) errContainer.textContent = '';
                    }
                }
            }
        });

        return valid;
    }

    saveBtn.addEventListener('click', function (e) {
        e.preventDefault();

        if (fileInput) fileInput.removeAttribute('required');

        const isValid = showValidationErrors();
        if (!isValid) {
            if (fileInput) fileInput.setAttribute('required', 'required');
            return;
        }

        // 🔹 Continue with PDF generation
        const uploadSection = document.getElementById('upload_section');
        const cardFooter    = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter)    cardFooter.style.display    = 'block';

        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        const printClone = addContainer.cloneNode(true);
        const uploadSectionInClone = printClone.querySelector('#upload_section');
        if (uploadSectionInClone) uploadSectionInClone.remove();

        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        Array.from(printClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of water pressure complaint';
        printClone.insertBefore(printTitle, printClone.firstChild);

        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });

        printClone.querySelectorAll('.selected-value').forEach(div => {
            div.classList.remove('d-none');
        });

        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;

            pdf.addImage(
                imgData, 'JPEG',
                margin, margin,
                pdf.internal.pageSize.getWidth() - margin * 2,
                pdf.internal.pageSize.getHeight() - margin * 2
            );

            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content.');
            }

            pdf.save('Water Pressure ComplaintCertificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });
});
</script> --}}

<script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn   = document.getElementById('saveAndPrintBtn');
    const form      = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');   

    if (!saveBtn || !form) return;

    const messages = {
        connection_no: 'Connection No is Required',
        property_owner_name: 'Owner Name is Required',
        Full_Address_Of_The_Property: 'Address is Required',
        Ward: 'Ward is Required',
        zone: 'Zone is Required',
        Water_Connection_Size: 'Water Connection Size is Required',
        Connection_Type: 'Connection Type is Required',
        Water_Connection_Usage: 'Water Connection Usage is Required',
        OutstandingAmt: 'Outstanding Amount is Required',
        total_connection: 'Connection is Required',
        panycha_type_add: 'Type is Required',
        is_correct_info: 'Please Accept the Declaration'
    };

    // 🔹 Validation Function
    function showValidationErrors() {
        let valid = true;
        form.querySelectorAll('.error-message').forEach(el => el.remove());

        Object.keys(messages).forEach(field => {
            const input = form.querySelector(`[name="${field}"]`);
            if (input) {
                let isEmpty = false;

                if (input.type === 'checkbox' || input.type === 'radio') {
                    const checked = form.querySelectorAll(`[name="${field}"]:checked`);
                    isEmpty = checked.length === 0;
                } else {
                    isEmpty = !input.value.trim();
                }

                if (isEmpty) {
                    valid = false;
                    const msg = document.createElement('div');
                    msg.className = 'error-message';
                    msg.style.color = 'red';
                    msg.style.fontSize = '13px';
                    msg.textContent = messages[field];

                    if (field === 'is_correct_info') {
                        const errContainer = form.querySelector('.is_correct_info_err');
                        if (errContainer) {
                            errContainer.textContent = messages[field];
                        } else {
                            input.closest('.col-md-12').appendChild(msg);
                        }
                    } else {
                        input.insertAdjacentElement('afterend', msg);
                    }
                } else if (field === 'is_correct_info') {
                    const errContainer = form.querySelector('.is_correct_info_err');
                    if (errContainer) errContainer.textContent = '';
                }
            }
        });
        return valid;
    }

    saveBtn.addEventListener('click', function (e) {
        e.preventDefault();
        if (fileInput) fileInput.removeAttribute('required');

        const isValid = showValidationErrors();
        if (!isValid) {
            if (fileInput) fileInput.setAttribute('required', 'required');
            return;
        }

        const uploadSection = document.getElementById('upload_section');
        const cardFooter    = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter)    cardFooter.style.display    = 'block';

        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;

        // Clone Form for PDF
        const printClone = addContainer.cloneNode(true);
        const uploadSectionInClone = printClone.querySelector('#upload_section');
        if (uploadSectionInClone) uploadSectionInClone.remove();

        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of Water Pressure Complaint';
        printClone.insertBefore(printTitle, printClone.firstChild);

        // Remove buttons & card styles
        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });

        // Convert Input Fields to Bordered Boxes
        printClone.querySelectorAll('input[type="text"], input[type="number"], textarea').forEach(input => {
            const value = input.value.trim() || '';
            const box = document.createElement('div');
            box.textContent = value;
            box.style.border = '1px solid #999';
            box.style.padding = '5px 8px';
            box.style.minHeight = '28px';
            box.style.marginTop = '4px';
            box.style.borderRadius = '4px';
            box.style.background = '#f9f9f9';
            input.parentNode.replaceChild(box, input);
        });

        // ✅ Replace SELECTs with selected text (Fix applied)
        printClone.querySelectorAll('select').forEach(select => {
            // Get selected text from the original form, not the clone
            const originalSelect = form.querySelector(`[name="${select.name}"]`);
            const selectedText =
                originalSelect.options[originalSelect.selectedIndex]?.text ||
                '--Select--';

            const div = document.createElement('div');
            div.textContent = selectedText;
            div.style.border = '1px solid #999';
            div.style.padding = '5px 8px';
            div.style.minHeight = '28px';
            div.style.marginTop = '4px';
            div.style.borderRadius = '4px';
            div.style.background = '#f9f9f9';

            select.parentNode.replaceChild(div, select);
        });

        // ✅ Replace Declaration checkbox with full statement
        printClone.querySelectorAll('input[type="checkbox"]').forEach(chk => {
            const container = chk.closest('.col-md-12') || chk.parentNode;
            const declarationText = document.createElement('div');
            declarationText.innerHTML = `
                <p style="margin:6px 0; font-weight:500;">
                    All information provided above is correct and I shall be fully responsible for any discrepancy.
                    <br>
                    वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार आहे.
                </p>
            `;
            container.innerHTML = '';
            container.appendChild(declarationText);
        });

        // Create Hidden Print Container
        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        // Generate PDF
        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;

            pdf.addImage(
                imgData, 'JPEG',
                margin, margin,
                pdf.internal.pageSize.getWidth() - margin * 2,
                pdf.internal.pageSize.getHeight() - margin * 2
            );

            pdf.save('Water Pressure ComplaintCertificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });
});
</script>











{{-- Add  --}}
{{-- <script>
    $('#searchdetails').on('click', function(e) {
        e.preventDefault();

        let formData = {
            marchantid: $('#marchantid').val(),
            connection_no: $('#connection_no').val(),
            _token: $('input[name="_token"]').val()
        };

        $.ajax({
            url: '{{ route('fetch.water.details') }}',
            method: 'POST',
            data: formData,
            datatype: JSON,
            success: function(response) {
                console.log("Encrypted Data:", response.jsonData.encr_request);

                const decryptedData = JSON.parse(response.jsonData.encr_request); // Replace with actual decryption function

                console.log("Decrypted Data:", decryptedData['connectionDetails'].Water_Connection_Number);

                if (decryptedData && decryptedData['connectionDetails']) {
                    $('#Connection_Type').val(decryptedData['connectionDetails'].Connection_Type);
                    $('#House_Number').val(decryptedData['connectionDetails'].House_Number);
                    $('#property_owner_name').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    $('#Full_Address_Of_The_Property').val(decryptedData['connectionDetails'].Full_Address_Of_The_Property);
                    $('#Water_Connection_Size').val(decryptedData['connectionDetails'].Water_Connection_Size);
                    $('#Water_Connection_Usage').val(decryptedData['connectionDetails'].Water_Connection_Usage);
                    $('#zone').val(decryptedData['connectionDetails'].Zone);
                    $('#Ward').val(decryptedData['connectionDetails'].Ward);
                    $('#OutstandingAmt').val(decryptedData['connectionDetails'].OutstandingAmt);
                    // $('#water_connection_no').val(decryptedData['connectionDetails'].Water_Connection_Number);
                    // // $('#applicant_full_name').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    // $('#address').val(decryptedData['connectionDetails'].Full_Address_Of_The_Property);
                    // // $('#address').val(decryptedData['connectionDetails'].Water_Connection_Size);
                    // // $('#house_no').val(decryptedData['connectionDetails'].Water_Connection_Usage);
                    // // $('#owner_add').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    // // $('#ward').val(decryptedData['connectionDetails'].Ward);
                } else {
                    console.error("connectionDetails is missing or undefined");
                }
            },

            error: function(xhr) {
                console.error(xhr.responseText);
            }
        });
    });

    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('water-pressure-complaint.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script> --}}

<script>
$(document).ready(function () {

    // 🔹 SEARCH DETAILS BUTTON
    $('#searchdetails').on('click', function(e) {
        e.preventDefault();

        let formData = {
            marchantid: $('#marchantid').val(),
            connection_no: $('#connection_no').val(),
            _token: $('input[name="_token"]').val()
        };

        $.ajax({
            url: '{{ route('fetch.water.details') }}',
            method: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                console.log("Encrypted Data:", response.jsonData.encr_request);

                const decryptedData = JSON.parse(response.jsonData.encr_request); 
                console.log("Decrypted Data:", decryptedData['connectionDetails'].Water_Connection_Number);

                if (decryptedData && decryptedData['connectionDetails']) {

                    // 🔹 Fill fields with connection details
                    $('#Connection_Type').val(decryptedData['connectionDetails'].Connection_Type);
                    $('#House_Number').val(decryptedData['connectionDetails'].House_Number);
                    $('#property_owner_name').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    $('#Full_Address_Of_The_Property').val(decryptedData['connectionDetails'].Full_Address_Of_The_Property);
                    $('#Water_Connection_Size').val(decryptedData['connectionDetails'].Water_Connection_Size);
                    $('#Water_Connection_Usage').val(decryptedData['connectionDetails'].Water_Connection_Usage);
                    $('#zone').val(decryptedData['connectionDetails'].Zone);
                    $('#Ward').val(decryptedData['connectionDetails'].Ward);
                    $('#OutstandingAmt').val(decryptedData['connectionDetails'].OutstandingAmt);

                    // 🔹 Filter Type of Permission dropdown based on Water_Connection_Usage
                    const usage = decryptedData['connectionDetails'].Water_Connection_Usage?.toLowerCase() || '';
                    const $typeSelect = $('#panycha_type_add');

                    // Save original options (only once)
                    if (!$typeSelect.data('all-options')) {
                        $typeSelect.data('all-options', $typeSelect.find('option').clone());
                    }

                    const allOptions = $typeSelect.data('all-options');
                    let filteredOptions;

                    if (usage.includes('domestic')) {
                        filteredOptions = allOptions.filter(function() {
                            return $(this).val().toLowerCase().includes('domestic') || $(this).val() === '';
                        });
                    } else if (usage.includes('commercial')) {
                        filteredOptions = allOptions.filter(function() {
                            return $(this).val().toLowerCase().includes('commercial') || $(this).val() === '';
                        });
                    } else {
                        filteredOptions = allOptions; // fallback
                    }

                    // Replace the select options
                    $typeSelect.empty().append(filteredOptions);

                    // 🔹 Always reset to default "--Select Type--"
                    $typeSelect.val('');

                } else {
                    console.error("connectionDetails is missing or undefined");
                }
            },
            error: function(xhr) {
                console.error(xhr.responseText);
            }
        });
    });

    // 🔹 FORM SUBMIT
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);

        $.ajax({
            url: '{{ route('water-pressure-complaint.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css({'opacity': '0.5', 'visibility': 'visible'});
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);

                if (!data.error) {
                    swal("Successful!", data.success, "success").then(() => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                } else {
                    swal("Error!", data.error, "error");
                }
            },
            statusCode: {
                422: function(responseObject) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function() {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css({'opacity': '0', 'visibility': 'hidden'});
            },
        });
    });

});
</script>




<script>
document.addEventListener('DOMContentLoaded', function () {
    const existingConInput = document.getElementById('total_connection');

    if (existingConInput) {
        existingConInput.addEventListener('input', function (e) {
            // Remove any non-digit characters
            this.value = this.value.replace(/[^0-9]/g, '');
        });
    }
});
</script>



