<x-admin.layout>
    <x-slot name="title">Complaint Of Water Pressure / पाण्याची दबाव क्षमता तक्रार</x-slot>
    <x-slot name="heading">Complaint Of Water Pressure / पाण्याची दबाव क्षमता तक्रार</x-slot>
    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" value="{{ $data->applicant_name }}" placeholder="Enter Applicant Name" required disabled readonly>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="address" name="address" type="text" placeholder="Enter Name Of New Owner" required disabled readonly>{{ $data->address }} </textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Applicant Mobile No / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $data->mobile_no }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text"
                                    placeholder="Enter Mobile Number" required disabled readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Applicant EmailID / ईमेल आयडी<span class="text-danger"></span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $data->email_id }}" required disabled readonly>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Applicant Adhaar No / आधार क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" value='{{ $data->aadhar_no }}' oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text"
                                    placeholder="Enter Aadhar Card No" required disabled readonly>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>

                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">

                            @csrf
                            <div class="col-md-4">
                                <input class="form-control" id="marchantid" name="marchantid" type="hidden" value="MBMCCORE">
                                <span class="text-danger is-invalid marchantid_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="connection_no">Connection No<span class="text-danger">*</span></label>
                                <input class="form-control" id="connection_no" value='{{ $data->connection_no }}' name="connection_no" type="text" placeholder="Enter Connection No" disabled readonly>
                                <span class="text-danger is-invalid connection_no_err"></span>
                            </div>

                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Water Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <div class="col-md-4">
                                    <label class="col-form-label" for="property_owner_name">Owner Name/मालकाचे नाव<span class="text-danger">*</span></label>
                                    <input class="form-control" id="property_owner_name" value='{{ $data->property_owner_name }}' name="property_owner_name" type="text" placeholder="Enter Owner Name" required disabled readonly>
                                    <span class="text-danger is-invalid property_owner_name_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Full_Address_Of_The_Property"> Owner Address/मालकाचा पत्ता<span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="Full_Address_Of_The_Property" id="Full_Address_Of_The_Property" cols="30" rows="2" placeholder="Enter  Address" required disabled readonly> {{ $data->Full_Address_Of_The_Property }} </textarea>
                                    <span class="text-danger is-invalid Full_Address_Of_The_Property_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Ward" id="Ward" value='{{ $data->Ward }}' placeholder="Enter Ward Area" required disabled readonly>
                                    <span class="text-danger is-invalid Ward_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <input class="form-control" name="zone" id="zone" value='{{ $data->zone }}' placeholder="Enter Zone" required disabled readonly>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Size">Water Connection Size<span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Size" value='{{ $data->Water_Connection_Size }}' name="Water_Connection_Size" type="text" placeholder="Enter Water Connection Size" required disabled
                                        readonly>
                                    <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Connection_Type">Connection Type<span class="text-danger">*</span></label>
                                    <input class="form-control" name="Connection_Type" value='{{ $data->Connection_Type }}' id="Connection_Type" type="text" placeholder="Enter Connection Type" required disabled readonly>
                                    <span class="text-danger is-invalid Connection_Type_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="Water_Connection_Usage">Water Connection Usage <span class="text-danger">*</span></label>
                                    <input class="form-control" id="Water_Connection_Usage" value='{{ $data->Water_Connection_Usage }}' name="Water_Connection_Usage" type="text" placeholder="Enter Water Connection Usage" required disabled
                                        readonly>
                                    <span class="text-danger is-invalid Water_Connection_Usage_err"></span>
                                </div>

                                <div class="col-md-4">
                                    <label class="col-form-label" for="OutstandingAmt"> Total Outstanding Payable/ एकूण थकबाकी बिल भरले?<span class="text-danger">*</span></label>
                                    <input class="form-control" id="OutstandingAmt" value='{{ $data->OutstandingAmt }}' name="OutstandingAmt" type="text" required disabled readonly>
                                    <span class="text-danger is-invalid OutstandingAmt_err"></span>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="card-header">
                        <h4 class="card-title">Add Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="total_connection">Total Connection Number / एकूण कनेक्शन क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" id="total_connection" value='{{ $data->total_connection }}' name="total_connection" type="text" placeholder="Name of the Owner" required disabled readonly>
                                <span class="text-danger is-invalid total_connection_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="landmark">Landmark / जवळची खूण </label>
                                <input class="form-control" id="landmark" value='{{ $data->landmark }}' name="landmark" type="text" placeholder="Enter Landmark" disabled readonly>
                                <span class="text-danger is-invalid landmark_err"></span>
                            </div>


                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="panycha_type_add">पाण्याचा प्रकार / Type of Permission</label>
                                <select class="form-select" id="panycha_type_add" name="panycha_type_add" disabled readonly>
                                    <option value="">--Select Type--</option>
                                    <option value="दुरुस्ती परवानगी" {{ $data->panycha_type_add == 'दुरुस्ती परवानगी' ? 'selected' : '' }}>दुरुस्ती परवानगी</option>
                                    <option value="स्थानांतरण परवानगी" {{ $data->panycha_type_add == 'स्थानांतरण परवानगी' ? 'selected' : '' }}>स्थानांतरण परवानगी</option>
                                </select>
                                <span class="text-danger is-invalid panycha_type_err"></span>
                            </div> --}}

                            <div class="col-md-4">
    <label class="col-form-label" for="panycha_type_add">
        पाण्याचा प्रकार / Type of Permission
    </label>
    <select class="form-select" id="panycha_type_add" name="panycha_type_add" disabled readonly>
        <option value="">--Select Type--</option>
        <option value="दुरुस्ती परवानगी(Domestic - 1inch)" {{ $data->panycha_type_add == 'दुरुस्ती परवानगी(Domestic - 1inch)' ? 'selected' : '' }}>दुरुस्ती परवानगी(Domestic - 1inch)</option>
        <option value="दुरुस्ती परवानगी(Domestic - 1/2inch)" {{ $data->panycha_type_add == 'दुरुस्ती परवानगी(Domestic - 1/2inch)' ? 'selected' : '' }}>दुरुस्ती परवानगी(Domestic - 1/2inch)</option>
        <option value="दुरुस्ती परवानगी(Commercial - 1inch)" {{ $data->panycha_type_add == 'दुरुस्ती परवानगी(Commercial - 1inch)' ? 'selected' : '' }}>दुरुस्ती परवानगी(Commercial - 1inch)</option>
        <option value="दुरुस्ती परवानगी(Commercial - 1/2inch)" {{ $data->panycha_type_add == 'दुरुस्ती परवानगी(Commercial - 1/2inch)' ? 'selected' : '' }}>दुरुस्ती परवानगी(Commercial - 1/2inch)</option>

        <option value="स्थानांतरण परवानगी(Domestic - 1inch)" {{ $data->panycha_type_add == 'स्थानांतरण परवानगी(Domestic - 1inch)' ? 'selected' : '' }}>स्थानांतरण परवानगी(Domestic - 1inch)</option>
        <option value="स्थानांतरण परवानगी(Domestic - 1/2inch)" {{ $data->panycha_type_add == 'स्थानांतरण परवानगी(Domestic - 1/2inch)' ? 'selected' : '' }}>स्थानांतरण परवानगी(Domestic - 1/2inch)</option>
        <option value="स्थानांतरण परवानगी(Commercial - 1inch)" {{ $data->panycha_type_add == 'स्थानांतरण परवानगी(Commercial - 1inch)' ? 'selected' : '' }}>स्थानांतरण परवानगी(Commercial - 1inch)</option>
        <option value="स्थानांतरण परवानगी(Commercial - 1/2inch)" {{ $data->panycha_type_add == 'स्थानांतरण परवानगी(Commercial - 1/2inch)' ? 'selected' : '' }}>स्थानांतरण परवानगी(Commercial - 1/2inch)</option>
    </select>
    <span class="text-danger is-invalid panycha_type_err"></span>
</div>


                         <div class="col-md-4">
                                    <label class="col-form-label" for="prev_water_bill">Water Tax Bill/पाणी बिल देयक</label>
                                    <div><a href="{{ asset('storage/' . $data->prev_water_bill) }}" target="_blank">View Document</a></div>
                                    {{-- <input class="form-control" id="prev_water_bill" name="prev_water_bill" type="file"> --}}
                                    <span class="text-danger is-invalid prev_water_bill_err"></span>
                                </div>

                                {{-- Junior Engineer - Only Upload --}}
                    @if(auth()->user()->hasRole('JuniorEngineer'))
                        <div class="col-md-4">
                            <label class="col-form-label" for="mestri_site">Mestri site visit Report</label>
                            <input class="form-control" id="mestri_sites" name="mestri_sites" type="file">
                            <span class="text-danger is-invalid mestri_site_err"></span>
                        </div>
                    @endif

                    {{-- Deputy Engineer OR Executive Engineer - Only View --}}
                    @if(auth()->user()->hasRole('DeputyEngineer') || auth()->user()->hasRole('ExecutiveEngineer'))
                        <div class="col-md-4">
                            <label class="col-form-label" for="mestri_site">Mestri site visit Report</label>

                            @if(!empty($data->mestri_site))
                                <div>
                                    <a href="{{ asset('storage/' . $data->mestri_site) }}" target="_blank">View Document</a>
                                </div>
                            @else
                                <p class="text-muted">No Document Uploaded</p>
                            @endif

                            <span class="text-danger is-invalid mestri_site_err"></span>
                        </div>
                    @endif













                           @if(auth()->user()->hasRole('JuniorEngineer'))
                    <div class="col-md-4">     
                      <label for="jramountone"><strong>Road Repair (रस्ता दुरुस्ती):</strong></label>
                        <select name="jramountone" id="jramountone" class="form-select">
                            <option value="">-- Select --</option>
                            <option value="12024">डांबरी रस्ता</option>
                            <option value="15069">सिमेंट काँक्रीट</option>
                        </select>
                    </div>

                   <div class="col-md-4">     
                       <label for="running_meterone"><strong>Running Meter (रनिंग मीटर):</strong></label>
                        <input type="text" name="running_meterone" id="running_meterone" 
                            class="form-control" placeholder="Enter Running Meter">
                    </div>
                @endif

                {{-- @if(auth()->user()->hasRole('JuniorEngineer'))
    <div class="col-md-4">     
        <label for="jramountone"><strong>Road Repair (रस्ता दुरुस्ती):</strong></label>
        <select name="jramountone" id="jramountone" class="form-select">
            <option value="">-- Select --</option>
            <option value="12024" {{ isset($data) && $data->jramountone == '12024' ? 'selected' : '' }}>डांबरी रस्ता</option>
            <option value="15069" {{ isset($data) && $data->jramountone == '15069' ? 'selected' : '' }}>सिमेंट काँक्रीट</option>
        </select>
    </div>

    <div class="col-md-4">     
        <label for="running_meterone"><strong>Running Meter (रनिंग मीटर):</strong></label>
        <input type="text" name="running_meterone" id="running_meterone" 
               class="form-control" placeholder="Enter Running Meter"
               value="{{ $data->running_meterone ?? '' }}">
    </div>
@else
    <div class="col-md-4">     
        <label for="jramountone"><strong>Road Repair (रस्ता दुरुस्ती):</strong></label>
        <input type="text" class="form-control" 
               value="{{ $data->jramountone ?? '' }}" readonly>
    </div>

    <div class="col-md-4">     
        <label for="running_meterone"><strong>Running Meter (रनिंग मीटर):</strong></label>
        <input type="text" class="form-control" 
               value="{{ $data->running_meterone ?? '' }}" readonly>
    </div>
@endif --}}



                            <div class="col-md-4">
                                <label class="col-form-label" for="application_documents">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <div><a href="{{ asset('storage/' . $data->application_document) }}" target="_blank">View Document</a></div>
                                {{-- <input class="form-control" id="application_documents" name="application_documents" type="file" required> --}}
                                <span class="text-danger is-invalid application_documents_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" rows="4" required></textarea>
                            </div>

                            {{-- <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" required name="is_correct_info" value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        {{-- <button type="submit" class="btn btn-primary" id="addSubmit">Update</button> --}}
                        {{-- <button type="reset" class="btn btn-warning">Reset</button> --}}
                         <button id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>




{{-- Add --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
     document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route('water-pressure-complaint.update', $data->id) }}';
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });

    // $(document).ready(function() {
    //     $('.approveBtn').on('click', function() {
    //         let statusId = $(this).data('id');
    //         let remark = $('#Remark').val();
    //          let jramountone = $('#jramountone').val();
    //           let running_meterone = $('#running_meterone').val();
           

    //         if (remark.trim() !== '') {
    //             $.ajax({
    //                 url: '/approve-item/' + statusId,
    //                 type: 'POST',
    //                 data: {
    //                     _token: '{{ csrf_token() }}',
    //                     remark: remark
    //                      jramountone:jramountone
    //                      running_meterone:running_meterone
    //                 },
    //                 success: function(response) {
    //                     Swal.fire({
    //                         icon: 'success',
    //                         title: 'Success!',
    //                         text: response.message,
    //                         confirmButtonText: 'OK'
    //                     }).then(() => {
    //                         window.location.href = response.redirect_url;
    //                     });
    //                 },
    //                 error: function(xhr) {
    //                     Swal.fire({
    //                         icon: 'error',
    //                         title: 'Error!',
    //                         text: 'Error: ' + xhr.responseText,
    //                         confirmButtonText: 'OK'
    //                     });
    //                 }
    //             });
    //         } else {
    //             Swal.fire({
    //                 icon: 'warning',
    //                 title: 'Warning!',
    //                 text: 'Please Add Remark',
    //                 confirmButtonText: 'OK'
    //             });
    //         }
    //     });
    // });


    $(document).ready(function() {
    $('.approveBtn').on('click', function() {
        let statusId = $(this).data('id');
        let remark = $('#Remark').val();
       let jramountone = $('#jramountone').length ? $('#jramountone').val() : null;
let running_meterone = $('#running_meterone').length ? $('#running_meterone').val() : null;

        if (remark.trim() !== '') {
            $.ajax({
                url: '/approve-item/' + statusId,
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    remark: remark,
                  jramountone: jramountone,
        running_meterone: running_meterone
                },
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message,
                        confirmButtonText: 'OK'
                    }).then(() => {
                        window.location.href = response.redirect_url;
                    });
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Error: ' + xhr.responseText,
                        confirmButtonText: 'OK'
                    });
                }
            });
        } else {
            Swal.fire({
                icon: 'warning',
                title: 'Warning!',
                text: 'Please Add Remark',
                confirmButtonText: 'OK'
            });
        }
    });
});

    



    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>


<script>
    
$(document).ready(function () {
    // Prevent letters and special characters
    $('#running_meterone').on('input', function () {
        let value = $(this).val();

        // Replace anything that is NOT a digit
        value = value.replace(/[^0-9]/g, '');
        $(this).val(value);
    });

    // Optional: On form submit validation
    $('#addForm').on('submit', function (e) {
        let runningMeter = $('#running_meterone').val().trim();

        if (runningMeter === '') {
            e.preventDefault();
            $('.running_meterone_err').text('Running Meter is required');
        } else {
            $('.running_meterone_err').text('');
        }
    });
});
</script>
