<x-admin.layout>
    <x-slot name="title">Water Re Connection / पुनः जोडणी करणे</x-slot>
    <x-slot name="heading">Water Re Connection / पुनः जोडणी करणे</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                <div class="card">
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" value="{{ $user->name }}" placeholder="Enter Applicant Name" required>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="address" name="address" type="text" placeholder="Enter Name Of New Owner" required>{{ $user->address }} </textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Applicant Mobile No / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $user->mobile }}" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text"
                                    placeholder="Enter Mobile Number" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Applicant EmailID / ईमेल आयडी<span class="text-danger"></span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" value="{{ $user->email }}" required>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Applicant Adhaar No / आधार क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" value='{{ $user->aadhar_no }}' oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text"
                                    placeholder="Enter Aadhar Card No" required>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div>

                        </div>
                    </div>

                    <div class="card-body">

                        @csrf
                        <div class="col-md-4">
                            <input class="form-control" id="marchantid" name="marchantid" type="hidden" value="MBMCCORE">
                            <span class="text-danger is-invalid marchantid_err"></span>
                        </div>
                        <div class="col-md-4">
                            <label class="col-form-label" for="connection_no">Connection No<span class="text-danger">*</span></label>
                            <input class="form-control" id="connection_no" name="connection_no" type="text" placeholder="Enter Connection No" >
                            <span class="text-danger is-invalid connection_no_err"></span>
                        </div>

                        <button type="Search" class="btn btn-primary mt-2" id="searchdetails">Search</button>
                    </div>
                </div>



                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Water Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="Property_Owner_Name">Owner Name/मालकाचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="Property_Owner_Name" name="Property_Owner_Name" type="text" placeholder="Enter Owner Name"  readonly>
                                <span class="text-danger is-invalid Property_Owner_Name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Full_Address_Of_The_Property"> Owner Address/मालकाचा पत्ता<span class="text-danger">*</span></label>
                                <textarea class="form-control" name="Full_Address_Of_The_Property" id="Full_Address_Of_The_Property" cols="30" rows="2" placeholder="Enter  Address"  readonly></textarea>
                                <span class="text-danger is-invalid Full_Address_Of_The_Property_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <input class="form-control" name="Ward" id="Ward" placeholder="Enter Ward Area"  readonly>
                                <span class="text-danger is-invalid Ward_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                <input class="form-control" name="zone" id="zone" placeholder="Enter Zone"  readonly>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Water_Connection_Size">Water Connection Size<span class="text-danger">*</span></label>
                                <input class="form-control" id="Water_Connection_Size" name="Water_Connection_Size" type="text" placeholder="Enter Water Connection Size" readonly>
                                <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Connection_Type">Connection Type<span class="text-danger">*</span></label>
                                <input class="form-control" name="Connection_Type" id="Connection_Type" type="text" placeholder="Enter Connection Type" readonly>
                                <span class="text-danger is-invalid Connection_Type_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Water_Connection_Usage">Water Connection Usage <span class="text-danger">*</span></label>
                                <input class="form-control" id="Water_Connection_Usage" name="Water_Connection_Usage" type="text" placeholder="Enter Water Connection Usage"  readonly>
                                <span class="text-danger is-invalid Water_Connection_Usage_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="OutstandingAmt"> Total Outstanding Payable/ एकूण थकबाकी बिल भरले?<span class="text-danger">*</span></label>
                                <input class="form-control" id="OutstandingAmt" name="OutstandingAmt" type="text"  readonly>
                                <span class="text-danger is-invalid OutstandingAmt_err"></span>
                            </div>
                            <div class="col-md-4 mt-4">
                                <button type="button" id="payaccentech" class="btn btn-success" target="_blank"
                                    onclick="window.location.href='https://watertax.nagarkaryavali.com/FrmWTConnSearch.aspx?@=AD65C7423AEA4530E3CB0528C8EFFFE4185BBCFBFA074578B362FC23AB6A7765'">Pay</button>
                            </div>

                        </div>
                    </div>
                </div>
                {{-- <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data"> --}}
                @csrf

                <div class="card">
                    {{-- <div class="card-header">
                        <h4 class="card-title">Add Details</h4>
                    </div> --}}
                    <div class="card-header">
                        <h4 class="card-title">Connection Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="water_connection_no">Applicant Full Name / अर्जदाराचे पूर्ण नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="water_connection_no" name="water_connection_no" type="text" placeholder="Enter Applicant Full Name" required>
                                <span class="text-danger is-invalid water_connection_no_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="new_owner_name">Applicant Full Address / अर्जदाराचा पूर्ण पत्ता <span class="text-danger">*</span></label>
                                <input class="form-control" id="new_owner_name" name="new_owner_name" type="text" placeholder="Enter Name Of New Owner" required>
                                <span class="text-danger is-invalid new_owner_name_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" type="text" placeholder="Enter Mobile Number" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id"> Email Id / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email" required>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="aadhar_no">Aadhar Number / आधार क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar_no" name="aadhar_no" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="12" minlength="12" type="text" placeholder="Enter Aadhar Card No" required>
                                <span class="text-danger is-invalid aadhar_no_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                    <select class="form-select" name="zone" id="zone" required>
                                        <option value="">Select Zone</option>

                                        @foreach ($zones as $zone)
                                        <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid zone_err"></span>
                                </div> --}}
                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <select class="form-select" name="ward_area" id="ward_area" required>
                                        <option value="">Select Ward Area</option>

                                        @foreach ($wards as $ward)
                                        <option value="{{ $ward->name }}">{{ $ward->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid ward_area_err"></span>
                                </div> --}}
                            <div class="col-md-4">
                                <label class="col-form-label" for="total_connection">Total Connection / एकूण कनेक्शन<span class="text-danger">*</span></label>
                                <input class="form-control" id="total_connection" name="total_connection" type="text" placeholder="Enter Plot Number" >
                                <span class="text-danger is-invalid total_connection_err"></span>
                            </div>

                           <div class="col-md-4">
                            <label class="col-form-label" for="Water_Connection_Size">
                                Water Connection Type <span class="text-danger">*</span>
                            </label>
                            <select class="form-control" id="Water_Connection_Size_Count" name="Water_Connection_Size_Count">
                                <option value="">-- Select --</option>
                                <option value="3000">घारगुती</option>
                                <option value="3000">वाणिज्य </option>
                            </select>
                            <span class="text-danger is-invalid Water_Connection_Size_err"></span>
                        </div>
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="connection_no">Connection Number / कनेक्शन क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" id="connection_no" name="connection_no" type="text" placeholder="Enter connection Number" required>
                                <span class="text-danger is-invalid connection_no_err"></span>
                            </div> --}}
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="owner_name">Owner Name / मालकाचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="owner_name" name="owner_name" type="text" placeholder="Enter Owner Name" required>
                                <span class="text-danger is-invalid owner_name_err"></span>
                            </div> --}}
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="owner_full_add">Owner Full Address / मालकाचा पूर्ण पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="owner_full_add" name="owner_full_add" type="text" placeholder="Enter Owner Name" required>
                                <span class="text-danger is-invalid owner_full_add_err"></span>
                            </div> --}}
                            <div class="col-md-4">
                                <label class="col-form-label" for="house_no">House Number / घर नं </label>
                                <input class="form-control" id="house_no" name="house_no" type="text" placeholder="Enter House Number">
                                <span class="text-danger is-invalid house_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="landmark">Landmark / जवळची खूण<span class="text-danger"></span></label>
                                <input class="form-control" id="landmark" name="landmark" type="text" placeholder="Enter Landmark" >
                                <span class="text-danger is-invalid landmark_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <select class="form-select" name="ward_area" id="ward_area" required>
                                    <option value="">Select Ward Area</option>

                                    @foreach ($wards as $ward)
                                        <option value="{{ $ward->name }}">{{ $ward->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_area_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                <select class="form-select" name="zone" id="zone" required>
                                    <option value="">Select Zone</option>

                                    @foreach ($zones as $zone)
                                        <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="address">Property Number / मालमत्ता क्रमांक <span class="text-danger">*</span></label>
                                <textarea class="form-control" name="address" id="address" cols="30" rows="2" placeholder="Enter Property Number" ></textarea>
                                <span class="text-danger is-invalid address_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="new_tap_connection">Detail Of New Tap Connection / मिळकतीस नवीन मागणी केलेल्या नळ कनेक्शनचा तपशील <span class="text-danger">*</span></label>
                                    <select class="form-select" name="new_tap_connection" id="new_tap_connection" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["औध्योगिक व्यवसायासाठी", "घरघुती वापरा साठी", "बिगर घरघुती वापरासाठी", "वाणिज्य"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid new_tap_connection_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="current_connection_is_authorized">Currently Existed Tap Connection Unauthorized / मिळकतीस सध्या अस्तित्वात असलेले नळ कनेक्शन अनाधिकृत होते काय ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="current_connection_is_authorized" id="current_connection_is_authorized" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid current_connection_is_authorized_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="applicant_or_tenant">Applicant Or Tenant / अर्जदार / भाडेकरु आहेत काय ?   <span class="text-danger">*</span></label>
                                    <select class="form-select" name="applicant_or_tenant" id="applicant_or_tenant" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid applicant_or_tenant_err"></span>
                                </div> --}}
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="connection_size">Connection Size / कनेक्शन आकार<span class="text-danger">*</span></label>
                                <input class="form-control" id="connection_size" name="connection_size" type="number" placeholder="Enter Connection Size" required>
                                <span class="text-danger is-invalid connection_size_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="criminal_judicial_issue">Criminal Judicial Issues About Existing Tap Connection / मिळकतीस सध्या असलेल्या नळ कनेक्शनाबाबत काही फौजदारी किंवा न्यायालयीन बाबी सुरु आहेत का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="criminal_judicial_issue" id="criminal_judicial_issue" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid criminal_judicial_issue_err"></span>
                                </div> --}}

                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="tap_size">Tap Size / नळ आकार<span class="text-danger">*</span></label>
                                    <select class="form-select" name="tap_size" id="tap_size" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["15mm", "20mm", "25mm", "40mm", "50mm", "80mm", "100mm", "150mm", "300mm"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid tap_size_err"></span>
                                </div> --}}
                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="existing_connection_detail">Currently Existing Tap Connection Detail / मिळकतीस सध्या अस्तित्वात असलेल्या नळ कनेक्शनचा तपशील<span class="text-danger">*</span></label>
                                    <select class="form-select" name="existing_connection_detail" id="existing_connection_detail" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["बांधकाम", "औद्योगीक", "निवासी", "विशेष प्रवर्ग (शैक्षणिक संस्था,शासकीय,निमशासकीय कार्यालय,पथसंस्था,इतर)", "व्यावसायिक अथवा वाणिज्य"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid existing_connection_detail_err"></span>
                                </div> --}}
                            {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="place_belongs_to_municipal">Place Belongs To Municipal Council Limit / सदर जागा नगरपरिषदेच्या हद्दीत आहे का ? <span class="text-danger">*</span></label>
                                    <select class="form-select" name="place_belongs_to_municipal" id="place_belongs_to_municipal" required>
                                        <option value="">Select option</option>
                                        @php
                                            $options = ["Yes", "No"];
                                        @endphp
                                        @foreach ($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid place_belongs_to_municipal_err"></span>
                                </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="no_of_existing_con">Number Of Existing Water Connection / सध्या स्थितीत पाणी कनेक्शनची संख्या</label>
                                <input class="form-control" id="no_of_existing_con" name="no_of_existing_con" type="text" placeholder="Number Of Existing Water Connection">
                                <span class="text-danger is-invalid no_of_existing_con_err"></span>
                            </div>
                            {{-- <div class="col-md-4">
                                <label for="criminal" class="col-form-label">If Any Criminal Judicial Issue exist on Connection/कनेक्शनवर कोणतीही फौजदारी न्यायिक समस्या असल्यास</label>
                                <input type="text" class="form-control" id="criminal" name="criminal" text="criminal" placeholder="Enter Criminal">
                                <span class="text-danger is-invalid criminal_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                    <label class="col-form-label" for="criminal">If Any Criminal Judicial Issue exist on Connection/जर कनेक्शनवर कोणताही फौजदारी न्यायिक मुद्दा अस्तित्वात असेल तर<span
                                            class="text-danger"></span></label>
                                    <select class="form-select" name="criminal" id="criminal" >
                                        <option value="">Select option</option>
                                        @php
                                            $options = ['Yes', 'No'];
                                        @endphp
                                        @foreach ($options as $option)
                                            <option value="{{ $option }}">{{ $option }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid criminal_err"></span>
                                </div>



                            <div class="col-md-4">
                                <label class="col-form-label" for="prev_water_bill">Previous Water Bill / मागील पाणी बिल </label>
                                <input class="form-control" id="prev_water_bills" name="prev_water_bills" type="file">
                                <span class="text-danger is-invalid prev_water_bill_err"></span>
                            </div>

                           

                            <div class="col-md-4">
                                <label class="col-form-label" for="nodues_documents">Upload Certificate of No Dues / थकबाकी नसल्याचा दाखला / जल जोडणी खंडीत आदेश महानगरपालिकेचा</label>
                                <input class="form-control" id="nodues_documents" name="nodues_documents" type="file">
                                <span class="text-danger is-invalid nodues_documents_err"></span>
                            </div>

                            <div class="col-md-4" id="upload_section" style="display:none;">
                             
                                    <label class="col-form-label" for="application_documents">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="application_documents" name="application_documents" type="file" >
                                    <span class="text-danger is-invalid application_documents_err"></span>
                              
                            </div>

                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info"  name="is_correct_info" value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. / वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div>

                        </div>
                    </div>
                </div>


                 <div class="form-group" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                    </div>
                    <div class="card-footer" id="card-footer" style="display:none;">
                    <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                    <button type="reset" class="btn btn-warning">Reset</button>
                </div>
            </form>
        </div>
    </div>
    </div>

</x-admin.layout>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn = document.getElementById('saveAndPrintBtn');
    const form = document.getElementById('addForm');
    const fileInput = document.getElementById('application_documents');

    // Custom validation messages
    const validationMessages = {
        connection_no: 'Connection No is Required',
        Property_Owner_Name: 'Property Owner is Required',
        Full_Address_Of_The_Property: 'Full Address is Required',
        Ward: 'Ward is Required',
        zone: 'Zone is Required',
        Water_Connection_Size: 'Water Connection is Required',
        Connection_Type: 'Connection Type is Required',
        Water_Connection_Usage: 'Water Connection Usage is Required',
        OutstandingAmt: 'Outstanding is Required',
        total_connection: 'Total Connection is Required',
        
        address: 'Existing Water Bill is Required',
        Water_Connection_Size_Count:'Water Connection Type is Required',
        is_correct_info: 'Please accept the Declaration'
    };

    if (!saveBtn || !form) return;

    // Helper to show error below each field
    function showError(field, message) {
        clearError(field); // clear previous
        const errorSpan = document.createElement('span');
        errorSpan.className = 'error-text';
        Object.assign(errorSpan.style, {
            color: 'red',
            fontSize: '13px',
            display: 'block',
            marginTop: '2px'
        });
        errorSpan.textContent = message;
        field.parentNode.insertBefore(errorSpan, field.nextSibling);
        field.classList.add('is-invalid');
    }

    // Helper to remove error
    function clearError(field) {
        const next = field.nextElementSibling;
        if (next && next.classList.contains('error-text')) next.remove();
        field.classList.remove('is-invalid');
    }

    saveBtn.addEventListener('click', function(e) {
        e.preventDefault();
        let isValid = true;

        // Validate all fields
        for (const [fieldId, message] of Object.entries(validationMessages)) {
            const field = document.getElementById(fieldId);
            if (!field) continue;

            // Clear previous errors
            if(fieldId === 'is_correct_info'){
                const errorSpan = document.querySelector('.is_correct_info_err');
                if(errorSpan) errorSpan.textContent = '';
            } else {
                clearError(field);
            }

            if ((field.type === 'checkbox' || field.type === 'radio') && !field.checked) {
                if(fieldId === 'is_correct_info') {
                    // Show error in dedicated span for declaration checkbox
                    const errorSpan = document.querySelector('.is_correct_info_err');
                    if(errorSpan) errorSpan.textContent = message;
                } else {
                    showError(field, message);
                }
                isValid = false;
            } else if (!field.value || field.value.trim() === '') {
                showError(field, message);
                isValid = false;
            }
        }

        if (!isValid) return; // stop if any field invalid

        // Remove file required temporarily
        if (fileInput) fileInput.removeAttribute('required');

        // Show upload section & footer
        const uploadSection = document.getElementById('upload_section');
        const cardFooter = document.getElementById('card-footer');
        if (uploadSection) uploadSection.style.display = 'block';
        if (cardFooter) cardFooter.style.display = 'block';

        // Clone container & generate PDF
        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;
        const printClone = addContainer.cloneNode(true);
        const uploadSectionInClone = printClone.querySelector('#upload_section');
if (uploadSectionInClone) {
    uploadSectionInClone.remove();
}
        Object.assign(printClone.style, {
            fontSize: '16px',
            lineHeight: '1.4',
            padding: '20px',
            margin: '0 auto',
            background: '#fff',
            width: '210mm',
            minHeight: '297mm',
            boxSizing: 'border-box'
        });

        Array.from(printClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });

        const printTitle = document.createElement('h2');
        Object.assign(printTitle.style, {
            textAlign: 'center',
            marginBottom: '18px',
            fontSize: '18px'
        });
        printTitle.textContent = 'Certificate of water reconnection';
        printClone.insertBefore(printTitle, printClone.firstChild);

        printClone.querySelectorAll('button').forEach(btn => btn.remove());
        printClone.querySelectorAll('.card').forEach(card => {
            Object.assign(card.style, {
                background: 'white',
                boxShadow: 'none',
                border: '1px solid #ccc',
                marginBottom: '12px',
                padding: '12px'
            });
        });
        printClone.querySelectorAll('.selected-value').forEach(div => div.classList.remove('d-none'));

        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }

        printContainer.innerHTML = '';
        printContainer.appendChild(printClone);

        // Generate PDF
        html2canvas(printClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const { jsPDF } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const margin = 10;
            pdf.addImage(imgData, 'JPEG', margin, margin, pdf.internal.pageSize.getWidth() - margin * 2, pdf.internal.pageSize.getHeight() - margin * 2 );
            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) alert('Warning: PDF > 2MB');
            pdf.save('Water ReConnectionCertificate.pdf');
            saveBtn.style.display = 'none';
        }).finally(() => {
            if (fileInput) fileInput.setAttribute('required', 'required');
        });
    });

    // Clear error on input/change
    Object.keys(validationMessages).forEach(id => {
        const field = document.getElementById(id);
        if (!field) return;

        if(id === 'is_correct_info'){
            field.addEventListener('change', () => {
                const errorSpan = document.querySelector('.is_correct_info_err');
                if(errorSpan) errorSpan.textContent = '';
            });
        } else {
            field.addEventListener('input', () => clearError(field));
            field.addEventListener('change', () => clearError(field));
        }
    });
});
</script>








{{-- Add --}}
<script>
    $('#searchdetails').on('click', function(e) {
        e.preventDefault();

        let formData = {
            marchantid: $('#marchantid').val(),
            connection_no: $('#connection_no').val(),
            _token: $('input[name="_token"]').val()
        };

        $.ajax({
            url: '{{ route('fetch.water.details') }}',
            method: 'POST',
            data: formData,
            datatype: JSON,
            success: function(response) {
                console.log("Encrypted Data:", response.jsonData.encr_request);

                const decryptedData = JSON.parse(response.jsonData.encr_request); // Replace with actual decryption function

                console.log("Decrypted Data:", decryptedData['connectionDetails'].Water_Connection_Number);

                if (decryptedData && decryptedData['connectionDetails']) {
                    $('#Connection_Type').val(decryptedData['connectionDetails'].Connection_Type);
                    $('#House_Number').val(decryptedData['connectionDetails'].House_Number);
                    $('#Property_Owner_Name').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    $('#Full_Address_Of_The_Property').val(decryptedData['connectionDetails'].Full_Address_Of_The_Property);
                    $('#Water_Connection_Size').val(decryptedData['connectionDetails'].Water_Connection_Size);
                    $('#Water_Connection_Usage').val(decryptedData['connectionDetails'].Water_Connection_Usage);
                    $('#zone').val(decryptedData['connectionDetails'].Zone);
                    $('#Ward').val(decryptedData['connectionDetails'].Ward);
                    $('#OutstandingAmt').val(decryptedData['connectionDetails'].OutstandingAmt);
                    // $('#connection_no').val(decryptedData['connectionDetails'].Water_Connection_Number);
                    // $('#owner_name').val(decryptedData['connectionDetails'].Property_Owner_Name);
                    // $('#new_owner_name').val(decryptedData['connectionDetails'].Full_Address_Of_The_Property);
                    // $('#address').val(decryptedData['connectionDetails'].Water_Connection_Size);
                    // $('#house_no').val(decryptedData['connectionDetails'].Water_Connection_Usage);
                    // $('#ward').val(decryptedData['connectionDetails'].Ward);
                } else {
                    console.error("connectionDetails is missing or undefined");
                }
            },

            error: function(xhr) {
                console.error(xhr.responseText);
            }
        });
    });

    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('water-reconnection.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
