<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CfcController;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\PaymentSummary;
use App\Http\Controllers\TestController;
use App\Http\Controllers\TrackApplication;

use App\Http\Controllers\ServiceController;
use App\Http\Controllers\MarriageController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MyProfileController;
use App\Http\Controllers\BobPaymentController;
use App\Http\Controllers\Master\FeesController;
use App\Http\Controllers\MobileTowerController;
use App\Http\Controllers\PropertyTaxController;
use App\Http\Controllers\SafaiDemandController;
use App\Http\Controllers\StateLicenseController;
use App\Http\Controllers\HealthLicenseController;
use App\Http\Controllers\VerifyPaymentController;
use App\Http\Controllers\DivSubDivisionController;
use App\Http\Controllers\GardensFilmingController;
use App\Http\Controllers\HealthNocMunciController;
use App\Http\Controllers\Trade\TradeNocController;
use App\Http\Controllers\AbattoirLicenseController;
use App\Http\Controllers\TentsPermissionController;
use App\Http\Controllers\Master\SignatureController;
use App\Http\Controllers\NewTaxAssessmentController;
use App\Http\Controllers\RecordObjectionsController;
use App\Http\Controllers\Trade\PerLicenseController;
use App\Http\Controllers\ClassroomsForRentController;
use App\Http\Controllers\PlinthCertificateController;
use App\Http\Controllers\StallBoardLicenseController;
use App\Http\Controllers\TaxProperty\NoDueController;
use App\Http\Controllers\Trade\AutoRenewalController;

use App\Http\Controllers\HoardingPermissionController;
use App\Http\Controllers\PermissionShootingController;
use App\Http\Controllers\ServiceInformationController;
use App\Http\Controllers\Trade\NOCForMandapController;
use App\Http\Controllers\Trade\TradeLicenseController;
use App\Http\Controllers\DemolishingPropertyController;
use App\Http\Controllers\Nulm\HawkerRegisterController;
use App\Http\Controllers\PermissionForPmcOwnController;
use App\Http\Controllers\ProcessionAndParadeController;
use App\Http\Controllers\Pwd\GrantingTelecomController;
use App\Http\Controllers\Trade\MovieShootingController;
use App\Http\Controllers\OccupancyCertificateController;
use App\Http\Controllers\TaxProperty\IssuanceController;
use App\Http\Controllers\Trade\PlumberLicenseController;
use App\Http\Controllers\ParkCulturePermissionController;
use App\Http\Controllers\TaxProperty\TaxDemandController;
use App\Http\Controllers\Trade\ChangeOwnerNameController;
use App\Http\Controllers\Trade\LicenseTransferController;
use App\Http\Controllers\AapaleSarkarLoginCheckController;
use App\Http\Controllers\DrinageWater\WaterDuesController;
use App\Http\Controllers\MedicalHealth\PotholesController;
use App\Http\Controllers\PwdElectrical\WindBlowController;
use App\Http\Controllers\TaxProperty\RetaxationController;
use App\Http\Controllers\Trade\ChangeHolderNameController;
use App\Http\Controllers\Trade\RenewalOfLicenseController;
use App\Http\Controllers\AdvertisementPermissionController;
use App\Http\Controllers\EstateVibhag\SolarPowerController;
use App\Http\Controllers\Master\NatureOfBusinessController;
use App\Http\Controllers\TaxProperty\NewTaxationController;
use App\Http\Controllers\TownPlaning\BhagNakashaController;
use App\Http\Controllers\Trade\ChangeLicenseNameController;
use App\Http\Controllers\Trade\ChangeLicenseTypeController;
use App\Http\Controllers\TreeAuth\TreeProtectionController;
use App\Http\Controllers\DrinageWater\SewerageNocController;
use App\Http\Controllers\DrinageWater\WaterRepairController;
use App\Http\Controllers\TaxProperty\TaxExemptionController;
use App\Http\Controllers\MedicalHealth\GutterCoverController;
use App\Http\Controllers\Trade\ChangeHolderPartnerController;
use App\Http\Controllers\Trade\LicenseCancellationController;
use App\Http\Controllers\DrinageWater\PortableWaterController;
use App\Http\Controllers\DrinageWater\WaterTransferController;
use App\Http\Controllers\TaxProperty\SelfAssessmentController;
use App\Http\Controllers\Trade\LicenseLoadgingHouseController;
use App\Http\Controllers\Trade\RenewLicenseLoadgingController;
use App\Http\Controllers\TownPlaning\ZoneCertificateController;
use App\Http\Controllers\Trade\RenewalPlumberLicenseController;
use App\Http\Controllers\TaxProperty\TransferPropertyController;
use App\Http\Controllers\Trade\RenewalLicenseMarriageController;
use App\Http\Controllers\WaterSupplyDepartment\NoDuesController;
use App\Http\Controllers\Trade\ChangeOwnerPartnerCountController;
use App\Http\Controllers\Trade\IssuanceLicenseMarriageController;
use App\Http\Controllers\fireDepartment\FireNoObjectionController;
use App\Http\Controllers\MedicalHealth\DepMedicalHealthController;
use App\Http\Controllers\MovableAdvertisementPermissionController;
use App\Http\Controllers\PwdElectrical\StromWaterDrainsController;
use App\Http\Controllers\TownPlaning\BuildingPermissionController;
use App\Http\Controllers\WaterSupplyDepartment\WaterTaxController;
use App\Http\Controllers\DrinageWater\FailureWaterSupplyController;
use App\Http\Controllers\DrinageWater\SeweragePropertiesController;
use App\Http\Controllers\MallaNisaranDepartment\DrainageController;
use App\Http\Controllers\PwdElectrical\SarvajanikJagetunController;
use App\Http\Controllers\TownPlaning\OccupancyCetificateController;
use App\Http\Controllers\Trade\NewTradeLicensePermissionController;
use App\Http\Controllers\TaxProperty\TransferSelfPropertyController;
use App\Http\Controllers\MedicalHealth\CityCleanControllerController;
use App\Http\Controllers\MedicalHealth\GrantNursingLicenseController;
use App\Http\Controllers\MedicalHealth\ChangeNursingLicenseController;
use App\Http\Controllers\PwdElectrical\PathRoadCitizienshipController;
use App\Http\Controllers\fireDepartment\FinalFireNoObjectionController;
use App\Http\Controllers\MedicalHealth\RenewalNursingLicenseController;



use App\Http\Controllers\PwdElectrical\PrivateInfrastructureController;
use App\Http\Controllers\TaxProperty\RegistrationOfObjectionController;
use App\Http\Controllers\TaxProperty\TaxExemptionNonResidentController;
use App\Http\Controllers\WaterSupplyDepartment\WaterPressureController;
use App\Http\Controllers\PwdElectrical\DevelopmentWorkQuantityController;
use App\Http\Controllers\EstateVibhag\ElectricMeterNameTransferController;
use App\Http\Controllers\PwdElectrical\VikasKamachaGopniyDakhlaController;
use App\Http\Controllers\WaterSupplyDepartment\ChangeInOwnershipController;
use App\Http\Controllers\WaterSupplyDepartment\WaterReConnectionController;
use App\Http\Controllers\WaterSupplyDepartment\NewWaterConnectionController;
use App\Http\Controllers\ConstructionDepartment\DrainageConnectionController;
use App\Http\Controllers\WaterSupplyDepartment\DefectiveWaterMeterController;
use App\Http\Controllers\WaterSupplyDepartment\ChangeConnecionUsageController;
use App\Http\Controllers\TaxProperty\PropertyDivisionIntoSubDivisionController;
use App\Http\Controllers\TaxProperty\TransferRegistrationCertificateController;
use App\Http\Controllers\WaterSupplyDepartment\DisconnectWaterSupplyController;
use App\Http\Controllers\WaterSupplyDepartment\WaterQualityComplaintController;
use App\Http\Controllers\ConstructionDepartment\RoadCuttingPermissionController;
use App\Http\Controllers\WaterSupplyDepartment\IllegalWaterConnectionController;
use App\Http\Controllers\MedicalHealth\CivilLocalSelfGovermentNominationController;
use App\Http\Controllers\WaterSupplyDepartment\ChangeWaterConnectionSizeController;
use App\Http\Controllers\WaterSupplyDepartment\WaterUnavailabilitySupplyController;
use App\Http\Controllers\PwdElectrical\CompletitionCertificateDevelopmentController;
use App\Http\Controllers\PwdElectrical\VibhagThakbakiNaslyachePramanpatraController;
use App\Http\Controllers\WaterSupplyDepartment\UnavailabilityOfWaterSupplyController;
use App\Http\Controllers\InsuranceOfBirthController\InsuranceOfBirthReadingController;
use App\Http\Controllers\InsuranceOfBirthController\InsuranceOfDeathReadingController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
})->name('/');


// SMS delivery reports endpoint (configure this URL in your SMS provider to receive DLRs)
Route::post('sms/dlr', [App\Http\Controllers\SmsDeliveryController::class, 'receive']);


Route::get('hoarding/{id}', [HoardingPermissionController::class, 'hoardingdetails'])->name('hoarding-permission.hoardingdetails');
// Route::get('make-payment', [App\Http\Controllers\PaymentController::class, 'index']);
// Guest Users
Route::middleware(['guest', 'PreventBackHistory', 'firewall.all'])->group(function () {
    Route::get('login', [App\Http\Controllers\Registeration\AuthController::class, 'showLogin'])->name('login');
    Route::post('login', [App\Http\Controllers\Registeration\AuthController::class, 'login'])->name('signin');

    Route::get('register', [App\Http\Controllers\Registeration\AuthController::class, 'showRegister'])->name('register');
    Route::post('register', [App\Http\Controllers\Registeration\AuthController::class, 'register'])->name('signup');
    Route::post('/resend-otp', [App\Http\Controllers\Registeration\AuthController::class, 'resendOtp'])->name('resend.otp');

});

Route::prefix('/payment')->group(function () {
    Route::get('/bob/create/{id}', [App\Http\Controllers\BobPaymentController::class, 'initPaymentRequest'])->name('create-payment');
    Route::any('/bob/success', [App\Http\Controllers\BobPaymentController::class, 'successResponse'])->name('success-payment');
     Route::any('/bob/cancel', [App\Http\Controllers\BobPaymentController::class, 'cancelResponse'])->name('cancel-payment');


    Route::any('/bob/failed', [App\Http\Controllers\BobPaymentController::class, 'failedResponse'])->name('failed-payment');
    Route::post('redirect-payment', [App\Http\Controllers\BobPaymentController::class, 'redirectPayment'])->name('redirect-payment');
});



// Authenticated users
Route::get('my-application', [DashboardController::class, 'myApplication'])->name('my-application');
Route::middleware(['auth', 'PreventBackHistory', 'firewall.all'])->group(function () {
    // Users Roles n Permissions
    Route::resource('users', App\Http\Controllers\Admin\UserController::class);
    Route::get('users/{user}/toggle', [App\Http\Controllers\Admin\UserController::class, 'toggle'])->name('users.toggle');
    Route::get('users/{user}/retire', [App\Http\Controllers\Admin\UserController::class, 'retire'])->name('users.retire');
    Route::put('users/{user}/change-password', [App\Http\Controllers\Admin\UserController::class, 'changePassword'])->name('users.change-password');
    Route::get('users/{user}/get-role', [App\Http\Controllers\Admin\UserController::class, 'getRole'])->name('users.get-role');
    Route::put('users/{user}/assign-role', [App\Http\Controllers\Admin\UserController::class, 'assignRole'])->name('users.assign-role');
    Route::get('fetchdepartment', [App\Http\Controllers\Admin\UserController::class, 'approvalrequesthierarchies'])->name('approvalrequesthierarchies');
    Route::delete('/user/{user}', [App\Http\Controllers\Admin\UserController::class, 'destroy'])->name('user.destroy');
    Route::resource('approval-request-hierarchies', App\Http\Controllers\Admin\ApprovalRequestHierarchiesController::class);
    Route::resource('roles', App\Http\Controllers\Admin\RoleController::class);
    Route::get('/get-wards-by-prabhag/{id}', [App\Http\Controllers\Admin\UserController::class, 'getWardsByPrabhag']);
    Route::get('/get-water-wards-by-prabhag/{id}', [App\Http\Controllers\Admin\UserController::class, 'getWaterWardsByPrabhag']);


    Route::get('pendinglist', [App\Http\Controllers\Admin\PendingListController::class, 'pending_list'])->name('pendinglist');
    Route::get('rejected_list', [App\Http\Controllers\Admin\PendingListController::class, 'rejected_list'])->name('rejectedlist');
    Route::post('/approve-item/{statusId}', [App\Http\Controllers\Admin\PendingListController::class, 'approveItem'])->name('approveItem');
    Route::get('approvelist', [App\Http\Controllers\Admin\PendingListController::class, 'approve_list'])->name('approvelist');
Route::post('/file/revert-back', [App\Http\Controllers\Admin\PendingListController::class, 'revertBack'])->name('file.revert.back');
Route::post('/file/revert-backgranting', [App\Http\Controllers\Admin\PendingListController::class, 'revertBackGranting'])->name('file.revert.backgranting');

    Route::post('/reject-item/{statusId}', [App\Http\Controllers\Admin\PendingListController::class, 'rejectItem'])->name('rejectItem');
    Route::post('/upload-factor/{statusId}', [App\Http\Controllers\Admin\PendingListController::class, 'uploadfactor'])->name('uploadfactor');
    Route::post('/upload-document/{statusId}', [App\Http\Controllers\Admin\PendingListController::class, 'upload'])->name('upload');
    Route::post('/upload-certitficate/{statusId}', [App\Http\Controllers\Admin\PendingListController::class, 'upload_certitficate'])->name('upload_certitficate');

    // Auth Routes
    Route::post('logout', [App\Http\Controllers\Registeration\AuthController::class, 'Logout'])->name('logout');
    Route::get('show-change-password', [App\Http\Controllers\Registeration\AuthController::class, 'showChangePassword'])->name('show-change-password');
    Route::post('change-password', [App\Http\Controllers\Registeration\AuthController::class, 'changePassword'])->name('change-password');
    Route::get('home', fn() => redirect()->route('dashboard'))->name('home');
    Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('service/{id}', [DashboardController::class, 'subService'])->name('service.my-service');
    Route::get('generate-payment-url', [DashboardController::class, 'generatePaymentUrl'])->name('generate-payment-url');
    Route::get('payment-return-url', [DashboardController::class, 'paymentReturnUrl'])->name('payment-return-url');


    //start of marriage registration form
    Route::post('marriage-registration/store-marriage-registration-form', [MarriageController::class, 'storeMarriageRegistrationForm'])->name('marriage-registration.store-marriage-registration-form');
    Route::post('marriage-registration/store-marriage-registration-details', [MarriageController::class, 'storeMarriageRegistrationDetails'])->name('marriage-registration.store-marriage-registration-details');
    Route::post('marriage-registration/store-groom-information', [MarriageController::class, 'storeGroomInformation'])->name('marriage-registration.store-groom-information');
    Route::post('marriage-registration/store-bride-information', [MarriageController::class, 'storeBrideInformation'])->name('marriage-registration.store-bride-information');
    Route::post('marriage-registration/store-priest-information', [MarriageController::class, 'storePriestInformation'])->name('marriage-registration.store-priest-information');
    Route::post('marriage-registration/store-witness_information', [MarriageController::class, 'storeWitnessInformation'])->name('marriage-registration.store-witness-information');
    Route::resource('marriage-registration', MarriageController::class);
    Route::get('receiptmarriage/{id}', [MarriageController::class, 'generateReceipt'])->name('marriage-registration.generateReceipt');

    // end of marriage registration form

    Route::get('service-information', [ServiceInformationController::class, 'serviceInformation'])->name('service-information');

    // property Tax Routes
    Route::get('issuanceofpropertytax/{id}', [IssuanceController::class, 'generateReceipt'])->name('issuance-of-property-tax.generateReceipt');
    Route::resource('issuance-of-property-tax', IssuanceController::class);

    Route::get('transferproperty/{id}', [TransferPropertyController::class, 'generateReceipt'])->name('transfer-property.generateReceipt');
    Route::resource('transfer-property', TransferPropertyController::class);

    Route::get('transferselfproperty/{id}', [TransferSelfPropertyController::class, 'generateReceipt'])->name('transfer-selfproperty.generateReceipt');
    Route::resource('transfer-selfproperty', TransferSelfPropertyController::class);

    Route::get('taxreceiptexemption/{id}', [TaxExemptionController::class, 'generateReceipt'])->name('tax-exemption.generateReceipt');
    Route::resource('tax-exemption', TaxExemptionController::class);

    Route::get('taxdemand/{id}', [TaxDemandController::class, 'generateReceipt'])->name('tax-demand.generateReceipt');
    Route::resource('tax-demand', TaxDemandController::class);

    Route::get('retaxationreceipt/{id}', [RetaxationController::class, 'generateReceipt'])->name('retaxation.generateReceipt');
    Route::resource('retaxation', RetaxationController::class);

    Route::get('newtaxationreceipt/{id}', [NewTaxationController::class, 'generateReceipt'])->name('new-taxation.generateReceipt');
    Route::resource('new-taxation', NewTaxationController::class);

    Route::get('noduesreceipt/{id}', [NoDueController::class, 'generateReceipt'])->name('no-dues.generateReceipt');
    Route::resource('no-dues', NoDueController::class);

    Route::get('taxexemptionnonresidentrexeipt/{id}', [TaxExemptionNonResidentController::class, 'generateReceipt'])->name('tax-exemption-non-resident.generateReceipt');
    Route::post('/fetch-property-details', [NoDueController::class, 'fetchpropertyDetails'])->name('fetch.property.details');
    Route::post('/fetch.propertynodue.details', [NoDueController::class, 'fetchnoDuespropertyDetails'])->name('fetch.propertynodue.details');
    // Route::post('/store-property-details', [NoDueController::class, 'storepropertyDetails'])->name('store.property.details');
    Route::resource('tax-exemption-non-resident', TaxExemptionNonResidentController::class);

    Route::get('self-assessmentreceipt/{id}', [SelfAssessmentController::class, 'generateReceipt'])->name('self-assessment.generateReceipt');
    Route::resource('self-assessment', SelfAssessmentController::class);
    Route::get('registrationofobjectionreceipt/{id}', [RegistrationOfObjectionController::class, 'generateReceipt'])->name('registration-of-objection.generateReceipt');
    Route::resource('registration-of-objection', RegistrationOfObjectionController::class);

    Route::resource('property-division', PropertyDivisionIntoSubDivisionController::class);
    Route::get('propertydivisonreceipt/{id}', [PropertyDivisionIntoSubDivisionController::class, 'generateReceipt'])->name('property-division.generateReceipt');

    // Route::resource('transfer-registration-certificate', TransferRegistrationCertificateController::class);

    // Fire Department Routes
    Route::get('fire-no-objection-receipt/{id}', [FireNoObjectionController::class, 'generateReceipt'])->name('fire-no-objection.generateReceipt');
    Route::resource('fire-no-objection', FireNoObjectionController::class);
    Route::get('fire-final-no-objection-receipt/{id}', [FinalFireNoObjectionController::class, 'generateReceipt'])->name('fire-final-no-objection.generateReceipt');
    Route::resource('fire-final-no-objection', FinalFireNoObjectionController::class);

    // Water Supply Department Routes
    Route::resource('water-new-connection', NewWaterConnectionController::class);
    Route::get('water-new-connection-recipt/{id}', [NewWaterConnectionController::class, 'generateReceipt'])->name('water-new-connection.generateReceipt');
    Route::post('/fetch-water-details', [NewWaterConnectionController::class, 'fetchDetails'])->name('fetch.water.details');
    Route::post('/update-road-type', [NewWaterConnectionController::class, 'updateRoad'])->name('water.updateRoad');

    Route::get('water-illegal-connection-recipt/{id}', [IllegalWaterConnectionController::class, 'generateReceipt'])->name('water-illegal-connection.generateReceipt');
    Route::resource('water-illegal-connection', IllegalWaterConnectionController::class);

    Route::resource('water-change-ownership', ChangeInOwnershipController::class);
    Route::get('water-change-ownership-recipt/{id}', [ChangeInOwnershipController::class, 'generateReceipt'])->name('water-change-ownership.generateReceipt');

    Route::resource('water-connection-size-change', ChangeWaterConnectionSizeController::class);
    Route::get('waterconnectionsize-changereceipt/{id}', [ChangeWaterConnectionSizeController::class, 'generateReceipt'])->name('water-connection-size-change.generateReceipt');

    Route::resource('water-reconnection', WaterReConnectionController::class);
    Route::get('waterreconnectionreceipt/{id}', [WaterReConnectionController::class, 'generateReceipt'])->name('water-reconnection.generateReceipt');

    Route::resource('water-disconnect-supply', DisconnectWaterSupplyController::class);
    Route::get('water-disconnect-supply-receipt/{id}', [DisconnectWaterSupplyController::class, 'generateReceipt'])->name('water-disconnect-supply.generateReceipt');

    Route::resource('water-change-connection-usage', ChangeConnecionUsageController::class);
    Route::get('water-change-connection-usage-receipt/{id}', [ChangeConnecionUsageController::class, 'generateReceipt'])->name('water-change-connection-usage.generateReceipt');

    Route::resource('water-Tax-bill', WaterTaxController::class);
    Route::get('water-Tax-bill-receipt/{id}', [WaterTaxController::class, 'generateReceipt'])->name('water-Tax-bill.generateReceipt');

    Route::resource('water-no-dues', NoDuesController::class);
    Route::get('waternodues-receipt/{id}', [NoDuesController::class, 'generateReceipt'])->name('water-no-dues.generateReceipt');

    //Route::resource('water-unavailability-supply', UnavailabilityOfWaterSupplyController::class);

    Route::resource('water-defective-meter', DefectiveWaterMeterController::class);
    Route::get('waterdefectivemeterreceipt/{id}', [DefectiveWaterMeterController::class, 'generateReceipt'])->name('water-defective-meter.generateReceipt');


    Route::resource('water-pressure-complaint', WaterPressureController::class);
    Route::get('waterpressurecomplaintreceipt/{id}', [WaterPressureController::class, 'generateReceipt'])->name('water-pressure-complaint.generateReceipt');


    Route::resource('water-quality-complaint', WaterQualityComplaintController::class);
    Route::get('waterqualitycomplaintreceipt/{id}', [WaterQualityComplaintController::class, 'generateReceipt'])->name('water-quality-complaint.generateReceipt');


    Route::resource('water-unavailability-supply', WaterUnavailabilitySupplyController::class);
    Route::get('waterunavailabilityreceipt/{id}', [WaterUnavailabilitySupplyController::class, 'generateReceipt'])->name('water-unavailability-supply.generateReceipt');

    // Trade Routes
    Route::resource('trade-plumber-license', PlumberLicenseController::class);
    Route::get('tradeplumberlicensereceipt/{id}', [PlumberLicenseController::class, 'generateReceipt'])->name('trade-plumber-license.generateReceipt');

    Route::resource('renewal-plumber-license', RenewalPlumberLicenseController::class);
    Route::get('renewalplumberlicense/{id}', [RenewalPlumberLicenseController::class, 'generateReceipt'])->name('renewal-plumber-license.generateReceipt');

    Route::get('tradenewlicensereceipt/{id}', [NewTradeLicensePermissionController::class, 'generateReceipt'])->name('trade-new-license.generateReceipt');
    Route::resource('trade-new-license', NewTradeLicensePermissionController::class);

    Route::get('traderenewallicensereceipt/{id}', [RenewalOfLicenseController::class, 'generateReceipt'])->name('trade-renewal-license.generateReceipt');
    Route::resource('trade-renewal-license', RenewalOfLicenseController::class);

    Route::get('tradeautorenewallicensereceipt/{id}', [AutoRenewalController::class, 'generateReceipt'])->name('trade-autorenewal-license.generateReceipt');
    Route::resource('trade-autorenewal-license', AutoRenewalController::class);

    Route::get('tradelicensetransferreceipt/{id}', [LicenseTransferController::class, 'generateReceipt'])->name('trade-license-transfer.generateReceipt');
    Route::resource('trade-license-transfer', LicenseTransferController::class);

    Route::get('tradeperlicensereceipt/{id}', [PerLicenseController::class, 'generateReceipt'])->name('trade-per-license.generateReceipt');
    Route::resource('trade-per-license', PerLicenseController::class);

    Route::resource('trade-noc-mandap', NOCForMandapController::class);
    Route::get('tradenocmandapreceipt/{id}', [NOCForMandapController::class, 'generateReceipt'])->name('trade-noc-mandap.generateReceipt');

   Route::resource('demand-safai', SafaiDemandController::class);





    // Route::get('/download-rejection-certificate/{statusId}', [App\Http\Controllers\Admin\PendingListController::class, 'downloadRejectionCertificate'])->name('downloadRejectionCertificate');
    Route::get('/download-rejection-certificate/{statusId}', [NOCForMandapController::class, 'downloadRejectionCertificate'])->name('trade-noc-mandap.downloadRejectionCertificate');

    Route::get('tradechangelicensename/{id}', [ChangeLicenseNameController::class, 'generateReceipt'])->name('trade-change-license-name.generateReceipt');
    Route::resource('trade-change-license-name', ChangeLicenseNameController::class);

    Route::get('tradechangelicensetypereceipt/{id}', [ChangeLicenseTypeController::class, 'generateReceipt'])->name('trade-change-license-type.generateReceipt');
    Route::resource('trade-change-license-type', ChangeLicenseTypeController::class);

    Route::get('tradechangeownercountreceipt/{id}', [ChangeOwnerPartnerCountController::class, 'generateReceipt'])->name('trade-change-owner-count.generateReceipt');
    Route::resource('trade-change-owner-count', ChangeOwnerPartnerCountController::class);

    Route::get('tradechangeofholderreceipt/{id}', [ChangeHolderNameController::class, 'generateReceipt'])->name('trade-change-of-holder.generateReceipt');
    Route::resource('trade-change-of-holder', ChangeHolderNameController::class);

    Route::get('tradechangeownernamereceipt/{id}', [ChangeOwnerNameController::class, 'generateReceipt'])->name('trade-change-owner-name.generateReceipt');
    Route::resource('trade-change-owner-name', ChangeOwnerNameController::class);

    Route::get('tradelicensecancellationreceipt/{id}', [LicenseCancellationController::class, 'generateReceipt'])->name('trade-license-cancellation.generateReceipt');
    Route::resource('trade-license-cancellation', LicenseCancellationController::class);

    Route::get('tradenocreceipt/{id}', [TradeNocController::class, 'generateReceipt'])->name('tradenoc.generateReceipt');
    Route::resource('tradenoc', TradeNocController::class);

    Route::get('tradelicenseloadingreceipt/{id}', [LicenseLoadgingHouseController::class, 'generateReceipt'])->name('trade-license-loading.generateReceipt');
    Route::resource('trade-license-loading', LicenseLoadgingHouseController::class);

    Route::get('traderenewlicenseloading/{id}', [RenewLicenseLoadgingController::class, 'generateReceipt'])->name('trade-renew-license-loading.generateReceipt');
    Route::resource('trade-renew-license-loading', RenewLicenseLoadgingController::class);

    Route::resource('trade-issuance-license-marriage', IssuanceLicenseMarriageController::class);
    Route::get('tradeissuancelicensereceipt/{id}', [IssuanceLicenseMarriageController::class, 'generateReceipt'])->name('trade-issuance-license-marriage.generateReceipt');

    Route::resource('trade-renew-license-marriage', RenewalLicenseMarriageController::class);
    Route::get('traderenewlicensmarriagereceipt/{id}', [RenewalLicenseMarriageController::class, 'generateReceipt'])->name('trade-renew-license-marriage.generateReceipt');

    Route::resource('movie-shooting', MovieShootingController::class);
    Route::get('movieshootingreceipt/{id}', [MovieShootingController::class, 'generateReceipt'])->name('movie-shooting.generateReceipt');

    Route::resource('trade-change-holder-partner', ChangeHolderPartnerController::class);
    Route::get('tradechangeholderreceipt/{id}', [ChangeHolderPartnerController::class, 'generateReceipt'])->name('trade-change-holder-partner.generateReceipt');

    Route::resource('trade-license',TradeLicenseController::class);
    Route::get('tradelicensereceipt/{id}', [TradeLicenseController::class, 'generateReceipt'])->name('trade-license.generateReceipt');



    //birth-death
    Route::get('insurancereceipt/{id}', [InsuranceOfBirthReadingController::class, 'generateReceipt'])->name('insurance.generateReceipt');
    Route::resource('insurance',InsuranceOfBirthReadingController::class);
    Route::get('deathinsurancereceipt/{id}', [InsuranceOfDeathReadingController::class, 'generateReceipt'])->name('death-insurance.generateReceipt');
    Route::resource('death-insurance',InsuranceOfDeathReadingController::class);


    Route::get('marriagereport', [MarriageController::class, 'marriagereport'])->name('marriage-report.marriagereport');
    Route::get('allreport', [MarriageController::class, 'allreport'])->name('all-report');
    Route::get('/marriage/goshwar1/{id}', [MarriageController::class, 'goshwar1'])->name('marriage.goshwar1');
    Route::get('/marriage/goshwar3/{id}', [MarriageController::class, 'goshwar3'])->name('marriage.goshwar3');


    // NULM
    Route::resource('hawker-register', HawkerRegisterController::class);

    //PWD
    Route::get('granttelecomereceipt/{id}', [GrantingTelecomController::class, 'generateReceipt'])->name('grant-telecome.generateReceipt');
    Route::get('granttelecomdemandnote/{id}', [GrantingTelecomController::class, 'generatedemandnote'])->name('grant-telecome.generatedemandnote');
    Route::resource('grant-telecome', GrantingTelecomController::class);
    Route::get('certificatetwo/{id}',[GrantingTelecomController::class,'certificateTwo'])
    ->name('grant-telecome.certificatetwo');

    //Tree Auth
    Route::resource('tree-protection', TreeProtectionController::class);
    Route::get('treereceipt/{id}', [TreeProtectionController::class, 'generateReceipt'])->name('tree-protection.generateReceipt');
    Route::get('/get-vruksh-names', [TreeProtectionController::class, 'getVrukshNames'])->name('get.vruksh.names');
    Route::get('/get-vruksh-subnames', [TreeProtectionController::class, 'getVrukshSubnames'])->name('get.vruksh.subnames');


    //PwdElectrical
    Route::get('stromwaterdrainsreceipt/{id}', [StromWaterDrainsController::class, 'generateReceipt'])->name('strom-water-drains.generateReceipt');
    Route::resource('strom-water-drains', StromWaterDrainsController::class);

     Route::get('Windblowreceipt/{id}', [WindBlowController::class, 'generateReceipt'])->name('wind-blow.generateReceipt');
    Route::resource('wind-blow', WindBlowController::class);

    Route::get('vikaskamachagopniydakhla/{id}', [VikasKamachaGopniyDakhlaController::class, 'generateReceipt'])->name('vikas-kamacha-gopniy-dakhla.generateReceipt');
    Route::resource('vikas-kamacha-gopniy-dakhla', VikasKamachaGopniyDakhlaController::class);

    Route::get('vibhagthakbaki/{id}', [VibhagThakbakiNaslyachePramanpatraController::class, 'generateReceipt'])->name('vibhag-thakbaki.generateReceipt');
    Route::resource('vibhag-thakbaki', VibhagThakbakiNaslyachePramanpatraController::class);

    Route::get('sarvajnikjagetun/{id}', [SarvajanikJagetunController::class, 'generateReceipt'])->name('sarvajnik-jagetun.generateReceipt');
    Route::resource('sarvajnik-jagetun', SarvajanikJagetunController::class);

    Route::resource('path-road-citizen', PathRoadCitizienshipController::class);

    Route::get('privatereceipt/{id}', [PrivateInfrastructureController::class, 'generateReceipt'])->name('private-infrastructure.generateReceipt');
    Route::resource('private-infrastructure', PrivateInfrastructureController::class);

    Route::get('completitioncertificate/{id}', [CompletitionCertificateDevelopmentController::class, 'generateReceipt'])->name('completition-certificate.generateReceipt');
    Route::resource('completition-certificate',CompletitionCertificateDevelopmentController::class);

    Route::get('developmentworkquantity/{id}', [DevelopmentWorkQuantityController::class, 'generateReceipt'])->name('development-work-quantity.generateReceipt');
    Route::resource('development-work-quantity', DevelopmentWorkQuantityController::class);

    // Draniange water
    Route::resource('failure-watersupply', FailureWaterSupplyController::class);
    Route::get('failurereceipt/{id}', [FailureWaterSupplyController::class, 'generateReceipt'])->name('failure-watersupply.generateReceipt');



    //Estate vibhag
      Route::get('electricreceipt/{id}', [ElectricMeterNameTransferController::class, 'generateReceipt'])
    ->name('electric-meter-name.generateReceipt');
    Route::resource('electric-meter-name',ElectricMeterNameTransferController::class);
    Route::resource('solarpower-heater',SolarPowerController::class);
    Route::get('solarpower-heater-receipt/{id}', [SolarPowerController::class, 'generateReceipt'])
        ->name('solarpower-heater.generateReceipt');
    //drainage and sanpani
    Route::resource('sewerage-noc',SewerageNocController::class);
    Route::get('seweragenocreceipt/{id}', [SewerageNocController::class, 'generateReceipt'])
    ->name('sewerage-noc.generateReceipt');
    Route::resource('waterrepair',WaterRepairController::class);
     Route::get('waterrepairreceipt/{id}', [WaterRepairController::class, 'generateReceipt'])
    ->name('waterrepair.generateReceipt');
    Route::resource('watertransferpermission',WaterTransferController::class);
    Route::get('watertransferpermissionreceipt/{id}', [WaterTransferController::class, 'generateReceipt'])
    ->name('watertransferpermission.generateReceipt');
    Route::resource('portablewater',PortableWaterController::class);
    Route::get('portablewaterreceipt/{id}', [PortableWaterController::class, 'generateReceipt'])
    ->name('portablewater.generateReceipt');
    Route::resource('sewerage-peoperty',SeweragePropertiesController::class);
    Route::get('seweragepeopertyreceipt/{id}', [SeweragePropertiesController::class, 'generateReceipt'])
    ->name('sewerage-peoperty.generateReceipt');
    Route::resource('water-dues',WaterDuesController::class);
     Route::get('waterduesreceipt/{id}', [WaterDuesController::class, 'generateReceipt'])
    ->name('water-dues.generateReceipt');


    // profile route
    Route::get('/profile', [MyProfileController::class, 'profile'])->name('user.profile');

    // route for town planing
    Route::resource('town-planing-zone-certificate', ZoneCertificateController::class);
        Route::get('townplaningzonereceipt/{id}', [ZoneCertificateController::class, 'generateReceipt'])
    ->name('town-planing-zone-certificate.generateReceipt');
    Route::resource('town-planing-bhag-nakasha', BhagNakashaController::class);
    Route::resource('town-building-permission', BuildingPermissionController::class);
    Route::resource('town-occupancy-certificate', OccupancyCetificateController::class);
    Route::get('townplaningbhagnakashareceipt/{id}', [BhagNakashaController::class, 'generateReceipt'])
    ->name('town-planing-bhag-nakasha.generateReceipt');

    // route for construction department
    Route::get('receipt/{id}', [RoadCuttingPermissionController::class, 'generateReceipt'])
    ->name('construction-road-cutting.generateReceipt');

    Route::get('demandnote/{id}', [RoadCuttingPermissionController::class, 'demand_note'])->name('construction-road-cutting.demand_note');
    
    Route::get('/paymentoptions/{serviceId}/{id}', [PaymentSummary::class, 'paymentoptions'])->name('construction-road-cutting.paymentoptions');
    Route::resource('construction-drainage-connection', DrainageConnectionController::class);
    Route::get('construction-drainage-connection-receipt/{id}', [DrainageConnectionController::class, 'generateReceipt'])->name('construction-drainage-connection.generateReceipt');

    Route::resource('construction-road-cutting', RoadCuttingPermissionController::class);



    Route::get('certificateone/{id}', [RoadCuttingPermissionController::class, 'certificateOne'])
    ->name('construction-road-cutting.certificateone');

   

    // Route::get('/certificate/download/{id}', [App\Http\Controllers\ConstructionDepartment\RoadCuttingPermissionController::class, 'downloadPDF'])->name('certificate.download');

    Route::resource('ward', \App\Http\Controllers\Master\WardController::class);
    Route::resource('zone', \App\Http\Controllers\Master\ZoneController::class);

    Route::resource('plinth-certificate', PlinthCertificateController::class);

    Route::resource('occupancy-certificate', OccupancyCertificateController::class);


    //  Route::resource('occupancy-certificate', OccupancyCertificateController::class);

    Route::resource('permission-shooting', PermissionShootingController::class);
    Route::get('hoardingpermissiondemandnote/{id}', [HoardingPermissionController::class, 'generatedemandnote'])->name('hoarding-permission.generatedemandnote');
    Route::get('hoardingpermissionreceipt/{id}', [HoardingPermissionController::class, 'generateReceipt'])->name('hoarding-permission.generateReceipt');
    Route::resource('hoarding-permission', HoardingPermissionController::class);
    Route::resource('health-license', HealthLicenseController::class);



    Route::resource('stallboard-license', StallBoardLicenseController::class);

    Route::resource('abattoir-license', AbattoirLicenseController::class);


    Route::resource('gardens-filming', GardensFilmingController::class);
    Route::get('gardensfilmingreceipt/{id}', [GardensFilmingController::class, 'generateReceipt'])->name('gardens-filming.generateReceipt');


    Route::resource('park-culture', ParkCulturePermissionController::class);
    Route::get('parkculturereceipt/{id}', [ParkCulturePermissionController::class, 'generateReceipt'])->name('park-culture.generateReceipt');


    Route::resource('pmc-owned', PermissionForPmcOwnController::class);
    Route::get('pmcownedreceipt/{id}', [PermissionForPmcOwnController::class, 'generateReceipt'])->name('pmc-owned.generateReceipt');


    Route::resource('tents-permission', TentsPermissionController::class);
    Route::get('tentspermissionreceipt/{id}', [TentsPermissionController::class, 'generateReceipt'])->name('tents-permission.generateReceipt');


    Route::resource('classroom-rent', ClassroomsForRentController::class);
    Route::get('classroomrentreceipt/{id}', [ClassroomsForRentController::class, 'generateReceipt'])->name('classroom-rent.generateReceipt');

    Route::resource('procession-parade', ProcessionAndParadeController::class);
    Route::get('processionparadereceipt/{id}', [ProcessionAndParadeController::class, 'generateReceipt'])->name('procession-parade.generateReceipt');

    Route::resource('record-objections', RecordObjectionsController::class);
    Route::get('recordobjectionsreceipt/{id}', [RecordObjectionsController::class, 'generateReceipt'])->name('record-objections.generateReceipt');

    Route::resource('mobile-tower', MobileTowerController::class);
    Route::get('mobiletowerreceipt/{id}', [MobileTowerController::class, 'generateReceipt'])->name('mobile-tower.generateReceipt');

    Route::resource('state-license', StateLicenseController::class);
    Route::get('statelicensereceipt/{id}', [StateLicenseController::class, 'generateReceipt'])->name('state-license.generateReceipt');


    Route::resource('healthnoc-munici', HealthNocMunciController::class);
    Route::get('healthnocmunicireceipt/{id}', [HealthNocMunciController::class, 'generateReceipt'])->name('healthnoc-munici.generateReceipt');

    Route::resource('movable-advertisement', MovableAdvertisementPermissionController::class);
    Route::get('movableadvertisementreceipt/{id}', [MovableAdvertisementPermissionController::class, 'generateReceipt'])->name('movable-advertisement.generateReceipt');

    Route::resource('cfc', CfcController::class);
    Route::resource('advertisement-permission', AdvertisementPermissionController::class);
    Route::resource('newtax-assessment', NewTaxAssessmentController::class);
    Route::resource('divsub-division', DivSubDivisionController::class);
    Route::resource('demolishingproperty', DemolishingPropertyController::class);
    Route::get('demolishing-property/{id}', [DemolishingPropertyController::class, 'generateReceipt'])->name('demolishing-property.generateReceipt');



    //Department Of Medical Health
    Route::resource('grantnursing-license', GrantNursingLicenseController::class);
    Route::get('grantnursinglicensereceipt/{id}', [GrantNursingLicenseController::class, 'generateReceipt'])->name('grantnursing-license.generateReceipt');

    Route::get('cityclean/{id}', [CityCleanControllerController::class, 'generateReceipt'])->name('city-clean.generateReceipt');
    Route::resource('city-clean', CityCleanControllerController::class);

    Route::resource('renewnursing-license', RenewalNursingLicenseController::class);
    Route::get('renewnursinglicensereceipt/{id}', [RenewalNursingLicenseController::class, 'generateReceipt'])->name('renewnursing-license.generateReceipt');

    Route::resource('changenursing-license', ChangeNursingLicenseController::class);
    Route::get('changenursinglicensereceipt/{id}', [ChangeNursingLicenseController::class, 'generateReceipt'])->name('changenursing-license.generateReceipt');

    Route::resource('civil-local-self-government',CivilLocalSelfGovermentNominationController::class);
    Route::get('civilreceipt/{id}', [CivilLocalSelfGovermentNominationController::class, 'generateReceipt'])->name('civil-local-self-government.generateReceipt');


    Route::get('guttercoverreceipt/{id}', [GutterCoverController::class, 'generateReceipt'])->name('guttercover-maintain.generateReceipt');
    Route::resource('guttercover-maintain',GutterCoverController::class);
    Route::get('potholesreceipt/{id}', [PotholesController::class, 'generateReceipt'])->name('potholes-road.generateReceipt');
    Route::resource('potholes-road',PotholesController::class);

    Route::resource('fees', FeesController::class);
    Route::resource('signature', SignatureController::class);
    Route::resource('nature-business', NatureOfBusinessController::class);

    Route::resource('drainage', DrainageController::class);

    Route::resource('track-application', TrackApplication::class);

    Route::resource('verify-payment-reciept', VerifyPaymentController::class);
    Route::post('verify-payment-reciept/{status}/verify', [VerifyPaymentController::class, 'verify'])
    ->name('verify-payment-reciept.verify');
});
Route::post('rts-service-status', [AapaleSarkarLoginCheckController::class, 'updateStatus'])->name('rts.status');


Route::post('check-app-user', [App\Http\Controllers\AppLoginController::class, 'checkAppUser']);
Route::get('app-login', [App\Http\Controllers\AppLoginController::class, 'appLogin'])->name('app-login');

// Route::get('check-aapalesarkar-user', [AapaleSarkarLoginCheckController::class, 'check']);
 Route::get('trade-noc-mandap/download_certificate/{id}', [NOCForMandapController::class, 'show'])->name('trade-noc-mandap.download_certificate');

 Route::get('/departments/{department}/designations', [App\Http\Controllers\Admin\ApprovalRequestHierarchiesController::class, 'getDesignations'])->name('departments.designations');




 //test url one
  Route::get('test_check_current_status/{service_name_route}/{id}', [TestController::class, 'index']);
  Route::get('approver_check/{id}', [TestController::class, 'show_approval_hierarchy']);


Route::get('/php', function (Request $request) {
    dd(encrypt(18));
    if (!auth()->check())
        return 'Unauthorized request';

    Artisan::call($request->artisan);
    return dd(Artisan::output());
});



